/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.install.configmanager.actionengine.ant.utils;

import com.ibm.ws.install.configmanager.logging.LoggerFactory;
import com.ibm.ws.install.configmanager.osutils.PlatformConstants;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public class AutomaticCodePageConversionAntTask
extends Task {
    private String m_sPath = null;
    private String m_sErrorMessage = new String();
    private static final Logger LOGGER = LoggerFactory.createLogger(AutomaticCodePageConversionAntTask.class);
    private static final String S_CLASS_NAME = AutomaticCodePageConversionAntTask.class.getName();
    private static final String S_JAVA_FILE_ENCODING_PROPERTY = "file.encoding";
    private static final String S_NO_PATH = "Missing path property";

    public void init() throws BuildException {
        LOGGER.entering(AutomaticCodePageConversionAntTask.class.getName(), "init");
        super.init();
        this.m_sPath = null;
        LOGGER.exiting(AutomaticCodePageConversionAntTask.class.getName(), "init");
    }

    public void execute() throws BuildException {
        LOGGER.entering(AutomaticCodePageConversionAntTask.class.getName(), "execute");
        super.execute();
        if (!this.doAllParamsCheckOutOk()) {
            LOGGER.logp(Level.SEVERE, S_CLASS_NAME, "execute", "Incorrect parameters specified for the AutomaticCodePageConversionAntTask");
            LOGGER.logp(Level.SEVERE, S_CLASS_NAME, "execute", "Error location is: " + this.getLocation().toString());
            throw new BuildException(this.m_sErrorMessage, this.getLocation());
        }
        String sEncoding = System.getProperty(S_JAVA_FILE_ENCODING_PROPERTY);
        LOGGER.logp(Level.INFO, S_CLASS_NAME, "execute", "Detected file encoding is: " + sEncoding);
        String convertTo = PlatformConstants.getProperEncodingForCurrentOSShellScripts();
        if (!sEncoding.equalsIgnoreCase(convertTo)) {
            LOGGER.logp(Level.INFO, S_CLASS_NAME, "execute", "Calling convert on file: " + this.m_sPath + " to encoding: " + convertTo);
            this.convert(this.m_sPath, convertTo);
        }
        LOGGER.exiting(AutomaticCodePageConversionAntTask.class.getName(), "execute");
    }

    public void setPath(String sPath) {
        LOGGER.entering(this.getClass().getName(), "setPath");
        LOGGER.logp(Level.INFO, S_CLASS_NAME, "setPath", "Incoming path is set to: " + sPath);
        this.m_sPath = sPath;
        LOGGER.exiting(this.getClass().getName(), "setPath");
    }

    private boolean doAllParamsCheckOutOk() {
        LOGGER.entering(AutomaticCodePageConversionAntTask.class.getName(), "doAllParamsCheckOutOk");
        if (this.m_sPath == null) {
            this.m_sErrorMessage = S_NO_PATH;
            LOGGER.logp(Level.SEVERE, S_CLASS_NAME, "doAllParamsCheckOutOk", "Param check failed, error message is: " + this.m_sErrorMessage);
            LOGGER.exiting(AutomaticCodePageConversionAntTask.class.getName(), "doAllParamsCheckOutOk");
            return false;
        }
        LOGGER.exiting(AutomaticCodePageConversionAntTask.class.getName(), "doAllParamsCheckOutOk");
        return true;
    }

    private void convert(String sPath, String sTo) {
        LOGGER.entering(AutomaticCodePageConversionAntTask.class.getName(), "convert");
        try {
            File file = new File(sPath);
            BufferedReader rd = new BufferedReader(new InputStreamReader(new FileInputStream(file)));
            ArrayList<String> filecontent = new ArrayList<String>();
            String line = null;
            while ((line = rd.readLine()) != null) {
                filecontent.add(line);
            }
            rd.close();
            FileOutputStream fos = new FileOutputStream(file);
            PrintWriter writer = new PrintWriter(new OutputStreamWriter((OutputStream)fos, sTo));
            for (int i = 0; i < filecontent.size(); ++i) {
                line = (String)filecontent.get(i);
                writer.println((String)filecontent.get(i));
            }
            writer.flush();
            writer.close();
            LOGGER.logp(Level.INFO, S_CLASS_NAME, "convert", sPath + " is converted to " + sTo);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        LOGGER.exiting(AutomaticCodePageConversionAntTask.class.getName(), "convert");
    }
}

