/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.install.configmanager.actionengine.ant.utils;

import com.ibm.ws.install.configmanager.logging.LoggerFactory;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Target;
import org.apache.tools.ant.taskdefs.CallTarget;
import org.apache.tools.ant.taskdefs.Property;

public class ANTTargetCaller {
    private static final String S_ANT_CALL = "antcall";
    private static final Logger LOGGER = LoggerFactory.createLogger(ANTTargetCaller.class);
    private static final String S_CLASS_NAME = ANTTargetCaller.class.getName();

    public static void callTargetWithTheseValues(String sTargetName, Hashtable hashtableValues, Project projectContainingTheTarget, Target targetOwning) throws BuildException {
        LOGGER.entering(ANTTargetCaller.class.getName(), "callTargetWithTheseValues");
        CallTarget calltargetThis = ANTTargetCaller.createCallTargetObjectForTheGivenTargetName(sTargetName, projectContainingTheTarget, targetOwning);
        ANTTargetCaller.transferTheseParamsToThisCallTarget(calltargetThis, hashtableValues);
        calltargetThis.execute();
        LOGGER.exiting(ANTTargetCaller.class.getName(), "callTargetWithTheseValues");
    }

    private static CallTarget createCallTargetObjectForTheGivenTargetName(String sTargetName, Project projectContainingTheTarget, Target targetOwning) throws BuildException {
        LOGGER.entering(ANTTargetCaller.class.getName(), "createCallTargetObjectForTheGivenTargetName");
        CallTarget calltargetThis = (CallTarget)projectContainingTheTarget.createTask(S_ANT_CALL);
        calltargetThis.setOwningTarget(targetOwning);
        calltargetThis.setInheritAll(true);
        calltargetThis.setInheritRefs(false);
        calltargetThis.setTarget(sTargetName);
        LOGGER.exiting(ANTTargetCaller.class.getName(), "createCallTargetObjectForTheGivenTargetName");
        return calltargetThis;
    }

    private static void transferTheseParamsToThisCallTarget(CallTarget calltargetThis, Hashtable hashtableParams) {
        LOGGER.entering(ANTTargetCaller.class.getName(), "transferTheseParamsToThisCallTarget");
        Enumeration enumerationKeys = hashtableParams.keys();
        while (enumerationKeys.hasMoreElements()) {
            Object oParamName = enumerationKeys.nextElement();
            Object oParamValue = hashtableParams.get(oParamName);
            Property propertyTransferThis = calltargetThis.createParam();
            propertyTransferThis.setName(oParamName.toString());
            propertyTransferThis.setValue(oParamValue.toString());
            LOGGER.logp(Level.INFO, S_CLASS_NAME, "transferTheseParamsToThisCallTarget", "Transferred " + oParamName.toString() + "=" + oParamValue.toString() + " to " + calltargetThis.toString());
        }
        LOGGER.exiting(ANTTargetCaller.class.getName(), "transferTheseParamsToThisCallTarget");
    }
}

