/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.install.configmanager.actionengine;

import com.ibm.ws.install.configmanager.actionengine.ArgumentConfigAction;
import com.ibm.ws.install.configmanager.actionengine.Environment;
import com.ibm.ws.install.configmanager.actionengine.Parameter;
import com.ibm.ws.install.configmanager.logging.LoggerFactory;
import com.ibm.ws.install.configmanager.utils.ValidationManager;
import java.util.List;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValidatorConfigAction
extends ArgumentConfigAction {
    private static final String S_VALIDATION_VALUE_KEY = "validationValue";
    private static final String S_VALIDATION_VALUE_PATTERN = "(validationValue=)(.*)";
    private static final Pattern PATTERN_VALIDATION_VALUE = Pattern.compile("(validationValue=)(.*)");
    private static final int N_NAME_GROUP_NO_VALIDATION_VALUE = 2;
    private static final boolean F_DEFAULT_VALIDATION_VALUE = true;
    private static final Logger LOGGER = LoggerFactory.createLogger(ValidatorConfigAction.class);

    public ValidatorConfigAction(String sActionPath, int nPriority, boolean fFatal, List<Parameter> listParameter, String sResourceBundle, boolean fOptional, String alias, List<Environment> listSupportedEnvironments) {
        super(sActionPath, nPriority, fFatal, listParameter, sResourceBundle, fOptional, alias, listSupportedEnvironments);
    }

    public boolean executeValidator() {
        String sOutput = super.executeArgumentAction();
        return ValidatorConfigAction.parseOutputForValidationValue(sOutput);
    }

    private static boolean parseOutputForValidationValue(String sOutput) {
        LOGGER.entering(ValidationManager.class.getName(), "parseOutputForValidationValue");
        if (sOutput == null || sOutput.equals("")) {
            return true;
        }
        Matcher validationValueMatcher = PATTERN_VALIDATION_VALUE.matcher(sOutput);
        boolean fValidationValue = true;
        if (validationValueMatcher.find()) {
            fValidationValue = Boolean.valueOf(validationValueMatcher.group(2));
        }
        LOGGER.exiting(ValidationManager.class.getName(), "parseOutputForValidationValue");
        return fValidationValue;
    }
}

