/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.install.configmanager.actionengine;

import com.ibm.ws.install.configmanager.actionengine.ActionImpl;
import com.ibm.ws.install.configmanager.actionengine.JACLAction;
import com.ibm.ws.install.configmanager.ijc.IJC;
import com.ibm.ws.install.configmanager.ijc.IJCParseException;
import com.ibm.ws.install.configmanager.logging.LogUtils;
import com.ibm.ws.install.configmanager.logging.LoggerFactory;
import com.ibm.ws.install.configmanager.utils.FileUtils;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class IJCAction
extends ActionImpl {
    private String m_sOutput = "";
    private String m_sErrorOutput = "";
    private static final Pattern PATTERN_IN_PROC_CALL_PATTERN = Pattern.compile("<inproccall>(.*)</inproccall>");
    private static final int N_CLASS_NAME_GROUP = 1;
    private static final Logger LOGGER = LoggerFactory.createLogger(IJCAction.class);
    private static final String S_CLASS_NAME = IJCAction.class.getName();

    public IJCAction(String sActionPath, boolean fFatal) {
        super(sActionPath, fFatal);
    }

    public boolean executeAction() {
        LOGGER.entering(IJCAction.class.getName(), "executeAction");
        boolean fResult = false;
        try {
            String sClassName = this.getClassNameForThisAction();
            Class<?> classIJCAction = Class.forName(sClassName, true, Thread.currentThread().getContextClassLoader());
            Constructor<?> constructorDefault = classIJCAction.getConstructor(new Class[0]);
            constructorDefault.setAccessible(true);
            IJC ijcThisAction = (IJC)constructorDefault.newInstance(new Object[0]);
            fResult = ijcThisAction.execute();
            this.m_sOutput = ijcThisAction.getOutput();
            this.m_sErrorOutput = ijcThisAction.getErrorOutput();
        }
        catch (Throwable e) {
            LogUtils.logException(LOGGER, e);
            fResult = false;
        }
        LOGGER.logp(Level.INFO, S_CLASS_NAME, "executeAction", "Result of executing " + this.getActionPath() + " was: " + fResult);
        LOGGER.exiting(IJCAction.class.getName(), "executeAction");
        return fResult;
    }

    public boolean rollBackAction() {
        LOGGER.entering(IJCAction.class.getName(), "rollBackAction");
        LOGGER.exiting(IJCAction.class.getName(), "rollBackAction");
        return false;
    }

    public String getActionManualCommand() {
        LOGGER.entering(IJCAction.class.getName(), "getActionManualCommand");
        LOGGER.exiting(IJCAction.class.getName(), "getActionManualCommand");
        return "";
    }

    private String getClassNameForThisAction() throws IOException, FileNotFoundException, IJCParseException {
        LOGGER.entering(IJCAction.class.getName(), "getClassNameForThisAction");
        String sIJCThisActionContents = FileUtils.readFile(this.getActionPath());
        Matcher matcherInProcCall = PATTERN_IN_PROC_CALL_PATTERN.matcher(sIJCThisActionContents);
        if (matcherInProcCall.find()) {
            String sClassName = matcherInProcCall.group(1);
            LOGGER.logp(Level.INFO, S_CLASS_NAME, "getClassNameForThisAction", "Class to launch for " + this.getActionPath() + " is: " + sClassName);
            LOGGER.exiting(IJCAction.class.getName(), "getClassNameForThisAction");
            return sClassName;
        }
        LOGGER.logp(Level.WARNING, S_CLASS_NAME, "getClassNameForThisAction", "IJC file for " + this.getActionPath() + " could not be parsed successfully");
        LOGGER.logp(Level.WARNING, S_CLASS_NAME, "getClassNameForThisAction", "The IJC file contents follow for " + this.getActionPath() + "\n" + sIJCThisActionContents);
        LOGGER.throwing(IJCAction.class.getName(), "getClassNameForThisAction", new IJCParseException());
        throw new IJCParseException();
    }

    public String getActionErrorOutput() {
        LOGGER.entering(JACLAction.class.getName(), "getActionErrorOutput");
        LOGGER.exiting(JACLAction.class.getName(), "getActionErrorOutput");
        return this.m_sErrorOutput;
    }

    public String getActionOutput() {
        LOGGER.entering(JACLAction.class.getName(), "getActionOutput");
        LOGGER.exiting(JACLAction.class.getName(), "getActionOutput");
        return this.m_sOutput;
    }
}

