/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ejbpersistence.dataaccess;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ejbpersistence.dataaccess.EJBKeyGenerator;
import com.ibm.ws.ejbpersistence.utilpm.CannotGenerateKeyException;
import com.ibm.ws.ejbpersistence.utilpm.PMExceptionHandler;
import com.ibm.ws.ejbpersistence.utilpm.PMLogger;
import com.ibm.ws.ffdc.FFDCFilter;
import java.net.InetAddress;
import java.net.UnknownHostException;

public class InMemoryEJBKeyGenerator
implements EJBKeyGenerator {
    private String generatorUniquifier;
    private static InMemoryEJBKeyGenerator singleton;
    private long nextValueUniqueWithinThisJVM = 0L;
    private static TraceComponent mytc;

    public InMemoryEJBKeyGenerator() throws CannotGenerateKeyException {
        String string = null;
        try {
            string = InetAddress.getLocalHost().getHostAddress();
            StringBuffer stringBuffer = new StringBuffer(string);
            stringBuffer.append(System.currentTimeMillis());
            this.generatorUniquifier = stringBuffer.toString();
        }
        catch (UnknownHostException unknownHostException) {
            FFDCFilter.processException((Throwable)unknownHostException, (String)"com.ibm.ws.ejbpersistence.dataaccess.InMemoryEJBKeyGenerator.getMachineOrProcessorUniquifier", (String)"77", (Object)this);
            CannotGenerateKeyException cannotGenerateKeyException = new CannotGenerateKeyException("PMGR6054 Cannot find local host IP address (by calling java.net.InetAddress.getLocalHost().getHostAddress()), used to generate unique key value", unknownHostException);
            PMExceptionHandler.logEJBException(mytc, cannotGenerateKeyException, null);
            throw cannotGenerateKeyException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getUniqueKey() {
        StringBuffer stringBuffer = new StringBuffer(this.getGeneratorUniquifier());
        long l = 0L;
        InMemoryEJBKeyGenerator inMemoryEJBKeyGenerator = this;
        synchronized (inMemoryEJBKeyGenerator) {
            l = this.nextValueUniqueWithinThisJVM++;
        }
        stringBuffer.append(l);
        String string = stringBuffer.toString();
        return string;
    }

    public static EJBKeyGenerator createInMemoryEJBKeyGenerator() {
        if (singleton == null) {
            singleton = new InMemoryEJBKeyGenerator();
        }
        return singleton;
    }

    private String getGeneratorUniquifier() {
        return this.generatorUniquifier;
    }

    static {
        mytc = PMLogger.registerTC(PMExceptionHandler.class);
    }
}

