/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ejbcontainer.jitdeploy;

import com.ibm.ejs.container.EJBConfigurationException;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.util.dopriv.SystemGetPropertyPrivileged;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.util.AccessController;
import java.io.File;
import java.io.FileOutputStream;
import java.lang.reflect.Method;
import java.rmi.RemoteException;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.GeneratorAdapter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class JITUtils {
    static final String JIT_TRACE_GROUP = "JITDeploy";
    static final String JIT_RSRC_BUNDLE = "com.ibm.ejs.container.container";
    static final String INDENT = "     ";
    static final Class[] NO_PARAMS = new Class[0];
    private static final String CLASS_NAME = JITUtils.class.getName();
    private static final TraceComponent tc = Tr.register(CLASS_NAME, "JITDeploy", "com.ibm.ejs.container.container");
    private static String svUserInstallRoot = null;
    static final Type TYPE_Exception = Type.getType((String)"Ljava/lang/Exception;");
    static final Type TYPE_Object = Type.getType((String)"Ljava/lang/Object;");
    static final Type TYPE_Object_ARRAY = Type.getType((String)"[Ljava/lang/Object;");
    static final Type TYPE_String = Type.getType((String)"Ljava/lang/String;");
    static final Type TYPE_Throwable = Type.getType((String)"Ljava/lang/Throwable;");
    static final Type TYPE_Serializable = Type.getType((String)"Ljava/io/Serializable;");

    JITUtils() {
    }

    static String convertClassName(String className) {
        return className.replace('.', '/');
    }

    static String convertClassName(Class<?> clazz) {
        if (clazz == null) {
            return null;
        }
        String className = clazz.getName();
        return className.replace('.', '/');
    }

    public static String methodKey(Method m) {
        StringBuilder result = new StringBuilder(m.getName());
        result.append("(");
        Class<?>[] argTypes = m.getParameterTypes();
        for (int i = 0; i < argTypes.length; ++i) {
            if (i > 0) {
                result.append(",");
            }
            result.append(argTypes[i].getName());
        }
        result.append(")");
        return result.toString();
    }

    static final String jdiMethodSignature(Method method) {
        StringBuilder sb = new StringBuilder();
        Class<?>[] methodParams = method.getParameterTypes();
        sb.append("(");
        for (int j = 0; j < methodParams.length; ++j) {
            sb.append(JITUtils.mapTypeToJDIEncoding(methodParams[j]));
        }
        sb.append(")");
        sb.append(JITUtils.mapTypeToJDIEncoding(method.getReturnType()));
        return sb.toString();
    }

    private static final String mapTypeToJDIEncoding(Class type) {
        String typeName = type.getName();
        String returnValue = type.isArray() ? typeName.replace('.', '/') : (typeName.indexOf(46) > 0 ? "L" + typeName.replace('.', '/') + ";" : (typeName.equals("void") ? "V" : (typeName.equals("boolean") ? "Z" : (typeName.equals("int") ? "I" : (typeName.equals("long") ? "J" : (typeName.equals("double") ? "D" : (typeName.equals("float") ? "F" : (typeName.equals("char") ? "C" : (typeName.equals("byte") ? "B" : (typeName.equals("short") ? "S" : "L" + typeName + ";"))))))))));
        return returnValue;
    }

    static Type[] getTypes(Class[] classes) {
        int size = classes.length;
        Type[] types = new Type[size];
        for (int i = 0; i < size; ++i) {
            types[i] = Type.getType((Class)classes[i]);
        }
        return types;
    }

    static Class<?>[] getCheckedExceptions(Method method, boolean isRmiRemote, boolean removeSubclasses) throws EJBConfigurationException {
        boolean throwsRemoteException = false;
        Class<?>[] exceptions = method.getExceptionTypes();
        int numExceptions = exceptions.length;
        ArrayList checkedExceptions = new ArrayList(numExceptions);
        for (Class<?> exception : exceptions) {
            Class checkedEx;
            int j;
            if (exception == RemoteException.class) {
                if (!isRmiRemote) {
                    Tr.warning(tc, "JIT_INVALID_THROW_REMOTE_CNTR5101W", new Object[]{method.getName(), method.getDeclaringClass().getName()});
                }
                throwsRemoteException = true;
                continue;
            }
            if (RemoteException.class.isAssignableFrom(exception)) {
                String className = method.getDeclaringClass().getName();
                Tr.error(tc, "JIT_INVALID_SUBCLASS_REMOTE_EX_CNTR5102E", new Object[]{exception.getName(), method.getName(), className});
                throw new EJBConfigurationException("Application exception " + exception.getName() + " defined on method " + method.getName() + " of interface " + className + " must not subclass java.rmi.RemoteException.");
            }
            if (removeSubclasses) {
                boolean isSubclass = false;
                for (Class<?> parentEx : exceptions) {
                    if (exception == parentEx || !parentEx.isAssignableFrom(exception)) continue;
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "getCheckedExceptions: ignoring " + exception.getName() + ", subclass of " + parentEx.getName());
                    }
                    isSubclass = true;
                    break;
                }
                if (isSubclass) continue;
                checkedExceptions.add(exception);
                continue;
            }
            int numChecked = checkedExceptions.size();
            for (j = 0; j < numChecked && !(checkedEx = (Class)checkedExceptions.get(j)).isAssignableFrom(exception); ++j) {
            }
            checkedExceptions.add(j, exception);
        }
        if (isRmiRemote && !throwsRemoteException) {
            String className = method.getDeclaringClass().getName();
            Tr.error(tc, "JIT_MISSING_REMOTE_EX_CNTR5104E", new Object[]{method.getName(), className});
            throw new EJBConfigurationException("Method " + method.getName() + " of interface " + className + " must throw java.rmi.RemoteException");
        }
        return checkedExceptions.toArray(new Class[checkedExceptions.size()]);
    }

    static Class<?>[] sortExceptions(Class<?>[] exceptions, boolean removeSubclasses) {
        int numExceptions = exceptions.length;
        ArrayList checkedExceptions = new ArrayList(numExceptions);
        for (Class<?> exception : exceptions) {
            Class checkedEx;
            int j;
            if (removeSubclasses) {
                boolean isSubclass = false;
                for (Class<?> parentEx : exceptions) {
                    if (exception == parentEx || !parentEx.isAssignableFrom(exception)) continue;
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "getCheckedExceptions: ignoring " + exception.getName() + ", subclass of " + parentEx.getName());
                    }
                    isSubclass = true;
                    break;
                }
                if (isSubclass) continue;
                checkedExceptions.add(exception);
                continue;
            }
            int numChecked = checkedExceptions.size();
            for (j = 0; j < numChecked && !(checkedEx = (Class)checkedExceptions.get(j)).isAssignableFrom(exception); ++j) {
            }
            checkedExceptions.add(j, exception);
        }
        return checkedExceptions.toArray(new Class[checkedExceptions.size()]);
    }

    static void unbox(GeneratorAdapter mg, Type type) {
        switch (type.getSort()) {
            case 0: {
                return;
            }
            case 1: {
                mg.visitTypeInsn(192, "java/lang/Boolean");
                mg.visitMethodInsn(182, "java/lang/Boolean", "booleanValue", "()Z");
                break;
            }
            case 2: {
                mg.visitTypeInsn(192, "java/lang/Character");
                mg.visitMethodInsn(182, "java/lang/Character", "charValue", "()C");
                break;
            }
            case 3: {
                mg.visitTypeInsn(192, "java/lang/Byte");
                mg.visitMethodInsn(182, "java/lang/Byte", "byteValue", "()B");
                break;
            }
            case 4: {
                mg.visitTypeInsn(192, "java/lang/Short");
                mg.visitMethodInsn(182, "java/lang/Short", "shortValue", "()S");
                break;
            }
            case 5: {
                mg.visitTypeInsn(192, "java/lang/Integer");
                mg.visitMethodInsn(182, "java/lang/Integer", "intValue", "()I");
                break;
            }
            case 6: {
                mg.visitTypeInsn(192, "java/lang/Float");
                mg.visitMethodInsn(182, "java/lang/Float", "floatValue", "()F");
                break;
            }
            case 7: {
                mg.visitTypeInsn(192, "java/lang/Long");
                mg.visitMethodInsn(182, "java/lang/Long", "longValue", "()J");
                break;
            }
            case 8: {
                mg.visitTypeInsn(192, "java/lang/Double");
                mg.visitMethodInsn(182, "java/lang/Double", "doubleValue", "()D");
                break;
            }
            default: {
                mg.checkCast(type);
            }
        }
    }

    static String USER_INSTALL_ROOT() {
        if (svUserInstallRoot == null) {
            try {
                String userInstallRoot = (String)AccessController.doPrivileged((PrivilegedAction)new SystemGetPropertyPrivileged("user.install.root", null));
                if (userInstallRoot == null) {
                    userInstallRoot = (String)AccessController.doPrivileged((PrivilegedAction)new SystemGetPropertyPrivileged("was.install.root", ""));
                }
                svUserInstallRoot = userInstallRoot;
            }
            catch (Throwable ex) {
                FFDCFilter.processException((Throwable)ex, (String)(CLASS_NAME + ".USER_INSTALL_ROOT"), (String)"419");
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "USER_INSTALL_ROOT() failed : " + ex.getMessage());
                }
                svUserInstallRoot = "";
            }
        }
        return svUserInstallRoot;
    }

    static void writeToClassFile(String internalClassName, byte[] classBytes) {
        block3: {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "writeToClassFile (" + internalClassName + ", " + (classBytes == null ? "null" : classBytes.length + " bytes") + ")");
            }
            try {
                File file = new File(JITUtils.USER_INSTALL_ROOT() + "/logs/JITDeploy/" + internalClassName + ".class");
                File directory = file.getParentFile();
                directory.mkdirs();
                FileOutputStream classFile = new FileOutputStream(file);
                classFile.write(classBytes);
                classFile.flush();
                classFile.close();
            }
            catch (Throwable ex) {
                FFDCFilter.processException((Throwable)ex, (String)(CLASS_NAME + ".writeToClassFile"), (String)"463");
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block3;
                Tr.debug(tc, "writeToClassFile failed for class " + internalClassName + " : " + ex.getMessage());
            }
        }
    }
}

