/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cpi;

import com.ibm.ejs.persistence.CollectionFactory;
import com.ibm.ejs.persistence.EJSJDBCPersister;
import com.ibm.ejs.persistence.EnumerationFactory;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.cpi.CPIException;
import com.ibm.websphere.cpi.Finder;
import com.ibm.websphere.cpi.Persister;
import com.ibm.websphere.cpi.PersisterConfigData;
import com.ibm.websphere.cpi.PersisterFactory;
import com.ibm.websphere.cpi.PersisterHome;
import com.ibm.websphere.cpi.PersisterTx;
import com.ibm.websphere.csi.EJBConfigData;
import com.ibm.ws.cpi.JDBCPersisterMetaDataImpl;
import com.ibm.ws.ffdc.FFDCFilter;
import java.rmi.RemoteException;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Properties;
import javax.ejb.FinderException;
import javax.naming.InitialContext;
import javax.sql.DataSource;

public class JDBCPersisterFactoryImpl
implements PersisterFactory {
    private static TraceComponent tc = Tr.register(JDBCPersisterFactoryImpl.class, "EJBContainer", "com.ibm.ejs.container.container");
    private static final String CLASS_NAME = "com.ibm.ws.cpi.JDBCPersisterFactoryImpl";

    public Persister create(EJBConfigData ejbConfigData) throws CPIException {
        EJSJDBCPersister result = null;
        PersisterConfigData persisterConfig = ejbConfigData.getPersisterConfigData();
        Properties persisterProps = persisterConfig.getProperties();
        String dataSourceName = (String)persisterProps.get("DataSourceName");
        DataSource dataSource = null;
        try {
            Object ejb = ejbConfigData.getDeploymentData();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "EJB : ", ejb);
            }
            if (ejbConfigData.getEJBComponentMetaData().getEJBComponentType() != 5) {
                return null;
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "looking up data source", dataSourceName);
            }
            if (dataSourceName == null) {
                Tr.warning(tc, "DATASOURCE_NAME_NULL_CNTR0026W", ejbConfigData.getJ2EEName());
                throw new CPIException("Data source name is not specified.");
            }
            InitialContext ic = new InitialContext();
            dataSource = (DataSource)ic.lookup(dataSourceName);
            JDBCPersisterMetaDataImpl pmd = new JDBCPersisterMetaDataImpl(ejb, persisterConfig, ejbConfigData.getClassLoader(), dataSource);
            result = EJSJDBCPersister.create(pmd);
        }
        catch (Exception ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.cpi.JDBCPersisterFactoryImpl.create", (String)"96", (Object)this);
            String errorMsg = "The bean's J2EEName is " + ejbConfigData.getJ2EEName() + ". The data source name is " + dataSourceName + ".";
            Tr.warning(tc, "ERROR_STARTING_CMP_BEAN_CNTR0031W", new Object[]{ejbConfigData.getJ2EEName(), ex});
            Tr.warning(tc, "ERROR_CREATING_CMP_PERSISTER_CNTR0032W", dataSourceName);
            throw new CPIException("Persister creation failed." + errorMsg, ex);
        }
        return result;
    }

    public Enumeration wrapResultsInEnumeration(PersisterTx txInfo, PersisterHome homeInfo, Finder finder) throws RemoteException, FinderException {
        return EnumerationFactory.create(txInfo, homeInfo, finder);
    }

    public Enumeration wrapResultsInEnumeration(PersisterTx txInfo, PersisterHome homeInfo, Enumeration keys) throws RemoteException, FinderException {
        return EnumerationFactory.create(txInfo, homeInfo, keys);
    }

    public Collection wrapResultsInCollection(PersisterTx txInfo, PersisterHome homeInfo, Finder finder) throws RemoteException, FinderException {
        return CollectionFactory.create(txInfo, homeInfo, finder);
    }

    public Collection wrapResultsInCollection(PersisterTx txInfo, PersisterHome homeInfo, Collection keys) throws RemoteException, FinderException {
        return CollectionFactory.create(txInfo, homeInfo, keys);
    }
}

