/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.container;

import com.ibm.ws.container.Configuration;
import com.ibm.ws.container.Container;
import com.ibm.ws.webcontainer.util.EmptyIterator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public abstract class AbstractContainer
implements Container {
    protected String name = null;
    private boolean isAlive = false;
    protected Map subElements = null;
    protected Map attributes = null;
    protected Configuration config = null;

    public boolean isAlive() {
        return this.isAlive;
    }

    public void setAttribute(String name, Object value) {
        if (this.attributes == null) {
            this.attributes = new HashMap();
        }
        this.attributes.put(name, value);
    }

    public Object getAttribute(String name) {
        return this.attributes.get(name);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public synchronized void start() {
        this.isAlive = true;
    }

    public synchronized void stop() {
        this.isAlive = false;
    }

    public synchronized void destroy() {
        if (!this.isAlive()) {
            return;
        }
        Iterator iter = this.subContainers();
        while (iter.hasNext()) {
            Container cont = (Container)iter.next();
            cont.destroy();
            this.removeSubContainer(cont.getName());
        }
        this.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Container removeSubContainer(String name) {
        if (this.subElements != null) {
            AbstractContainer abstractContainer = this;
            synchronized (abstractContainer) {
                return (Container)this.subElements.remove(name);
            }
        }
        return null;
    }

    public Container getSubContainer(String name) {
        Iterator i = this.subContainers();
        Container container2 = null;
        while (i.hasNext()) {
            Container c = (Container)i.next();
            if (!c.getName().equals(name)) continue;
            container2 = c;
        }
        return container2;
    }

    public Iterator subContainers() {
        if (this.subElements != null) {
            Map clonedElements = (Map)((HashMap)this.subElements).clone();
            return clonedElements.values().iterator();
        }
        return EmptyIterator.getInstance();
    }

    public boolean isActive() {
        return this.isAlive;
    }

    public void initialize(Configuration config) {
        this.config = config;
        this.name = config.getId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSubContainer(Container con) {
        if (con == null || con.getName() == null) {
            throw new RuntimeException("Container Name is null");
        }
        if (this.subElements == null) {
            this.subElements = new HashMap();
        }
        AbstractContainer abstractContainer = this;
        synchronized (abstractContainer) {
            this.subElements.put(con.getName(), con);
        }
    }

    protected Configuration getConfig() {
        return this.config;
    }

    protected void setConfig(Configuration config) {
        this.config = config;
    }
}

