/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.servlet.filter;

import com.ibm.ejs.sm.client.ui.NLS;
import com.ibm.websphere.servlet.filter.ServletChain;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;

public class ChainerServlet
extends HttpServlet {
    private static final long serialVersionUID = 3257291335513092404L;
    public static final String PARAM_SERVLET_PATHS = "chainer.pathlist";
    private static NLS nls = new NLS("com.ibm.ws.webcontainer.resources.Messages");
    private String[] chainPath = null;

    public void init() throws ServletException {
        String string = this.getRequiredInitParameter(PARAM_SERVLET_PATHS);
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        Vector<String> vector = new Vector<String>();
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken().trim();
            if (string2.length() <= 0) continue;
            vector.addElement(string2);
        }
        int n = vector.size();
        if (n > 0) {
            this.chainPath = new String[n];
            for (int i = 0; i < n; ++i) {
                this.chainPath[i] = (String)vector.elementAt(i);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void service(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        ServletChain servletChain = new ServletChain();
        try {
            String string = null;
            for (int i = 0; i < this.chainPath.length; ++i) {
                string = this.chainPath[i];
                RequestDispatcher requestDispatcher = this.getServletContext().getRequestDispatcher(string);
                servletChain.addRequestDispatcher(requestDispatcher);
            }
            servletChain.forward(new HttpServletRequestWrapper(httpServletRequest), new HttpServletResponseWrapper(httpServletResponse));
        }
        finally {
            if (servletChain != null) {
                servletChain.clear();
            }
        }
    }

    String getRequiredInitParameter(String string) throws ServletException {
        String string2 = this.getInitParameter(string);
        if (string2 == null) {
            throw new ServletException(MessageFormat.format(nls.getString("Missing.required.initialization.parameter", "Missing required initialization parameter: {0}"), string));
        }
        return string2;
    }

    public void destroy() {
    }
}

