/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.product.formatters;

import com.ibm.websphere.product.formatters.TextPrintFormatter;
import java.util.Iterator;
import java.util.Vector;

public class HTMLPrintFormatter
extends TextPrintFormatter {
    public static final String pgmVersion = "1.4";
    public static final String pgmUpdate = "9/3/02";
    public static final int BASE_TEXT_SIZE = 3;
    public static final int INDENT_PERCENTAGE = 10;

    protected String fontPrefix(int indent) {
        int size = 3 - indent;
        if (size < 0) {
            size = 0;
        }
        return "<FONT SIZE=\"+" + size + "\">";
    }

    protected String fontPostfix(int indent) {
        return "</FONT>";
    }

    protected void writeTablePrefix(int indent) {
        this.out.println("<TABLE WIDTH=\"100%\">");
        this.out.println("<TR><TD WIDTH=\"" + (indent *= 10) + "%\"></TD>");
        this.out.print("    <TD WIDTH=\"" + (100 - indent) + "%\">");
    }

    protected void writeTablePostfix(int indent) {
        this.out.println("</TD>");
        this.out.println("</TR>");
        this.out.println("</TABLE>");
    }

    public String embolden(String text) {
        return "<B>" + text + "</B>";
    }

    public void println(String text, int indent) {
        this.writeTablePrefix(indent);
        this.out.println(text);
        this.writeTablePostfix(indent);
    }

    public void blankLine() {
        this.out.println("<BR>");
    }

    public void printHeader(String text) {
        this.out.println("<HTML>");
        this.out.println("<HEAD>");
        this.out.println("<TITLE>" + text + "</TITLE>");
        this.out.println("</HEAD>");
        this.out.println("");
        this.out.println("<BODY>");
        this.out.println("<H1>" + text + "</H1>");
        this.out.println("<HR>");
    }

    public void printFooter(String text) {
        this.out.println("");
        this.out.println("<HR>");
        this.out.println("<H1>" + text + "</H1>");
        this.out.println("</BODY>");
        this.out.println("</HTML>");
    }

    public void printList(Iterator iterator, int indent) {
        this.writeTablePrefix(indent);
        this.out.println("");
        this.out.println("        <UL>");
        while (iterator.hasNext()) {
            this.out.println("            <LI>" + iterator.next() + "</LI>");
        }
        this.out.println("        </UL>");
        this.out.print("    ");
        this.writeTablePostfix(indent);
    }

    public void printTable(Vector allocations, Vector table, int indent) {
        this.writeTablePrefix(indent);
        this.out.println("");
        this.out.println("        <TABLE WIDTH=\"100%\">");
        Iterator tableWeights = allocations.iterator();
        Iterator tableRows = table.iterator();
        int[] nextWeights = null;
        while (tableRows.hasNext()) {
            if (tableWeights.hasNext()) {
                nextWeights = (int[])tableWeights.next();
            }
            Object[] nextRow = (Object[])tableRows.next();
            this.out.println("            <TR>");
            for (int columnNo = 0; columnNo < nextRow.length; ++columnNo) {
                Object nextColumnValue = nextRow[columnNo];
                int nextWeight = nextWeights[columnNo];
                this.out.println("                <TD WIDTH=\"" + nextWeight + "%\">" + nextColumnValue + "</TD>");
            }
            this.out.println("            </TR>");
        }
        this.out.println("        </TABLE>");
        this.out.print("    ");
        this.writeTablePostfix(indent);
    }
}

