/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.pmi;

import com.ibm.websphere.management.exception.AdminException;
import com.ibm.websphere.pmi.PmiConstants;
import com.ibm.websphere.pmi.client.PerfDescriptor;
import com.ibm.websphere.pmi.client.PmiClient;
import com.ibm.websphere.pmi.stat.CountStatisticImpl;
import com.ibm.websphere.pmi.stat.MBeanLevelSpec;
import com.ibm.websphere.pmi.stat.MBeanStatDescriptor;
import com.ibm.websphere.pmi.stat.RangeStatisticImpl;
import com.ibm.websphere.pmi.stat.StatDescriptor;
import com.ibm.websphere.pmi.stat.Statistic;
import com.ibm.websphere.pmi.stat.StatisticImpl;
import com.ibm.websphere.pmi.stat.Stats;
import com.ibm.websphere.pmi.stat.TimeStatisticImpl;
import java.io.Serializable;
import java.util.ArrayList;
import javax.management.ObjectName;

public class PmiClientTest
implements PmiConstants {
    static PmiClient pmiClnt = null;
    static String nodeName = null;
    static String serverName = null;
    static String portNumber = null;
    static String connectorType = null;
    static boolean success = true;

    public static void main(String[] stringArray) {
        try {
            Serializable[] serializableArray;
            if (stringArray.length < 1) {
                System.out.println("Parameters: host [portNumber] [connectorType] [serverName]");
                return;
            }
            nodeName = stringArray[0];
            if (stringArray.length > 1) {
                portNumber = stringArray[1];
            }
            if (stringArray.length > 2) {
                connectorType = stringArray[2];
            }
            pmiClnt = new PmiClient(nodeName, portNumber, "WAS50", false, connectorType);
            PerfDescriptor[] perfDescriptorArray = pmiClnt.listNodes();
            nodeName = perfDescriptorArray[0].getNodeName();
            System.out.println("use node " + nodeName);
            if (stringArray.length == 4) {
                serverName = stringArray[3];
            } else {
                serializableArray = pmiClnt.listServers(nodeName);
                if (serializableArray == null || serializableArray.length == 0) {
                    System.out.println("No server is found on node " + nodeName);
                    System.exit(1);
                }
                serverName = serializableArray[0].getName();
                System.out.println("Choose server " + serverName);
            }
            serializableArray = pmiClnt.listMBeans(nodeName, serverName);
            Serializable serializable = null;
            Serializable serializable2 = null;
            Serializable serializable3 = null;
            Serializable serializable4 = null;
            Serializable serializable5 = null;
            ArrayList<Serializable> arrayList = new ArrayList<Serializable>(10);
            if (serializableArray != null) {
                Object object;
                System.out.println("Number of MBeans retrieved= " + serializableArray.length);
                for (int i = 0; i < serializableArray.length; ++i) {
                    Serializable serializable6 = serializableArray[i];
                    object = ((ObjectName)serializable6).getKeyProperty("type");
                    if (object != null && ((String)object).equals("Server")) {
                        serializable2 = serializable6;
                        continue;
                    }
                    if (object != null && ((String)object).equals("Perf")) {
                        serializable = serializable6;
                        continue;
                    }
                    if (object != null && ((String)object).equals("WLM")) {
                        serializable3 = serializable6;
                        continue;
                    }
                    if (object != null && ((String)object).equals("EntityBean")) {
                        serializable4 = serializable6;
                        arrayList.add(serializable4);
                        continue;
                    }
                    if (object == null || !((String)object).equals("JVM")) continue;
                    serializable5 = serializable6;
                }
                PmiClientTest.testSetLevel(serializable2);
                PmiClientTest.testGetStats(arrayList);
                PmiClientTest.testGetStats2(new ObjectName[]{serializable5, serializable4});
                StatDescriptor statDescriptor = new StatDescriptor(new String[]{"wlmModule.server"});
                object = new MBeanStatDescriptor((ObjectName)serializable3, statDescriptor);
                Stats stats = pmiClnt.getStats(nodeName, serverName, (MBeanStatDescriptor)object, false);
                if (stats != null) {
                    System.out.println("\n\n WLM server data\n\n + " + ((Object)stats).toString());
                } else {
                    System.out.println("\n\n No WLM server data is availalbe.");
                }
                PmiClientTest.testListStatMembers((ObjectName)serializable2);
                PmiClientTest.testUpdate((ObjectName)serializable5, false, true);
            } else {
                System.out.println("No ObjectNames returned from Query");
            }
        }
        catch (Exception exception) {
            new AdminException(exception).printStackTrace();
            System.out.println("Exception = " + exception);
            exception.printStackTrace();
            success = false;
        }
        if (success) {
            System.out.println("\n\n All tests are passed");
        } else {
            System.out.println("\n\n Some tests are failed. Check for the exceptions");
        }
    }

    private static MBeanStatDescriptor[] getMBeanStatDescriptor(ArrayList arrayList) {
        if (arrayList == null || arrayList.size() == 0) {
            return null;
        }
        MBeanStatDescriptor[] mBeanStatDescriptorArray = new MBeanStatDescriptor[arrayList.size()];
        for (int i = 0; i < mBeanStatDescriptorArray.length; ++i) {
            mBeanStatDescriptorArray[i] = arrayList.get(i) instanceof ObjectName ? new MBeanStatDescriptor((ObjectName)arrayList.get(i)) : (MBeanStatDescriptor)arrayList.get(i);
        }
        return mBeanStatDescriptorArray;
    }

    private static void processStats(Stats stats) {
        PmiClientTest.processStats(stats, "");
    }

    private static void processStats(Stats stats, String string) {
        Stats[] statsArray;
        if (stats == null) {
            return;
        }
        System.out.println("\n\n");
        String string2 = stats.getName();
        System.out.println(string + "stats name=" + string2);
        Statistic[] statisticArray = stats.listStatistics();
        if (statisticArray != null) {
            for (int i = 0; i < statisticArray.length; ++i) {
                StatisticImpl statisticImpl;
                System.out.print(string + "    " + "data name=" + PmiClient.getNLSValue(statisticArray[i].getName()) + ", description=" + PmiClient.getNLSValue(statisticArray[i].getDescription()) + ", unit=" + PmiClient.getNLSValue(statisticArray[i].getUnit()) + ", startTime=" + statisticArray[i].getStartTime() + ", lastSampleTime=" + statisticArray[i].getLastSampleTime());
                if (statisticArray[i].getDataInfo().getType() == 2) {
                    System.out.println(", count=" + ((CountStatisticImpl)statisticArray[i]).getCount());
                    continue;
                }
                if (statisticArray[i].getDataInfo().getType() == 4) {
                    statisticImpl = (TimeStatisticImpl)statisticArray[i];
                    System.out.println(", count=" + ((TimeStatisticImpl)statisticImpl).getCount() + ", total=" + ((TimeStatisticImpl)statisticImpl).getTotal() + ", mean=" + ((TimeStatisticImpl)statisticImpl).getMean() + ", min=" + ((TimeStatisticImpl)statisticImpl).getMin() + ", max=" + ((TimeStatisticImpl)statisticImpl).getMax());
                    continue;
                }
                if (statisticArray[i].getDataInfo().getType() != 5) continue;
                statisticImpl = (RangeStatisticImpl)statisticArray[i];
                System.out.println(", current=" + ((RangeStatisticImpl)statisticImpl).getCurrent() + ", lowWaterMark=" + ((RangeStatisticImpl)statisticImpl).getLowWaterMark() + ", highWaterMark=" + ((RangeStatisticImpl)statisticImpl).getHighWaterMark() + ", integral=" + ((RangeStatisticImpl)statisticImpl).getIntegral() + ", avg=" + ((RangeStatisticImpl)statisticImpl).getMean());
            }
        }
        if ((statsArray = stats.getSubStats()) == null || statsArray.length == 0) {
            return;
        }
        for (int i = 0; i < statsArray.length; ++i) {
            PmiClientTest.processStats(statsArray[i], string + "    ");
        }
    }

    private static void testSetLevel(ObjectName objectName) {
        System.out.println("\n\n testSetLevel\n\n");
        try {
            MBeanLevelSpec mBeanLevelSpec = new MBeanLevelSpec(objectName, null, 7);
            pmiClnt.setStatLevel(nodeName, serverName, mBeanLevelSpec, true);
            System.out.println("after setInstrumentaionLevel high on server MBean\n\n");
            MBeanLevelSpec[] mBeanLevelSpecArray = pmiClnt.getStatLevel(nodeName, serverName, objectName, true);
            if (mBeanLevelSpecArray == null) {
                System.out.println("error: null from getInstrumentationLevel");
            } else {
                for (int i = 0; i < mBeanLevelSpecArray.length; ++i) {
                    if (mBeanLevelSpecArray[i] == null) continue;
                    int n = mBeanLevelSpecArray[i].getLevel();
                    ObjectName objectName2 = mBeanLevelSpecArray[i].getObjectName();
                    StatDescriptor statDescriptor = mBeanLevelSpecArray[i].getStatDescriptor();
                }
            }
        }
        catch (Exception exception) {
            new AdminException(exception).printStackTrace();
            exception.printStackTrace();
            System.out.println("Exception in testLevel");
            success = false;
        }
    }

    private static void testListStatMembers(ObjectName objectName) {
        System.out.println("\n\ntestListStatMembers \n");
        try {
            MBeanStatDescriptor[] mBeanStatDescriptorArray;
            int n;
            MBeanStatDescriptor[] mBeanStatDescriptorArray2 = pmiClnt.listStatMembers(nodeName, serverName, objectName);
            if (mBeanStatDescriptorArray2 == null) {
                return;
            }
            System.out.println(" listStatMembers for server MBean, num members (i.e. top level modules) is " + mBeanStatDescriptorArray2.length);
            for (n = 0; n < mBeanStatDescriptorArray2.length; ++n) {
                if (mBeanStatDescriptorArray2[n] == null) continue;
                mBeanStatDescriptorArray = mBeanStatDescriptorArray2[n].getObjectName();
                StatDescriptor statDescriptor = mBeanStatDescriptorArray2[n].getStatDescriptor();
            }
            for (n = 0; n < mBeanStatDescriptorArray2.length; ++n) {
                if (mBeanStatDescriptorArray2[n] == null) continue;
                System.out.println("\n\nlistStatMembers for msd=" + mBeanStatDescriptorArray2[n].toString());
                mBeanStatDescriptorArray = pmiClnt.listStatMembers(nodeName, serverName, mBeanStatDescriptorArray2[n]);
            }
        }
        catch (Exception exception) {
            new AdminException(exception).printStackTrace();
            exception.printStackTrace();
            System.out.println("Exception in testListStatMembers");
            success = false;
        }
    }

    private static void testGetStats(ArrayList arrayList) {
        System.out.println("\n\n testgetStats\n\n");
        try {
            Stats[] statsArray = pmiClnt.getStats(nodeName, serverName, PmiClientTest.getMBeanStatDescriptor(arrayList), true);
            if (statsArray == null) {
                return;
            }
            for (int i = 0; i < statsArray.length; ++i) {
                PmiClientTest.processStats(statsArray[i]);
            }
        }
        catch (Exception exception) {
            new AdminException(exception).printStackTrace();
            exception.printStackTrace();
            System.out.println("exception from testGetStats");
            success = false;
        }
    }

    private static void testGetStats2(ObjectName[] objectNameArray) {
        System.out.println("\n\n testGetStats2\n\n");
        try {
            Stats[] statsArray = pmiClnt.getStats(nodeName, serverName, objectNameArray, true);
            if (statsArray != null) {
                for (int i = 0; i < statsArray.length; ++i) {
                    if (statsArray[i] == null) continue;
                    System.out.println(((Object)statsArray[i]).toString());
                }
            } else {
                System.out.println("null stat");
            }
        }
        catch (Exception exception) {
            new AdminException(exception).printStackTrace();
            exception.printStackTrace();
            System.out.println("exception from testGetStats2");
            success = false;
        }
    }

    private static void testUpdate(ObjectName objectName, boolean bl, boolean bl2) {
        System.out.println("\n\n testUpdate\n\n");
        try {
            MBeanLevelSpec mBeanLevelSpec = new MBeanLevelSpec(objectName, null, 0);
            pmiClnt.setStatLevel(nodeName, serverName, mBeanLevelSpec, true);
            Stats stats = pmiClnt.getStats(nodeName, serverName, objectName, false);
            Stats stats2 = pmiClnt.getStats(nodeName, serverName, objectName, true);
            mBeanLevelSpec = new MBeanLevelSpec(objectName, null, 7);
            pmiClnt.setStatLevel(nodeName, serverName, mBeanLevelSpec, true);
            Stats stats3 = pmiClnt.getStats(nodeName, serverName, objectName, true);
            System.out.println("\n\n stats3 is");
            PmiClientTest.processStats(stats3);
            stats.update(stats3, bl, bl2);
            System.out.println("\n\n update stats1");
            PmiClientTest.processStats(stats);
            stats2.update(stats3, bl, bl2);
            System.out.println("\n\n update stats2");
            PmiClientTest.processStats(stats2);
        }
        catch (Exception exception) {
            System.out.println("\n\n Exception in testUpdate");
            exception.printStackTrace();
            success = false;
        }
    }
}

