/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.models.bindings.helpers.impl;

import com.ibm.ejs.models.base.bindings.webappbnd.WebAppBinding;
import com.ibm.etools.commonarchive.WARFile;
import com.ibm.websphere.models.bindings.helpers.PMEWebAppBindingHelper;
import com.ibm.websphere.models.bindings.pmebnd.PMEWebAppBinding;
import com.ibm.websphere.models.bindings.pmebnd.PmebndFactory;
import com.ibm.websphere.models.bindings.pmebnd.PmebndPackage;
import com.ibm.websphere.models.extensions.helpers.impl.PMEHelperUtils;
import com.ibm.websphere.models.extensions.helpers.impl.ResourceAndExtent;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;

public class PMEWebAppBindingHelperImpl
implements PMEWebAppBindingHelper {
    private Resource resource = null;
    private EList extent = null;
    private WebAppBinding basebnd = null;
    private PMEWebAppBinding pmeWebAppBinding;
    private boolean create = false;

    public PMEWebAppBindingHelperImpl(WARFile war) {
        this(war, true);
    }

    public PMEWebAppBindingHelperImpl(WARFile war, boolean create) {
        this.create = create;
        PMEHelperUtils.init();
        ResourceAndExtent resAndExt = PMEHelperUtils.getResourceAndExtent(war, "WEB-INF/ibm-web-bnd-pme.xmi", create);
        this.resource = resAndExt.resource;
        this.extent = resAndExt.extent;
        this.basebnd = war.getBindings();
        this.init();
    }

    public PMEWebAppBindingHelperImpl(ResourceSet resourceSet) {
        this(resourceSet, true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public PMEWebAppBindingHelperImpl(ResourceSet resourceSet, boolean create) {
        this.create = create;
        PMEHelperUtils.init();
        ResourceAndExtent resAndExt = PMEHelperUtils.getResourceAndExtent(resourceSet, "WEB-INF/ibm-web-bnd-pme.xmi", create);
        this.resource = resAndExt.resource;
        this.extent = resAndExt.extent;
        ResourceAndExtent baseResAndExt = PMEHelperUtils.getResourceAndExtent(resourceSet, "WEB-INF/ibm-web-bnd.xmi", create);
        if (baseResAndExt.extent != null) {
            if (baseResAndExt.extent.size() == 1) {
                EObject refobj = (EObject)baseResAndExt.extent.get(0);
                if (!(refobj instanceof WebAppBinding)) throw new IllegalStateException("unknown EObject type: " + refobj.getClass().getName());
                this.basebnd = (WebAppBinding)refobj;
            } else if (baseResAndExt.extent.size() > 1) {
                throw new IllegalStateException("More than one EObject!");
            }
        }
        this.init();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void init() {
        if (this.extent == null) return;
        if (this.extent.size() == 1) {
            EObject refobj = (EObject)this.extent.get(0);
            if (!(refobj instanceof PMEWebAppBinding)) throw new IllegalStateException("unknown EObject type: " + refobj.getClass().getName());
            this.pmeWebAppBinding = (PMEWebAppBinding)refobj;
            return;
        } else {
            if (this.extent.size() > 1) {
                throw new IllegalStateException("More than one EObject");
            }
            this.getPMEWebAppBinding();
        }
    }

    public PMEWebAppBinding getPMEWebAppBinding() {
        if (this.pmeWebAppBinding == null && this.create) {
            PmebndFactory f = PmebndPackage.eINSTANCE.getPmebndFactory();
            this.setPMEWebAppBinding(f.createPMEWebAppBinding());
        }
        return this.pmeWebAppBinding;
    }

    public void setPMEWebAppBinding(PMEWebAppBinding bnd) {
        this.pmeWebAppBinding = bnd;
        if (this.extent != null) {
            if (this.extent.size() > 0) {
                this.extent.set(0, this.pmeWebAppBinding);
            } else {
                this.extent.add(this.pmeWebAppBinding);
            }
        }
    }

    public void releaseResources() {
        this.resource = null;
        this.extent = null;
    }
}

