/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.models.base.serialization;

import com.ibm.websphere.models.base.serialization.Messages;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.xmi.XMLHelper;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.emf.ecore.xmi.impl.SAXXMLHandler;

public abstract class PMESAXXMLHandler
extends SAXXMLHandler {
    protected EObject extension;

    public PMESAXXMLHandler(XMLResource xmiResource, XMLHelper helper, Map options) {
        super(xmiResource, helper, options);
        this.idAttribute = "id";
    }

    protected String getCurrentElementLocalName() {
        String elementName;
        String localName = elementName = (String)this.elements.peek();
        int index = elementName.indexOf(":");
        if (index != -1) {
            localName = elementName.substring(index + 1);
        }
        return localName;
    }

    protected EObject getExtension() {
        return this.extension;
    }

    protected abstract URI getExtensionsURISuffix();

    protected abstract String getRootElementName();

    protected void handleRootElement() {
        EObject deploymentDescriptor = (EObject)this.resourceSet.getLoadOptions().get("Merged Deployment Descriptor");
        this.extension = this.getExt(deploymentDescriptor);
        if (this.extension == null) {
            URI uri = this.xmlResource.getURI();
            URI ddSuffix = this.getExtensionsURISuffix();
            URI ddUri = uri.trimSegments(ddSuffix.segmentCount());
            Resource resource = this.resourceSet.getResource(ddUri = ddUri.appendSegments(ddSuffix.segments()), true);
            if (resource != null) {
                this.extension = (EObject)resource.getContents().get(0);
            } else {
                Logger logger = Logger.getLogger("com.ibm.websphere.models.base", "com.ibm.websphere.models.base.serialization.messages");
                logger.logp(Level.SEVERE, this.getClass().getName(), "handleRootElement", "PMEbase.0", new Object[]{ddUri});
                throw new IllegalArgumentException(Messages.getString("PMEbase.0.1"));
            }
        }
    }

    protected abstract EObject getExt(EObject var1);

    protected abstract boolean isRootObject(EObject var1);

    protected void processElement(String name, String prefix, String localName) {
        super.processElement(name, prefix, localName);
        String rootElementName = this.getRootElementName();
        if (rootElementName != null && rootElementName.equals(localName)) {
            this.handleRootElement();
        }
    }

    protected void setAttribValue(EObject object, String name, String value) {
        if (this.isRootObject(object) && "version".equals(name)) {
            return;
        }
        super.setAttribValue(object, name, value);
    }
}

