/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.management.remote;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.exception.ConnectorAuthenticationException;
import com.ibm.websphere.management.exception.ConnectorException;
import com.ibm.ws.management.util.SecurityHelper;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorProvider;
import javax.management.remote.JMXServiceURL;
import javax.management.remote.rmi.RMIConnector;
import javax.management.remote.rmi.RMIServer;
import javax.naming.InitialContext;
import javax.rmi.PortableRemoteObject;
import javax.security.auth.Subject;

public class WsProvider
implements JMXConnectorProvider {
    private static final String bundleName = "com.ibm.ws.management.resources.connector";
    private static TraceComponent tc = Tr.register(WsProvider.class, "Admin", "com.ibm.ws.management.resources.connector");

    public WsProvider() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "WsProvider");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "WsProvider");
        }
    }

    public JMXConnector newJMXConnector(JMXServiceURL jmxServiceURL, Map _map) throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "newJMXConnector", new Object[]{jmxServiceURL, _map});
        }
        String username = null;
        String password = null;
        boolean securityEnabled = false;
        RMIServer rmiServer = null;
        RMIConnector rmiConnector = null;
        HashMap map = new HashMap(_map);
        Properties clientProp = new Properties();
        if (map.containsKey("java.naming.security.principal") && map.containsKey("java.naming.security.credentials")) {
            username = (String)map.get("java.naming.security.principal");
            password = (String)map.get("java.naming.security.credentials");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Getting Context.SECURITY_PRINCIPAL and Context.SECURITY_CREDENTIALS from map: uid=" + username);
            }
            if (username != null && password != null) {
                if (tc.isDebugEnabled() && password.length() > 0) {
                    Tr.debug(tc, "...and pwd=*****");
                }
                clientProp.setProperty("username", username);
                clientProp.setProperty("password", password);
                securityEnabled = true;
                map.remove("java.naming.security.principal");
                map.remove("java.naming.security.credentials");
            }
        } else if (map.containsKey("jmx.remote.credentials")) {
            String[] creds;
            Object cred = map.get("jmx.remote.credentials");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Getting jmx.remote.credentials from map: " + cred);
            }
            if (cred != null && cred instanceof String[] && (creds = (String[])cred) != null && creds.length == 2) {
                username = creds[0];
                if (username != null) {
                    clientProp.setProperty("username", username);
                }
                if ((password = creds[1]) != null) {
                    clientProp.setProperty("password", password);
                }
                if (username != null && password != null) {
                    securityEnabled = true;
                }
                map.remove("jmx.remote.credentials");
            }
        } else if (map.containsKey("username") && map.containsKey("password")) {
            username = (String)map.get("username");
            password = (String)map.get("password");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Getting username and password from map: uid=" + username);
            }
            if (username != null && password != null) {
                if (tc.isDebugEnabled() && password.length() > 0) {
                    Tr.debug(tc, "...and pwd=*****");
                }
                clientProp.setProperty("username", username);
                clientProp.setProperty("password", password);
                securityEnabled = true;
            }
        }
        String url = jmxServiceURL.getURLPath();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "JMXServiceURL", url);
        }
        if (!url.startsWith("/jndi/")) {
            throw new MalformedURLException("URL path must begin with /jndi/");
        }
        Properties env = new Properties();
        env.setProperty("com.ibm.websphere.naming.jndicache.cacheobject", "none");
        String host = jmxServiceURL.getHost();
        int port = jmxServiceURL.getPort();
        if (host.indexOf(58) > -1 && host.indexOf(91) < 0) {
            host = "[" + host + "]";
        }
        String jndiURL = url.substring(6);
        env.put("java.naming.provider.url", "corbaloc:iiop:" + host + ":" + port + "/" + "WsnAdminNameService");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "ENV", env);
        }
        try {
            InitialContext initialContext = new InitialContext(env);
            if (securityEnabled) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Username and password are available; authenticate using the data");
                }
                try {
                    initialContext.lookup("");
                    this.authenticate(clientProp);
                }
                catch (Exception e) {
                    throw new ConnectorException(e);
                }
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Calling lookup for " + jndiURL);
            }
            Object obj = initialContext.lookup(jndiURL);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Lookup found " + obj.getClass().getName());
            }
            rmiServer = (RMIServer)PortableRemoteObject.narrow((Object)obj, RMIServer.class);
            rmiConnector = new RMIConnector(rmiServer, map);
        }
        catch (Exception ex) {
            throw new IOException("Connector not available: " + ex.getMessage());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "newJMXConnector", new Object[]{rmiConnector});
        }
        return rmiConnector;
    }

    private void authenticate(Properties props) throws ConnectorAuthenticationException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "authenticate");
        }
        if (props != null) {
            try {
                String username = props.getProperty("username");
                String password = props.getProperty("password");
                if (username != null && password != null) {
                    Subject subject = SecurityHelper.authenticate(username, password);
                    SecurityHelper.setInvocationSubject(subject);
                }
            }
            catch (Exception ex) {
                throw new ConnectorAuthenticationException("RMI Connector login failed", ex);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "authenticate");
        }
    }
}

