/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.management.configservice.tasks;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.ffdc.Manager;
import com.ibm.websphere.management.AdminClient;
import com.ibm.websphere.management.AdminService;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.management.configservice.ConfigServiceProxy;
import com.ibm.websphere.management.exception.ConfigServiceException;
import com.ibm.websphere.management.exception.ConnectorException;
import com.ibm.ws.management.AdminHelper;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Properties;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InstallRARTask {
    String LOCAL = "local_";
    private static TraceComponent tc = Tr.register(InstallRARTask.class, "management", "com.ibm.ws.management.resources.configservice");
    private ConfigService configService;
    static final String _SERVER = "Server";
    static final String _NODE = "Node";
    static final String _CLUSTER = "ServerCluster";
    static final String _CELL = "Cell";

    public InstallRARTask(ConfigService configService) {
        this.configService = configService;
    }

    public ObjectName installResourceAdapter(Session session, String string, String string2, Hashtable hashtable) throws ConfigServiceException, ConnectorException {
        String string3;
        boolean bl;
        Object object;
        ObjectName[] objectNameArray;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "installResourceAdapter", new Object[]{session, string, string2, hashtable});
        }
        if (hashtable == null) {
            hashtable = new Hashtable<String, String>();
        }
        if ((objectNameArray = this.configService.resolve(session, "Node=" + string)).length == 0) {
            Manager.Ffdc.log(new Throwable().fillInStackTrace(), (Object)this, "com.ibm.websphere.management.configservice.tasks.InstallRARTask", "63", new Object[]{this});
            String string4 = TraceNLS.getFormattedMessage("com.ibm.ws.management.resources.configservice", "ADMG0034E", new Object[]{string}, null);
            throw new ConfigServiceException(string4);
        }
        int n = 0;
        Boolean bl2 = (Boolean)hashtable.get("rar.DeleteSourceRar");
        if (bl2 != null && bl2.booleanValue()) {
            n = 1000;
        }
        ObjectName objectName = objectNameArray[0];
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "node", objectName);
        }
        boolean bl3 = false;
        String string5 = (String)hashtable.get("rar.isolatedClassLoader");
        if (string5 != null) {
            if (string5.equalsIgnoreCase("true")) {
                string5 = hashtable.put("rar.isolatedClassLoader", "true");
                bl3 = true;
            }
            if (string5.equals("")) {
                bl3 = true;
                hashtable.put("rar.isolatedClassLoader", "true");
            }
        }
        if (bl3 && (object = (String)hashtable.get("rar.nativePath")) != null) {
            Manager.Ffdc.log(new Throwable().fillInStackTrace(), (Object)this, "com.ibm.websphere.management.configservice.tasks.InstallRARTask", "134", new Object[]{this});
            String string6 = TraceNLS.getFormattedMessage("com.ibm.ws.management.resources.configservice", "ADMG0305E", new Object[]{string2}, null);
            throw new ConfigServiceException(string6);
        }
        object = new File(string2.replace('\\', '/'));
        String string7 = (String)hashtable.get("rar.archivePath");
        if (string7 == null) {
            string7 = "${CONNECTOR_INSTALL_ROOT}/";
        }
        if (!string7.trim().endsWith("/") && !string7.trim().endsWith(File.separator)) {
            string7 = string7 + "/";
        }
        string7 = string7 + ((File)object).getName();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Archive path: " + string7);
        }
        try {
            boolean bl4 = InstallRARTask.isJ2CRAExist(session, this.configService, string7, bl3, objectName);
        }
        catch (NullPointerException nullPointerException) {
            Manager.Ffdc.log(new Throwable().fillInStackTrace(), (Object)this, "com.ibm.websphere.management.configservice.tasks.InstallRARTask", "165");
            String string8 = TraceNLS.getFormattedMessage("com.ibm.ws.management.resources.configservice", "ADMG0306E", new Object[]{nullPointerException}, null);
            ConfigServiceException configServiceException = new ConfigServiceException(string8);
            configServiceException.initCause(nullPointerException);
            throw configServiceException;
        }
        catch (ConfigServiceException configServiceException) {
            throw configServiceException;
        }
        String string9 = (String)hashtable.get("rar.enableHASupport");
        boolean bl5 = false;
        if (string9 != null) {
            if (string9.equalsIgnoreCase("yes")) {
                bl5 = true;
            }
            if (string9.equals("")) {
                bl5 = true;
                hashtable.put("rar.enableHASupport", "true");
            }
        }
        if (bl5 && !(bl = InstallRARTask.validateHACapability(string3 = (String)hashtable.get("rar.HACapability")))) {
            hashtable.put("rar.HACapability", "no");
        }
        string3 = "getResourceAdapterFromRAR";
        String[] stringArray = new String[]{"java.lang.String", "java.util.Hashtable"};
        Object[] objectArray = new Object[]{string2, hashtable};
        AttributeList attributeList = (AttributeList)this.invoke(session, objectName, string, string3, objectArray, stringArray);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "raAttrList", attributeList);
        }
        string3 = "extractArchive";
        stringArray = new String[]{"java.lang.String", "java.lang.String", "int"};
        String string10 = null;
        try {
            string10 = (String)ConfigServiceHelper.getAttributeValue(attributeList, "archivePath");
        }
        catch (AttributeNotFoundException attributeNotFoundException) {
            String string11 = TraceNLS.getFormattedMessage("com.ibm.ws.management.resources.configservice", "ADMG0011E", null, null);
            throw new ConfigServiceException(attributeNotFoundException, string11);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "dest", string10);
        }
        objectArray = new Object[]{string2, string10, new Integer(n)};
        this.invoke(session, objectName, string, string3, objectArray, stringArray);
        ObjectName objectName2 = this.configService.createConfigData(session, objectName, "J2CResourceAdapter", null, attributeList);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "installResourceAdapter", objectName2);
        }
        return objectName2;
    }

    private Object invoke(Session session, ObjectName objectName, String string, String string2, Object[] objectArray, String[] stringArray) throws ConfigServiceException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "invoke", new Object[]{session, objectName, string, string2, objectArray, stringArray});
        }
        Object object = null;
        try {
            if (this.configService instanceof ConfigServiceProxy) {
                Object object2;
                Object object3;
                ObjectName objectName2;
                ConfigServiceProxy configServiceProxy = (ConfigServiceProxy)this.configService;
                AdminClient adminClient = configServiceProxy.getAdminClient();
                ObjectName objectName3 = adminClient.getServerMBean();
                String string3 = (String)adminClient.invoke(objectName3, "getProcessType", null, null);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "configService processType", string3);
                }
                if (string3.equals("UnManagedProcess") || string3.equals("AdminAgent")) {
                    objectName2 = new ObjectName("*:node=" + string + ",type=AdminOperations,*");
                } else {
                    object3 = new ObjectName("*:node=" + string + ",type=NodeAgent,*");
                    object2 = adminClient.queryNames((ObjectName)object3, null);
                    if (object2.isEmpty()) {
                        throw new InstanceNotFoundException(((ObjectName)object3).getCanonicalName());
                    }
                    String string4 = ((ObjectName)object2.iterator().next()).getKeyProperty("process");
                    objectName2 = new ObjectName("*:node=" + string + ",process=" + string4 + ",type=AdminOperations,*");
                }
                object3 = adminClient.queryNames(objectName2, null);
                if (object3.size() == 0) {
                    throw new InstanceNotFoundException(objectName2.getCanonicalName());
                }
                object2 = (ObjectName)object3.iterator().next();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "adminOp", object2);
                }
                object = adminClient.invoke((ObjectName)object2, string2, objectArray, stringArray);
            } else {
                AdminService adminService = AdminServiceFactory.getAdminService();
                if (adminService == null) {
                    String string5 = System.getProperty("local.node");
                    Tr.debug(tc, "local node=" + string5 + "while the target node =" + string);
                    if (!string5.equals(string)) {
                        throw new UnsupportedOperationException("Target node should be the same as the current node in local node mode.");
                    }
                    Class<?> clazz = Class.forName("com.ibm.ws.management.component.AdminOperationsMBean");
                    Class<?> clazz2 = Class.forName("java.lang.String");
                    Class<Integer> clazz3 = Integer.TYPE;
                    Class<?> clazz4 = Class.forName("java.util.Hashtable");
                    ObjectName[] objectNameArray = this.configService.getRelationship(session, objectName, "parent");
                    String string6 = ConfigServiceHelper.getDisplayName(objectNameArray[0]);
                    String string7 = System.getProperty("was.repository.root");
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "configRoot" + string7 + " cell=" + string6 + "node = " + string);
                    }
                    Class[] classArray = null;
                    Object[] objectArray2 = null;
                    if (string2.equals("getResourceAdapterFromRAR") || string2.equals("getRARInfo")) {
                        classArray = new Class[]{clazz2, clazz4, clazz2, clazz2, clazz2};
                        objectArray2 = new Object[]{objectArray[0], objectArray[1], string7, string6, string};
                    } else {
                        classArray = new Class[]{clazz2, clazz2, clazz3, clazz2, clazz2, clazz2};
                        objectArray2 = new Object[]{objectArray[0], objectArray[1], objectArray[2], string7, string6, string};
                    }
                    Method method = clazz.getMethod(this.LOCAL + string2, classArray);
                    object = method.invoke(null, objectArray2);
                } else {
                    Object object4;
                    ObjectName objectName4;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "adminService processType", adminService.getProcessType());
                    }
                    if (adminService.getProcessType().equals("UnManagedProcess") || adminService.getProcessType().equals("AdminAgent")) {
                        objectName4 = new ObjectName("*:node=" + string + ",type=AdminOperations,*");
                    } else {
                        object4 = AdminHelper.getInstance().getNodeAgentName(string);
                        objectName4 = new ObjectName("*:node=" + string + ",process=" + (String)object4 + ",type=AdminOperations,*");
                    }
                    object4 = adminService.queryNames(objectName4, null);
                    if (object4.size() == 0) {
                        throw new InstanceNotFoundException(objectName4.getCanonicalName());
                    }
                    ObjectName objectName5 = (ObjectName)object4.iterator().next();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "adminOp", objectName5);
                    }
                    object = adminService.invoke(objectName5, string2, objectArray, stringArray);
                }
            }
        }
        catch (ConnectorException connectorException) {
            throw connectorException;
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            throw new ConfigServiceException(throwable);
        }
        catch (Exception exception) {
            Manager.Ffdc.log((Throwable)exception, (Object)this, "com.ibm.websphere.management.configservice.tasks.InstallRARTask", "71", new Object[]{this});
            throw new ConfigServiceException(exception);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "invoke", object);
        }
        return object;
    }

    public Hashtable getRARInfo(Session session, String string, String string2, Hashtable hashtable) throws ConfigServiceException, ConnectorException {
        ObjectName[] objectNameArray;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "installResourceAdapter", new Object[]{session, string, string2, hashtable});
        }
        Hashtable hashtable2 = new Hashtable();
        if (hashtable == null) {
            hashtable = new Hashtable();
        }
        if ((objectNameArray = this.configService.resolve(session, "Node=" + string)).length == 0) {
            Manager.Ffdc.log(new Throwable().fillInStackTrace(), (Object)this, "com.ibm.websphere.management.configservice.tasks.InstallRARTask", "63", new Object[]{this});
            String string3 = TraceNLS.getFormattedMessage("com.ibm.ws.management.resources.configservice", "ADMG0034E", new Object[]{string}, null);
            throw new ConfigServiceException(string3);
        }
        ObjectName objectName = objectNameArray[0];
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "node", objectName);
        }
        String string4 = "getRARInfo";
        String[] stringArray = new String[]{"java.lang.String", "java.util.Hashtable"};
        Object[] objectArray = new Object[]{string2, hashtable};
        hashtable2 = (Hashtable)this.invoke(session, objectName, string, string4, objectArray, stringArray);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getRAInfo ", hashtable2);
        }
        return hashtable2;
    }

    public static boolean validateHACapability(String string) {
        if (string == null) {
            return false;
        }
        return string.equals("endpoint") || string.equals("instance") || string.equals("no");
    }

    public static boolean isJ2CRAExist(Session session, ConfigService configService, String string, boolean bl, ObjectName objectName) throws ConfigServiceException {
        return InstallRARTask.isJ2CRAExist(session, configService, string, bl, objectName, null);
    }

    public static boolean isJ2CRAExist(Session session, ConfigService configService, String string, boolean bl, ObjectName objectName, ObjectName objectName2) throws ConfigServiceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isJ2CRAExist " + string + " isolated : " + bl + " scope : " + objectName);
        }
        ObjectName objectName3 = null;
        ObjectName objectName4 = null;
        ObjectName[] objectNameArray = null;
        boolean bl2 = false;
        String string2 = objectName.getKeyProperty("_Websphere_Config_Data_Type");
        String string3 = objectName.getKeyProperty("_Websphere_Config_Data_Display_Name");
        String string4 = null;
        try {
            if (string2.equals(_SERVER)) {
                objectNameArray = configService.getRelationship(session, objectName, "parent");
                if (objectNameArray.length > 0) {
                    objectName4 = objectNameArray[0];
                    string4 = objectName4.getKeyProperty("_Websphere_Config_Data_Display_Name");
                    objectNameArray = configService.getRelationship(session, objectName4, "parent");
                    if (objectNameArray.length > 0) {
                        objectName3 = objectNameArray[0];
                    }
                }
            } else if (string2.equals(_NODE)) {
                string4 = string3;
                string3 = null;
                objectNameArray = configService.getRelationship(session, objectName, "parent");
                if (objectNameArray.length > 0) {
                    objectName3 = objectNameArray[0];
                }
            } else if (string2.equals(_CLUSTER) && (objectNameArray = configService.getRelationship(session, objectName, "parent")).length > 0) {
                objectName3 = objectNameArray[0];
            }
        }
        catch (ConnectorException connectorException) {
            Manager.Ffdc.log(new Throwable().fillInStackTrace(), InstallRARTask.class, "com.ibm.websphere.management.configservice.tasks.InstallRARTask", "376");
            String string5 = TraceNLS.getFormattedMessage("com.ibm.ws.management.resources.configservice", "ADMG0306E", new Object[]{connectorException}, null);
            ConfigServiceException configServiceException = new ConfigServiceException(string5);
            configServiceException.setStackTrace(connectorException.getStackTrace());
            throw configServiceException;
        }
        List<ObjectName> list = InstallRARTask.listResources(session, configService, "J2CResourceAdapter", string, true, objectName3);
        if (list != null) {
            bl2 = true;
            String[] stringArray = new String[]{null, null, null};
            String string6 = null;
            String string7 = null;
            String string8 = null;
            for (ObjectName objectName5 : list) {
                String string9;
                InstallRARTask.getLocation(session, configService, objectName5, stringArray);
                string6 = stringArray[0];
                string7 = stringArray[1];
                string8 = stringArray[2];
                if (string2.equals(_SERVER) && string6.equals(_SERVER) && !string7.equals(string3) || (string2.equals(_NODE) || string2.equals(_SERVER) ? string8 != null && !string8.equals(string4) : string2.equals(_CLUSTER) && (string6.equals(_CLUSTER) && !string7.equals(string3) || string6.equals(_NODE)))) continue;
                boolean bl3 = false;
                try {
                    bl3 = (Boolean)configService.getAttribute(session, objectName5, "isolatedClassLoader");
                }
                catch (ConnectorException connectorException) {
                    Manager.Ffdc.log(new Throwable().fillInStackTrace(), InstallRARTask.class, "com.ibm.websphere.management.configservice.tasks.InstallRARTask", "438");
                    string9 = TraceNLS.getFormattedMessage("com.ibm.ws.management.resources.configservice", "ADMG0306E", new Object[]{connectorException}, null);
                    throw new ConfigServiceException(string9);
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "found ra " + objectName5);
                }
                if (bl3 == bl) continue;
                String string10 = null;
                string9 = null;
                if (objectName2 != null) {
                    string10 = objectName5.getKeyProperty("_Websphere_Config_Data_Id");
                    string9 = objectName2.getKeyProperty("_Websphere_Config_Data_Id");
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "id0 = " + string10 + "id1 =" + string9);
                    }
                }
                if (string9 != null && string10.equals(string9)) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "mode did not match : " + bl);
                }
                Manager.Ffdc.log(new Throwable().fillInStackTrace(), InstallRARTask.class, "com.ibm.websphere.management.configservice.tasks.InstallRARTask", "446");
                String string11 = TraceNLS.getFormattedMessage("com.ibm.ws.management.resources.configservice", "ADMG0304E", new Object[]{string}, null);
                throw new ConfigServiceException(string11);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isJ2CRAExist returns " + bl2);
        }
        return bl2;
    }

    private static void getLocation(Session session, ConfigService configService, ObjectName objectName, String[] stringArray) {
        Properties properties = ConfigServiceHelper.getObjectLocation(objectName);
        String string = (String)properties.get("server");
        String string2 = (String)properties.get("node");
        String string3 = (String)properties.get("cluster");
        if (string != null) {
            stringArray[0] = _SERVER;
            stringArray[1] = string;
            stringArray[2] = string2;
        } else if (string2 != null) {
            stringArray[0] = _NODE;
            stringArray[2] = string2;
        } else if (string3 != null) {
            stringArray[0] = _CLUSTER;
            stringArray[1] = string3;
        } else {
            stringArray[0] = _CELL;
        }
    }

    public static List<ObjectName> listResources(Session session, ConfigService configService, String string, String string2, boolean bl, ObjectName objectName) throws ConfigServiceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "listResources : " + string + " aechivePath: " + string2 + " recursive " + bl + " scope = " + objectName);
        }
        ArrayList<ObjectName> arrayList = null;
        ObjectName[] objectNameArray = null;
        ObjectName objectName2 = null;
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        hashtable.put("_Websphere_Config_Data_Type", string);
        try {
            objectName2 = new ObjectName("WebSphere", hashtable);
            objectNameArray = configService.queryConfigObjects(session, objectName, objectName2, null);
        }
        catch (MalformedObjectNameException malformedObjectNameException) {
            Manager.Ffdc.log(new Throwable().fillInStackTrace(), InstallRARTask.class, "com.ibm.websphere.management.configservice.tasks.InstallRARTask", "405");
            String string3 = TraceNLS.getFormattedMessage("com.ibm.ws.management.resources.configservice", "ADMG0306E", new Object[]{malformedObjectNameException}, null);
            throw new ConfigServiceException(string3);
        }
        catch (NullPointerException nullPointerException) {
            Manager.Ffdc.log(new Throwable().fillInStackTrace(), InstallRARTask.class, "com.ibm.websphere.management.configservice.tasks.InstallRARTask", "410");
            String string4 = TraceNLS.getFormattedMessage("com.ibm.ws.management.resources.configservice", "ADMG0306E", new Object[]{nullPointerException}, null);
            throw new ConfigServiceException(string4);
        }
        catch (ConnectorException connectorException) {
            Manager.Ffdc.log(new Throwable().fillInStackTrace(), InstallRARTask.class, "com.ibm.websphere.management.configservice.tasks.InstallRARTask", "415");
            String string5 = TraceNLS.getFormattedMessage("com.ibm.ws.management.resources.configservice", "ADMG0306E", new Object[]{connectorException}, null);
            throw new ConfigServiceException(string5);
        }
        for (ObjectName objectName3 : objectNameArray) {
            String string6 = null;
            try {
                string6 = (String)configService.getAttribute(session, objectName3, "archivePath");
                if (!string6.equalsIgnoreCase(string2)) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Found Archive Path = " + string6);
                }
                if (arrayList == null) {
                    arrayList = new ArrayList<ObjectName>();
                }
                arrayList.add(objectName3);
            }
            catch (ConnectorException connectorException) {
                Manager.Ffdc.log(new Throwable().fillInStackTrace(), InstallRARTask.class, "com.ibm.websphere.management.configservice.tasks.InstallRARTask", "496");
                String string7 = TraceNLS.getFormattedMessage("com.ibm.ws.management.resources.configservice", "ADMG0306E", new Object[]{connectorException}, null);
                throw new ConfigServiceException(string7);
            }
        }
        if (tc.isDebugEnabled() && arrayList != null && arrayList.size() != 0) {
            for (ObjectName objectName4 : arrayList) {
                Tr.debug(tc, "     ----" + objectName4);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "listResources");
        }
        return arrayList;
    }
}

