/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.uddi.datatype.binding;

import com.ibm.uddi.UDDIElement;
import com.ibm.uddi.UDDIException;
import com.ibm.uddi.datatype.Description;
import com.ibm.uddi.datatype.binding.AccessPoint;
import com.ibm.uddi.datatype.binding.HostingRedirector;
import com.ibm.uddi.datatype.binding.TModelInstanceDetails;
import java.util.Vector;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class BindingTemplate
extends UDDIElement {
    public static final String UDDI_TAG = "bindingTemplate";
    protected Element base = null;
    String bindingKey = null;
    String serviceKey = null;
    AccessPoint accessPoint = null;
    HostingRedirector hostingRedirector = null;
    TModelInstanceDetails tModelInstanceDetails = null;
    Vector description = new Vector();

    public BindingTemplate() {
    }

    public BindingTemplate(String string, TModelInstanceDetails tModelInstanceDetails) {
        this.bindingKey = string;
        this.tModelInstanceDetails = tModelInstanceDetails;
    }

    public BindingTemplate(Element element) throws UDDIException {
        super(element);
        this.bindingKey = element.getAttribute("bindingKey");
        this.serviceKey = element.getAttribute("serviceKey");
        NodeList nodeList = null;
        nodeList = this.getChildElementsByTagName(element, "accessPoint");
        if (nodeList.getLength() > 0) {
            this.accessPoint = new AccessPoint((Element)nodeList.item(0));
        }
        if ((nodeList = this.getChildElementsByTagName(element, "hostingRedirector")).getLength() > 0) {
            this.hostingRedirector = new HostingRedirector((Element)nodeList.item(0));
        }
        if ((nodeList = this.getChildElementsByTagName(element, "tModelInstanceDetails")).getLength() > 0) {
            this.tModelInstanceDetails = new TModelInstanceDetails((Element)nodeList.item(0));
        }
        nodeList = this.getChildElementsByTagName(element, "description");
        int n = 0;
        while (n < nodeList.getLength()) {
            this.description.addElement(new Description((Element)nodeList.item(n)));
            ++n;
        }
    }

    public AccessPoint getAccessPoint() {
        return this.accessPoint;
    }

    public String getBindingKey() {
        return this.bindingKey;
    }

    public String getDefaultDescriptionString() {
        if (this.description.size() > 0) {
            Description description = (Description)this.description.elementAt(0);
            return description.getText();
        }
        return null;
    }

    public Vector getDescriptionVector() {
        return this.description;
    }

    public HostingRedirector getHostingRedirector() {
        return this.hostingRedirector;
    }

    public String getServiceKey() {
        return this.serviceKey;
    }

    public TModelInstanceDetails getTModelInstanceDetails() {
        return this.tModelInstanceDetails;
    }

    public void saveToXML(Element element) {
        this.base = element.getOwnerDocument().createElement(UDDI_TAG);
        if (this.bindingKey != null) {
            this.base.setAttribute("bindingKey", this.bindingKey);
        }
        if (this.serviceKey != null) {
            this.base.setAttribute("serviceKey", this.serviceKey);
        }
        int n = 0;
        while (n < this.description.size()) {
            ((Description)this.description.elementAt(n)).saveToXML(this.base);
            ++n;
        }
        if (this.accessPoint != null) {
            this.accessPoint.saveToXML(this.base);
        }
        if (this.hostingRedirector != null) {
            this.hostingRedirector.saveToXML(this.base);
        }
        if (this.tModelInstanceDetails != null) {
            this.tModelInstanceDetails.saveToXML(this.base);
        }
        element.appendChild(this.base);
    }

    public void setAccessPoint(AccessPoint accessPoint) {
        this.accessPoint = accessPoint;
    }

    public void setBindingKey(String string) {
        this.bindingKey = string;
    }

    public void setDefaultDescriptionString(String string) {
        if (this.description.size() > 0) {
            this.description.setElementAt(new Description(string), 0);
        } else {
            this.description.addElement(new Description(string));
        }
    }

    public void setDescriptionVector(Vector vector) {
        this.description = vector;
    }

    public void setHostingRedirector(HostingRedirector hostingRedirector) {
        this.hostingRedirector = hostingRedirector;
    }

    public void setServiceKey(String string) {
        this.serviceKey = string;
    }

    public void setTModelInstanceDetails(TModelInstanceDetails tModelInstanceDetails) {
        this.tModelInstanceDetails = tModelInstanceDetails;
    }
}

