/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ras.mgr;

import com.ibm.ras.RASConstants;
import com.ibm.ras.RASIOException;
import com.ibm.ras.RASUtil;
import com.ibm.ras.mgr.RASBaseGroup;
import com.ibm.ras.mgr.RASConfig;
import com.ibm.ras.mgr.RASGroup;
import com.ibm.ras.mgr.RASIDataStore;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.util.Properties;
import java.util.StringTokenizer;

public class RASPropertyDataStore
implements RASConstants,
RASIDataStore {
    private static final String S = "(C) Copyright IBM Corp. 1998.";
    private Properties props;

    public RASPropertyDataStore(Properties props) {
        this.setPropertyDataStore(props);
    }

    public RASPropertyDataStore(String name) throws RASIOException {
        this.setPropertyDataStore(new Properties());
        try {
            BufferedInputStream is = new BufferedInputStream(this.getClass().getResourceAsStream(name));
            this.props.load(is);
            is.close();
        }
        catch (Exception e) {
            throw new RASIOException(RASUtil.rasMsgs.getMessage("ERR_PROP_IO", name));
        }
    }

    public Properties getPropertyDataStore() {
        return this.props;
    }

    public void setPropertyDataStore(Properties props) {
        this.props = props;
    }

    public RASBaseGroup restoreConfig() throws RASIOException {
        RASBaseGroup baseGroup = new RASBaseGroup();
        this.addRASObjects("msgLoggers", baseGroup);
        this.addRASObjects("trcLoggers", baseGroup);
        this.addRASObjects("handlers", baseGroup);
        this.addRASObjects("formatters", baseGroup);
        String list = this.props.getProperty("defaultHandlerNames");
        if (list != null) {
            baseGroup.setDefaultHandlers(list);
        }
        if ((list = this.props.getProperty("defaultMessageHandlerNames")) != null) {
            baseGroup.setDefaultMessageHandlers(list);
        }
        if ((list = this.props.getProperty("defaultTraceHandlerNames")) != null) {
            baseGroup.setDefaultTraceHandlers(list);
        }
        return baseGroup;
    }

    public void saveConfig(RASBaseGroup baseGroup) throws RASIOException {
    }

    private void addRASObjects(String type, RASBaseGroup baseGroup) throws RASIOException {
        String list = this.props.getProperty(type);
        if (list != null) {
            StringTokenizer st = new StringTokenizer(list);
            while (st.hasMoreElements()) {
                String propFileName = st.nextToken();
                if (propFileName == null) continue;
                propFileName = "/" + propFileName.replace('.', '/') + ".properties";
                Properties propFile = new Properties();
                try {
                    RASGroup group;
                    BufferedInputStream is = new BufferedInputStream(this.getClass().getResourceAsStream(propFileName));
                    propFile.load(is);
                    is.close();
                    String groupName = propFile.getProperty("group");
                    if (groupName == null || groupName.equals("")) {
                        group = baseGroup;
                    } else {
                        group = baseGroup.getGroup(groupName);
                        if (group == null) {
                            group = new RASGroup(groupName);
                            baseGroup.addGroup(group);
                        }
                    }
                    if (type.equals("msgLoggers")) {
                        group.addMessageLoggerConfig(new RASConfig(propFile));
                        continue;
                    }
                    if (type.equals("trcLoggers")) {
                        group.addTraceLoggerConfig(new RASConfig(propFile));
                        continue;
                    }
                    if (type.equals("handlers")) {
                        group.addHandlerConfig(new RASConfig(propFile));
                        continue;
                    }
                    if (!type.equals("formatters")) continue;
                    group.addFormatterConfig(new RASConfig(propFile));
                }
                catch (IOException e) {
                    throw new RASIOException(RASUtil.rasMsgs.getMessage("ERR_PROP_IO", propFileName));
                }
                catch (NullPointerException e) {
                    throw new RASIOException(RASUtil.rasMsgs.getMessage("ERR_PROP_NOT_FOUND", propFileName));
                }
            }
        }
    }
}

