/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.marshall.util;

import com.ibm.etools.marshall.util.IRangeObject;

public class IntegerRange
implements IRangeObject {
    private static String copyright = "(c) Copyright IBM Corporation 1999, 2004.";
    static final long serialVersionUID = -7839365150075934254L;
    protected int lowerRange_;
    protected int upperRange_;

    public IntegerRange() {
        this.lowerRange_ = 0;
        this.upperRange_ = 0;
    }

    public IntegerRange(int n, int n2) throws IllegalArgumentException {
        if (n2 < n) {
            throw new IllegalArgumentException(Integer.toString(n2));
        }
        this.lowerRange_ = n;
        this.upperRange_ = n2;
    }

    public Object clone() {
        try {
            IntegerRange integerRange = (IntegerRange)super.clone();
            return integerRange;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError(cloneNotSupportedException.getMessage());
        }
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!(object instanceof IntegerRange)) {
            return false;
        }
        IntegerRange integerRange = (IntegerRange)object;
        if (this.lowerRange_ != integerRange.lowerRange_) {
            return false;
        }
        return this.upperRange_ == integerRange.upperRange_;
    }

    public Object getLowerRange() {
        return new Integer(this.lowerRange_);
    }

    public Object getUpperRange() {
        return new Integer(this.upperRange_);
    }

    public static boolean isInRange(int n, int n2, int n3) throws IllegalArgumentException {
        if (n2 < n) {
            throw new IllegalArgumentException(Integer.toString(n2));
        }
        return n3 >= n && n3 <= n2;
    }

    public boolean isInRange(Object object) {
        if (!(object instanceof Integer)) {
            return false;
        }
        int n = (Integer)object;
        return IntegerRange.isInRange(this.lowerRange_, this.upperRange_, n);
    }

    public void setLowerRange(Object object) throws IllegalArgumentException {
        if (!(object instanceof Integer)) {
            throw new IllegalArgumentException(object.toString());
        }
        this.lowerRange_ = (Integer)object;
    }

    public void setUpperRange(Object object) throws IllegalArgumentException {
        if (!(object instanceof Integer)) {
            throw new IllegalArgumentException(object.toString());
        }
        this.upperRange_ = (Integer)object;
    }
}

