/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.ejb.client.runtime;

import java.beans.Beans;
import java.rmi.RemoteException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Hashtable;
import javax.ejb.EJBHome;
import javax.ejb.EJBMetaData;
import javax.ejb.Handle;
import javax.ejb.HomeHandle;
import javax.ejb.RemoveException;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.rmi.PortableRemoteObject;

public abstract class AbstractEJBFactory
implements EJBHome {
    private EJBHome ejbHome;
    private InitialContext initialContext;
    private Hashtable initialContextFactoryEnvironment;
    private String jndiName;
    public static final String DEFAULT_INITIAL_CONTEXT_FACTORY_NAME = "com.ibm.websphere.naming.WsnInitialContextFactory";
    private static Object INITIAL_CONTEXT_FACTORY_KEY = "java.naming.factory.initial";
    private static final String INITIAL_CONTEXT_FACTORY_PROPERTY = "java.naming.factory.initial";
    public static final String DEFAULT_INITIAL_CONTEXT_PROVIDER_URL = "IIOP:///";
    private static Object INITIAL_CONTEXT_PROVIDER_URL_KEY = "java.naming.provider.url";
    private static final String INITIAL_CONTEXT_PROVIDER_URL_PROPERTY = "java.naming.provider.url";

    public AbstractEJBFactory() {
        this.initialize();
    }

    protected EJBHome _acquireEJBHome() throws RemoteException {
        try {
            return this.acquireEJBHome();
        }
        catch (NamingException namingException) {
            throw new RemoteException("Cannot acquire home.", namingException);
        }
    }

    protected EJBHome acquireEJBHome() throws NamingException {
        if (this.ejbHome == null) {
            this.ejbHome = AbstractEJBFactory.lookupEJBHome(this.getHomeInterface(), this.acquireInitialContext(), this.getJNDIName());
        }
        return this.ejbHome;
    }

    public InitialContext acquireInitialContext() throws NamingException {
        if (this.initialContext == null) {
            this.initialContext = new InitialContext(this.getInitialContextFactoryEnvironment());
        }
        return this.initialContext;
    }

    public void addToInitialContextFactoryEnvironment(Object object, Object object2) {
        this.resetInitialContext();
        this.getInitialContextFactoryEnvironment().put(object, object2);
    }

    protected abstract String getDefaultJNDIName();

    public EJBMetaData getEJBMetaData() throws RemoteException {
        if (Beans.isDesignTime()) {
            return null;
        }
        return this._acquireEJBHome().getEJBMetaData();
    }

    public HomeHandle getHomeHandle() {
        return null;
    }

    protected abstract Class getHomeInterface();

    public Hashtable getInitialContextFactoryEnvironment() {
        if (this.initialContextFactoryEnvironment == null) {
            this.initialContextFactoryEnvironment = new Hashtable(8, 0.075f);
            this.getInitialContextFactoryName();
            this.getInitialContextProviderURL();
        }
        return this.initialContextFactoryEnvironment;
    }

    public String getInitialContextFactoryName() {
        Hashtable hashtable = this.getInitialContextFactoryEnvironment();
        String string = (String)hashtable.get(INITIAL_CONTEXT_FACTORY_KEY);
        if (string == null) {
            string = AbstractEJBFactory.getSystemProperty(INITIAL_CONTEXT_FACTORY_PROPERTY, DEFAULT_INITIAL_CONTEXT_FACTORY_NAME);
            hashtable.put(INITIAL_CONTEXT_FACTORY_KEY, string);
        }
        return string;
    }

    public String getInitialContextProviderURL() {
        Hashtable hashtable = this.getInitialContextFactoryEnvironment();
        String string = (String)hashtable.get(INITIAL_CONTEXT_PROVIDER_URL_KEY);
        if (string == null) {
            string = AbstractEJBFactory.getSystemProperty(INITIAL_CONTEXT_PROVIDER_URL_PROPERTY, DEFAULT_INITIAL_CONTEXT_PROVIDER_URL);
            hashtable.put(INITIAL_CONTEXT_PROVIDER_URL_KEY, string);
        }
        return string;
    }

    private static String getSystemProperty(final String string, final String string2) {
        return (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return System.getProperty(string, string2);
            }
        });
    }

    public String getJNDIName() {
        if (this.jndiName == null) {
            this.jndiName = this.getDefaultJNDIName();
        }
        return this.jndiName;
    }

    private void initialize() {
        this.reset();
    }

    protected static final synchronized EJBHome lookupEJBHome(Class clazz, InitialContext initialContext, String string) throws NamingException, ClassCastException {
        EJBHome eJBHome = null;
        if (initialContext != null) {
            Object object = initialContext.lookup(string);
            eJBHome = (EJBHome)PortableRemoteObject.narrow((Object)object, (Class)clazz);
        }
        return eJBHome;
    }

    public void remove(Object object) throws RemoteException, RemoveException {
        this._acquireEJBHome().remove(object);
    }

    public void remove(Handle handle) throws RemoteException, RemoveException {
        this._acquireEJBHome().remove(handle);
    }

    public void reset() {
        this.ejbHome = null;
        this.initialContext = null;
        this.initialContextFactoryEnvironment = null;
        this.jndiName = null;
    }

    protected void resetEJBHome() {
        this.ejbHome = null;
    }

    public void resetInitialContext() {
        this.ejbHome = null;
        this.initialContext = null;
    }

    protected void setEJBHome(EJBHome eJBHome) {
        this.resetInitialContext();
        this.ejbHome = eJBHome;
    }

    public void setInitialContext(InitialContext initialContext) {
        this.resetInitialContext();
        this.initialContext = initialContext;
    }

    public void setInitialContextFactoryEnvironment(Hashtable hashtable) {
        this.resetInitialContext();
        this.initialContextFactoryEnvironment = hashtable;
    }

    public void setInitialContextFactoryName(String string) {
        this.addToInitialContextFactoryEnvironment(INITIAL_CONTEXT_FACTORY_KEY, string);
    }

    public void setInitialContextProviderURL(String string) {
        this.addToInitialContextFactoryEnvironment(INITIAL_CONTEXT_PROVIDER_URL_KEY, string);
    }

    public void setJNDIName(String string) {
        this.resetEJBHome();
        this.jndiName = string;
    }
}

