/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.ctc.wsdl.extensions.physicalrep.properties;

import com.ibm.etools.ctc.physicalrep.PhysicalrepPlugin;
import com.ibm.etools.ctc.wsdl.extensions.physicalrep.properties.PhysicalrepPropertyHelper;
import com.ibm.etools.typedescriptor.Bi_DirectionStringTD;
import com.ibm.etools.typedescriptor.NumeralShapes;
import com.ibm.etools.typedescriptor.Orientation;
import com.ibm.etools.typedescriptor.TextShapes;
import com.ibm.etools.typedescriptor.TypeDescriptorPackage;
import com.ibm.etools.typedescriptor.TypeOfText;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.help.WorkbenchHelp;

public class BidiAttributesDialog
extends Dialog
implements Listener {
    private static final String copyright = "Licensed Material - Property of IBM <<PART NUMBER - 5724-D15>> (C) Copyright IBM Corp. 2001, 2003 - All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.".intern();
    private static final String idTextType = "textType";
    private static final String idOrientation = "orientation";
    private static final String idNumeralShapes = "numeralShapes";
    private static final String idTextShape = "textShape";
    private Bi_DirectionStringTD initialValue;
    private Bi_DirectionStringTD selectedValue;
    private Button okButton;
    private Button deleteButton;
    private Button cancelButton;
    private Combo textTypeCombo;
    private Combo orientationCombo;
    private Button symmetricCheckbox;
    private Combo numeralShapesCombo;
    private Combo textShapeCombo;

    protected BidiAttributesDialog(Shell shell, Bi_DirectionStringTD bi_DirectionStringTD) {
        super(shell);
        WorkbenchHelp.setHelp((Control)shell, (String)"com.ibm.etools.ctc.physicalrep.BiDiAttributes_Main");
        this.setShellStyle(80);
        this.initialValue = bi_DirectionStringTD;
        this.selectedValue = TypeDescriptorPackage.eINSTANCE.getTypeDescriptorFactory().createBi_DirectionStringTD();
        if (bi_DirectionStringTD != null) {
            this.selectedValue.setTextType(bi_DirectionStringTD.getTextType());
            this.selectedValue.setOrientation(bi_DirectionStringTD.getOrientation());
            this.selectedValue.setSymmetric(bi_DirectionStringTD.getSymmetric());
            this.selectedValue.setNumeralShapes(bi_DirectionStringTD.getNumeralShapes());
            this.selectedValue.setTextShape(bi_DirectionStringTD.getTextShape());
        }
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(PhysicalrepPlugin.getResources().getMessage("%BIDI_DIALOG_TITLE"));
    }

    protected void createButtonsForButtonBar(Composite composite) {
        this.okButton = this.createButton(composite, 0, IDialogConstants.OK_LABEL, true);
        WorkbenchHelp.setHelp((Control)this.okButton, (String)"com.ibm.etools.ctc.physicalrep.BiDiAttributes_OK");
        this.deleteButton = this.createButton(composite, 9, PhysicalrepPlugin.getResources().getMessage("%BIDI_DIALOG_BUTTON_DELETE"), false);
        this.deleteButton.addListener(13, (Listener)this);
        WorkbenchHelp.setHelp((Control)this.deleteButton, (String)"com.ibm.etools.ctc.physicalrep.BiDiAttributes_Delete");
        this.cancelButton = this.createButton(composite, 1, IDialogConstants.CANCEL_LABEL, false);
        WorkbenchHelp.setHelp((Control)this.cancelButton, (String)"com.ibm.etools.ctc.physicalrep.BiDiAttributes_Cancel");
        this.getShell().setDefaultButton(this.okButton);
        this.okButton.setEnabled(this.initialValue == null);
        this.deleteButton.setEnabled(this.initialValue != null);
    }

    protected Control createDialogArea(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        composite2.setLayout((Layout)gridLayout);
        composite2.setLayoutData((Object)new GridData(768));
        WorkbenchHelp.setHelp((Control)composite2, (String)"com.ibm.etools.ctc.physicalrep.BiDiAttributes_Main");
        Label label = new Label(composite2, 0);
        label.setText(PhysicalrepPlugin.getResources().getMessage("%BIDI_DIALOG_TEXTTYPE"));
        this.textTypeCombo = new Combo(composite2, 4);
        this.textTypeCombo.setItems(PhysicalrepPropertyHelper.getEnumerationStrings(idTextType));
        this.textTypeCombo.addListener(13, (Listener)this);
        WorkbenchHelp.setHelp((Control)this.textTypeCombo, (String)"com.ibm.etools.ctc.physicalrep.BiDiAttributes_TextType");
        Label label2 = new Label(composite2, 0);
        label2.setText(PhysicalrepPlugin.getResources().getMessage("%BIDI_DIALOG_ORIETATION"));
        this.orientationCombo = new Combo(composite2, 4);
        this.orientationCombo.setItems(PhysicalrepPropertyHelper.getEnumerationStrings(idOrientation));
        this.orientationCombo.addListener(13, (Listener)this);
        WorkbenchHelp.setHelp((Control)this.orientationCombo, (String)"com.ibm.etools.ctc.physicalrep.BiDiAttributes_Orientation");
        Label label3 = new Label(composite2, 0);
        label3.setText(PhysicalrepPlugin.getResources().getMessage("%BIDI_DIALOG_SYMMETRIC"));
        this.symmetricCheckbox = new Button(composite2, 32);
        this.symmetricCheckbox.addListener(13, (Listener)this);
        WorkbenchHelp.setHelp((Control)this.symmetricCheckbox, (String)"com.ibm.etools.ctc.physicalrep.BiDiAttributes_Symmetric");
        Label label4 = new Label(composite2, 0);
        label4.setText(PhysicalrepPlugin.getResources().getMessage("%BIDI_DIALOG_NUMERALSHAPES"));
        this.numeralShapesCombo = new Combo(composite2, 4);
        this.numeralShapesCombo.setItems(PhysicalrepPropertyHelper.getEnumerationStrings(idNumeralShapes));
        this.numeralShapesCombo.addListener(13, (Listener)this);
        WorkbenchHelp.setHelp((Control)this.numeralShapesCombo, (String)"com.ibm.etools.ctc.physicalrep.BiDiAttributes_NumeralShapes");
        Label label5 = new Label(composite2, 0);
        label5.setText(PhysicalrepPlugin.getResources().getMessage("%BIDI_DIALOG_TEXTSHAPE"));
        this.textShapeCombo = new Combo(composite2, 4);
        this.textShapeCombo.setItems(PhysicalrepPropertyHelper.getEnumerationStrings(idTextShape));
        this.textShapeCombo.addListener(13, (Listener)this);
        WorkbenchHelp.setHelp((Control)this.textShapeCombo, (String)"com.ibm.etools.ctc.physicalrep.BiDiAttributes_TextShape");
        this.textTypeCombo.select(this.selectedValue.getTextType().getValue());
        this.orientationCombo.select(this.selectedValue.getOrientation().getValue());
        this.symmetricCheckbox.setSelection(this.selectedValue.isSetSymmetric());
        this.numeralShapesCombo.select(this.selectedValue.getNumeralShapes().getValue());
        this.textShapeCombo.select(this.selectedValue.getTextShape().getValue());
        return composite2;
    }

    public void handleEvent(Event event2) {
        Widget widget = event2.widget;
        if (widget == this.deleteButton) {
            this.selectedValue = null;
            super.close();
        } else if (widget == this.symmetricCheckbox) {
            this.selectedValue.setSymmetric(new Boolean(this.symmetricCheckbox.getSelection()));
            this.attributeChanged();
        } else if (widget == this.textTypeCombo) {
            this.selectedValue.setTextType(TypeOfText.get((int)this.textTypeCombo.getSelectionIndex()));
            this.attributeChanged();
        } else if (widget == this.orientationCombo) {
            this.selectedValue.setOrientation(Orientation.get((int)this.orientationCombo.getSelectionIndex()));
            this.attributeChanged();
        } else if (widget == this.numeralShapesCombo) {
            this.selectedValue.setNumeralShapes(NumeralShapes.get((int)this.numeralShapesCombo.getSelectionIndex()));
            this.attributeChanged();
        } else if (widget == this.textShapeCombo) {
            this.selectedValue.setTextShape(TextShapes.get((int)this.textShapeCombo.getSelectionIndex()));
            this.attributeChanged();
        }
    }

    private void attributeChanged() {
        boolean bl = this.initialValue == null || this.selectedValue.getTextType().getValue() != this.initialValue.getTextType().getValue() || this.selectedValue.getOrientation().getValue() != this.initialValue.getOrientation().getValue() || this.selectedValue.isSetSymmetric() != this.initialValue.isSetSymmetric() || this.selectedValue.getNumeralShapes().getValue() != this.initialValue.getNumeralShapes().getValue() || this.selectedValue.getTextShape().getValue() != this.initialValue.getTextShape().getValue();
        this.okButton.setEnabled(bl);
    }

    Bi_DirectionStringTD getBidiAttributes() {
        return this.selectedValue;
    }
}

