/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.util.deployment.utilities;

import com.ibm.ejs.util.deployment.utilities.UtilsTrace;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;

public class FileUtils {
    private static String copyright = "Licensed Material - Property of IBMIBM(R) VisualAge(R) for Java(TM), Version 2.0 - Professional/Enterprise Update(C) Copyright IBM Corp. 1998 - All Rights Reserved.US Government Users Restricted Rights - Use, duplication or disclosurerestricted by GSA ADP Schedule Contract with IBM Corp.";

    public static final void copyFile(String srcFileName, String dstFileName) throws IOException {
        FileInputStream srcStream = null;
        FileOutputStream outStream = null;
        BufferedInputStream inStream = null;
        try {
            File f1 = new File(srcFileName);
            File f2 = new File(dstFileName);
            if (f1.equals(f2)) {
                return;
            }
            UtilsTrace.trace("\nFileUtils: copyFile(): Copying " + srcFileName + " to " + dstFileName);
            srcStream = new FileInputStream(srcFileName);
            outStream = new FileOutputStream(dstFileName);
            inStream = new BufferedInputStream(srcStream);
            int bytesRead = inStream.read();
            while (bytesRead != -1) {
                outStream.write(bytesRead);
                bytesRead = inStream.read();
            }
            if (outStream != null) {
                outStream.close();
            }
        }
        catch (IOException e) {
            if (srcStream != null) {
                srcStream.close();
            }
            if (outStream != null) {
                outStream.close();
            }
            throw e;
        }
    }

    public static final void deleteDirTree(File dir) throws IOException {
        if (!dir.exists()) {
            return;
        }
        if (dir.isDirectory()) {
            String[] entries = dir.list();
            for (int i = 0; i < entries.length; ++i) {
                File f = new File(dir.getPath(), entries[i]);
                FileUtils.deleteDirTree(f);
            }
        }
        dir.delete();
    }
}

