/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.util.cache;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.util.am.AlarmListener;
import com.ibm.ejs.util.am.AlarmManager;
import com.ibm.ejs.util.cache.Cache;
import com.ibm.ejs.util.cache.CacheElementEnumerator;
import com.ibm.ejs.util.cache.Element;
import com.ibm.ejs.util.cache.EvictionStrategy;
import com.ibm.ejs.util.cache.SimpleLimitStrategy;
import com.ibm.websphere.csi.InsufficientCacheSpaceException;
import com.ibm.ws.ffdc.FFDCFilter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.NoSuchElementException;

public final class SweepLruEvictionStrategy
extends Thread
implements EvictionStrategy,
AlarmListener {
    private static final TraceComponent tc = Tr.register(SweepLruEvictionStrategy.class, "EJBCache", "com.ibm.ejs.container.container");
    private static final String CLASS_NAME = "com.ibm.ejs.util.cache.SweepLruEvictionStrategy";
    private final Cache ivCache;
    private long ivSweepInterval;
    private final long ivMaxSweepInterval;
    private long ivDiscardThreshold = 20L;
    private long ivMaxDiscardThreshold;
    private long ivMinDiscardThreshold;
    private long ivUpperLimit;
    private long ivNumBelowSoftLimit = 0L;
    private CacheElementEnumerator ivElements;
    private Enumeration ivVictims;
    private final long MINIMUM_SWEEP_INTERVAL = 1000L;
    private final long MAXIMUM_SWEEP_INTERVAL = 12000L;
    private final long SWEEP_INTERVAL_ADJUST = 500L;
    private final long MINIMUM_ADJUSTED_INTERVAL = 3000L;
    private final long MAX_THRESHOLD_MULTIPLIER = 60000L;
    private final long MIN_THRESHOLD_MULTIPLIER = 9000L;

    public SweepLruEvictionStrategy(Cache cache, long sweepInterval) {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry(tc, "<init> : " + cache.getName() + " size = " + cache.getConfigSize() + ", sweep = " + sweepInterval);
        }
        this.ivCache = cache;
        this.ivSweepInterval = sweepInterval < 1000L ? 1000L : (sweepInterval > 12000L ? 12000L : sweepInterval);
        this.ivMaxSweepInterval = this.ivSweepInterval;
        this.ivUpperLimit = this.ivCache.numBuckets * 3;
        if (this.ivSweepInterval * this.ivDiscardThreshold > 60000L) {
            this.ivDiscardThreshold = 60000L / this.ivSweepInterval;
            if (this.ivDiscardThreshold < 2L) {
                this.ivDiscardThreshold = 2L;
            }
        }
        this.ivMaxDiscardThreshold = this.ivDiscardThreshold;
        this.ivMinDiscardThreshold = 9000L / this.ivSweepInterval;
        if (this.ivMinDiscardThreshold < 2L) {
            this.ivMinDiscardThreshold = 2L;
        }
        this.ivElements = (CacheElementEnumerator)this.ivCache.enumerateElements();
        this.ivVictims = null;
        this.setDaemon(true);
        this.setName("SweepLruEvictionStrategy");
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit(tc, "<init> : " + cache.getName() + " size = " + cache.getConfigSize() + ", sweep = " + this.ivSweepInterval + ", threshold = " + this.ivDiscardThreshold);
        }
    }

    public void run() {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry(tc, "run");
        }
        if (this.ivSweepInterval >= 1000L) {
            if (isTraceOn && tc.isDebugEnabled()) {
                Tr.debug(tc, "SweepLruEvictionStrategy using Alarms");
            }
            AlarmManager.createDeferrable((long)this.ivSweepInterval, (AlarmListener)this, null);
            if (isTraceOn && tc.isEntryEnabled()) {
                Tr.exit(tc, "run");
            }
            return;
        }
        if (isTraceOn && tc.isDebugEnabled()) {
            Tr.debug(tc, "SweepLruEvictionStrategy running as background thread");
        }
        while (true) {
            try {
                while (true) {
                    SweepLruEvictionStrategy.sleep(this.ivSweepInterval);
                    this.alarm(null);
                }
            }
            catch (InterruptedException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ejs.util.cache.SweepLruEvictionStrategy.run", (String)"310", (Object)this);
                Tr.warning(tc, "LRU_THREAD_INTERRUPTED_CNTR0052W", new Object[]{e});
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ejs.util.cache.SweepLruEvictionStrategy.run", (String)"315", (Object)this);
                Tr.warning(tc, "LRU_THREAD_CAUGHT_EXCEPTION_CNTR0053W", new Object[]{this, e});
                continue;
            }
            break;
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit(tc, "run");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void alarm(Object alarmContext) {
        try {
            block13: {
                try {
                    if (this.ivNumBelowSoftLimit > this.ivMaxDiscardThreshold) {
                        if (this.ivDiscardThreshold < this.ivMaxDiscardThreshold) {
                            ++this.ivDiscardThreshold;
                        } else if (this.ivSweepInterval < this.ivMaxSweepInterval) {
                            this.ivSweepInterval += 500L;
                        }
                        this.ivNumBelowSoftLimit = 0L;
                    }
                    this.ivCache.numSweeps = this.ivCache.numSweeps == Long.MAX_VALUE ? 1L : ++this.ivCache.numSweeps;
                    if (this.ivCache.limitStrategy.softLimitReached(this.ivCache)) {
                        this.sweep();
                        if (this.ivCache.limitStrategy.softLimitReached(this.ivCache)) {
                            this.ivNumBelowSoftLimit = 0L;
                            if ((long)this.ivCache.numObjects <= this.ivUpperLimit) break block13;
                            if (this.ivSweepInterval > 3000L) {
                                this.ivSweepInterval -= 500L;
                                break block13;
                            }
                            if (this.ivDiscardThreshold > this.ivMinDiscardThreshold) {
                                --this.ivDiscardThreshold;
                                this.sweep();
                            }
                            break block13;
                        }
                        ++this.ivNumBelowSoftLimit;
                        break block13;
                    }
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, this.ivCache.getName() + ": Sweep (" + this.ivCache.numSweeps + "," + this.ivDiscardThreshold + "," + this.ivSweepInterval + ")" + " - Cache limit not reached : " + this.ivCache.getSize() + "/" + this.ivCache.getConfigSize());
                    }
                    ++this.ivNumBelowSoftLimit;
                }
                catch (Exception e) {
                    FFDCFilter.processException((Throwable)e, (String)"com.ibm.ejs.util.cache.SweepLruEvictionStrategy.alarm", (String)"424", (Object)this);
                    Tr.warning(tc, "LRU_THREAD_CAUGHT_EXCEPTION_CNTR0053W", new Object[]{this, e});
                    Object var4_3 = null;
                    if (this.ivSweepInterval < 1000L) return;
                    AlarmManager.createDeferrable((long)this.ivSweepInterval, (AlarmListener)this, null);
                    return;
                }
            }
            Object var4_2 = null;
            if (this.ivSweepInterval < 1000L) return;
            AlarmManager.createDeferrable((long)this.ivSweepInterval, (AlarmListener)this, null);
            return;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (this.ivSweepInterval < 1000L) throw throwable;
            AlarmManager.createDeferrable((long)this.ivSweepInterval, (AlarmListener)this, null);
            throw throwable;
        }
    }

    private void sweep() {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry(tc, this.ivCache.getName() + ": Sweep (" + this.ivCache.numSweeps + "," + this.ivDiscardThreshold + "," + this.ivSweepInterval + ")" + " - Cache limit exceeded : " + this.ivCache.getSize() + "/" + this.ivCache.getConfigSize());
        }
        int numEvicted = 0;
        long sweepCount = 0L;
        Element element = null;
        try {
            while ((element = (Element)this.ivElements.nextElemNoEx()) != null) {
                sweepCount = element.accessedSweep <= this.ivCache.numSweeps ? this.ivCache.numSweeps - element.accessedSweep : Long.MAX_VALUE - element.accessedSweep + this.ivCache.numSweeps;
                if (element.pinned != 0 || sweepCount <= this.ivDiscardThreshold || !this.ivCache.evictObject(element.key)) continue;
                ++numEvicted;
            }
        }
        catch (NoSuchElementException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ejs.util.cache.SweepLruEvictionStrategy.sweep", (String)"499", (Object)this);
            this.ivElements.reset();
            if (isTraceOn && tc.isEntryEnabled()) {
                Tr.exit(tc, this.ivCache.getName() + ": Sweep (" + this.ivCache.numSweeps + "," + this.ivDiscardThreshold + "," + this.ivSweepInterval + ")" + " - Evicted = " + numEvicted + " : " + this.ivCache.getSize() + " : NoSuchElementException");
            }
            return;
        }
        this.ivElements.reset();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit(tc, this.ivCache.getName() + ": Sweep (" + this.ivCache.numSweeps + "," + this.ivDiscardThreshold + "," + this.ivSweepInterval + ")" + " - Evicted = " + numEvicted + " : " + this.ivCache.getSize() + "/" + this.ivCache.getConfigSize());
        }
    }

    public synchronized Object getVictim(Cache cache) {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry(tc, "getVictim");
        }
        Element victim = null;
        Element element = null;
        boolean newVictimList = false;
        while (victim == null) {
            if (this.ivVictims == null || !this.ivVictims.hasMoreElements()) {
                if (newVictimList) break;
                this.ivVictims = this.ivCache.enumerateElements();
                newVictimList = true;
            }
            try {
                element = (Element)this.ivVictims.nextElement();
            }
            catch (NoSuchElementException nsee) {
                FFDCFilter.processException((Throwable)nsee, (String)"com.ibm.ejs.util.cache.SweepLruEvictionStrategy.getVictim", (String)"573", (Object)this);
                continue;
            }
            if (!this.canBeDiscarded(element)) continue;
            victim = element;
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit(tc, "getVictim : " + victim);
        }
        return victim;
    }

    public boolean canBeDiscarded(Element element) {
        long sweepCount = 0L;
        sweepCount = element.accessedSweep <= this.ivCache.numSweeps ? this.ivCache.numSweeps - element.accessedSweep : Long.MAX_VALUE - element.accessedSweep + this.ivCache.numSweeps;
        return sweepCount > this.ivDiscardThreshold;
    }

    public static void main(String[] args) {
        try {
            String object;
            String key;
            int i;
            Cache testCache = new Cache("TestCache", 9, false);
            testCache.setLimitStrategy(new SimpleLimitStrategy(2, 2));
            SweepLruEvictionStrategy ev = new SweepLruEvictionStrategy(testCache, 10000L);
            testCache.setEvictionStrategy(ev);
            SimpleDateFormat format = new SimpleDateFormat("HH:mm:ss.SSSS");
            for (i = 0; i < 15; ++i) {
                key = Integer.toString(i);
                object = format.format(new Date());
                System.out.println("Inserting (" + key + ", " + object + ")");
                testCache.insert(key, object);
                testCache.unpin(key);
            }
            System.out.println("---- There are " + testCache.getSize() + " elements in the cache");
            for (i = 14; i >= 0; --i) {
                key = Integer.toString(i);
                object = (String)testCache.find(key);
                System.out.println("Found (" + key + ", " + object + ")");
                testCache.unpin(key);
            }
            System.out.println("---- There are still " + testCache.getSize() + " elements in the cache");
            for (i = 29; i >= 15; --i) {
                key = Integer.toString(i);
                object = (String)testCache.find(key);
                System.out.println("Found (" + key + ", " + object + ")");
            }
            System.out.println("---- There are still " + testCache.getSize() + " elements in the cache");
            for (i = 15; i < 30; ++i) {
                key = Integer.toString(i);
                object = format.format(new Date());
                try {
                    System.out.println("Inserting (" + key + ", " + object + ")");
                    testCache.insert(key, object);
                    testCache.unpin(key);
                    continue;
                }
                catch (InsufficientCacheSpaceException ex) {
                    FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ejs.util.cache.SweepLruEvictionStrategy.main", (String)"686");
                    System.out.println("!!!! Cache is full");
                    break;
                }
            }
            System.out.println("---- There are now " + testCache.getSize() + " elements in the cache");
            ev.start();
            try {
                do {
                    System.out.println("Sleeping...");
                    SweepLruEvictionStrategy.sleep(1000L);
                    System.out.println(">>>> There are now " + testCache.getSize() + " elements in the cache");
                } while (testCache.getSize() > 2);
            }
            catch (InterruptedException ex) {
                FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ejs.util.cache.SweepLruEvictionStrategy.main", (String)"713");
                System.out.println(ex);
            }
            for (int i2 = 0; i2 < 30; ++i2) {
                key = Integer.toString(i2);
                object = (String)testCache.find(key);
                System.out.println("Found (" + key + ", " + object + ")");
            }
            System.out.println("---- There are " + testCache.getSize() + " elements in the cache");
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ejs.util.cache.SweepLruEvictionStrategy.main", (String)"734");
            System.out.println(e);
        }
    }
}

