/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.util.cache;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.util.ASSERT;
import com.ibm.ejs.util.am.AlarmListener;
import com.ibm.ejs.util.am.AlarmManager;
import com.ibm.ejs.util.cache.Cache;
import com.ibm.ejs.util.cache.CacheElementEnumerator;
import com.ibm.ejs.util.cache.Element;
import com.ibm.ejs.util.cache.EvictionStrategy;
import com.ibm.ejs.util.cache.SimpleLimitStrategy;
import com.ibm.websphere.csi.InsufficientCacheSpaceException;
import com.ibm.ws.ffdc.FFDCFilter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.NoSuchElementException;

public final class BackgroundLruEvictionStrategy
extends Thread
implements EvictionStrategy,
AlarmListener {
    private static final TraceComponent tc = Tr.register(BackgroundLruEvictionStrategy.class, "EJBCache", "com.ibm.ejs.container.container");
    private static final String CLASS_NAME = "com.ibm.ejs.util.cache.BackgroundLruEvictionStrategy";
    private final Cache ivCache;
    private long ivSweepInterval;
    private long ivDiscardThreshold = 60L;
    private long ivMaxDiscardThreshold;
    private long ivMinDiscardThreshold;
    private long ivUpperLimit;
    private long ivNumBelowSoftLimit = 0L;
    private int ivSoftLimitBuffer;
    private CacheElementEnumerator ivElements;
    private Enumeration ivVictims;
    private final long MINIMUM_SWEEP_INTERVAL = 1000L;
    private final long MAX_THRESHOLD_MULTIPLIER = 120000L;
    private final long MIN_THRESHOLD_MULTIPLIER = 9000L;

    public BackgroundLruEvictionStrategy(Cache cache, long sweepInterval) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "<init> : " + cache.getName() + " size = " + cache.getConfigSize() + ", sweep = " + sweepInterval);
        }
        this.ivCache = cache;
        this.ivSweepInterval = sweepInterval < 1000L ? 1000L : sweepInterval;
        this.ivUpperLimit = (long)((double)this.ivCache.numBuckets * 1.1);
        if (this.ivSweepInterval * this.ivDiscardThreshold > 120000L) {
            this.ivDiscardThreshold = 120000L / this.ivSweepInterval;
            if (this.ivDiscardThreshold < 2L) {
                this.ivDiscardThreshold = 2L;
            }
        }
        this.ivMaxDiscardThreshold = this.ivDiscardThreshold;
        this.ivMinDiscardThreshold = 9000L / this.ivSweepInterval;
        if (this.ivMinDiscardThreshold < 2L) {
            this.ivMinDiscardThreshold = 2L;
        }
        this.ivSoftLimitBuffer = this.ivCache.numBuckets / 100;
        if (this.ivSoftLimitBuffer > 50) {
            this.ivSoftLimitBuffer = 50;
        }
        this.ivElements = (CacheElementEnumerator)this.ivCache.enumerateElements();
        this.ivVictims = null;
        this.setDaemon(true);
        this.setName("BackgroundLruEvictionStrategy");
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "<init> : " + this.ivCache.getName() + " size = " + cache.getConfigSize() + ", sweep = " + this.ivSweepInterval + ", threshold = " + this.ivDiscardThreshold + ", buffer = " + this.ivSoftLimitBuffer);
        }
    }

    public void run() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "run");
        }
        if (this.ivSweepInterval >= 1000L) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "BackgroundLruEvictionStrategy using Alarms");
            }
            AlarmManager.create((long)this.ivSweepInterval, (AlarmListener)this, null);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "run");
            }
            return;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "BackgroundLruEvictionStrategy running as background thread");
        }
        while (true) {
            try {
                while (true) {
                    BackgroundLruEvictionStrategy.sleep(this.ivSweepInterval);
                    this.alarm(null);
                }
            }
            catch (InterruptedException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ejs.util.cache.BackgroundLruEvictionStrategy.run", (String)"328", (Object)this);
                Tr.warning(tc, "LRU_THREAD_INTERRUPTED_CNTR0052W", new Object[]{e});
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ejs.util.cache.BackgroundLruEvictionStrategy.run", (String)"337", (Object)this);
                Tr.warning(tc, "LRU_THREAD_CAUGHT_EXCEPTION_CNTR0053W", new Object[]{this, e});
                continue;
            }
            break;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "run");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void alarm(Object alarmContext) {
        try {
            block9: {
                try {
                    if (this.ivDiscardThreshold < this.ivMaxDiscardThreshold && this.ivNumBelowSoftLimit > this.ivMaxDiscardThreshold) {
                        ++this.ivDiscardThreshold;
                        this.ivNumBelowSoftLimit = 0L;
                    }
                    this.ivCache.numSweeps = this.ivCache.numSweeps == Long.MAX_VALUE ? 1L : ++this.ivCache.numSweeps;
                    if (this.ivCache.limitStrategy.softLimitReached(this.ivCache)) {
                        this.sweep();
                        if (this.ivCache.limitStrategy.softLimitReached(this.ivCache)) {
                            this.ivNumBelowSoftLimit = 0L;
                            if ((long)this.ivCache.numObjects > this.ivUpperLimit && this.ivDiscardThreshold > this.ivMinDiscardThreshold) {
                                --this.ivDiscardThreshold;
                                this.sweep();
                            }
                            break block9;
                        }
                        ++this.ivNumBelowSoftLimit;
                        break block9;
                    }
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, this.ivCache.getName() + ": Sweep (" + this.ivCache.numSweeps + "," + this.ivDiscardThreshold + ")" + " - Cache limit not reached : " + this.ivCache.getSize() + "/" + this.ivCache.getConfigSize());
                    }
                    ++this.ivNumBelowSoftLimit;
                }
                catch (Exception e) {
                    FFDCFilter.processException((Throwable)e, (String)"com.ibm.ejs.util.cache.BackgroundLruEvictionStrategy.alarm", (String)"446", (Object)this);
                    Tr.warning(tc, "LRU_THREAD_CAUGHT_EXCEPTION_CNTR0053W", new Object[]{this, e});
                    Object var4_3 = null;
                    if (this.ivSweepInterval < 1000L) return;
                    AlarmManager.create((long)this.ivSweepInterval, (AlarmListener)this, null);
                    return;
                }
            }
            Object var4_2 = null;
            if (this.ivSweepInterval < 1000L) return;
            AlarmManager.create((long)this.ivSweepInterval, (AlarmListener)this, null);
            return;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (this.ivSweepInterval < 1000L) throw throwable;
            AlarmManager.create((long)this.ivSweepInterval, (AlarmListener)this, null);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sweep() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, this.ivCache.getName() + ": Sweep (" + this.ivCache.numSweeps + "," + this.ivDiscardThreshold + ")" + " - Cache limit exceeded : " + this.ivCache.getSize() + "/" + this.ivCache.getConfigSize());
        }
        int numEvicted = 0;
        int numEvictedBelowSoftLimit = 0;
        long sweepCount = 0L;
        try {
            while (this.ivElements.hasMoreElements() && (numEvictedBelowSoftLimit < this.ivSoftLimitBuffer || this.ivCache.limitStrategy.softLimitReached(this.ivCache))) {
                Element element = (Element)this.ivElements.nextElement();
                sweepCount = element.accessedSweep <= this.ivCache.numSweeps ? this.ivCache.numSweeps - element.accessedSweep : Long.MAX_VALUE - element.accessedSweep + this.ivCache.numSweeps;
                if (element.pinned != 0 || sweepCount <= this.ivDiscardThreshold) continue;
                boolean evicted = false;
                if (this.ivCache.ivEvictionLocks != null) {
                    Object object = this.ivCache.ivEvictionLocks.getLock(element.key);
                    synchronized (object) {
                        evicted = this.ivCache.evictObject(element.key);
                    }
                } else {
                    evicted = this.ivCache.evictObject(element.key);
                }
                if (!evicted) continue;
                ++numEvicted;
                if (this.ivCache.limitStrategy.softLimitReached(this.ivCache)) {
                    numEvictedBelowSoftLimit = 0;
                    continue;
                }
                ++numEvictedBelowSoftLimit;
            }
        }
        catch (NoSuchElementException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ejs.util.cache.BackgroundLruEvictionStrategy.sweep", (String)"526", (Object)this);
            this.ivElements.reset();
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, this.ivCache.getName() + ": Sweep (" + this.ivCache.numSweeps + "," + this.ivDiscardThreshold + ")" + " - Evicted = " + numEvicted + " : " + this.ivCache.getSize() + " : NoSuchElementException");
            }
            return;
        }
        this.ivElements.reset();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, this.ivCache.getName() + ": Sweep (" + this.ivCache.numSweeps + "," + this.ivDiscardThreshold + ")" + " - Evicted = " + numEvicted + " : " + this.ivCache.getSize() + "/" + this.ivCache.getConfigSize());
        }
    }

    public synchronized Object getVictim(Cache cache) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getVictim");
        }
        Element victim = null;
        Element element = null;
        boolean newVictimList = false;
        while (victim == null) {
            if (this.ivVictims == null || !this.ivVictims.hasMoreElements()) {
                if (newVictimList) break;
                this.ivVictims = this.ivCache.enumerateElements();
                newVictimList = true;
            }
            try {
                element = (Element)this.ivVictims.nextElement();
            }
            catch (NoSuchElementException nsee) {
                FFDCFilter.processException((Throwable)nsee, (String)"com.ibm.ejs.util.cache.BackgroundLruEvictionStrategy.getVictim", (String)"600", (Object)this);
                continue;
            }
            if (!this.canBeDiscarded(element)) continue;
            victim = element;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getVictim : " + victim);
        }
        return victim;
    }

    public boolean canBeDiscarded(Element element) {
        long sweepCount = 0L;
        sweepCount = element.accessedSweep <= this.ivCache.numSweeps ? this.ivCache.numSweeps - element.accessedSweep : Long.MAX_VALUE - element.accessedSweep + this.ivCache.numSweeps;
        return sweepCount > this.ivDiscardThreshold && element.pinned == 0 && !element.ivEvictionIneligible;
    }

    public static void main(String[] args) {
        try {
            String object;
            String key;
            int i;
            Cache testCache = new Cache("TestCache", 9, false);
            testCache.setLimitStrategy(new SimpleLimitStrategy(15, 20));
            BackgroundLruEvictionStrategy ev = new BackgroundLruEvictionStrategy(testCache, 1000L);
            testCache.setEvictionStrategy(ev);
            SimpleDateFormat format = new SimpleDateFormat("HH:mm:ss.SSSS");
            for (i = 0; i < 15; ++i) {
                key = Integer.toString(i);
                object = format.format(new Date());
                System.out.println("Inserting (" + key + ", " + object + ")");
                testCache.insert(key, object);
                testCache.unpin(key);
            }
            System.out.println("---- There are " + testCache.getSize() + " elements in the cache");
            ASSERT.isTrue((testCache.getSize() == 15 ? 1 : 0) != 0, (String)"testCache.getSize() == 15");
            for (i = 14; i >= 0; --i) {
                key = Integer.toString(i);
                object = (String)testCache.find(key);
                System.out.println("Found (" + key + ", " + object + ")");
                testCache.unpin(key);
            }
            System.out.println("---- There are still " + testCache.getSize() + " elements in the cache");
            ASSERT.isTrue((testCache.getSize() == 15 ? 1 : 0) != 0, (String)"testCache.getSize() == 15");
            for (i = 29; i >= 15; --i) {
                key = Integer.toString(i);
                object = (String)testCache.find(key);
                System.out.println("Found (" + key + ", " + object + ")");
                ASSERT.isTrue((object == null ? 1 : 0) != 0, (String)"object == null");
            }
            System.out.println("---- There are still " + testCache.getSize() + " elements in the cache");
            ASSERT.isTrue((testCache.getSize() == 15 ? 1 : 0) != 0, (String)"testCache.getSize() == 15");
            for (i = 15; i < 30; ++i) {
                key = Integer.toString(i);
                object = format.format(new Date());
                try {
                    System.out.println("Inserting (" + key + ", " + object + ")");
                    testCache.insert(key, object);
                    testCache.unpin(key);
                    continue;
                }
                catch (InsufficientCacheSpaceException ex) {
                    FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ejs.util.cache.BackgroundLruEvictionStrategy.main", (String)"718");
                    System.out.println("!!!! Cache is full");
                    ASSERT.isTrue((testCache.getSize() == 20 ? 1 : 0) != 0, (String)"testCache.getSize() == 20");
                    break;
                }
            }
            System.out.println("---- There are now " + testCache.getSize() + " elements in the cache");
            ev.start();
            try {
                do {
                    System.out.println("Sleeping...");
                    BackgroundLruEvictionStrategy.sleep(1000L);
                    System.out.println(">>>> There are now " + testCache.getSize() + " elements in the cache");
                } while (testCache.getSize() > 15);
            }
            catch (InterruptedException ex) {
                FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ejs.util.cache.BackgroundLruEvictionStrategy.main", (String)"748");
                System.out.println(ex);
            }
            for (int i2 = 0; i2 < 30; ++i2) {
                key = Integer.toString(i2);
                object = (String)testCache.find(key);
                System.out.println("Found (" + key + ", " + object + ")");
            }
            System.out.println("---- There are " + testCache.getSize() + " elements in the cache");
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ejs.util.cache.BackgroundLruEvictionStrategy.main", (String)"767");
            System.out.println(e);
        }
    }
}

