/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.ras;

import com.ibm.ejs.ras.RasHelper;
import com.ibm.ejs.ras.TraceEnableEvent;
import com.ibm.ws.logging.LevelConstants;

public class TraceElement {
    int ivLevel;
    String ivName;
    boolean ivDebugEnabled;
    boolean ivEventEnabled;
    boolean ivEntryEnabled;
    boolean ivDetailEnabled;
    boolean ivConfigEnabled;
    boolean ivInfoEnabled;
    boolean ivServiceEnabled;
    boolean ivWarningEnabled;
    boolean ivErrorEnabled;
    boolean ivFatalEnabled;

    TraceElement(String name) {
        this.ivName = name;
        this.ivLevel = 8;
        this.setInstanceVariables();
    }

    public final String getName() {
        return this.ivName;
    }

    public final boolean isDebugEnabled() {
        return this.ivDebugEnabled;
    }

    public final boolean isEntryEnabled() {
        return this.ivEntryEnabled;
    }

    public final boolean isEventEnabled() {
        return this.ivEventEnabled;
    }

    public final boolean isDetailEnabled() {
        return this.ivDetailEnabled;
    }

    public final boolean isConfigEnabled() {
        return this.ivConfigEnabled;
    }

    public final boolean isInfoEnabled() {
        return this.ivInfoEnabled;
    }

    public final boolean isAuditEnabled() {
        return this.ivServiceEnabled;
    }

    public final boolean isWarningEnabled() {
        return this.ivWarningEnabled;
    }

    public final boolean isErrorEnabled() {
        return this.ivErrorEnabled;
    }

    public final boolean isFatalEnabled() {
        return this.ivFatalEnabled;
    }

    public final boolean isServiceEnabled() {
        return this.ivServiceEnabled;
    }

    String getTraceSpecification() {
        StringBuffer b = new StringBuffer(this.ivName);
        b.append("=").append(LevelConstants.NAMES[this.ivLevel]);
        return new String(b);
    }

    String getStartsWith(String prefix, int level) {
        int lenPrefix = prefix.length();
        String result = "";
        if (this.ivName.startsWith(prefix)) {
            String s = this.ivName.substring(lenPrefix);
            if (s.startsWith(".")) {
                s = s.substring(1);
            }
            String[] components = RasHelper.split(s, 46);
            StringBuffer b = new StringBuffer(s.length());
            int len = components.length;
            for (int i = level; i < len - 1; ++i) {
                b.append(components[i]);
                b.append('.');
            }
            if (level < len) {
                b.append(components[len - 1]);
            }
            result = new String(b);
        }
        return result;
    }

    void applyTraceEnableEvent(TraceEnableEvent event2) {
        this.ivLevel = event2.getType();
        this.setInstanceVariables();
    }

    public final int getLevel() {
        return this.ivLevel;
    }

    protected void setInstanceVariables() {
        this.ivDebugEnabled = this.isLevelEnabled(3);
        this.ivEntryEnabled = this.isLevelEnabled(5);
        this.ivEventEnabled = this.isLevelEnabled(7);
        this.ivDetailEnabled = this.isLevelEnabled(8);
        this.ivConfigEnabled = this.isLevelEnabled(9);
        this.ivInfoEnabled = this.isLevelEnabled(10);
        this.ivServiceEnabled = this.isLevelEnabled(11);
        this.ivWarningEnabled = this.isLevelEnabled(12);
        this.ivErrorEnabled = this.isLevelEnabled(14);
        this.ivFatalEnabled = this.isLevelEnabled(15);
    }

    protected boolean isLevelEnabled(int level) {
        return LevelConstants.DISTINCT_LEVELS[this.ivLevel] <= LevelConstants.DISTINCT_LEVELS[level];
    }
}

