/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.ras;

import com.ibm.ejs.ras.RasHelper;
import com.ibm.ejs.ras.StreamEvent6;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.text.DateFormat;
import java.text.FieldPosition;
import java.util.Date;
import java.util.Vector;

abstract class SystemStream
extends PrintStream {
    private static final String svTrue = "true";
    private static final String svFalse = "false";
    private static final String svLineSeparator = RasHelper.getSystemProperty("line.separator");
    private static final byte[] svLineSeparatorBytes = svLineSeparator.getBytes();
    private static final char[] svLineSeparatorChars = svLineSeparator.toCharArray();
    PrintStream ivStream;
    private boolean ivSuppress;
    private boolean ivFormatted;
    String ivFormatType;
    private boolean ivWritePending = false;
    private boolean ivWriteDirectlyToStream = false;
    private StreamEvent6 ivEvent = null;
    private Vector ivCache;
    private int ivCacheSize = 0;
    private static final int svMaxCacheSize = 8192;
    StringBuffer ivBuffer;
    DateFormat ivFormatter;
    Date ivDate;
    FieldPosition ivFieldPos;

    SystemStream(OutputStream dummy, PrintStream stream, boolean suppress, boolean format, String formatType) {
        super(dummy);
        this.ivStream = stream;
        this.ivFormatted = format;
        this.ivFormatType = formatType;
        this.ivSuppress = suppress;
        this.ivBuffer = new StringBuffer();
        this.ivFormatter = RasHelper.getBasicDateFormatter();
        this.ivDate = new Date();
        this.ivFieldPos = new FieldPosition(0);
        String sysProp = RasHelper.getSystemProperty("com.ibm.ejs.ras.writeSystemStreamsDirectlyToFile");
        this.ivWriteDirectlyToStream = sysProp != null && svTrue.equalsIgnoreCase(sysProp);
    }

    abstract StreamEvent6 createEvent(String var1);

    abstract StreamEvent6 createEvent(byte[] var1);

    abstract StreamEvent6 createEvent(char[] var1);

    abstract void dispatchEvent(StreamEvent6 var1);

    public void flush() {
        this.ivStream.flush();
    }

    public void close() {
        this.ivStream.close();
    }

    public boolean checkError() {
        return this.ivStream.checkError();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(int b) {
        if (this.ivSuppress) {
            return;
        }
        byte[] data = new byte[]{(byte)b};
        StreamEvent6 se = this.cacheTraceData(data);
        if (se != null) {
            this.dispatchEvent(se);
        }
        if (!this.ivFormatted) {
            this.ivStream.write(b);
        } else {
            SystemStream systemStream = this;
            synchronized (systemStream) {
                if (this.ivWritePending) {
                    this.ivStream.write(b);
                } else {
                    StreamEvent6 sse = this.createEvent(data);
                    sse.writeSelfToStream(this.ivStream, this.ivFormatType, false, this.ivBuffer, this.ivFormatter, this.ivDate, this.ivFieldPos);
                    this.ivWritePending = true;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(byte[] buffer, int offset, int len) {
        block15: {
            if (this.ivSuppress) {
                return;
            }
            if (len == 0) {
                return;
            }
            if (buffer == null) {
                throw new NullPointerException();
            }
            if (offset < 0 || len < 0) {
                throw new IndexOutOfBoundsException();
            }
            int size = buffer.length;
            if (offset > size || len > size || offset + len > size) {
                throw new IndexOutOfBoundsException();
            }
            if (offset + len < 0) {
                throw new IndexOutOfBoundsException();
            }
            byte[] data = new byte[len];
            System.arraycopy(buffer, offset, data, 0, len);
            Object se = this.cacheTraceData(data);
            if (se != null) {
                this.dispatchEvent((StreamEvent6)se);
            }
            try {
                if (!this.ivFormatted) {
                    this.ivStream.write(data);
                    break block15;
                }
                se = this;
                synchronized (se) {
                    if (this.ivWritePending) {
                        this.ivStream.write(data);
                    } else {
                        StreamEvent6 sse = this.createEvent(data);
                        sse.writeSelfToStream(this.ivStream, this.ivFormatType, false, this.ivBuffer, this.ivFormatter, this.ivDate, this.ivFieldPos);
                    }
                }
                this.ivWritePending = !SystemStream.endsWithLineSeparator(data);
            }
            catch (IOException ioe) {
                // empty catch block
            }
        }
    }

    static boolean endsWithLineSeparator(String s) {
        if (s == null) {
            return false;
        }
        return s.endsWith(svLineSeparator);
    }

    static boolean endsWithLineSeparator(byte[] b) {
        if (b == null) {
            return false;
        }
        if (b.length < svLineSeparatorBytes.length) {
            return false;
        }
        for (int i = 1; i <= svLineSeparatorBytes.length; ++i) {
            if (b[b.length - i] == svLineSeparatorBytes[svLineSeparatorBytes.length - i]) continue;
            return false;
        }
        return true;
    }

    static boolean endsWithLineSeparator(char[] c) {
        if (c == null) {
            return false;
        }
        if (c.length < svLineSeparatorChars.length) {
            return false;
        }
        for (int i = 1; i <= svLineSeparatorBytes.length; ++i) {
            if (c[c.length - i] == svLineSeparatorBytes[svLineSeparatorBytes.length - i]) continue;
            return false;
        }
        return true;
    }

    public void print(boolean x) {
        if (this.ivSuppress) {
            return;
        }
        if (!x) {
            this.doPrint(svFalse);
        } else {
            this.doPrint(svTrue);
        }
    }

    public void print(char x) {
        if (this.ivSuppress) {
            return;
        }
        String writeData = String.valueOf(x);
        this.doPrint(writeData);
    }

    public void print(int x) {
        if (this.ivSuppress) {
            return;
        }
        String writeData = String.valueOf(x);
        this.doPrint(writeData);
    }

    public void print(long x) {
        if (this.ivSuppress) {
            return;
        }
        String writeData = String.valueOf(x);
        this.doPrint(writeData);
    }

    public void print(float x) {
        if (this.ivSuppress) {
            return;
        }
        String writeData = String.valueOf(x);
        this.doPrint(writeData);
    }

    public void print(double x) {
        if (this.ivSuppress) {
            return;
        }
        String writeData = String.valueOf(x);
        this.doPrint(writeData);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void print(char[] x) {
        if (this.ivSuppress) {
            return;
        }
        StreamEvent6 se = this.cacheTraceData(x);
        if (se != null) {
            this.dispatchEvent(se);
        }
        if (!this.ivFormatted) {
            this.ivStream.print(x);
        } else {
            SystemStream systemStream = this;
            synchronized (systemStream) {
                if (this.ivWritePending) {
                    this.ivStream.print(x);
                } else {
                    StreamEvent6 sse = this.createEvent(x);
                    sse.writeSelfToStream(this.ivStream, this.ivFormatType, false, this.ivBuffer, this.ivFormatter, this.ivDate, this.ivFieldPos);
                }
                this.ivWritePending = !SystemStream.endsWithLineSeparator(x);
            }
        }
    }

    public void print(String x) {
        if (this.ivSuppress) {
            return;
        }
        this.doPrint(x);
    }

    public void print(Object obj) {
        if (this.ivSuppress) {
            return;
        }
        String writeData = String.valueOf(obj);
        this.doPrint(writeData);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println() {
        if (this.ivSuppress) {
            return;
        }
        String writeData = null;
        StreamEvent6 sse = null;
        sse = this.getTraceData(writeData);
        this.dispatchEvent(sse);
        if (!this.ivFormatted) {
            this.ivStream.println();
        } else {
            SystemStream systemStream = this;
            synchronized (systemStream) {
                if (this.ivWritePending) {
                    this.ivStream.println();
                } else {
                    sse = this.createEvent(writeData);
                    sse.writeSelfToStream(this.ivStream, this.ivFormatType, true, this.ivBuffer, this.ivFormatter, this.ivDate, this.ivFieldPos);
                }
                this.ivWritePending = false;
            }
        }
    }

    public void println(boolean x) {
        if (this.ivSuppress) {
            return;
        }
        if (x) {
            this.doPrintLine(svTrue);
        } else {
            this.doPrintLine(svFalse);
        }
    }

    public void println(char x) {
        if (this.ivSuppress) {
            return;
        }
        String writeData = String.valueOf(x);
        this.doPrintLine(writeData);
    }

    public void println(int x) {
        if (this.ivSuppress) {
            return;
        }
        String writeData = String.valueOf(x);
        this.doPrintLine(writeData);
    }

    public void println(long x) {
        if (this.ivSuppress) {
            return;
        }
        String writeData = String.valueOf(x);
        this.doPrintLine(writeData);
    }

    public void println(float x) {
        if (this.ivSuppress) {
            return;
        }
        String writeData = String.valueOf(x);
        this.doPrintLine(writeData);
    }

    public void println(double x) {
        if (this.ivSuppress) {
            return;
        }
        String writeData = String.valueOf(x);
        this.doPrintLine(writeData);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println(char[] x) {
        if (this.ivSuppress) {
            return;
        }
        StreamEvent6 sse = null;
        sse = this.getTraceData(x);
        this.dispatchEvent(sse);
        if (!this.ivFormatted) {
            this.ivStream.println(x);
        } else {
            SystemStream systemStream = this;
            synchronized (systemStream) {
                if (this.ivWritePending) {
                    this.ivStream.println(x);
                } else {
                    sse = this.createEvent(x);
                    sse.writeSelfToStream(this.ivStream, this.ivFormatType, true, this.ivBuffer, this.ivFormatter, this.ivDate, this.ivFieldPos);
                }
                this.ivWritePending = false;
            }
        }
    }

    public void println(String x) {
        if (this.ivSuppress) {
            return;
        }
        this.doPrintLine(x);
    }

    public void println(Object x) {
        if (this.ivSuppress) {
            return;
        }
        String writeData = null;
        writeData = x instanceof Throwable ? RasHelper.throwableToString((Throwable)x) : String.valueOf(x);
        this.doPrintLine(writeData);
    }

    void writeWebSphereEvent(String data) {
        if (this.ivWritePending) {
            this.ivStream.println();
        }
        this.ivStream.println(data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void doPrint(String data) {
        StreamEvent6 se = this.cacheTraceData(data);
        if (se != null) {
            this.dispatchEvent(se);
        }
        if (!this.ivFormatted || this.ivWriteDirectlyToStream) {
            this.ivStream.print(data);
        } else {
            SystemStream systemStream = this;
            synchronized (systemStream) {
                if (this.ivWritePending) {
                    this.ivStream.print(data);
                } else {
                    StreamEvent6 sse = this.createEvent(data);
                    sse.writeSelfToStream(this.ivStream, this.ivFormatType, false, this.ivBuffer, this.ivFormatter, this.ivDate, this.ivFieldPos);
                }
                this.ivWritePending = !SystemStream.endsWithLineSeparator(data);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void doPrintLine(String data) {
        StreamEvent6 sse = this.getTraceData(data);
        this.dispatchEvent(sse);
        if (!this.ivFormatted || this.ivWriteDirectlyToStream) {
            this.ivStream.println(data);
        } else {
            SystemStream systemStream = this;
            synchronized (systemStream) {
                if (this.ivWritePending) {
                    this.ivStream.println(data);
                } else {
                    StreamEvent6 sse2 = this.createEvent(data);
                    sse2.writeSelfToStream(this.ivStream, this.ivFormatType, true, this.ivBuffer, this.ivFormatter, this.ivDate, this.ivFieldPos);
                }
                this.ivWritePending = false;
            }
        }
    }

    private synchronized StreamEvent6 cacheTraceData(String data) {
        int size;
        int n = size = data == null ? 8 : data.length() * 2;
        if (this.ivCacheSize + size > 8192) {
            return this.getTraceData(data);
        }
        if (SystemStream.endsWithLineSeparator(data)) {
            return this.getTraceData(data);
        }
        if (this.ivEvent == null) {
            this.ivEvent = this.createEvent(data);
        } else {
            if (this.ivCache == null) {
                this.ivCache = new Vector();
            }
            this.ivCache.addElement(data);
        }
        this.ivCacheSize += size;
        return null;
    }

    private synchronized StreamEvent6 cacheTraceData(byte[] data) {
        int size;
        int n = size = data == null ? 0 : data.length;
        if (this.ivCacheSize + size > 8192) {
            return this.getTraceData(data);
        }
        if (SystemStream.endsWithLineSeparator(data)) {
            return this.getTraceData(data);
        }
        if (this.ivEvent == null) {
            this.ivEvent = this.createEvent(data);
        } else {
            if (this.ivCache == null) {
                this.ivCache = new Vector();
            }
            this.ivCache.addElement(data);
        }
        this.ivCacheSize += size;
        return null;
    }

    private synchronized StreamEvent6 cacheTraceData(char[] data) {
        int size;
        int n = size = data == null ? 0 : data.length;
        if (this.ivCacheSize + size > 8192) {
            return this.getTraceData(data);
        }
        if (SystemStream.endsWithLineSeparator(data)) {
            return this.getTraceData(data);
        }
        if (this.ivEvent == null) {
            this.ivEvent = this.createEvent(data);
        } else {
            if (this.ivCache == null) {
                this.ivCache = new Vector();
            }
            this.ivCache.addElement(data);
        }
        this.ivCacheSize += size;
        return null;
    }

    private synchronized StreamEvent6 getTraceData(String data) {
        if (this.ivEvent == null) {
            return this.createEvent(data);
        }
        StreamEvent6 se = this.ivEvent;
        if (this.ivCache == null) {
            this.ivCache = new Vector();
        }
        this.ivCache.addElement(data);
        se.addDataCache(this.ivCache);
        this.ivEvent = null;
        this.ivCache = null;
        this.ivCacheSize = 0;
        return se;
    }

    private synchronized StreamEvent6 getTraceData(byte[] data) {
        if (this.ivEvent == null) {
            return this.createEvent(data);
        }
        StreamEvent6 se = this.ivEvent;
        if (this.ivCache == null) {
            this.ivCache = new Vector();
        }
        this.ivCache.addElement(data);
        se.addDataCache(this.ivCache);
        this.ivEvent = null;
        this.ivCache = null;
        this.ivCacheSize = 0;
        return se;
    }

    private synchronized StreamEvent6 getTraceData(char[] data) {
        if (this.ivEvent == null) {
            return this.createEvent(data);
        }
        StreamEvent6 se = this.ivEvent;
        if (this.ivCache == null) {
            this.ivCache = new Vector();
        }
        this.ivCache.addElement(data);
        se.addDataCache(this.ivCache);
        this.ivEvent = null;
        this.ivCache = null;
        this.ivCacheSize = 0;
        return se;
    }
}

