/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.persistence;

import com.ibm.ejs.container.ContainerProperties;
import com.ibm.ejs.persistence.BMFinderHelper;
import com.ibm.ejs.persistence.CMFinderHelper;
import com.ibm.ejs.persistence.EnumeratorException;
import com.ibm.ejs.persistence.FinderCollection;
import com.ibm.ejs.persistence.FinderEnumeration;
import com.ibm.ejs.persistence.FinderHelper;
import com.ibm.ejs.persistence.NoMoreElementsException;
import com.ibm.ejs.persistence.PortableFinderCollection;
import com.ibm.ejs.persistence.PortableFinderEnumeration;
import com.ibm.ejs.persistence.RemoteEnumeratorImpl;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.cpi.Finder;
import com.ibm.websphere.cpi.PersisterHome;
import com.ibm.websphere.cpi.PersisterTx;
import com.ibm.ws.ffdc.FFDCFilter;
import java.rmi.RemoteException;
import java.util.Collection;
import java.util.Enumeration;
import javax.ejb.EJBObject;
import javax.ejb.FinderException;

public abstract class MultivalueFinderFactory {
    private static final TraceComponent tc = Tr.register(MultivalueFinderFactory.class, "EJBContainer", "com.ibm.ejs.container.container");
    private static final String CLASS_NAME = "com.ibm.ejs.persistence.MultivalueFinderFactory";
    public static final boolean propFlag = MultivalueFinderFactory.getPropFlag();

    public static Enumeration createEnumeration(PersisterTx tx, PersisterHome home, Finder finder) throws RemoteException, FinderException {
        CMFinderHelper helper = new CMFinderHelper(home, finder);
        if (!tx.beganInThisScope()) {
            return (Enumeration)MultivalueFinderFactory.createLazyEnumerator(tx, helper, false);
        }
        return (Enumeration)MultivalueFinderFactory.createGreedyEnumerator(tx, helper, false);
    }

    public static Enumeration createEnumeration(PersisterTx tx, PersisterHome home, Enumeration keys) throws RemoteException, FinderException {
        BMFinderHelper helper = new BMFinderHelper(home, keys);
        if (!tx.beganInThisScope()) {
            return (Enumeration)MultivalueFinderFactory.createLazyEnumerator(tx, helper, false);
        }
        return (Enumeration)MultivalueFinderFactory.createGreedyEnumerator(tx, helper, false);
    }

    public static Collection createCollection(PersisterTx tx, PersisterHome home, Finder finder) throws RemoteException, FinderException {
        CMFinderHelper helper = new CMFinderHelper(home, finder);
        if (!tx.beganInThisScope()) {
            return (Collection)MultivalueFinderFactory.createLazyEnumerator(tx, helper, true);
        }
        return (Collection)MultivalueFinderFactory.createGreedyEnumerator(tx, helper, true);
    }

    public static Collection createCollection(PersisterTx tx, PersisterHome home, Collection keys) throws RemoteException, FinderException {
        BMFinderHelper helper = new BMFinderHelper(home, keys);
        if (!tx.beganInThisScope()) {
            return (Collection)MultivalueFinderFactory.createLazyEnumerator(tx, helper, true);
        }
        return (Collection)MultivalueFinderFactory.createGreedyEnumerator(tx, helper, true);
    }

    private static Object createLazyEnumerator(PersisterTx tx, FinderHelper helper, boolean isCollection) throws RemoteException, FinderException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "createLazyEnumerator", new Object[]{tx, helper});
        }
        EJBObject[] elements = null;
        boolean exhausted = false;
        try {
            if (propFlag) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Creating PortableFinderEnumerator");
                }
                elements = helper.enumerateIntoArray(25, true);
            } else {
                elements = helper.enumerateIntoArray(25, true);
            }
            exhausted = !helper.hasMoreElements();
        }
        catch (NoMoreElementsException ex) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event(tc, "Enumeration is empty");
            }
            exhausted = true;
        }
        catch (EnumeratorException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ejs.persistence.MultivalueFinderFactory.createLazyEnumerator", (String)"138");
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "createLazyEnumerator", e);
            }
            throw new FinderException(e.toString());
        }
        RemoteEnumeratorImpl vEnum = null;
        if (!exhausted) {
            if (helper instanceof CMFinderHelper) {
                helper.cacheCustomFinderAccessIntentState();
            }
            vEnum = new RemoteEnumeratorImpl(helper);
            tx.registerSynchronization(vEnum);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "createLazyEnumerator");
        }
        if (isCollection) {
            if (propFlag) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Creating PortableFinderCollection");
                }
                return new PortableFinderCollection(elements, exhausted, vEnum);
            }
            return new FinderCollection(elements, exhausted, vEnum);
        }
        if (propFlag) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Creating PortableFinderEnumeration");
            }
            return new PortableFinderEnumeration(elements, exhausted, vEnum);
        }
        return new FinderEnumeration(elements, exhausted, vEnum);
    }

    private static Object createGreedyEnumerator(PersisterTx tx, FinderHelper helper, boolean isCollection) throws RemoteException, FinderException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "createGreedyEnumerator", new Object[]{tx, helper});
        }
        EJBObject[] elements = null;
        try {
            elements = helper.enumerateIntoArray(false);
        }
        catch (NoMoreElementsException ex) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event(tc, "Enumeration is empty");
            }
        }
        catch (EnumeratorException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ejs.persistence.MultivalueFinderFactory.createGreedyEnumerator", (String)"184");
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "createGreedyEnumerator", e);
            }
            throw new FinderException(e.toString());
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "createGreedyEnumerator");
        }
        if (isCollection) {
            if (propFlag) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Creating PortableFinderCollection");
                }
                return new PortableFinderCollection(elements);
            }
            return new FinderCollection(elements);
        }
        if (propFlag) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Creating PortableFinderEnumeration");
            }
            return new PortableFinderEnumeration(elements);
        }
        return new FinderEnumeration(elements);
    }

    public static boolean getPropFlag() {
        boolean mb = true;
        String temp2 = ContainerProperties.PortableFinder;
        mb = temp2 != null ? temp2.equalsIgnoreCase("true") : ContainerProperties.Portable;
        return mb;
    }
}

