/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.persistence;

import com.ibm.ejs.cm.portability.DuplicateKeyException;
import com.ibm.ejs.cm.portability.PortabilityLayerExt;
import com.ibm.ejs.cm.portability.PortableConnection;
import com.ibm.ejs.cm.portability.PortableDataSource;
import com.ibm.ejs.container.BeanId;
import com.ibm.ejs.container.ContainerManagedBeanO;
import com.ibm.ejs.container.ContainerTx;
import com.ibm.ejs.container.EJSDeployedSupport;
import com.ibm.ejs.container.util.BuzzHash;
import com.ibm.ejs.container.util.NameUtil;
import com.ibm.ejs.j2c.HandleList;
import com.ibm.ejs.persistence.EJSPersistenceException;
import com.ibm.ejs.persistence.EJSPersister;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.cpi.JDBCPersisterMetaData;
import com.ibm.websphere.cpi.PersisterHome;
import com.ibm.websphere.csi.EJBMethodInfo;
import com.ibm.websphere.rsadapter.DataStoreHelper;
import com.ibm.websphere.rsadapter.DataStoreHelperMetaData;
import com.ibm.ws.LocalTransaction.InconsistentLocalTranException;
import com.ibm.ws.LocalTransaction.LocalTransactionCoordinator;
import com.ibm.ws.LocalTransaction.LocalTransactionCurrent;
import com.ibm.ws.LocalTransaction.RolledbackException;
import com.ibm.ws.Transaction.TransactionManagerFactory;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.rsadapter.jdbc.WSJdbcDataSource;
import com.ibm.ws.rsadapter.jdbc.WSJdbcObject;
import com.ibm.ws.rsadapter.jdbc.WSJdbcUtil;
import com.ibm.ws.rsadapter.jdbc.WSJdbcWrapper;
import com.ibm.ws.rsadapter.spi.InternalDataStoreHelper;
import com.ibm.ws.threadContext.ConnectionHandleAccessorImpl;
import com.ibm.ws.threadContext.ThreadContext;
import com.ibm.ws.util.WSThreadLocal;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Properties;
import javax.ejb.EJBObject;
import javax.ejb.EntityBean;
import javax.resource.ResourceException;
import javax.sql.DataSource;

public abstract class EJSJDBCPersister
implements EJSPersister {
    private static final TraceComponent tc = Tr.register(EJSJDBCPersister.class, "EJBContainer", "com.ibm.ejs.container.container");
    private static final String CLASS_NAME = "com.ibm.ejs.persistence.EJSJDBCPersister";
    private static final TraceComponent tc2 = Tr.register("com.ibm.ejs.persistence.EJSJDBCPersister$DataStoreHelper", "EJBContainer", "com.ibm.ejs.resources.CONMMessages");
    private boolean ivCMPAutoCommitWarningLogged = false;
    private boolean ivCMPWarningLogged = false;
    private static final WSThreadLocal<ContainerManagedBeanO> cvThreadLocal = new WSThreadLocal();
    protected PersisterHome home = null;
    protected String schemaName;
    protected WSJdbcDataSource jdbcDataSource = null;
    protected PortableDataSource dataSource = null;
    protected String dbUser = null;
    protected String dbPassword = null;
    private boolean newDataSource = false;
    private DataStoreHelper dshelper = null;
    private DataStoreHelperMetaData dshelperMetadata = null;
    private InternalDataStoreHelper intDSHelper = null;
    private boolean supportsSelectForUpdate;
    private boolean supportsKeepUpdateLocks;

    public static EJSJDBCPersister create(JDBCPersisterMetaData pmd) throws Exception {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "create(MetaData)");
        }
        Class c = EJSJDBCPersister.getPersisterClass(pmd);
        EJSJDBCPersister p = (EJSJDBCPersister)c.newInstance();
        Properties prop = pmd.getPersisterConfigData().getProperties();
        p.initialize(pmd.getDataSource(), (String)prop.get("DBUser"), (String)prop.get("DBPassword"), (String)prop.get("DBSchema"));
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "create(MetaData)");
        }
        return p;
    }

    private static Class getPersisterClass(JDBCPersisterMetaData pmd) throws Exception {
        String implClassName;
        Class<?> rtnClass;
        block10: {
            String baseName;
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.entry(tc, "getPersisterClass");
            }
            rtnClass = null;
            ClassLoader clsLdr = pmd.getClassLoader();
            Object enterpriseBean = pmd.getEnterpriseBean();
            implClassName = baseName = NameUtil.getDeployedPersisterClassName(enterpriseBean);
            try {
                implClassName = implClassName + "_" + BuzzHash.computeHashStringMid32Bit(NameUtil.getHashStr(enterpriseBean));
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "getPersisterClass(): Ejb module 2.0 - Loading Persister = " + implClassName);
                }
                rtnClass = clsLdr != null ? clsLdr.loadClass(implClassName) : Class.forName(implClassName);
            }
            catch (ClassNotFoundException cnfe) {
                implClassName = NameUtil.updateFilenameHashCode(enterpriseBean, implClassName);
                if (implClassName != null) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "getPersisterClass(): Failed Loading version 2 class, try modified BuzzHash version=" + implClassName);
                    }
                    try {
                        rtnClass = clsLdr != null ? clsLdr.loadClass(implClassName) : Class.forName(implClassName);
                    }
                    catch (ClassNotFoundException cnfe1) {
                        // empty catch block
                    }
                }
                if (rtnClass != null) break block10;
                implClassName = baseName;
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "getPersisterClass(): Ejb module 1.0 - Loading Persister = " + implClassName);
                }
                Class<?> clazz = rtnClass = clsLdr != null ? clsLdr.loadClass(implClassName) : Class.forName(implClassName);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getPersisterClass Loaded " + implClassName);
        }
        return rtnClass;
    }

    public EJSJDBCPersister() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "<init>");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "<init>");
        }
    }

    public void setHome(PersisterHome h) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "setHome", h);
        }
        this.home = h;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "setHome");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void initialize(DataSource dataSource, String dbUser, String dbPassword, String schemaName) throws EJSPersistenceException {
        block47: {
            PortableConnection c;
            block46: {
                block49: {
                    Object v0;
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        Tr.entry(tc, "initialize", this);
                    }
                    if (!(dataSource instanceof WSJdbcDataSource)) break block49;
                    this.newDataSource = true;
                    this.jdbcDataSource = (WSJdbcDataSource)dataSource;
                    this.dshelper = this.jdbcDataSource.getDataStoreHelper();
                    this.intDSHelper = this.jdbcDataSource.getInternalDataStoreHelper();
                    this.dshelperMetadata = this.dshelper.getMetaData();
                    Connection conn = null;
                    LocalTransactionCurrent lc = null;
                    LocalTransactionCoordinator lcoord = null;
                    LocalTransactionCoordinator suspendedlcoord = null;
                    ThreadContext handleThreadContext = null;
                    handleThreadContext = ConnectionHandleAccessorImpl.getConnectionHandleAccessor().getThreadContext();
                    handleThreadContext.beginContext((Object)new HandleList());
                    lc = TransactionManagerFactory.getLocalTransactionCurrent();
                    suspendedlcoord = lc.suspend();
                    lc.begin();
                    lcoord = lc.getLocalTranCoord();
                    conn = this.jdbcDataSource.getConnection(dbUser, dbPassword);
                    this.supportsSelectForUpdate = this.dshelperMetadata.supportsSelectForUpdate();
                    this.supportsKeepUpdateLocks = this.dshelperMetadata.supportsExtendedForUpdate();
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "Connection supports Extended for Update:" + this.supportsKeepUpdateLocks);
                        Tr.debug(tc, "Connection supports Select   for Update:" + this.supportsSelectForUpdate);
                    }
                    this.schemaName = schemaName;
                    this.dbUser = dbUser;
                    this.dbPassword = dbPassword;
                    Object var12_13 = null;
                    try {
                        try {
                            if (conn != null) {
                                conn.close();
                            }
                            if (lcoord != null) {
                                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                    Tr.debug(tc, "rolling back local tran that was started.");
                                }
                                lcoord.complete(1);
                            }
                            v0 = null;
                        }
                        catch (SQLException e1) {
                            FFDCFilter.processException((Throwable)e1, (String)"com.ibm.ejs.persistence.EJSJDBCPersister.initialize", (String)"221", (Object)this);
                            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                                Tr.event(tc, "Failed to close connection", e1);
                            }
                            v0 = null;
                        }
                        catch (InconsistentLocalTranException e2) {
                            FFDCFilter.processException((Throwable)e2, (String)"com.ibm.ejs.persistence.EJSJDBCPersister.initialize", (String)"314", (Object)this);
                            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                                Tr.event(tc, "Tolerating InconsistentLocalTranException on rollback request", (Object)e2);
                            }
                            v0 = null;
                        }
                        catch (RolledbackException e3) {
                            FFDCFilter.processException((Throwable)e3, (String)"com.ibm.ejs.persistence.EJSJDBCPersister.initialize", (String)"326", (Object)this);
                            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                                Tr.event(tc, "Tolerating RolledbackException on a rollback request", (Object)e3);
                            }
                            v0 = null;
                        }
                    }
                    catch (Throwable throwable) {
                        Object var15_19;
                        v0 = var15_19 = null;
                    }
                    if (suspendedlcoord != null) {
                        lc.resume(suspendedlcoord);
                    }
                    if (null != handleThreadContext) {
                        handleThreadContext.endContext();
                    }
                    break block47;
                    {
                        catch (SQLException ex) {
                            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ejs.persistence.EJSJDBCPersister.initialize", (String)"209", (Object)this);
                            throw new EJSPersistenceException("", WSJdbcUtil.mapException((WSJdbcWrapper)((WSJdbcObject)conn), (SQLException)ex));
                        }
                    }
                    catch (Throwable throwable) {
                        Object v1;
                        Object var12_14 = null;
                        try {
                            try {
                                if (conn != null) {
                                    conn.close();
                                }
                                if (lcoord != null) {
                                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                        Tr.debug(tc, "rolling back local tran that was started.");
                                    }
                                    lcoord.complete(1);
                                }
                                v1 = null;
                            }
                            catch (SQLException e1) {
                                FFDCFilter.processException((Throwable)e1, (String)"com.ibm.ejs.persistence.EJSJDBCPersister.initialize", (String)"221", (Object)this);
                                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                                    Tr.event(tc, "Failed to close connection", e1);
                                }
                                v1 = null;
                            }
                            catch (InconsistentLocalTranException e2) {
                                FFDCFilter.processException((Throwable)e2, (String)"com.ibm.ejs.persistence.EJSJDBCPersister.initialize", (String)"314", (Object)this);
                                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                                    Tr.event(tc, "Tolerating InconsistentLocalTranException on rollback request", (Object)e2);
                                }
                                v1 = null;
                            }
                            catch (RolledbackException e3) {
                                FFDCFilter.processException((Throwable)e3, (String)"com.ibm.ejs.persistence.EJSJDBCPersister.initialize", (String)"326", (Object)this);
                                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                                    Tr.event(tc, "Tolerating RolledbackException on a rollback request", (Object)e3);
                                }
                                v1 = null;
                            }
                        }
                        catch (Throwable throwable2) {
                            Object var15_20;
                            v1 = var15_20 = null;
                        }
                        if (suspendedlcoord != null) {
                            lc.resume(suspendedlcoord);
                        }
                        if (null != handleThreadContext) {
                            handleThreadContext.endContext();
                        }
                        throw throwable;
                    }
                }
                this.dataSource = (PortableDataSource)dataSource;
                this.dbUser = dbUser;
                this.dbPassword = dbPassword;
                c = null;
                Connection conn = null;
                conn = dataSource.getConnection(dbUser, dbPassword);
                c = (PortableConnection)conn;
                this.supportsSelectForUpdate = c.getPortabilityLayer().supportsRowLockHint();
                this.supportsKeepUpdateLocks = c.getPortabilityLayer().supportsExtendedForUpdate(conn);
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Connection supports Extended for Update:" + this.supportsKeepUpdateLocks);
                    Tr.debug(tc, "Connection supports Select   for Update:" + this.supportsSelectForUpdate);
                }
                if (c.getPortabilityLayer().supportsSchema()) {
                    this.schemaName = schemaName;
                    break block46;
                }
                this.schemaName = "";
            }
            Object var17_23 = null;
            try {
                if (c != null) {
                    c.close();
                }
                break block47;
            }
            catch (SQLException e1) {
                FFDCFilter.processException((Throwable)e1, (String)"com.ibm.ejs.persistence.EJSJDBCPersister.initialize", (String)"267", (Object)this);
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    Tr.event(tc, "Failed to close connection", e1);
                }
                break block47;
            }
            {
                catch (SQLException e) {
                    FFDCFilter.processException((Throwable)e, (String)"com.ibm.ejs.persistence.EJSJDBCPersister.initialize", (String)"255", (Object)this);
                    throw new EJSPersistenceException("", e);
                }
            }
            catch (Throwable throwable) {
                block48: {
                    Object var17_24 = null;
                    try {
                        if (c != null) {
                            c.close();
                        }
                    }
                    catch (SQLException e1) {
                        FFDCFilter.processException((Throwable)e1, (String)"com.ibm.ejs.persistence.EJSJDBCPersister.initialize", (String)"267", (Object)this);
                        if (!TraceComponent.isAnyTracingEnabled() || !tc.isEventEnabled()) break block48;
                        Tr.event(tc, "Failed to close connection", e1);
                    }
                }
                throw throwable;
            }
        }
        this.postInit();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "initialize");
        }
    }

    public final boolean dbSupportsSelectForUpdate() {
        return this.supportsSelectForUpdate;
    }

    public final boolean dbSupportsKeepUpdateLocks() {
        return this.supportsKeepUpdateLocks;
    }

    protected void postInit() {
    }

    public void create(EntityBean eb) throws Exception {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "create(EntityBean)", this);
        }
        try {
            this._create(eb);
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ejs.persistence.EJSJDBCPersister.create", (String)"319", (Object)this);
            if (this.newDataSource) {
                if (this.dshelper.isDuplicateKey(ex)) {
                    throw new javax.ejb.DuplicateKeyException();
                }
                throw ex;
            }
            SQLException e = this.dataSource.getPortabilityLayer().translateException(ex);
            if (e instanceof DuplicateKeyException) {
                throw new javax.ejb.DuplicateKeyException();
            }
            throw e;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "create(EntityBean)");
        }
    }

    public EJBObject getBean(Object beanData) throws Exception {
        return this.home.getBean(this.getPrimaryKey(beanData), beanData);
    }

    public void checkCMPStoreOperation(BeanId beanId, boolean loadedForUpdate) throws Exception {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "checkCMPStoreOperation beanid[" + beanId + "] loadedForUpdate[" + loadedForUpdate + "] ivCMPWarningLogged[" + this.ivCMPWarningLogged + "] ivCMPAutoCommitWarningLogged[" + this.ivCMPAutoCommitWarningLogged + "]");
        }
        if (this.newDataSource) {
            int isolvl;
            String msgId;
            Connection conn = this.jdbcDataSource.getConnection(this.dbUser, this.dbPassword);
            if (!this.ivCMPWarningLogged && (msgId = this.dshelper.hasLostUpdateOrDeadLockOccurred(isolvl = conn.getTransactionIsolation(), loadedForUpdate)) != null) {
                Tr.service(tc2, msgId, beanId);
                this.ivCMPWarningLogged = true;
                if (this.ivCMPWarningLogged && tc.isDebugEnabled()) {
                    Tr.debug(tc, "checkCMPStoreOperation WARNING beanid[" + beanId + "] loadedForUpdate[" + loadedForUpdate + "] Possible Lost Update or Deadlock Condition");
                }
            }
        } else {
            PortableConnection c = (PortableConnection)this.dataSource.getConnection(this.dbUser, this.dbPassword);
            if (c.getAutoCommit()) {
                if (!this.ivCMPAutoCommitWarningLogged) {
                    Tr.service(tc, "POTENTIAL_LOST_UPDATE_CNTR0038W", beanId);
                    this.ivCMPAutoCommitWarningLogged = true;
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "checkCMPStoreOperation: WARNING beanid[" + beanId + "] loadedForUpdate[" + loadedForUpdate + "] Possible Lost Update");
                    }
                }
            } else if (!this.ivCMPWarningLogged) {
                PortabilityLayerExt p = c.getPortabilityLayer();
                this.ivCMPWarningLogged = p.checkCMPStoreOperation(beanId.toString(), (Connection)c, loadedForUpdate);
                if (this.ivCMPWarningLogged && tc.isDebugEnabled()) {
                    Tr.debug(tc, "checkCMPStoreOperation WARNING beanid[" + beanId + "] loadedForUpdate[" + loadedForUpdate + "] Possible Lost Update or Deadlock Condition");
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "checkCMPStoreOperation beanid[" + beanId + "] ivCMPWarningLogged[" + this.ivCMPWarningLogged + "] ivCMPAutoCommitWarningLogged[" + this.ivCMPAutoCommitWarningLogged + "]");
        }
    }

    public PreparedStatement getPreparedStatement(String key) throws EJSPersistenceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getPreparedStatement " + key);
        }
        PreparedStatement result = null;
        Connection conn = null;
        try {
            ContainerManagedBeanO beanO;
            conn = this.newDataSource ? this.jdbcDataSource.getConnection(this.dbUser, this.dbPassword) : this.dataSource.getConnection(this.dbUser, this.dbPassword);
            boolean cmp11fbpk = false;
            boolean cmp11cfWithRWAccessIntent = false;
            boolean cmp11ai = false;
            boolean cfScenario = false;
            int cmp11isolevel = 0;
            boolean cmp11AcquireDefaultIsolevel = false;
            boolean cmp11intran = false;
            String cmp11methname = null;
            ContainerTx ctx = null;
            EJSDeployedSupport s = (EJSDeployedSupport)this.home.getCurrentThreadDeployedSupport();
            EJBMethodInfo ejbInfo = null;
            if (s != null && (ejbInfo = s.getEJBMethodInfo()) != null) {
                cmp11fbpk = ejbInfo.getIsCMP11FBPK();
                cmp11cfWithRWAccessIntent = ejbInfo.getIsCMP11CustomFinderWithForUpdateAI();
                cmp11ai = ejbInfo.getReadOnlyAttribute();
                cmp11methname = ejbInfo.getMethodName();
                ctx = s.getCurrentTx();
                if (ctx != null) {
                    cmp11intran = ejbInfo.getEJBComponentMetaData().getEJBModuleVersion() == 11 ? ctx.isTransactionGlobal() : true;
                    cmp11isolevel = ctx.getIsolationLevel();
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "ContainerTx:" + ctx + " CMP11FlushActive :" + ctx.getCMP11FlushActive());
                    }
                    if (cmp11isolevel == 0) {
                        cmp11AcquireDefaultIsolevel = true;
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug(tc, "Isolevel of TRANSACTION_NONE encountered, using default database isolation level");
                        }
                    }
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Calling Method [" + cmp11methname + "] DB ForUpdate: " + this.supportsSelectForUpdate + " DBExt ForUpdate:" + this.supportsKeepUpdateLocks + " CF w/RW AI:" + cmp11cfWithRWAccessIntent + " FBPK:" + cmp11fbpk + " read-only:" + cmp11ai + " Inherit:" + this.home.hasInheritance() + " Child:" + this.home.isChild());
                }
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled() && (s == null || ejbInfo == null)) {
                Tr.debug(tc, "Custom Finder SQL Update Processing Skipped");
            }
            if (cmp11intran && !ctx.getCMP11FlushActive() && cmp11cfWithRWAccessIntent && !cmp11ai) {
                boolean addKeepLocksSQL;
                boolean bl = addKeepLocksSQL = this.supportsSelectForUpdate && this.supportsKeepUpdateLocks && !this.home.hasInheritance() && !this.home.isChild();
                if (this.newDataSource) {
                    if (cmp11AcquireDefaultIsolevel) {
                        try {
                            cmp11isolevel = this.dshelper.getIsolationLevel(null);
                        }
                        catch (ResourceException ex) {
                            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ejs.persistence.EJSJDBCPersister.getPreparedStatement", (String)"874", (Object)this);
                            throw new EJSPersistenceException("", ex);
                        }
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug(tc, "Using database default isolation level for :" + cmp11isolevel);
                        }
                    }
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "ContainerTx (glbl):" + ctx + " CurrentIsolevel:" + cmp11isolevel);
                    }
                    key = this.intDSHelper.processSQL(key, cmp11isolevel, this.supportsSelectForUpdate, addKeepLocksSQL);
                } else {
                    PortableConnection c = (PortableConnection)conn;
                    PortabilityLayerExt plx = c.getPortabilityLayer();
                    if (cmp11AcquireDefaultIsolevel) {
                        cmp11isolevel = plx.getPreferredIsolationLevel();
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug(tc, "Using database default isolation level for :" + cmp11isolevel);
                        }
                    }
                    key = plx.processSQL(key, cmp11isolevel, this.supportsSelectForUpdate, addKeepLocksSQL);
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Enhancing SQL Scenario, CF Case, SQL: " + key);
                }
                cfScenario = true;
            }
            if (!cfScenario && this.supportsSelectForUpdate && this.supportsKeepUpdateLocks && (beanO = (ContainerManagedBeanO)cvThreadLocal.get()) != null && beanO.getCalledFromLoadMethodForUpdate()) {
                boolean addKeepLocksSQL;
                boolean bl = addKeepLocksSQL = this.supportsSelectForUpdate && this.supportsKeepUpdateLocks && !this.home.hasInheritance() && !this.home.isChild();
                if (this.newDataSource) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "ContainerTx:" + ctx + " CurrentIsolevel:" + cmp11isolevel);
                    }
                    if (cmp11AcquireDefaultIsolevel) {
                        try {
                            cmp11isolevel = this.dshelper.getIsolationLevel(null);
                        }
                        catch (ResourceException ex) {
                            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ejs.persistence.EJSJDBCPersister.getPreparedStatement", (String)"938", (Object)this);
                            throw new EJSPersistenceException("", ex);
                        }
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug(tc, "Using database default isolation level for :" + cmp11isolevel);
                        }
                    }
                    key = this.intDSHelper.processSQL(key, cmp11isolevel, false, addKeepLocksSQL);
                } else {
                    PortableConnection c = (PortableConnection)conn;
                    PortabilityLayerExt plx = c.getPortabilityLayer();
                    if (cmp11AcquireDefaultIsolevel) {
                        cmp11isolevel = plx.getPreferredIsolationLevel();
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug(tc, "Using database default isolation level for :" + cmp11isolevel);
                        }
                    }
                    key = plx.processSQL(key, cmp11isolevel, false, addKeepLocksSQL);
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Enhancing SQL Scenario, Load Ext For Update Case, SQL: " + key);
                }
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "SQL for prepareStatement:" + key);
            }
            result = conn.prepareStatement(key);
        }
        catch (SQLException ex) {
            block37: {
                FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ejs.persistence.EJSJDBCPersister.getPreparedStatement", (String)"466", (Object)this);
                try {
                    if (conn != null) {
                        conn.close();
                    }
                }
                catch (SQLException e) {
                    FFDCFilter.processException((Throwable)e, (String)"com.ibm.ejs.persistence.EJSJDBCPersister.getPreparedStatement", (String)"477", (Object)this);
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block37;
                    Tr.debug(tc, "Connection close after error failed with: ", e);
                }
            }
            throw new EJSPersistenceException("getPStmt failed", ex);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getPreparedStatement");
        }
        return result;
    }

    protected final void returnPreparedStatement(PreparedStatement ps) throws EJSPersistenceException {
        Connection conn = null;
        try {
            conn = ps.getConnection();
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ejs.persistence.EJSJDBCPersister.returnPreparedStatement", (String)"503", (Object)this);
            throw new EJSPersistenceException(ex);
        }
        if (conn == null) {
            EJSPersistenceException e = new EJSPersistenceException("Prepared statement does not map to connection");
            Tr.error(tc, "PREPARED_STATEMENT_NOT_FOUND_CNTR0037E");
            throw e;
        }
        try {
            ps.close();
            conn.close();
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ejs.persistence.EJSJDBCPersister.returnPreparedStatement", (String)"526", (Object)this);
            throw new EJSPersistenceException(ex);
        }
    }

    public void preFind() throws RemoteException {
        this.home.preFind();
    }

    public final void setContextData(ContainerManagedBeanO beanO) {
        cvThreadLocal.set((Object)beanO);
    }

    public final Object[] getDataFromCache() {
        ContainerManagedBeanO beanO = (ContainerManagedBeanO)cvThreadLocal.get();
        return beanO.getDataCache();
    }

    public final void putDataIntoCache(Object[] data) {
        ContainerManagedBeanO beanO = (ContainerManagedBeanO)cvThreadLocal.get();
        beanO.setDataCache(data);
    }

    public abstract void _create(EntityBean var1) throws Exception;

    public abstract void remove(EntityBean var1) throws Exception;

    public abstract void refresh(EntityBean var1, boolean var2) throws Exception;

    public abstract void load(EntityBean var1, Object var2, boolean var3) throws Exception;

    public abstract Object getPrimaryKey(Object var1) throws Exception;

    public abstract void hydrate(EntityBean var1, Object var2, Object var3) throws Exception;

    public abstract void store(EntityBean var1) throws Exception;
}

