/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.persistence;

import com.ibm.ejs.container.ContainerEJBException;
import com.ibm.ejs.container.EJSDeployedSupport;
import com.ibm.ejs.persistence.EnumeratorException;
import com.ibm.ejs.persistence.FinderHelper;
import com.ibm.ejs.persistence.NoMoreElementsException;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.cpi.Finder;
import com.ibm.websphere.cpi.PersisterHome;
import com.ibm.ws.ffdc.FFDCFilter;
import java.rmi.Remote;
import java.util.Vector;
import javax.ejb.EJBObject;
import javax.rmi.PortableRemoteObject;

class CMFinderHelper
implements FinderHelper {
    boolean cmp11cfWithRWAccessIntent = false;
    boolean cmp11ai = true;
    String cmp11methname = null;
    boolean lazyEnumerationScenario = false;
    boolean initialRequestCompleted = false;
    private PersisterHome home;
    private Finder source;
    private static final TraceComponent tc = Tr.register(CMFinderHelper.class, "EJBContainer", "com.ibm.ejs.container.container");
    private static final String CLASS_NAME = "com.ibm.ejs.persistence.CMFinderHelper";

    CMFinderHelper(PersisterHome home, Finder source) {
        try {
            this.source = source;
            this.home = home;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "CMFinderHelper created");
            }
        }
        catch (RuntimeException r) {
            FFDCFilter.processException((Throwable)r, (String)"com.ibm.ejs.persistence.CMFinderHelper.CMFinderHelper", (String)"76", (Object)this);
            this.destroy();
            Tr.error(tc, "CAUGHT_EXCEPTION_AND_RETHROWING_CNTR0039E", r);
            throw r;
        }
        catch (Throwable t) {
            FFDCFilter.processException((Throwable)t, (String)"com.ibm.ejs.persistence.CMFinderHelper.CMFinderHelper", (String)"86", (Object)this);
            this.destroy();
            ContainerEJBException cex = new ContainerEJBException("Caught unexpected Throwable: " + t.getMessage(), t);
            Tr.error(tc, "CAUGHT_EXCEPTION_THROWING_NEW_EXCEPTION_CNTR0035E", new Object[]{t, cex.toString()});
            throw cex;
        }
    }

    public EJBObject[] enumerateIntoArray(int count, boolean hydrate) throws EnumeratorException {
        Vector<EJBObject> elements = null;
        try {
            try {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.entry(tc, "enumerateIntoArray", new Integer(count));
                }
                elements = new Vector<EJBObject>();
                if (this.lazyEnumerationScenario && this.initialRequestCompleted) {
                    this.home.setCustomFinderAccessIntentThreadState(this.cmp11cfWithRWAccessIntent, this.cmp11ai, this.cmp11methname);
                }
                for (int i = 0; i < count && this.source.hasMore(); ++i) {
                    if (hydrate || this.home.hasInheritance()) {
                        elements.addElement((EJBObject)PortableRemoteObject.toStub((Remote)this.source.nextObject()));
                        continue;
                    }
                    elements.addElement((EJBObject)PortableRemoteObject.toStub((Remote)this.home.getBeanWrapper(this.source.nextKey())));
                }
                Object var7_8 = null;
                this.initialRequestCompleted = true;
                if (this.lazyEnumerationScenario && this.initialRequestCompleted) {
                    this.home.resetCustomFinderAccessIntentContext();
                }
            }
            catch (Throwable e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ejs.persistence.CMFinderHelper.enumerateIntoArray", (String)"146", (Object)this);
                this.destroy();
                EnumeratorException eex = new EnumeratorException("Unexpected exception: " + e.getMessage(), e);
                Tr.error(tc, "CAUGHT_EXCEPTION_THROWING_NEW_EXCEPTION_CNTR0035E", new Object[]{e, eex.toString()});
                throw eex;
            }
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            this.initialRequestCompleted = true;
            if (this.lazyEnumerationScenario && this.initialRequestCompleted) {
                this.home.resetCustomFinderAccessIntentContext();
            }
            throw throwable;
        }
        if (elements.size() == 0) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "enumerateIntoArray: no more elements");
            }
            throw new NoMoreElementsException();
        }
        try {
            Object[] result = new EJBObject[elements.size()];
            elements.copyInto(result);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "enumerateIntoArray: found", new Integer(result.length));
            }
            return result;
        }
        catch (Throwable t) {
            FFDCFilter.processException((Throwable)t, (String)"com.ibm.ejs.persistence.CMFinderHelper.enumerateIntoArray", (String)"179", (Object)this);
            this.destroy();
            EnumeratorException eex = new EnumeratorException("Unexpected exception: " + t.getMessage(), t);
            Tr.error(tc, "CAUGHT_EXCEPTION_THROWING_NEW_EXCEPTION_CNTR0035E", new Object[]{t, eex.toString()});
            throw eex;
        }
    }

    public EJBObject[] enumerateIntoArray(boolean hydrate) throws EnumeratorException {
        return this.enumerateIntoArray(Integer.MAX_VALUE, hydrate);
    }

    public boolean hasMoreElements() throws EnumeratorException {
        boolean hasMore = false;
        try {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.entry(tc, "hasMoreElements");
            }
            if (this.source != null && !(hasMore = this.source.hasMore())) {
                this.destroy();
            }
        }
        catch (Throwable e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ejs.persistence.CMFinderHelper.hasMoreElements", (String)"231", (Object)this);
            this.destroy();
            EnumeratorException enumEx = new EnumeratorException("Unexpected exception: " + e.getMessage(), e);
            Tr.error(tc, "CAUGHT_EXCEPTION_THROWING_NEW_EXCEPTION_CNTR0035E", new Object[]{e, enumEx.toString()});
            throw enumEx;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "hasMoreElements returning boolean " + hasMore);
        }
        return hasMore;
    }

    public void destroy() {
        if (this.source != null) {
            Finder temp = this.source;
            this.source = null;
            this.home = null;
            temp.close();
        }
    }

    public void cacheCustomFinderAccessIntentState() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "cacheCustomFinderAccessIntentState");
        }
        this.lazyEnumerationScenario = true;
        EJSDeployedSupport s = (EJSDeployedSupport)this.home.getCurrentThreadDeployedSupport();
        if (s != null && s.getEJBMethodInfo() != null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Acquring Deployed Support");
            }
            this.cmp11cfWithRWAccessIntent = s.getEJBMethodInfo().getIsCMP11CustomFinderWithForUpdateAI();
            this.cmp11ai = s.getEJBMethodInfo().getReadOnlyAttribute();
            this.cmp11methname = s.getEJBMethodInfo().getMethodName();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Deployed Support State Info[method:" + this.cmp11methname + " CMP11AI " + String.valueOf(this.cmp11ai) + " CFwUpdateAI " + String.valueOf(this.cmp11cfWithRWAccessIntent) + "]");
            }
        } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Deployed Support is null");
        }
    }
}

