/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.oa;

import com.ibm.CORBA.iiop.ThreadPool;
import com.ibm.ejs.EJSException;
import com.ibm.ejs.container.util.EJSPlatformHelper;
import com.ibm.ejs.oa.EJSORBImpl;
import com.ibm.ejs.oa.EJSRootOAImpl;
import com.ibm.ejs.oa.LocationService;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.util.ByteArray;
import com.ibm.websphere.management.AdminServiceFactory;
import java.util.Map;
import java.util.Properties;

class EJSServerORBImpl
extends EJSORBImpl {
    private static final int UUID_LENGTH = 16;
    private String serverName = null;
    private boolean isClone = false;
    private String modelName = null;
    private long cloneId = -1L;
    private static final TraceComponent tc = Tr.register(EJSServerORBImpl.class, "ObjectAdapter", "com.ibm.ws.runtime.runtime");
    private static final String REGISTER_WITH_LSD_PROPERTY_KEY = "com.ibm.websphere.management.registerServerIORWithLSD";

    EJSServerORBImpl(String modelName, String serverName, String bootstrapHost, int bootstrapPort, ThreadPool threadPool, Properties orbProps) throws EJSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "<init>", new Object[]{modelName, serverName, bootstrapHost, new Integer(bootstrapPort), orbProps});
        }
        if (modelName != null) {
            this.setModelName(modelName);
        }
        Properties orbProperties = new Properties(defaultProperties);
        if (orbProps != null) {
            orbProperties.putAll((Map<?, ?>)orbProps);
        }
        EJSRootOAImpl rootOA = new EJSRootOAImpl();
        orbProperties.put("com.ibm.CORBA.ObjectResolver", rootOA);
        this.serverName = serverName;
        orbProperties.put("com.ibm.CORBA.ServerName", serverName);
        ByteArray serverBytes = new ByteArray(serverName.getBytes());
        int serverId = serverBytes.hashCode();
        orbProperties.put("com.ibm.CORBA.ServerId", String.valueOf(serverId & Integer.MAX_VALUE));
        if (orbProperties.get("com.ibm.CORBA.ServerUUID") == null) {
            orbProperties.put("com.ibm.CORBA.ServerUUID", this.getUuid(serverBytes.hashCode64()));
        }
        this.initializeORB(null, bootstrapHost, bootstrapPort, orbProperties);
        rootOA.init(this.orb, null, serverName);
        rootOA.setModelName(modelName);
        LocationService ls = null;
        if (!EJSPlatformHelper.isZOS() && AdminServiceFactory.getAdminService().getProcessType().equals("ManagedProcess")) {
            boolean registerWithLSD = true;
            String listenerPortString = this.orb.getProperty("com.ibm.CORBA.ListenerPort");
            if (listenerPortString != null) {
                try {
                    int p = Integer.parseInt(listenerPortString);
                    if (p > 0) {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug(tc, "The ORB ListenerPort is set to a fixed port=" + p);
                        }
                        String regFlag = null;
                        regFlag = System.getProperty(REGISTER_WITH_LSD_PROPERTY_KEY);
                        if (regFlag == null) {
                            regFlag = orbProperties.getProperty(REGISTER_WITH_LSD_PROPERTY_KEY);
                        }
                        if (regFlag != null) {
                            if (regFlag.equalsIgnoreCase("false")) {
                                registerWithLSD = false;
                                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                    Tr.debug(tc, "com.ibm.websphere.management.registerServerIORWithLSD=" + regFlag + " - will not register with the LSD");
                                }
                            } else if (regFlag.equalsIgnoreCase("true")) {
                                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                    Tr.debug(tc, "com.ibm.websphere.management.registerServerIORWithLSD=" + regFlag + " - registering with the LSD");
                                }
                            } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                Tr.debug(tc, "'" + regFlag + "' is not valid for " + REGISTER_WITH_LSD_PROPERTY_KEY + " - ignored. " + "Choices are: 'true', 'false'.");
                            }
                        }
                    }
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
            }
            if (registerWithLSD) {
                LocationService.initClient();
                ls = LocationService.getLocationService();
                if (ls != null) {
                    ls.register(this.orb);
                } else {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        Tr.exit(tc, "initialize");
                    }
                    throw new EJSException("Could not obtain LocationService instance.");
                }
            }
        }
        this.orb.setThreadPool(threadPool);
        if (ls != null) {
            ls.setThreadPool(threadPool);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "<init>");
        }
    }

    void terminate() {
        if (!EJSPlatformHelper.isZOS() && LocationService.getLocationService() != null) {
            LocationService.getLocationService().unregister();
        }
        if (this.orb != null) {
            this.orb.shutdown(false);
        }
    }

    final String getServerName() {
        return this.serverName;
    }

    final void setModelName(String modelName) {
        this.modelName = modelName;
        this.isClone = true;
    }

    final String getModelName() {
        return this.modelName;
    }

    final long getCloneId() {
        return this.cloneId;
    }

    final boolean isServerAClone() {
        return this.isClone;
    }

    protected String getUuid(long id) {
        String uuid = Long.toHexString(id);
        if (uuid.length() < 16) {
            for (int i = 16 - uuid.length(); i > 0; --i) {
                uuid = uuid + "0";
            }
        }
        return uuid;
    }
}

