/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.models.base.serialization;

import com.ibm.ejs.models.base.serialization.BaseXMLResourceImpl;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.impl.EFactoryImpl;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.emf.ecore.xmi.impl.XMLHelperImpl;

public abstract class BaseXMLHelperImpl
extends XMLHelperImpl {
    protected static final Map loadValueMapByDataType = new HashMap();
    protected static final Map saveValueMapByDataType = new HashMap();

    protected static void addLoadEnumerationMapping(EEnum eEnum, Map mapping) {
        loadValueMapByDataType.put(eEnum, mapping);
    }

    protected static void addSaveEnumerationMapping(EEnum eEnum, Map mapping) {
        saveValueMapByDataType.put(eEnum, mapping);
    }

    public BaseXMLHelperImpl(XMLResource resource) {
        super(resource);
    }

    public void addPrefix(String prefix, String uri) {
        super.addPrefix(prefix, uri);
        BaseXMLResourceImpl baseXMLResource = this.getBaseXMLResource();
        if (uri.equals(baseXMLResource.getDefaultNamespaceURI())) {
            baseXMLResource.setDefaultNamespacePrefix(prefix);
        }
    }

    public String convertToString(EFactory factory, EDataType dataType, Object value) {
        String stringValue = super.convertToString(factory, dataType, value);
        if (stringValue != null && dataType instanceof EEnum) {
            String convertedValue = this.getLiteralValue((EEnum)dataType, stringValue, saveValueMapByDataType);
            return convertedValue;
        }
        return stringValue;
    }

    public EObject createObject(EFactory eFactory, EClassifier type) {
        String typeName = type.getName();
        boolean isDocumentRoot = "DocumentRoot".equals(typeName);
        if (isDocumentRoot) {
            return this.createDocumentRoot(type);
        }
        return super.createObject(eFactory, type);
    }

    public String getURI(String prefix) {
        BaseXMLResourceImpl baseXMLResource = this.getBaseXMLResource();
        String defaultNamespacePrefix = baseXMLResource.getDefaultNamespacePrefix();
        boolean isDefaultNamespace = defaultNamespacePrefix.equals(prefix);
        if (isDefaultNamespace) {
            EPackage targetPackage = this.getTargetPackage();
            return targetPackage.getNsURI();
        }
        return super.getURI(prefix);
    }

    protected EObject createDocumentRoot(EClassifier type) {
        EFactoryImpl factory = new EFactoryImpl(){

            public EPackage getEPackage() {
                return BaseXMLHelperImpl.this.getTargetPackage();
            }
        };
        EObject documentRoot = factory.create((EClass)type);
        return documentRoot;
    }

    protected Object createFromString(EFactory factory, EDataType dataType, String value) {
        if (dataType instanceof EEnum) {
            String stringValue = this.getLiteralValue((EEnum)dataType, value, loadValueMapByDataType);
            if (stringValue == null) {
                return stringValue;
            }
            Object convertedValue = super.createFromString(factory, dataType, stringValue);
            return convertedValue;
        }
        return super.createFromString(factory, dataType, value);
    }

    protected BaseXMLResourceImpl getBaseXMLResource() {
        return (BaseXMLResourceImpl)this.getResource();
    }

    protected String getLiteralValue(EEnum eEnum, String value, Map enumMap) {
        String convertedValue;
        Map map = (Map)enumMap.get(eEnum);
        if (map != null && (convertedValue = (String)map.get(value)) != null) {
            return convertedValue;
        }
        return value;
    }

    protected abstract EPackage getTargetPackage();

    public void setValue(EObject object, EStructuralFeature feature, Object value, int position) {
        if (feature == null) {
            return;
        }
        if (!feature.isTransient()) {
            if (value == null && feature.getEType().getInstanceClass() != null && feature.getEType().getInstanceClass().isPrimitive()) {
                return;
            }
            super.setValue(object, feature, value, position);
        }
    }
}

