/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.models.base.extensions.helper;

import com.ibm.ejs.models.base.bindings.commonbnd.AbstractTraversalHelper;
import com.ibm.ejs.models.base.extensions.applicationext.ApplicationExtensionsHelper;
import com.ibm.ejs.models.base.extensions.helper.XMLRootHandler;
import com.ibm.ejs.models.base.extensions.init.ExtensionsInit;
import com.ibm.etools.commonarchive.EARFile;
import com.ibm.etools.commonarchive.ModuleFile;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.NamespaceContext;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jst.j2ee.commonarchivecore.internal.File;
import org.eclipse.jst.j2ee.internal.common.XMLResource;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public abstract class CommonExtensionsHelper
extends AbstractTraversalHelper {
    protected abstract String getDefaultExtensionsXMLUri();

    protected abstract String getDefaultExtensionsUri();

    protected EObject getExtension(EObject deploymentDescriptor) {
        return this.getBindingOrExtension(deploymentDescriptor);
    }

    protected String getExtraURI(Resource resource) {
        XMLResource xmlResource = (XMLResource)resource;
        if (xmlResource.isAlt()) {
            return ApplicationExtensionsHelper.getExtensionsUriFromAltDD(xmlResource);
        }
        return this.getDefaultExtensionsUri();
    }

    protected String getExtraXMLURI(Resource resource) {
        return this.getDefaultExtensionsXMLUri();
    }

    protected void init() {
        ExtensionsInit.init();
    }

    protected boolean isMetadataComplete(ModuleFile file, String xmlUri, String rootName) {
        boolean result = true;
        try {
            XMLRootHandler handler = new XMLRootHandler();
            InputStream stream = this.getInputStream(file, xmlUri);
            handler.parseContents(new InputSource(stream));
            if (rootName.equals(handler.getRootElementName())) {
                String value = handler.getRootElementAttributes().getValue("metadata-complete");
                result = value == null ? true : Boolean.valueOf(value);
            } else {
                Logger logger = Logger.getLogger("com.ibm.ejs.models.base.extensions.commonext", "com.ibm.ejs.models.base.extensions.commonext.serialization.messages");
                logger.logp(Level.SEVERE, this.getClass().getName(), "isMetadataComplete", "Commonext.1", new Object[]{handler.getRootElementName(), rootName, file.getName(), rootName});
            }
        }
        catch (FileNotFoundException ignored) {
        }
        catch (Exception e) {
            e.printStackTrace();
            Logger logger = Logger.getLogger("com.ibm.ejs.models.base.extensions.commonext", "com.ibm.ejs.models.base.extensions.commonext.serialization.messages");
            logger.logp(Level.SEVERE, this.getClass().getName(), "isMetadataComplete", "Commonext.2", new Object[]{e.toString(), file.getName(), xmlUri});
        }
        return result;
    }

    protected InputStream getInputStream(ModuleFile file, String uri) throws IOException, ParserConfigurationException, SAXException, XPathExpressionException {
        EARFile ear = (EARFile)file.getEARFile();
        if (ear == null) {
            return file.getResourceInputStream(uri);
        }
        File earExtensions = ear.getFile("META-INF/ibm-application-ext.xml");
        if (earExtensions == null) {
            return file.getResourceInputStream(uri);
        }
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        factory.setValidating(false);
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document doc = builder.parse(earExtensions.getInputStream());
        String expression = "//pre:module-extension[@name=\"" + file.getName() + "\"]/pre:alt-extensions";
        XPath xpath = XPathFactory.newInstance().newXPath();
        xpath.setNamespaceContext(new NamespaceContext(){

            public Iterator getPrefixes(String namespaceURI) {
                throw new UnsupportedOperationException();
            }

            public String getPrefix(String namespaceURI) {
                throw new UnsupportedOperationException();
            }

            public String getNamespaceURI(String prefix) {
                if (prefix == null) {
                    throw new NullPointerException();
                }
                if ("pre".equals(prefix)) {
                    return "http://websphere.ibm.com/xml/ns/javaee";
                }
                return "";
            }
        });
        NodeList result = (NodeList)xpath.evaluate(expression, doc.getDocumentElement(), XPathConstants.NODESET);
        int len = result.getLength();
        for (int i = 0; i < len; ++i) {
            String altUri;
            Node item = result.item(i);
            Node node = item.getAttributes().getNamedItem("uri");
            if (node == null || (altUri = node.getNodeValue()) == null) continue;
            return ear.getInputStream(altUri);
        }
        return file.getResourceInputStream(uri);
    }
}

