/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.models.base.bindings.applicationbnd.serialization;

import com.ibm.ejs.models.base.bindings.applicationbnd.ApplicationBinding;
import com.ibm.ejs.models.base.bindings.applicationbnd.ApplicationbndPackage;
import com.ibm.ejs.models.base.bindings.applicationbnd.AuthorizationTable;
import com.ibm.ejs.models.base.bindings.applicationbnd.RoleAssignment;
import com.ibm.ejs.models.base.bindings.applicationbnd.RunAsBinding;
import com.ibm.ejs.models.base.bindings.applicationbnd.RunAsMap;
import com.ibm.ejs.models.base.bindings.applicationbnd.impl.UserImpl;
import com.ibm.ejs.models.base.bindings.applicationbnd.serialization.Messages;
import com.ibm.ejs.models.base.bindings.commonbnd.BasicAuthData;
import com.ibm.ejs.models.base.serialization.BaseXMLResourceImpl;
import com.ibm.ejs.models.base.serialization.BaseXMLSaveImpl;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.xmi.XMLHelper;
import org.eclipse.jst.j2ee.common.SecurityRole;
import org.eclipse.wst.common.internal.emf.utilities.EncoderDecoderRegistry;

public class ApplicationbndXMLSaveImpl
extends BaseXMLSaveImpl {
    protected static final ApplicationbndPackage pkg = ApplicationbndPackage.eINSTANCE;
    private static final Logger logger = Logger.getLogger("com.ibm.ejs.models.base.bindings.applicationbnd.serialization", "com.ibm.ejs.models.base.bindings.applicationbnd.serialization.messages");
    protected static final Map specialSubjectEClassToLiteralMap = new HashMap();

    public ApplicationbndXMLSaveImpl(XMLHelper helper) {
        super(helper);
    }

    protected void createRunAs(SecurityRole securityRole) {
        BasicAuthData authData;
        ApplicationBinding applicationBinding;
        RunAsMap runAsMap;
        if (securityRole != null && (runAsMap = (applicationBinding = this.getApplicationBinding()).getRunAsMap()) != null && (authData = (BasicAuthData)runAsMap.getAuthData(securityRole)) != null) {
            String password;
            this.doc.startElement(this.getElementName("run-as"));
            String userId = authData.getUserId();
            if (userId != null) {
                this.doc.addAttribute("userid", userId);
            }
            if ((password = authData.getPassword()) != null) {
                this.doc.addAttribute("password", this.encodeString(password));
            }
            this.doc.endElement();
        }
    }

    protected void createSubjectType(UserImpl user) {
        String name;
        if (user != null && (name = user.getName()) != null) {
            this.doc.startElement(this.getElementName("user"));
            this.doc.addAttribute("name", name);
            String accessId = user.getAccessId();
            if (accessId != null) {
                this.doc.addAttribute("access-id", accessId);
            }
            this.doc.endElement();
        }
    }

    protected void endSaveFeatures(EObject o, int elementType, String content) {
        if (o instanceof RoleAssignment) {
            RoleAssignment roleAssignment = (RoleAssignment)o;
            SecurityRole securityRole = roleAssignment.getRole();
            this.createRunAs(securityRole);
            super.endSaveFeatures(o, 0, content);
        } else {
            super.endSaveFeatures(o, elementType, content);
        }
    }

    protected ApplicationBinding getApplicationBinding() {
        BaseXMLResourceImpl resource = (BaseXMLResourceImpl)this.xmlResource;
        ApplicationBinding applicationBinding = (ApplicationBinding)resource.getRootObject();
        return applicationBinding;
    }

    protected List getRunAsRoles(ApplicationBinding applicationBinding) {
        ArrayList<SecurityRole> roles = new ArrayList<SecurityRole>();
        RunAsMap runAsMap = applicationBinding.getRunAsMap();
        if (runAsMap != null) {
            EList runAsBindings = runAsMap.getRunAsBindings();
            for (RunAsBinding runAsBinding : runAsBindings) {
                SecurityRole securityRole = runAsBinding.getSecurityRole();
                if (securityRole == null) continue;
                roles.add(securityRole);
            }
            AuthorizationTable authorizationTable = applicationBinding.getAuthorizationTable();
            EList authorizations = authorizationTable.getAuthorizations();
            for (RoleAssignment roleAssignment : authorizations) {
                SecurityRole securityRole = roleAssignment.getRole();
                if (securityRole == null) continue;
                roles.remove(securityRole);
            }
        }
        return roles;
    }

    protected String getSpecialSubjectType(EClass specialSubjectEClass) {
        return (String)specialSubjectEClassToLiteralMap.get(specialSubjectEClass);
    }

    protected void saveDataTypeMany(EObject o, EStructuralFeature f) {
        if (pkg.getProfileBinding_ClientProfileNames() == f) {
            List values = (List)this.helper.getValue(o, f);
            int size = values.size();
            if (size > 0) {
                EDataType d = (EDataType)f.getEType();
                EPackage ePackage = d.getEPackage();
                EFactory fac = ePackage.getEFactoryInstance();
                String name = this.helper.getQName(f);
                for (int i = 0; i < size; ++i) {
                    Object value = values.get(i);
                    if (value == null) continue;
                    String svalue = this.helper.convertToString(fac, d, value);
                    if (this.escape != null) {
                        svalue = this.escape.convert(svalue);
                    }
                    this.doc.startElement(name);
                    this.doc.addAttribute("name", svalue);
                    this.doc.endElement();
                }
            }
        } else {
            super.saveDataTypeMany(o, f);
        }
    }

    protected void saveElement(EObject o, EStructuralFeature f) {
        if (pkg.getApplicationBinding_AuthorizationTable() == f) {
            this.saveContainedMany(o, pkg.getAuthorizationTable_Authorizations());
            ApplicationBinding applicationBinding = this.getApplicationBinding();
            List roles = this.getRunAsRoles(applicationBinding);
            for (SecurityRole securityRole : roles) {
                String roleName = securityRole.getRoleName();
                this.doc.startElement(this.getElementName("security-role"));
                this.doc.addAttribute("name", roleName);
                this.createRunAs(securityRole);
                this.doc.endElement();
                this.doc.addLine();
            }
        } else if (pkg.getApplicationBinding_ProfileMap() == f) {
            this.saveContainedMany(o, pkg.getProfileMap_ProfileBinding());
        } else {
            if (pkg.getApplicationBinding_RunAsMap() == f) {
                return;
            }
            if (pkg.getRoleAssignment_Users() == f) {
                this.createSubjectType((UserImpl)o);
            } else {
                super.saveElement(o, f);
            }
        }
    }

    protected void saveEObjectSingle(EObject o, EStructuralFeature f) {
        if (pkg.getRoleAssignment_Role() == f) {
            SecurityRole securityRole;
            String roleName;
            EObject value = (EObject)this.helper.getValue(o, f);
            if (value != null && (roleName = (securityRole = (SecurityRole)value).getRoleName()) != null) {
                this.doc.addAttribute("name", roleName);
            }
        } else {
            super.saveEObjectSingle(o, f);
        }
    }

    protected boolean saveFeatures(EObject o) {
        EClass eClass = o.eClass();
        if (pkg.getSpecialSubject().isSuperTypeOf(eClass)) {
            String typeValue = this.getSpecialSubjectType(eClass);
            if (typeValue == null) {
                logger.logp(Level.SEVERE, this.getClass().getName(), "saveFeatures", "Applicationbnd.4", new Object[]{eClass.getName()});
                throw new IllegalArgumentException(Messages.getString("Applicationbnd.4.1"));
            }
            this.doc.addAttribute("type", typeValue);
            this.endSaveFeatures(o, 0, null);
            return true;
        }
        return super.saveFeatures(o);
    }

    protected void saveHRefSingle(EObject o, EStructuralFeature f) {
        if (pkg.getApplicationBinding_Application() == f) {
            return;
        }
        super.saveHRefSingle(o, f);
    }

    protected void saveTypeAttribute(EClass eClass) {
    }

    protected String encodeString(String aString) {
        return EncoderDecoderRegistry.getDefaultRegistry().getDefaultEncoderDecoder().encode(aString);
    }

    static {
        specialSubjectEClassToLiteralMap.put(pkg.getEveryone(), "EVERYONE");
        specialSubjectEClassToLiteralMap.put(pkg.getAllAuthenticatedUsers(), "ALL_AUTHENTICATED_USERS");
        specialSubjectEClassToLiteralMap.put(pkg.getAllAuthenticatedInTrustedRealms(), "ALL_AUTHENTICATED_IN_TRUSTED_REALMS");
        specialSubjectEClassToLiteralMap.put(pkg.getServer(), "SERVER");
    }
}

