/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.models.base.bindings.applicationbnd.impl;

import com.ibm.ejs.models.base.bindings.applicationbnd.ApplicationbndPackage;
import com.ibm.ejs.models.base.bindings.applicationbnd.AuthorizationTable;
import com.ibm.ejs.models.base.bindings.applicationbnd.RoleAssignment;
import com.ibm.ejs.models.base.bindings.applicationbnd.Subject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.EObjectImpl;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.jst.j2ee.common.SecurityRole;

public class AuthorizationTableImpl
extends EObjectImpl
implements AuthorizationTable {
    private HashMap roleToSubjects;
    private HashMap subjectToRoles;
    private boolean tablesInitialized;
    protected EList authorizations = null;

    protected EClass eStaticClass() {
        return ApplicationbndPackage.Literals.AUTHORIZATION_TABLE;
    }

    public List getRolesForSubject(Subject subject) {
        this.initializeTheTables();
        return (List)this.subjectToRoles.get(subject);
    }

    public List getSubjectsForRole(SecurityRole role) {
        this.initializeTheTables();
        return (List)this.roleToSubjects.get(role);
    }

    public void initialize(List securityRoles) {
        for (SecurityRole role : securityRoles) {
            RoleAssignment roleAsn = ((ApplicationbndPackage)EPackage.Registry.INSTANCE.getEPackage("applicationbnd.xmi")).getApplicationbndFactory().createRoleAssignment();
            roleAsn.setRole(role);
            this.getAuthorizations().add(roleAsn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initializeTheTables() {
        if (!this.tablesInitialized) {
            AuthorizationTableImpl authorizationTableImpl = this;
            synchronized (authorizationTableImpl) {
                if (this.tablesInitialized) {
                    return;
                }
                this.roleToSubjects = new HashMap();
                this.subjectToRoles = new HashMap();
                EList auths = this.getAuthorizations();
                int authLen = auths.size();
                for (int i = 0; i < authLen; ++i) {
                    ArrayList<Subject> subjectsList = new ArrayList<Subject>();
                    RoleAssignment ras = (RoleAssignment)auths.get(i);
                    SecurityRole role = ras.getRole();
                    EList users = ras.getUsers();
                    int userLen = users.size();
                    for (int u = 0; u < userLen; ++u) {
                        Subject sub = (Subject)users.get(u);
                        subjectsList.add(sub);
                        ArrayList<SecurityRole> roleList = (ArrayList<SecurityRole>)this.subjectToRoles.get(sub);
                        if (roleList == null) {
                            roleList = new ArrayList<SecurityRole>();
                        }
                        roleList.add(role);
                        this.subjectToRoles.put(sub, roleList);
                    }
                    EList groups = ras.getGroups();
                    int groupLen = groups.size();
                    for (int g = 0; g < groupLen; ++g) {
                        Subject sub = (Subject)groups.get(g);
                        subjectsList.add(sub);
                        ArrayList<SecurityRole> roleList = (ArrayList<SecurityRole>)this.subjectToRoles.get(sub);
                        if (roleList == null) {
                            roleList = new ArrayList<SecurityRole>();
                        }
                        roleList.add(role);
                        this.subjectToRoles.put(sub, roleList);
                    }
                    EList splSubs = ras.getSpecialSubjects();
                    int splLen = splSubs.size();
                    for (int s = 0; s < splLen; ++s) {
                        Subject sub = (Subject)splSubs.get(s);
                        subjectsList.add(sub);
                        ArrayList<SecurityRole> roleList = (ArrayList<SecurityRole>)this.subjectToRoles.get(sub);
                        if (roleList == null) {
                            roleList = new ArrayList<SecurityRole>();
                        }
                        roleList.add(role);
                        this.subjectToRoles.put(sub, roleList);
                    }
                    this.roleToSubjects.put(role, subjectsList);
                }
                this.tablesInitialized = true;
            }
        }
    }

    public EList getAuthorizations() {
        if (this.authorizations == null) {
            this.authorizations = new EObjectContainmentEList(RoleAssignment.class, this, 0);
        }
        return this.authorizations;
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 0: {
                return ((InternalEList)this.getAuthorizations()).basicRemove(otherEnd, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 0: {
                return this.getAuthorizations();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 0: {
                this.getAuthorizations().clear();
                this.getAuthorizations().addAll((Collection)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 0: {
                this.getAuthorizations().clear();
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 0: {
                return this.authorizations != null && !this.authorizations.isEmpty();
            }
        }
        return super.eIsSet(featureID);
    }

    public String toString() {
        StringBuffer result = new StringBuffer("\n  Authorization Table [ ");
        result.append(this.getClass().getName() + '@' + Integer.toHexString(this.hashCode())).append(" ]\n");
        EList auths = this.getAuthorizations();
        result.append("  Authorization Table contains [ ").append(auths.size()).append(" ] role assignments\n");
        for (RoleAssignment ras : auths) {
            result.append(ras);
        }
        return result.toString();
    }
}

