/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.jms.listener;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminService;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.ws.management.util.SecurityHelper;
import com.ibm.ws.security.core.SecurityContext;
import com.ibm.ws390.utility.JAVAtoCPPUtilities;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Iterator;
import java.util.Set;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.security.auth.Subject;

class ListenerPortStopHelperAdmin {
    private static final TraceComponent tc = Tr.register(ListenerPortStopHelperAdmin.class, "MDB", "com.ibm.ejs.resources.ws390Messages");

    ListenerPortStopHelperAdmin() {
    }

    public static void internalStopListenerPort(String lpName) {
        block8: {
            boolean stillRunning;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "In internalStopListenerPort() for LP", lpName);
            }
            if (!(stillRunning = ListenerPortStopHelperAdmin.internalListenerPortIsStarted(lpName).booleanValue())) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Nothing to do since LP is already stopped", lpName);
                }
                return;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "LP is started, proceeding with stop", lpName);
            }
            ListenerPortStopHelperAdmin.issueStoppingMessage(lpName);
            final String theLPName = lpName;
            try {
                PrivilegedExceptionAction action = new PrivilegedExceptionAction(){

                    public Object run() throws Exception {
                        ListenerPortStopHelperAdmin.internalStopListenerPortBeef(theLPName);
                        return null;
                    }
                };
                try {
                    SecurityContext.runAsSystem((PrivilegedExceptionAction)action);
                }
                catch (PrivilegedActionException pae) {
                    Exception e = pae.getException();
                    StringWriter sw = new StringWriter();
                    PrintWriter pw = new PrintWriter(sw);
                    e.printStackTrace(pw);
                    Tr.error(tc, "BBOJ0097", new Object[]{"Exception stack trace: " + sw, "ListenerPortStopHelperAdmin", "internalStopListenerPort(String)"});
                    throw e;
                }
            }
            catch (Throwable t) {
                if (!tc.isDebugEnabled()) break block8;
                Tr.debug(tc, "stopListening: Could not stop listeners.", t);
            }
        }
    }

    private static void internalStopListenerPortBeef(String lpName) throws MalformedObjectNameException, InstanceNotFoundException, MBeanException, ReflectionException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "Start of internalStopListenerPortBeef() for LP", lpName);
        }
        AdminService adminService = AdminServiceFactory.getAdminService();
        ObjectName myLP = ListenerPortStopHelperAdmin.getLPObjectName(adminService, lpName);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "in internalStopListenerPortBeef(): issuing adminService stop()", lpName);
        }
        adminService.invoke(myLP, "stop", null, null);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "in internalStopListenerPortBeef(); ListenerPort stopped", myLP);
        }
    }

    public static void internalStopListenerPortAsynch(String lpName) {
        final String theLPName = lpName;
        Thread workerThread = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public void run() {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "On new thread, in internalStopListenerPortAsynch()", theLPName);
                }
                Subject savedSubject = null;
                Subject serverSubject = null;
                try {
                    serverSubject = SecurityHelper.getServerSubject();
                    if (serverSubject != null) {
                        savedSubject = SecurityHelper.pushInvocationSubject(serverSubject);
                    }
                    ListenerPortStopHelperAdmin.internalStopListenerPort(theLPName);
                    if (serverSubject == null) return;
                }
                catch (Throwable t) {
                    try {
                        StringWriter sw = new StringWriter();
                        PrintWriter pw = new PrintWriter(sw);
                        t.printStackTrace(pw);
                        String errString = "Unable to stop LP " + theLPName + " because of: " + sw;
                        Tr.error(tc, "BBOJ0097", new Object[]{errString, "ListenerPortStopHelperAdmin", "internalStopListenerPortAsynch(String)"});
                        if (serverSubject == null) return;
                    }
                    catch (Throwable throwable) {
                        if (serverSubject == null) throw throwable;
                        SecurityHelper.popInvocationSubject(savedSubject);
                        throw throwable;
                    }
                    SecurityHelper.popInvocationSubject(savedSubject);
                    return;
                }
                SecurityHelper.popInvocationSubject(savedSubject);
                return;
            }
        };
        workerThread.setDaemon(true);
        workerThread.start();
    }

    private static void issueStoppingMessage(String lpName) {
        String destJndiName = ListenerPortStopHelperAdmin.internalListenerPortGetJmsDestJNDIName(lpName);
        StringBuffer buf = new StringBuffer();
        buf.append(JAVAtoCPPUtilities.getenv((String)"cell_short_name"));
        buf.append("/" + JAVAtoCPPUtilities.getenv((String)"node_short_name"));
        buf.append("/" + JAVAtoCPPUtilities.getenv((String)"server_generic_short_name"));
        buf.append("/" + JAVAtoCPPUtilities.getenv((String)"server_specific_short_name"));
        Tr.audit(tc, "BBOJ0099", new Object[]{lpName, destJndiName, buf});
    }

    private static String internalListenerPortGetJmsDestJNDIName(String lpName) {
        String retVal;
        block5: {
            retVal = null;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "In internalListenerPortGetJmsDestJNDIName() for LP", lpName);
            }
            final String theLPName = lpName;
            try {
                PrivilegedExceptionAction action = new PrivilegedExceptionAction(){

                    public Object run() throws Exception {
                        String runRetVal = ListenerPortStopHelperAdmin.internalListenerPortGetJmsDestJNDINameBeef(theLPName);
                        return runRetVal;
                    }
                };
                try {
                    retVal = (String)SecurityContext.runAsSystem((PrivilegedExceptionAction)action);
                }
                catch (PrivilegedActionException pae) {
                    Exception e = pae.getException();
                    StringWriter sw = new StringWriter();
                    PrintWriter pw = new PrintWriter(sw);
                    e.printStackTrace(pw);
                    Tr.error(tc, "BBOJ0097", new Object[]{"Exception stack trace: " + sw, "ListenerPortStopHelperAdmin", "internalListenerPortGetJmsDestJNDIName(String)"});
                    throw e;
                }
            }
            catch (Throwable t) {
                if (!tc.isDebugEnabled()) break block5;
                Tr.debug(tc, "Could not complete ListenerPort getJmsDestJNDIName call", t);
            }
        }
        return retVal;
    }

    private static String internalListenerPortGetJmsDestJNDINameBeef(String lpName) throws MalformedObjectNameException, InstanceNotFoundException, MBeanException, ReflectionException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "Start of internalListenerPortGetJmsDestJNDINameBeef() for LP", lpName);
        }
        AdminService adminService = AdminServiceFactory.getAdminService();
        ObjectName myLP = ListenerPortStopHelperAdmin.getLPObjectName(adminService, lpName);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "in internalListenerPortGetJmsDestJNDINameBeef(): issuing adminService getJmsDestJNDIName()", lpName);
        }
        String retVal = (String)adminService.invoke(myLP, "getJmsDestJNDIName", null, null);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "in internalListenerPortGetJmsDestJNDINameBeef()", lpName);
        }
        return retVal;
    }

    private static Boolean internalListenerPortIsStarted(String lpName) {
        Boolean retVal = null;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "In internalListenerPortIsStarted() for LP", lpName);
        }
        final String theLPName = lpName;
        try {
            PrivilegedExceptionAction action = new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    Boolean runRetVal = ListenerPortStopHelperAdmin.internalListenerPortIsStartedBeef(theLPName);
                    return runRetVal;
                }
            };
            try {
                retVal = (Boolean)SecurityContext.runAsSystem((PrivilegedExceptionAction)action);
            }
            catch (PrivilegedActionException pae) {
                Exception e = pae.getException();
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                e.printStackTrace(pw);
                Tr.error(tc, "BBOJ0097", new Object[]{"Exception stack trace: " + sw, "ListenerPortStopHelperAdmin", "internalListenerPortIsStarted(String)"});
                throw e;
            }
        }
        catch (Throwable t) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Could not complete ListenerPort isStarted call", t);
            }
            retVal = Boolean.FALSE;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "In internalListenerPortIsStarted() for: (LP, retVal) ", new Object[]{lpName, retVal});
        }
        return retVal;
    }

    private static Boolean internalListenerPortIsStartedBeef(String lpName) throws MalformedObjectNameException, InstanceNotFoundException, MBeanException, ReflectionException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "Start of internalListenerPortIsStartedBeef() for LP", lpName);
        }
        AdminService adminService = AdminServiceFactory.getAdminService();
        ObjectName myLP = ListenerPortStopHelperAdmin.getLPObjectName(adminService, lpName);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "in internalListenerPortIsStartedBeef(): issuing adminService isStarted()", lpName);
        }
        Boolean retVal = (Boolean)adminService.invoke(myLP, "isStarted", null, null);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "in internalListenerPortIsStartedBeef()", lpName);
        }
        return retVal;
    }

    private static ObjectName getLPObjectName(AdminService adminService, String lpName) throws MalformedObjectNameException, InstanceNotFoundException, MBeanException, ReflectionException {
        String nodeName = adminService.getNodeName();
        String serverName = adminService.getProcessName();
        ObjectName query = null;
        StringBuffer query_name = new StringBuffer("WebSphere:type=ListenerPort,node=");
        query_name.append(nodeName);
        query_name.append(",process=");
        query_name.append(serverName);
        query_name.append(",name=");
        query_name.append(lpName);
        query_name.append(",*");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "query_name", query_name.toString());
        }
        query = new ObjectName(query_name.toString());
        Set myListenerPorts = null;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "issuing adminService.queryNames() for LP", lpName);
        }
        if ((myListenerPorts = adminService.queryNames(query, null)) == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "queryNames returned null LP list for LP", lpName);
            }
            throw new IllegalStateException("In getLPObjectName(), queryNames returned null LP list for LP: " + lpName);
        }
        if (myListenerPorts.size() != 1) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "queryNames did not return a single LP  - (LP, list size) ", new Object[]{lpName, new Integer(myListenerPorts.size())});
            }
            throw new IllegalStateException("In getLPObjectName(): LP list size = " + myListenerPorts.size() + "for LP: " + lpName);
        }
        Iterator objectIter = myListenerPorts.iterator();
        ObjectName myLP = (ObjectName)objectIter.next();
        return myLP;
    }
}

