/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.csi;

import com.ibm.ejs.container.BeanId;
import com.ibm.ejs.container.BeanMetaData;
import com.ibm.ejs.csi.BeanManaged;
import com.ibm.ejs.csi.Mandatory;
import com.ibm.ejs.csi.Never;
import com.ibm.ejs.csi.NotSupported;
import com.ibm.ejs.csi.Required;
import com.ibm.ejs.csi.RequiresNew;
import com.ibm.ejs.csi.Supports;
import com.ibm.ejs.csi.TranStrategy;
import com.ibm.ejs.csi.TxCookieImpl;
import com.ibm.ejs.csi.UOWHandleImpl;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.util.FastHashtable;
import com.ibm.ejs.util.tran.SyncDriver;
import com.ibm.ejs.util.tran.SyncDriverCreationFailure;
import com.ibm.ejs.util.tran.SyncDriverFactory;
import com.ibm.websphere.csi.CSIActivitySessionResetException;
import com.ibm.websphere.csi.CSIException;
import com.ibm.websphere.csi.CSITransactionRolledbackException;
import com.ibm.websphere.csi.EJBComponentMetaData;
import com.ibm.websphere.csi.EJBKey;
import com.ibm.websphere.csi.EJBMethodInfo;
import com.ibm.websphere.csi.ExceptionType;
import com.ibm.websphere.csi.TransactionAttribute;
import com.ibm.websphere.csi.TxContextChange;
import com.ibm.websphere.csi.UOWControl;
import com.ibm.websphere.csi.UOWCookie;
import com.ibm.websphere.csi.UOWHandle;
import com.ibm.ws.LocalTransaction.LocalTransactionCoordinator;
import com.ibm.ws.LocalTransaction.LocalTransactionCurrent;
import com.ibm.ws.LocalTransaction.RolledbackException;
import com.ibm.ws.Transaction.TransactionManagerFactory;
import com.ibm.ws.Transaction.UOWCoordinator;
import com.ibm.ws.Transaction.UOWCurrent;
import com.ibm.ws.Transaction.UtxFactory;
import com.ibm.ws.Transaction.WebSphereTransactionManager;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.traceinfo.ejbcontainer.TETxLifeCycleInfo;
import javax.transaction.InvalidTransactionException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionRolledbackException;
import javax.transaction.UserTransaction;

public class TransactionControlImpl
implements UOWControl {
    private static final TraceComponent tc = Tr.register(TransactionControlImpl.class, "EJBContainer", "com.ibm.ejs.container.container");
    private static final String CLASS_NAME = "com.ibm.ejs.csi.TransactionControlImpl";
    protected WebSphereTransactionManager txService;
    protected UOWCurrent uowCurrent;
    protected LocalTransactionCurrent ltcCurrent;
    private TranStrategy[] txStrategies;
    private UserTransaction userTransactionImpl;
    protected SyncDriverFactory sdFactory;
    FastHashtable stickyLocalTxTable = new FastHashtable(251);
    static final int TIMEOUT_CLOCK_START = 0;
    static final int TIMEOUT_CLOCK_STOP = 2;

    public TransactionControlImpl() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "<init>");
        }
        this.txService = TransactionManagerFactory.getTransactionManager();
        this.sdFactory = new SyncDriverFactory();
        this.ltcCurrent = TransactionManagerFactory.getLocalTransactionCurrent();
        this.uowCurrent = TransactionManagerFactory.getUOWCurrent();
        this.userTransactionImpl = UtxFactory.createUserTransaction();
        this.txStrategies = new TranStrategy[TransactionAttribute.getNumAttrs()];
        this.txStrategies[TransactionAttribute.TX_NOT_SUPPORTED.getValue()] = new NotSupported(this);
        this.txStrategies[TransactionAttribute.TX_BEAN_MANAGED.getValue()] = new BeanManaged(this);
        this.txStrategies[TransactionAttribute.TX_REQUIRED.getValue()] = new Required(this);
        this.txStrategies[TransactionAttribute.TX_SUPPORTS.getValue()] = new Supports(this);
        this.txStrategies[TransactionAttribute.TX_REQUIRES_NEW.getValue()] = new RequiresNew(this);
        this.txStrategies[TransactionAttribute.TX_MANDATORY.getValue()] = new Mandatory(this);
        this.txStrategies[TransactionAttribute.TX_NEVER.getValue()] = new Never(this);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "<init>");
        }
    }

    public UOWCookie preInvoke(EJBKey key, EJBMethodInfo methodInfo) throws CSIException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "preInvoke");
        }
        this.completeTxTimeout();
        TranStrategy ts = this.txStrategies[methodInfo.getTransactionAttribute().getValue()];
        TxCookieImpl txCookie = null;
        try {
            txCookie = ts.preInvoke(key, methodInfo);
        }
        catch (Throwable th) {
            FFDCFilter.processException((Throwable)th, (String)"com.ibm.ejs.csi.TransactionControlImpl.preInvoke", (String)"266", (Object)this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event(tc, "Tran Strategy preInvoke failed", th);
            }
            if (th instanceof CSIException) {
                throw (CSIException)th;
            }
            throw new CSIException("Tran Strategy preInvoke failed", th);
        }
        txCookie.methodInfo = methodInfo;
        try {
            txCookie.ivCoordinator = this.getCurrentTransactionalUOW(false);
        }
        catch (Throwable throwable) {
            block19: {
                FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ejs.csi.TransactionControlImpl.preInvoke", (String)"266", (Object)this);
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    Tr.event(tc, "getCurrentTransactionalUOW failed", throwable);
                }
                boolean ivFailPreinvoke = false;
                if (throwable instanceof CSITransactionRolledbackException && methodInfo.getTransactionAttribute() == TransactionAttribute.TX_BEAN_MANAGED) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                        Tr.event(tc, "BMT - allowing method to proceed");
                    }
                    try {
                        txCookie.ivCoordinator = this.getCurrentTransactionalUOW(false);
                    }
                    catch (Throwable throwable1) {
                        FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ejs.csi.TransactionControlImpl.preInvoke", (String)"386", (Object)this);
                        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                            Tr.event(tc, "BMT - failed trying to get Tran BMT bean in invalid state");
                        }
                        ivFailPreinvoke = true;
                    }
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        Tr.exit(tc, "preInvoke (RolledBack) using old stuff : " + txCookie);
                    }
                    if (!ivFailPreinvoke) {
                        return txCookie;
                    }
                }
                try {
                    this.postInvoke(key, txCookie, ExceptionType.UNCHECKED_EXCEPTION, methodInfo);
                }
                catch (Throwable th) {
                    FFDCFilter.processException((Throwable)th, (String)"com.ibm.ejs.csi.TransactionControlImpl.preInvoke", (String)"266", (Object)this);
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isEventEnabled()) break block19;
                    Tr.event(tc, "postInvoke failed : original exception re-thrown", th);
                }
            }
            if (throwable instanceof CSIException) {
                throw (CSIException)throwable;
            }
            throw new CSIException("getCurrentTransactionalUOW failed", throwable);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "preInvoke : " + txCookie);
        }
        return txCookie;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postInvoke(EJBKey key, UOWCookie uowCookie, ExceptionType exType, EJBMethodInfo methodInfo) throws CSIException {
        TxCookieImpl txCookieImpl;
        block30: {
            LocalTransactionCoordinator suspendedLocalTx2;
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.entry(tc, "postInvoke");
            }
            if ((txCookieImpl = (TxCookieImpl)uowCookie) == null) {
                block29: {
                    LocalTransactionCoordinator lCoord = this.getLocalCoord();
                    if (lCoord != null) {
                        block28: {
                            try {
                                int resolver = ((EJBComponentMetaData)methodInfo.getComponentMetaData()).getLocalTranConfigData().getValueResolver();
                                if (resolver == 1) {
                                    lCoord.complete(1);
                                } else {
                                    lCoord.setRollbackOnly();
                                    lCoord.cleanup();
                                }
                            }
                            catch (RolledbackException ex) {
                                FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ejs.csi.TransactionControlImpl.postInvoke", (String)"325", (Object)this);
                            }
                            catch (Throwable ex) {
                                FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ejs.csi.TransactionControlImpl.postInvoke", (String)"330", (Object)this);
                                if (!TraceComponent.isAnyTracingEnabled() || !tc.isEventEnabled()) break block28;
                                Tr.event(tc, "Failed to complete local transaction", ex);
                            }
                        }
                        throw new CSIException("Aborted improperly started local transaction");
                    }
                    try {
                        this.setRollbackOnly();
                    }
                    catch (Throwable ex) {
                        FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ejs.csi.TransactionControlImpl.postInvoke", (String)"345", (Object)this);
                        if (!TraceComponent.isAnyTracingEnabled() || !tc.isEventEnabled()) break block29;
                        Tr.event(tc, "Failed to mark global transaction for rollback", ex);
                    }
                }
                throw new CSITransactionRolledbackException("Rolled back improperly started global transaction");
            }
            TranStrategy ts = txCookieImpl.txStrategy;
            try {
                if (exType == ExceptionType.NO_EXCEPTION) {
                    ts.postInvoke(key, txCookieImpl, methodInfo);
                } else {
                    ts.handleException(key, txCookieImpl, exType, methodInfo);
                }
                Object var9_12 = null;
                suspendedLocalTx2 = txCookieImpl.suspendedLocalTx;
                if (suspendedLocalTx2 == null) break block30;
            }
            catch (Throwable throwable) {
                Object var9_13 = null;
                LocalTransactionCoordinator suspendedLocalTx2 = txCookieImpl.suspendedLocalTx;
                if (suspendedLocalTx2 != null) {
                    try {
                        this.resumeLocalTx(suspendedLocalTx2);
                    }
                    catch (Exception ex) {
                        FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ejs.csi.TransactionControlImpl.postInvoke", (String)"394", (Object)this);
                        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                            Tr.event(tc, "Local tx resume failed", ex);
                        }
                        throw new CSIException("Local tx resume failed", ex);
                    }
                }
                Transaction suspendedTx = txCookieImpl.suspendedTx;
                if (suspendedTx != null) {
                    try {
                        this.resumeGlobalTx(suspendedTx, 0);
                    }
                    catch (Exception ex) {
                        FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ejs.csi.TransactionControlImpl.postInvoke", (String)"414", (Object)this);
                        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                            Tr.event(tc, "Global tx resume failed", ex);
                        }
                        throw new CSIException("Global tx resume failed", ex);
                    }
                }
                throw throwable;
            }
            try {
                this.resumeLocalTx(suspendedLocalTx2);
            }
            catch (Exception ex) {
                FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ejs.csi.TransactionControlImpl.postInvoke", (String)"394", (Object)this);
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    Tr.event(tc, "Local tx resume failed", ex);
                }
                throw new CSIException("Local tx resume failed", ex);
            }
        }
        Transaction suspendedTx = txCookieImpl.suspendedTx;
        if (suspendedTx != null) {
            try {
                this.resumeGlobalTx(suspendedTx, 0);
            }
            catch (Exception ex) {
                FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ejs.csi.TransactionControlImpl.postInvoke", (String)"414", (Object)this);
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    Tr.event(tc, "Global tx resume failed", ex);
                }
                throw new CSIException("Global tx resume failed", ex);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "postInvoke");
        }
    }

    public Object getCurrentTransactionalUOW(boolean checkMarkedRollback) throws CSITransactionRolledbackException {
        UOWCoordinator coord = this.uowCurrent.getUOWCoord();
        if (coord != null && checkMarkedRollback && coord.getRollbackOnly()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event(tc, "Attempting to do work on a tx that has been marked rollback.");
            }
            throw new CSITransactionRolledbackException("Transaction rolled back");
        }
        return coord;
    }

    public Object getCurrentSessionalUOW(boolean checkMarkedReset) throws CSIActivitySessionResetException {
        return null;
    }

    public UserTransaction getUserTransaction() {
        return this.userTransactionImpl;
    }

    public void setRollbackOnly() {
        LocalTransactionCoordinator lCoord;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "setRollbackOnly", this);
        }
        if ((lCoord = this.getLocalCoord()) != null) {
            lCoord.setRollbackOnly();
        } else {
            try {
                this.txService.setRollbackOnly();
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ejs.csi.TransactionControlImpl.setRollbackOnly", (String)"556", (Object)this);
                throw new IllegalStateException("No active transaction");
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "setRollbackOnly");
        }
    }

    public boolean getRollbackOnly() {
        LocalTransactionCoordinator lCoord = this.getLocalCoord();
        if (lCoord != null) {
            return lCoord.getRollbackOnly();
        }
        int status = 6;
        try {
            status = this.txService.getStatus();
        }
        catch (SystemException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ejs.csi.TransactionControlImpl.getRollbackOnly", (String)"667", (Object)this);
        }
        return status == 1 || status == 4 || status == 9;
    }

    public void enlistWithTransaction(Synchronization interestedParty) throws CSIException {
        SyncDriver sd = null;
        LocalTransactionCoordinator lCoord = this.getLocalCoord();
        if (lCoord != null) {
            try {
                sd = this.sdFactory.create(lCoord);
            }
            catch (SyncDriverCreationFailure ex) {
                FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ejs.csi.TransactionControlImpl.enlist", (String)"603", (Object)this);
                throw new CSIException("enlistment with local tx failed", ex);
            }
        } else {
            Transaction coord = this.getGlobalCoord();
            if (coord != null) {
                try {
                    sd = this.sdFactory.create(coord);
                }
                catch (SyncDriverCreationFailure ex) {
                    FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ejs.csi.TransactionControlImpl.enlist", (String)"616", (Object)this);
                    throw new CSIException("enlistment with global tx failed", ex);
                }
            } else {
                throw new IllegalStateException("No active transaction");
            }
        }
        sd.addParticipant(interestedParty);
    }

    public void enlistWithTransaction(Object uowCoord, Synchronization interestedParty) throws CSIException {
        SyncDriver sd = null;
        if (uowCoord != null) {
            try {
                sd = this.sdFactory.create((UOWCoordinator)uowCoord);
            }
            catch (SyncDriverCreationFailure ex) {
                FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ejs.csi.TransactionControlImpl.enlist", (String)"745", (Object)this);
                throw new CSIException("enlistment with UOWCoord failed", ex);
            }
        } else {
            throw new IllegalStateException("No active transaction");
        }
        sd.addParticipant(interestedParty);
    }

    public void enlistWithSession(Synchronization interestedParty) throws CSIException {
        throw new CSIException("ActivitySession should not exist");
    }

    public void sessionEnded(EJBKey[] EjbKeyArray) throws CSIException {
        throw new CSIException("ActivitySession should not exist");
    }

    public TxContextChange setupLocalTxContext(EJBKey key) throws CSIException {
        LocalTransactionCoordinator suspendedLocalTx = null;
        Transaction suspendedGlobalTx = null;
        LocalTransactionCoordinator activatedLocalTx = null;
        BeanMetaData bmd = ((BeanId)key).getHome().getBeanMetaData(key);
        int LocalTxBoundary = bmd.getLocalTranConfigData().getValueBoundary();
        Transaction globalTxCoord = this.getGlobalCoord();
        if (globalTxCoord != null) {
            LocalTransactionCoordinator stickyLocalTx;
            if (LocalTxBoundary == 1 && (stickyLocalTx = (LocalTransactionCoordinator)this.stickyLocalTxTable.remove((Object)key)) != null) {
                try {
                    suspendedGlobalTx = this.suspendGlobalTx(2);
                }
                catch (CSIException csie) {
                    FFDCFilter.processException((Throwable)csie, (String)"com.ibm.ejs.csi.TransactionControlImpl.setupLocalTxContext", (String)"937", (Object)this);
                    this.stickyLocalTxTable.put((Object)key, (Object)stickyLocalTx);
                    throw csie;
                }
                this.resumeLocalTx(stickyLocalTx);
                activatedLocalTx = stickyLocalTx;
            }
        } else {
            LocalTransactionCoordinator currentLocalTx = this.getLocalCoord();
            LocalTransactionCoordinator stickyLocalTx = null;
            if (LocalTxBoundary == 1) {
                stickyLocalTx = (LocalTransactionCoordinator)this.stickyLocalTxTable.remove((Object)key);
            }
            if (currentLocalTx != null && stickyLocalTx != null) {
                this.suspendLocalTx();
                suspendedLocalTx = currentLocalTx;
                this.resumeLocalTx(stickyLocalTx);
                activatedLocalTx = stickyLocalTx;
            } else if (currentLocalTx == null && stickyLocalTx != null) {
                this.resumeLocalTx(stickyLocalTx);
                activatedLocalTx = stickyLocalTx;
            }
        }
        return new TxContextChange(suspendedLocalTx, suspendedGlobalTx, activatedLocalTx, key);
    }

    public void teardownLocalTxContext(TxContextChange changedContext) {
        block5: {
            LocalTransactionCoordinator activatedLocalTx = changedContext.getActivatedLocalTx();
            if (activatedLocalTx != null) {
                Transaction previousGlobalTx;
                this.suspendLocalTx();
                this.stickyLocalTxTable.put((Object)changedContext.getKey(), (Object)activatedLocalTx);
                LocalTransactionCoordinator previousLocalTx = changedContext.getSuspendedLocalTx();
                if (previousLocalTx != null) {
                    this.resumeLocalTx(previousLocalTx);
                }
                if ((previousGlobalTx = changedContext.getSuspendedGlobalTx()) != null) {
                    try {
                        this.resumeGlobalTx(previousGlobalTx, 0);
                    }
                    catch (Exception ex) {
                        FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ejs.csi.TransactionControlImpl.teardownLocalTxContext", (String)"650", (Object)this);
                        if (!TraceComponent.isAnyTracingEnabled() || !tc.isEventEnabled()) break block5;
                        Tr.event(tc, "Global tx resume failed", ex);
                    }
                }
            }
        }
    }

    final LocalTransactionCoordinator beginLocalTx() {
        LocalTransactionCoordinator lCoord;
        block7: {
            lCoord = null;
            try {
                LocalTransactionCurrent ltcCurrent = TransactionManagerFactory.getLocalTransactionCurrent();
                ltcCurrent.begin();
                lCoord = this.getLocalCoord();
                if (TraceComponent.isAnyTracingEnabled()) {
                    if (tc.isEventEnabled()) {
                        if (lCoord != null) {
                            Tr.event(tc, "Began LTC cntxt: tid=" + Integer.toHexString(lCoord.hashCode()) + "(LTC)");
                        } else {
                            Tr.event(tc, "Began LTC cntxt: null Coordinator!");
                        }
                    }
                    if (lCoord != null && TETxLifeCycleInfo.isTraceEnabled()) {
                        TETxLifeCycleInfo.traceLocalTxBegin("" + System.identityHashCode(lCoord), "Begin Local Tx");
                    }
                }
            }
            catch (Exception ex) {
                FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ejs.csi.TransactionControlImpl.beginLocalTx", (String)"737", (Object)this);
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isEventEnabled()) break block7;
                Tr.event(tc, "Begin local tx failed", ex);
            }
        }
        return lCoord;
    }

    final LocalTransactionCoordinator suspendLocalTx() {
        LocalTransactionCoordinator lCoord = null;
        if (TraceComponent.isAnyTracingEnabled() && (tc.isEventEnabled() || TETxLifeCycleInfo.isTraceEnabled()) && (lCoord = this.getLocalCoord()) != null && TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event(tc, "Suspending LTC cntxt: tid=" + Integer.toHexString(lCoord.hashCode()) + "(LTC)");
        }
        LocalTransactionCoordinator rtnVal = this.ltcCurrent.suspend();
        if (lCoord != null && TraceComponent.isAnyTracingEnabled() && TETxLifeCycleInfo.isTraceEnabled()) {
            TETxLifeCycleInfo.traceLocalTxSuspend("" + System.identityHashCode(lCoord), "Suspend Local Tx");
        }
        return rtnVal;
    }

    final Transaction suspendGlobalTx(int action) throws CSIException {
        int txtype;
        Transaction ctrl = null;
        try {
            ctrl = this.txService.suspend();
            if (TraceComponent.isAnyTracingEnabled()) {
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "Suspending TX cntxt: " + ctrl);
                }
                if (TETxLifeCycleInfo.isTraceEnabled()) {
                    int idx;
                    String idStr = null;
                    if (ctrl != null) {
                        idStr = ctrl.toString();
                    }
                    idStr = idStr != null ? ((idx = idStr.indexOf("(")) != -1 ? idStr.substring(idx + 1, idStr.indexOf(")")) : ((idx = idStr.indexOf("tid=")) != -1 ? idStr.substring(idx + 4) : idStr)) : "NoTx";
                    TETxLifeCycleInfo.traceGlobalTxSuspend(idStr, "Suspend Global Tx");
                }
            }
        }
        catch (SystemException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ejs.csi.TransactionControlImpl.setRollbackOnly", (String)"770", (Object)this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event(tc, "Error suspending global tx", e);
            }
            throw new CSIException("suspend global tx failed", e);
        }
        if (ctrl != null && (txtype = ((UOWCoordinator)ctrl).getTxType()) == 2) {
            return ctrl;
        }
        return ctrl;
    }

    final void resumeLocalTx(LocalTransactionCoordinator lCoord) throws IllegalStateException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            if (lCoord != null) {
                Tr.event(tc, "Resuming LTC cntxt: tid=" + Integer.toHexString(lCoord.hashCode()) + "(LTC)");
            } else {
                Tr.event(tc, "Resuming LTC cntxt: null Coordinator!");
            }
        }
        this.ltcCurrent.resume(lCoord);
        if (TraceComponent.isAnyTracingEnabled() && lCoord != null && TETxLifeCycleInfo.isTraceEnabled()) {
            TETxLifeCycleInfo.traceLocalTxResume("" + System.identityHashCode(lCoord), "Resume Local Tx");
        }
    }

    final void resumeGlobalTx(Transaction ctrl, int action) throws SystemException, InvalidTransactionException {
        try {
            this.txService.resume(ctrl);
        }
        catch (SystemException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ejs.csi.TransactionControlImpl.resumeGlobalTx", (String)"814", (Object)this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event(tc, "Error resuming global tx", e);
            }
            throw e;
        }
        if (TraceComponent.isAnyTracingEnabled()) {
            if (tc.isEventEnabled()) {
                Tr.event(tc, "Resumed TX cntxt: " + this.txService.getTransaction());
            }
            if (TETxLifeCycleInfo.isTraceEnabled()) {
                int idx;
                String idStr = null;
                if (ctrl != null) {
                    idStr = ctrl.toString();
                }
                idStr = idStr != null ? ((idx = idStr.indexOf("(")) != -1 ? idStr.substring(idx + 1, idStr.indexOf(")")) : ((idx = idStr.indexOf("tid=")) != -1 ? idStr.substring(idx + 4) : idStr)) : "NoTx";
                TETxLifeCycleInfo.traceGlobalTxResume(idStr, "Resume Global Tx");
            }
        }
        if (((UOWCoordinator)ctrl).getTxType() == 2) {
            return;
        }
    }

    final LocalTransactionCoordinator getLocalCoord() {
        return this.ltcCurrent.getLocalTranCoord();
    }

    final Transaction getGlobalCoord() {
        try {
            Transaction control = this.txService.getTransaction();
            return control;
        }
        catch (SystemException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ejs.csi.TransactionControlImpl.getGlobalCoord", (String)"856", (Object)this);
            Tr.warning(tc, "TRANSACTION_COORDINATOR_NOT_AVAILABLE_CNTR0022E", new Object[]{ex});
            return null;
        }
    }

    public final void completeTxTimeout() throws CSITransactionRolledbackException {
        try {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.entry(tc, "completeTxTimeout");
            }
            this.txService.completeTxTimeout();
        }
        catch (TransactionRolledbackException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ejs.csi.TransactionControlImpl.completeTxTimeout", (String)"1390", (Object)this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "completeTxTimeout throwing CSITransactionRolledBackException");
            }
            throw new CSITransactionRolledbackException("Transaction rolled back", e);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "completeTxTimeout exit");
        }
    }

    public boolean isBmtActive(EJBMethodInfo methodInfo) {
        TranStrategy ts = this.txStrategies[methodInfo.getTransactionAttribute().getValue()];
        return ts.isBmtActive();
    }

    public boolean isBmasActive(EJBMethodInfo methodInfo) {
        return false;
    }

    public UOWHandle suspend() throws CSIException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "suspend");
        }
        UOWHandleImpl toReturn = null;
        if (this.getGlobalCoord() != null) {
            Transaction gtx = this.suspendGlobalTx(2);
            toReturn = new UOWHandleImpl(gtx);
        } else if (this.getLocalCoord() != null) {
            LocalTransactionCoordinator ltc = this.suspendLocalTx();
            toReturn = new UOWHandleImpl(ltc);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "suspend : " + toReturn);
        }
        return toReturn;
    }

    public void resume(UOWHandle handle) throws CSIException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "resume : " + handle);
        }
        if (handle != null) {
            UOWHandleImpl handleImpl = (UOWHandleImpl)handle;
            try {
                if (handleImpl.suspendedLocalTx != null) {
                    this.resumeLocalTx(handleImpl.suspendedLocalTx);
                } else {
                    this.resumeGlobalTx(handleImpl.suspendedGlobalTx, 0);
                }
            }
            catch (Throwable t) {
                FFDCFilter.processException((Throwable)t, (String)"com.ibm.ejs.csi.TransactionControlImpl.resume", (String)"1491", (Object)this);
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "resume", "Error resuming tx in TransactionControlImpl: " + t);
                }
                throw new CSIException("Error resuming tx in TransactionControlImpl.", t);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "resume");
        }
    }
}

