/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.csi;

import com.ibm.ejs.container.BeanId;
import com.ibm.ejs.container.StatefulBeanReaper;
import com.ibm.ejs.container.activator.StatefulSessionActivationStrategy;
import com.ibm.ejs.container.util.EJSPlatformHelper;
import com.ibm.ejs.csi.WSGZIPOutputStream;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.csi.CSIException;
import com.ibm.websphere.csi.EJBKey;
import com.ibm.websphere.csi.SessionBeanStore;
import com.ibm.websphere.csi.StreamUnavailableException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.util.AccessController;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class FileBeanStore
implements SessionBeanStore {
    private static final TraceComponent tc = Tr.register(FileBeanStore.class, "EJBContainer", "com.ibm.ejs.container.container");
    private static final String CLASS_NAME = "com.ibm.ejs.csi.FileBeanStore";
    private String passivationDir;
    private String serverName;
    private String clusterName;
    private static char[] hexChars = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    public FileBeanStore(String passivationDir) {
        this(passivationDir, null, null);
    }

    public FileBeanStore(String passivationDir, String serverName, String clusterName) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "<init>", new Object[]{passivationDir, serverName, clusterName});
        }
        if (passivationDir != null && new File(passivationDir).isDirectory()) {
            this.passivationDir = passivationDir;
        } else {
            this.passivationDir = null;
            if (passivationDir != null) {
                Tr.warning(tc, "PASSIVATION_DIRECTORY_DOES_NOT_EXIST_CNTR0023W", passivationDir);
            }
        }
        this.serverName = serverName;
        this.clusterName = clusterName;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "<init>");
        }
    }

    public GZIPInputStream getGZIPInputStream(EJBKey key) throws CSIException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getGZIPInputStream", key);
        }
        final String fileName = this.getPortableFilename(key.toString());
        final String passDir = this.passivationDir;
        GZIPInputStream result = null;
        try {
            result = (GZIPInputStream)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws FileNotFoundException, IOException {
                    File statefulBeanFile = null;
                    if (EJSPlatformHelper.isZOS()) {
                        if (FileBeanStore.this.clusterName != null) {
                            statefulBeanFile = new File(FileBeanStore.this.passivationDir, fileName + FileBeanStore.this.clusterName);
                            if (!statefulBeanFile.exists()) {
                                statefulBeanFile = new File(FileBeanStore.this.passivationDir, fileName + FileBeanStore.this.serverName);
                            }
                        } else {
                            statefulBeanFile = new File(FileBeanStore.this.passivationDir, fileName + FileBeanStore.this.serverName);
                        }
                        if (!statefulBeanFile.exists()) {
                            statefulBeanFile = new File(FileBeanStore.this.passivationDir, fileName);
                        }
                    } else {
                        statefulBeanFile = new File(passDir, fileName);
                    }
                    FileInputStream fis = new FileInputStream(statefulBeanFile);
                    return new GZIPInputStream(fis);
                }
            });
        }
        catch (PrivilegedActionException ex) {
            Exception ex2 = ex.getException();
            if (ex2 instanceof FileNotFoundException) {
                FFDCFilter.processException((Throwable)((FileNotFoundException)ex2), (String)"com.ibm.ejs.csi.FileBeanStore.getGZIPInputStream", (String)"91", (Object)this);
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    Tr.event(tc, "No file found while trying to activate passivated stateful session bean", fileName);
                }
                throw new StreamUnavailableException("");
            }
            if (ex2 instanceof IOException) {
                FFDCFilter.processException((Throwable)((IOException)ex2), (String)"com.ibm.ejs.csi.FileBeanStore.getGZIPInputStream", (String)"98", (Object)this);
                Tr.warning(tc, "IOEXCEPTION_READING_FILE_FOR_STATEFUL_SESSION_BEAN_CNTR0024W", new Object[]{fileName, this, (IOException)ex2});
                throw new CSIException("IOException reading input stream for stateful session bean", (IOException)ex2);
            }
            throw new CSIException("Unexpected exception reading input stream for stateful session bean", ex2);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getGZIPInputStream");
        }
        return result;
    }

    public GZIPOutputStream getGZIPOutputStream(EJBKey key) throws CSIException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getOutputStream ", key);
        }
        final String fileName = this.getPortableFilename(key.toString());
        GZIPOutputStream result = null;
        StatefulBeanReaper reaper = null;
        if (EJSPlatformHelper.isZOS()) {
            reaper = ((StatefulSessionActivationStrategy)((BeanId)key).getActivationStrategy()).getReaper();
        }
        final long beanTimeoutTime = EJSPlatformHelper.isZOS() ? reaper.getBeanTimeoutTime((BeanId)key) : 0L;
        try {
            result = (GZIPOutputStream)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IOException {
                    FileOutputStream fos = null;
                    if (EJSPlatformHelper.isZOS()) {
                        File statefulBeanFile = null;
                        statefulBeanFile = FileBeanStore.this.clusterName != null ? new File(FileBeanStore.this.passivationDir, fileName + FileBeanStore.this.clusterName) : new File(FileBeanStore.this.passivationDir, fileName + FileBeanStore.this.serverName);
                        fos = new FileOutputStream(statefulBeanFile);
                        return new WSGZIPOutputStream((OutputStream)fos, statefulBeanFile, beanTimeoutTime);
                    }
                    fos = new FileOutputStream(new File(FileBeanStore.this.passivationDir, fileName));
                    return new GZIPOutputStream(fos);
                }
            });
        }
        catch (PrivilegedActionException ex2) {
            IOException ex = (IOException)ex2.getException();
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ejs.csi.FileBeanStore.getOutputStream", (String)"127", (Object)this);
            Tr.warning(tc, "IOEXCEPTION_WRITING_FILE_FOR_STATEFUL_SESSION_BEAN_CNTR0025W", new Object[]{fileName, this, ex});
            throw new CSIException("Unable to open output stream", ex);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getOutputStream");
        }
        return result;
    }

    public void remove(EJBKey key) {
        String fileName;
        block4: {
            final String passDir = this.passivationDir;
            fileName = this.getPortableFilename(key.toString());
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.entry(tc, "remove file: " + fileName);
            }
            final EJBKey tempKey = key;
            try {
                AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws Exception {
                        File theFile = null;
                        if (EJSPlatformHelper.isZOS()) {
                            if (FileBeanStore.this.clusterName != null) {
                                theFile = new File(passDir, fileName + FileBeanStore.this.clusterName);
                                if (!theFile.exists()) {
                                    theFile = new File(passDir, fileName + FileBeanStore.this.serverName);
                                }
                            } else {
                                theFile = new File(passDir, fileName + FileBeanStore.this.serverName);
                            }
                            if (!theFile.exists()) {
                                theFile = new File(passDir, fileName);
                            }
                        } else {
                            theFile = new File(passDir, fileName);
                        }
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug(tc, "deleting file: " + theFile.getName() + ", path: " + theFile.getPath());
                        }
                        boolean deleted = theFile.delete();
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug(tc, "File.delete returned: " + deleted);
                        }
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug(tc, "Bean " + tempKey + " removed from the passivation store");
                        }
                        return null;
                    }
                });
            }
            catch (PrivilegedActionException ex) {
                FFDCFilter.processException((Throwable)ex.getException(), (String)"com.ibm.ejs.csi.FileBeanStore.remove", (String)"150", (Object)this);
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isEventEnabled()) break block4;
                Tr.event(tc, "Failed to remove session bean state", new Object[]{key, ex});
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "remove file: " + fileName);
        }
    }

    private static String byteArrayToHexString(byte[] b) {
        StringBuffer result = new StringBuffer(b.length * 2);
        for (int i = 0; i < b.length; ++i) {
            result.append(hexChars[b[i] >> 4 & 0xF]);
            result.append(hexChars[b[i] & 0xF]);
        }
        return result.toString();
    }

    private String getPortableFilename(String fileName) {
        StringBuffer resultBuffer = new StringBuffer();
        int length = fileName.length();
        for (int i = 0; i < length; ++i) {
            char c = fileName.charAt(i);
            if (Character.isLetterOrDigit(c) || c == '_' || c == '-' || c == '.') {
                resultBuffer.append(c);
                continue;
            }
            resultBuffer.append('_');
        }
        return resultBuffer.toString();
    }

    public OutputStream getOutputStream(EJBKey key) throws CSIException {
        final String fileName = this.getPortableFilename(key.toString());
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getOutputStream: file name = ", fileName);
        }
        FileOutputStream result = null;
        StatefulBeanReaper reaper = null;
        if (EJSPlatformHelper.isZOS()) {
            reaper = ((StatefulSessionActivationStrategy)((BeanId)key).getActivationStrategy()).getReaper();
        }
        final long beanTimeoutTime = EJSPlatformHelper.isZOS() ? reaper.getBeanTimeoutTime((BeanId)key) : 0L;
        try {
            result = (FileOutputStream)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IOException {
                    File file = new File(FileBeanStore.this.passivationDir, fileName);
                    if (EJSPlatformHelper.isZOS()) {
                        return new WSFileOutputStream(file, beanTimeoutTime);
                    }
                    return new FileOutputStream(file);
                }
            });
        }
        catch (PrivilegedActionException ex2) {
            IOException ex = (IOException)ex2.getException();
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ejs.csi.FileBeanStore.getUnCompressedOutputStream", (String)"460", (Object)this);
            Tr.warning(tc, "IOEXCEPTION_WRITING_FILE_FOR_STATEFUL_SESSION_BEAN_CNTR0025W", new Object[]{fileName, this, ex});
            throw new CSIException("Unable to open output stream", ex);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getOutputStream");
        }
        return result;
    }

    public InputStream getInputStream(EJBKey key) throws CSIException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getInputStream ", key);
        }
        final String fileName = this.getPortableFilename(key.toString());
        FileInputStream result = null;
        try {
            result = (FileInputStream)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IOException {
                    return new FileInputStream(new File(FileBeanStore.this.passivationDir, fileName));
                }
            });
        }
        catch (PrivilegedActionException ex) {
            Exception ex2 = ex.getException();
            if (ex2 instanceof FileNotFoundException) {
                FFDCFilter.processException((Throwable)((FileNotFoundException)ex2), (String)"com.ibm.ejs.csi.FileBeanStore.getInputStream", (String)"524", (Object)this);
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    Tr.event(tc, "No file found while trying to activate passivated stateful session bean", fileName);
                }
                throw new StreamUnavailableException("");
            }
            if (ex2 instanceof IOException) {
                FFDCFilter.processException((Throwable)((IOException)ex2), (String)"com.ibm.ejs.csi.FileBeanStore.getInputStream", (String)"531", (Object)this);
                Tr.warning(tc, "IOEXCEPTION_READING_FILE_FOR_STATEFUL_SESSION_BEAN_CNTR0024W", new Object[]{fileName, this, (IOException)ex2});
                throw new CSIException("IOException reading input stream for stateful session bean", (IOException)ex2);
            }
            throw new CSIException("Unexpected exception reading input stream for stateful session bean", ex2);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getInputStream");
        }
        return result;
    }

    class WSFileOutputStream
    extends FileOutputStream {
        long beanTimeoutTime;
        File beanFileObj;

        public WSFileOutputStream(File fileObj, long TimeoutTime) throws IOException {
            super(fileObj);
            this.beanFileObj = fileObj;
            this.beanTimeoutTime = TimeoutTime;
        }

        public void close() throws IOException {
            this.beanFileObj.setLastModified(this.beanTimeoutTime);
            super.close();
        }
    }
}

