/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.container.util;

import com.ibm.ejs.container.EJSContainer;
import com.ibm.ejs.container.EJSHome;
import com.ibm.ejs.container.EJSWrapperForBasicSFSBHome;
import com.ibm.ejs.container.util.ExceptionUtil;
import com.ibm.ejs.csi.J2EENameImpl;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.util.dopriv.SetContextClassLoaderPrivileged;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.naming.util.ReferenceData;
import com.ibm.ws.naming.util.ReferenceObjectFactory;
import com.ibm.ws.runtime.component.EJBContainerImpl;
import com.ibm.ws.runtime.component.EJBContainerImpl_threadLocal;
import com.ibm.ws.security.util.AccessController;
import java.rmi.NoSuchObjectException;
import java.rmi.Remote;
import java.security.PrivilegedAction;
import javax.rmi.PortableRemoteObject;

public class SFSBReferenceObjectFactory
implements ReferenceObjectFactory {
    private static final String CLASS_NAME = SFSBReferenceObjectFactory.class.getName();
    private static final TraceComponent tc = Tr.register(CLASS_NAME, "EJBContainer", "com.ibm.ejs.container.container");
    public static final String APP_NAME_PROP = "appName";
    public static final String MODULE_NAME_PROP = "moduleName";
    public static final String COMPONENT_NAME_PROP = "componentName";
    public static final String INTERFACE_NAME_PROP = "interfaceName";
    private Class<?> ivBusinessClass;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getObject(ReferenceData referenceData) throws Exception {
        Class<?> businessClass;
        String componentName;
        String moduleName;
        String appName;
        J2EENameImpl j2eeName;
        EJSHome home;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getObject");
        }
        if ((home = (EJSHome)EJSContainer.homeOfHomes.getHome(j2eeName = new J2EENameImpl(appName = referenceData.getProperty(APP_NAME_PROP), moduleName = referenceData.getProperty(MODULE_NAME_PROP), componentName = referenceData.getProperty(COMPONENT_NAME_PROP)))) == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "getObject could not find home for SFSB with J2EEName = " + j2eeName);
            }
            throw ExceptionUtil.EJBException("Unable to find EJB component: " + j2eeName, null);
        }
        String businessInterfaceName = referenceData.getProperty(INTERFACE_NAME_PROP);
        SFSBReferenceObjectFactory sFSBReferenceObjectFactory = this;
        synchronized (sFSBReferenceObjectFactory) {
            businessClass = this.ivBusinessClass;
        }
        try {
            ClassLoader classLoader = home.getBeanMetaData().classLoader;
            if (businessClass == null) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "getObject using ClassLoader to load remote business interface: " + businessInterfaceName + ", J2EEName: " + j2eeName);
                }
                businessClass = classLoader.loadClass(businessInterfaceName);
                SFSBReferenceObjectFactory sFSBReferenceObjectFactory2 = this;
                synchronized (sFSBReferenceObjectFactory2) {
                    this.ivBusinessClass = businessClass;
                }
            }
            EJSWrapperForBasicSFSBHome wrapper = home.getStatefulBusinessHomeWrapper();
            Object sfsbWrapper = wrapper.create(businessClass);
            Remote stub = SFSBReferenceObjectFactory.toStub((Remote)sfsbWrapper, classLoader);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "getObject returning: " + stub);
            }
            return stub;
        }
        catch (NoSuchObjectException ex) {
            FFDCFilter.processException((Throwable)ex, (String)(CLASS_NAME + ".getObject"), (String)"147", (Object)this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "Unexpected PortableRemoteObject.toStub() failure!", ex);
            }
            throw ex;
        }
        catch (ClassNotFoundException ex) {
            FFDCFilter.processException((Throwable)ex, (String)(CLASS_NAME + ".getObject"), (String)"156", (Object)this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "Unexpected ClassLoader.loadClass failure, remote business interface class: " + businessInterfaceName);
            }
            throw ExceptionUtil.EJBException("Unable to load remote business interface class: " + j2eeName + "/" + businessInterfaceName, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Remote toStub(Remote wrapper, ClassLoader classLoader) throws NoSuchObjectException {
        Remote remote;
        block2: {
            ClassLoader originalLoader = null;
            boolean resetClassLoader = false;
            SetContextClassLoaderPrivileged setCLPrivObj = ((EJBContainerImpl_threadLocal)EJBContainerImpl.svEJBContainerImpl_threadLocal.get()).ivClassLoaderChanger;
            try {
                setCLPrivObj.newClassLoader = classLoader;
                AccessController.doPrivileged((PrivilegedAction)setCLPrivObj);
                originalLoader = setCLPrivObj.oldClassLoader;
                resetClassLoader = setCLPrivObj.wasChanged;
                remote = PortableRemoteObject.toStub((Remote)wrapper);
                Object var7_6 = null;
                if (!resetClassLoader) break block2;
                setCLPrivObj.newClassLoader = originalLoader;
            }
            catch (Throwable throwable) {
                block3: {
                    Object var7_7 = null;
                    if (!resetClassLoader) break block3;
                    setCLPrivObj.newClassLoader = originalLoader;
                    AccessController.doPrivileged((PrivilegedAction)setCLPrivObj);
                }
                throw throwable;
            }
            AccessController.doPrivileged((PrivilegedAction)setCLPrivObj);
        }
        return remote;
    }
}

