/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.container.drs.ws390;

import com.ibm.ejs.container.drs.ws390.SfDRSControllerBootstrapImpl;
import com.ibm.ejs.container.drs.ws390.SfDRSControllerCacheMsgListenerImpl;
import com.ibm.ejs.container.drs.ws390.SfDRSControllerDataXferImpl;
import com.ibm.ejs.container.drs.ws390.SfDRSControllerInstanceImpl;
import com.ibm.ejs.container.drs.ws390.SfPlatformHelper;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.ws.exception.ComponentDisabledException;
import com.ibm.ws.exception.ConfigurationError;
import com.ibm.ws.exception.ConfigurationWarning;
import com.ibm.ws.exception.RuntimeError;
import com.ibm.ws.exception.RuntimeWarning;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.runtime.component.ComponentImpl;
import com.ibm.ws.runtime.service.MultibrokerDomain;
import com.ibm.wsspi.drs.DRSBootstrap;
import com.ibm.wsspi.drs.DRSCacheMsgListener;
import com.ibm.wsspi.drs.DRSControllerInstance;
import com.ibm.wsspi.drs.DRSControllerInstanceFactory;
import com.ibm.wsspi.drs.DRSControllerInstanceFactoryConfig;
import com.ibm.wsspi.drs.DRSDataXfer;
import com.ibm.wsspi.drs.DRSServantProxyFactory;
import com.ibm.wsspi.drs.DRSSettings;
import java.util.Map;

public class SfControllerServiceImpl
extends ComponentImpl
implements DRSControllerInstanceFactory {
    private static TraceComponent tc = Tr.register(SfControllerServiceImpl.class, "EJBDRSCache", "com.ibm.ejs.container.container");
    private static boolean _loggedVersion = false;
    private static DRSServantProxyFactory proxyFactory = null;
    private static DRSControllerInstanceFactory sfControllerService = null;

    public SfControllerServiceImpl() {
        String m = "SfControllerServiceImpl.constructor: ";
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "SfControllerServiceImpl.constructor: Entry");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled() && !_loggedVersion) {
            Tr.debug(tc, "SfControllerServiceImpl.constructor: Version 1.11 9/16/07 21:28:40");
            _loggedVersion = true;
        }
        if (sfControllerService != null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "SfControllerServiceImpl.constructor:  SfControllerServiceImpl already exists");
            }
            throw new IllegalStateException(" SfControllerServiceImpl already exists");
        }
        sfControllerService = this;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "SfControllerServiceImpl.constructor: Exit");
        }
    }

    private boolean shouldRunInThisJVM() {
        String m = "SfControllerServiceImpl.shouldRunInThisJVM: ";
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "SfControllerServiceImpl.shouldRunInThisJVM: Entry.");
        }
        boolean rc = false;
        rc = SfPlatformHelper.isZOS();
        if (rc) {
            rc = SfPlatformHelper.isZOS_Controller();
        }
        if (rc) {
            String processType = AdminServiceFactory.getAdminService().getProcessType();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "SfControllerServiceImpl.shouldRunInThisJVM:  Process Type = " + processType);
            }
            if (processType.equals("NodeAgent") || processType.equals("DeploymentManager")) {
                rc = false;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "SfControllerServiceImpl.shouldRunInThisJVM: Exit rc = " + rc);
        }
        return rc;
    }

    public void initialize(Object config) throws ComponentDisabledException, ConfigurationWarning, ConfigurationError {
        String methodName = "SfControllerServiceImpl.initialize()";
        String className = "SfControllerServiceImpl";
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "SfControllerServiceImpl.initialize() WCCM config=" + config);
        }
        if (this.shouldRunInThisJVM()) {
            DRSControllerInstanceFactoryConfig.setControllerInstanceFactory((String)"EJB Container DRS Controller Instance", (DRSControllerInstanceFactory)this);
            Tr.info(tc, "SFB_CONTROLLER_INIT_CNTR0099I", "SfControllerServiceImpl");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "SfControllerServiceImpl.initialize()");
        }
    }

    public void start() throws RuntimeWarning, RuntimeError {
        String methodName = "SfControllerServiceImpl.start()";
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "SfControllerServiceImpl.start()");
        }
        if (this.shouldRunInThisJVM()) {
            try {
                this.getDRSServantProxyFactory();
            }
            catch (Throwable t) {
                FFDCFilter.processException((Throwable)t, (String)"com.ibm.ejs.container.drs.ws390.SfControllerServiceImpl.start", (String)"256", (Object)((Object)this));
                Tr.error(tc, "SFB_CONTROLLER_EXCEPTION_CNTR0100E", new Object[]{"SfControllerServiceImpl.start()", t});
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "SfControllerServiceImpl.start()");
        }
    }

    public void stop() {
        String methodName = "SfControllerServiceImpl.stop()";
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "SfControllerServiceImpl.stop()");
        }
        if (this.shouldRunInThisJVM()) {
            // empty if block
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "SfControllerServiceImpl.stop()");
        }
    }

    public DRSControllerInstance createDRSControllerInstance(String ddxKey, DRSSettings drss, Map misc, boolean _usingHAManager, long _uniqueInstanceId) {
        String methodName = "SfControllerServiceImpl.createDRSControllerInstance()";
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "SfControllerServiceImpl.createDRSControllerInstance()");
        }
        SfDRSControllerInstanceImpl ddci = null;
        try {
            SfDRSControllerBootstrapImpl db;
            SfDRSControllerCacheMsgListenerImpl dcml;
            ddci = new SfDRSControllerInstanceImpl(ddxKey, drss, misc, _usingHAManager, _uniqueInstanceId);
            ddci.dcml = dcml = new SfDRSControllerCacheMsgListenerImpl(ddci);
            ddci.db = db = new SfDRSControllerBootstrapImpl(ddci);
            ddci.drsServantProxyFactory = proxyFactory;
            SfDRSControllerDataXferImpl ddx = new SfDRSControllerDataXferImpl(ddci, _usingHAManager);
            if (_usingHAManager) {
                DRSDataXfer baseDDX = this.getDRSDataXfer(drss.getMessageBrokerDomainName(), ddxKey, dcml, db, drss, misc);
                ddx.setBaseDDX(baseDDX);
                ddci.baseDDX = baseDDX;
            }
            ddci.ddx = ddx;
            ddci.init();
        }
        catch (Throwable t) {
            FFDCFilter.processException((Throwable)t, (String)"com.ibm.ejs.container.drs.ws390.SfControllerServiceImpl.createDRSControllerInstance", (String)"381", (Object)((Object)this));
            Tr.error(tc, "SFB_CONTROLLER_EXCEPTION_CNTR0100E", new Object[]{"SfControllerServiceImpl.createDRSControllerInstance()", t});
            ddci = null;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "SfControllerServiceImpl.createDRSControllerInstance()" + (ddci == null ? "failure" : "success"));
        }
        return ddci;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public DRSDataXfer getDRSDataXfer(String domainID, String instanceId, DRSCacheMsgListener dmcl, DRSBootstrap db, DRSSettings drss, Map miscParms) {
        DRSDataXfer ddx;
        block7: {
            String methodName = "SfControllerServiceImpl.getDRSDataXfer()";
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.entry(tc, "SfControllerServiceImpl.getDRSDataXfer() instanceID = " + instanceId);
            }
            ddx = null;
            MultibrokerDomain mbd = null;
            try {
                block6: {
                    try {
                        mbd = (MultibrokerDomain)super.getService(MultibrokerDomain.class);
                        ddx = mbd.getInstance(domainID, instanceId);
                        if (ddx != null) break block6;
                        ddx = mbd.createInstance(instanceId, dmcl, db, drss, null, miscParms);
                    }
                    catch (Throwable t) {
                        FFDCFilter.processException((Throwable)t, (String)"com.ibm.ejs.container.drs.ws390.SfControllerServiceImpl.getDRSDataXfer", (String)"430", (Object)((Object)this));
                        Tr.error(tc, "SFB_CONTROLLER_EXCEPTION_CNTR0100E", new Object[]{"SfControllerServiceImpl.getDRSDataXfer()", t});
                        Object var12_11 = null;
                        super.releaseService((Object)mbd);
                        break block7;
                    }
                }
                Object var12_10 = null;
            }
            catch (Throwable throwable) {
                Object var12_12 = null;
                super.releaseService((Object)mbd);
                throw throwable;
            }
            super.releaseService((Object)mbd);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "SfControllerServiceImpl.getDRSDataXfer() instanceID = " + instanceId);
        }
        return ddx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void getDRSServantProxyFactory() {
        block10: {
            String methodName = "SfControllerServiceImpl.getDRSServantProxyFactory()";
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.entry(tc, "SfControllerServiceImpl.getDRSServantProxyFactory()");
            }
            if (proxyFactory == null) {
                MultibrokerDomain mbd = null;
                try {
                    try {
                        mbd = (MultibrokerDomain)this.getService(MultibrokerDomain.class);
                        proxyFactory = mbd.getDRSServantProxyFactoryInstance();
                    }
                    catch (Throwable t) {
                        FFDCFilter.processException((Throwable)t, (String)"com.ibm.ejs.container.drs.ws390.SfControllerServiceImpl.getDRSServantProxyFactory", (String)"461", (Object)((Object)this));
                        Tr.error(tc, "SFB_CONTROLLER_EXCEPTION_CNTR0100E", new Object[]{"SfControllerServiceImpl.getDRSServantProxyFactory()", t});
                        Object var5_4 = null;
                        this.releaseService(mbd);
                        break block10;
                    }
                    Object var5_3 = null;
                }
                catch (Throwable throwable) {
                    Object var5_5 = null;
                    this.releaseService(mbd);
                    throw throwable;
                }
                this.releaseService(mbd);
            } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "SfControllerServiceImpl.getDRSServantProxyFactory - proxy factory already acquired");
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "SfControllerServiceImpl.getDRSServantProxyFactory - exit : " + (proxyFactory == null ? "failure" : "success"));
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "SfControllerServiceImpl.getDRSServantProxyFactory()");
        }
    }
}

