/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.container;

import com.ibm.ejs.container.BeanId;
import com.ibm.ejs.container.TimerTaskHandler;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.csi.EJBKey;
import com.ibm.websphere.csi.J2EEName;
import com.ibm.ws.csi.TimerTaskInfo;
import com.ibm.ws.ejb.portable.Constants;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.scheduler.AbstractTask;
import com.ibm.ws.scheduler.Runnable;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Date;

public final class TimerTaskInfoImpl
extends AbstractTask
implements TimerTaskInfo,
Serializable {
    private static final TraceComponent tc = Tr.register(TimerTaskInfoImpl.class, "EJBContainer", "com.ibm.ejs.container.container");
    private static final String CLASS_NAME = "com.ibm.ejs.container.TimerTaskInfoImpl";
    private static final long serialVersionUID = -3085300434270658658L;
    private static final byte[] EYECATCHER = Constants.TIMER_TASK_EYE_CATCHER;
    private static final short PLATFORM = 1;
    private static final short VERSION_ID = 1;
    protected static boolean svOnServer = false;
    private transient String ivApplication = null;
    private transient String ivModule = null;
    private transient String ivComponent = null;
    private transient String ivPrimaryKey = null;
    private transient String ivInfo = null;

    public TimerTaskInfoImpl() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "<init>: " + this.toString());
        }
    }

    TimerTaskInfoImpl(BeanId timedObjectId, Date startTime, long interval, Serializable info, String taskName, boolean globalTx) throws IOException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            String infoClassName = info == null ? null : info.getClass().getName();
            Tr.entry(tc, "<init>: " + timedObjectId + ", " + startTime + ", " + interval + ", " + infoClassName + ", " + taskName + ", " + globalTx);
        }
        if (!svOnServer) {
            throw new IllegalStateException("Method not supported on client.");
        }
        this.getTaskHolder().setTargetRunnable((Runnable)new TimerTaskHandler(timedObjectId, info));
        this.setName(taskName);
        this.setAutoPurge(true);
        this.setStartTime(startTime);
        if (interval < 0L) {
            this.setNumberOfRepeats(1);
        } else {
            this.setNumberOfRepeats(-1);
            this.setRepeatInterval(Long.toString(interval) + "ms");
        }
        int qos = 2;
        if (globalTx) {
            qos = 1;
        }
        this.setQOS(qos);
        this.setTimeCalcMethod(1);
        this.setTaskExecutionOptions(1);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "<init>: " + this.toString());
        }
    }

    public boolean isDirty() {
        return false;
    }

    public void setTimedObjectId(EJBKey beanId) {
        throw new IllegalStateException("TimedObjectId is read only");
    }

    public EJBKey getTimedObjectId() {
        if (!svOnServer) {
            throw new IllegalStateException("Method not supported on client.");
        }
        TimerTaskHandler taskHandler = (TimerTaskHandler)this.getTaskHolder().getTargetRunnable();
        return taskHandler.getTimedObjectId();
    }

    public void setInfo(Serializable info) {
        throw new IllegalStateException("Info is read only");
    }

    public Serializable getInfo() {
        if (!svOnServer) {
            throw new IllegalStateException("Method not supported on client.");
        }
        TimerTaskHandler taskHandler = (TimerTaskHandler)this.getTaskHolder().getTargetRunnable();
        return taskHandler.getInfo();
    }

    public String getApplication() {
        if (this.ivApplication == null) {
            this.getJ2EENameInfo();
        }
        return this.ivApplication;
    }

    public String getModule() {
        if (this.ivModule == null) {
            this.getJ2EENameInfo();
        }
        return this.ivModule;
    }

    public String getComponent() {
        if (this.ivComponent == null) {
            this.getJ2EENameInfo();
        }
        return this.ivComponent;
    }

    public String getPrimaryKeyString() {
        if (this.ivPrimaryKey == null && svOnServer) {
            try {
                TimerTaskHandler taskHandler = (TimerTaskHandler)this.getTaskHolder().getTargetRunnable();
                Serializable pkey = taskHandler.getPrimaryKey();
                if (pkey != null) {
                    this.ivPrimaryKey = pkey.toString();
                }
            }
            catch (Throwable th) {
                FFDCFilter.processException((Throwable)th, (String)"com.ibm.ejs.container.TimerTaskInfoImpl.getPrimaryKeyString", (String)"419", (Object)this);
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "getPrimaryKeyString: " + th);
                }
                this.ivPrimaryKey = "Not Available";
            }
        }
        return this.ivPrimaryKey;
    }

    public String getInfoString() {
        if (this.ivInfo == null && svOnServer) {
            try {
                TimerTaskHandler taskHandler = (TimerTaskHandler)this.getTaskHolder().getTargetRunnable();
                Serializable info = taskHandler.getInfo();
                if (info != null) {
                    this.ivInfo = info.toString();
                }
            }
            catch (Throwable th) {
                FFDCFilter.processException((Throwable)th, (String)"com.ibm.ejs.container.TimerTaskInfoImpl.getInfoString", (String)"459", (Object)this);
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "getInfoString: " + th);
                }
                this.ivInfo = "Not Available";
            }
        }
        return this.ivInfo;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "writeObject: " + this);
        }
        out.defaultWriteObject();
        out.write(EYECATCHER);
        out.writeShort(1);
        out.writeShort(1);
        out.writeObject(this.getApplication());
        out.writeObject(this.getModule());
        out.writeObject(this.getComponent());
        out.writeObject(this.getPrimaryKeyString());
        out.writeObject(this.getInfoString());
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "writeObject");
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "readObject");
        }
        in.defaultReadObject();
        byte[] eyeCatcher = new byte[EYECATCHER.length];
        int bytesRead = 0;
        for (int offset = 0; offset < EYECATCHER.length; offset += bytesRead) {
            bytesRead = in.read(eyeCatcher, offset, EYECATCHER.length - offset);
            if (bytesRead != -1) continue;
            throw new IOException("end of input stream while reading eye catcher");
        }
        for (int i = 0; i < EYECATCHER.length; ++i) {
            if (EYECATCHER[i] == eyeCatcher[i]) continue;
            String eyeCatcherString = new String(eyeCatcher);
            throw new IOException("Invalid eye catcher '" + eyeCatcherString + "' in TimerHandle input stream");
        }
        short incoming_platform = in.readShort();
        short incoming_vid = in.readShort();
        if (incoming_vid != 1) {
            throw new InvalidObjectException("EJB TimerTaskHandler data stream is not of the correct version, this client should be updated.");
        }
        this.ivApplication = (String)in.readObject();
        this.ivModule = (String)in.readObject();
        this.ivComponent = (String)in.readObject();
        this.ivPrimaryKey = (String)in.readObject();
        this.ivInfo = (String)in.readObject();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "readObject: " + this);
        }
    }

    private void getJ2EENameInfo() {
        block3: {
            this.ivApplication = "Not Available";
            this.ivModule = "Not Available";
            this.ivComponent = "Not Available";
            if (svOnServer) {
                try {
                    TimerTaskHandler taskHandler = (TimerTaskHandler)this.getTaskHolder().getTargetRunnable();
                    J2EEName j2eeName = taskHandler.getJ2EEName();
                    this.ivApplication = j2eeName.getApplication();
                    this.ivModule = j2eeName.getModule();
                    this.ivComponent = j2eeName.getComponent();
                }
                catch (Throwable th) {
                    FFDCFilter.processException((Throwable)th, (String)"com.ibm.ejs.container.TimerTaskInfoImpl.getJ2EENameInfo", (String)"613", (Object)this);
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block3;
                    Tr.debug(tc, "getJ2EENameInfo: " + th);
                }
            }
        }
    }

    public String toString() {
        if (TraceComponent.isAnyTracingEnabled() && (tc.isDebugEnabled() || tc.isEntryEnabled() || tc.isEventEnabled())) {
            if (svOnServer) {
                try {
                    return "TimerTaskInfoImpl(" + this.getTaskHolder().getTargetRunnable() + ") : " + super.toString();
                }
                catch (Throwable th) {
                    FFDCFilter.processException((Throwable)th, (String)"com.ibm.ejs.container.TimerTaskInfoImpl.toString", (String)"650", (Object)this);
                    return "TimerTaskInfoImpl(" + this.getApplication() + ", " + this.getModule() + ", " + this.getComponent() + ", " + this.getPrimaryKeyString() + ", " + this.getInfoString() + ") : " + super.toString();
                }
            }
            return "TimerTaskInfoImpl(" + this.ivApplication + ", " + this.ivModule + ", " + this.ivComponent + ", " + this.ivPrimaryKey + ", " + this.ivInfo + ") : " + super.toString();
        }
        return super.toString();
    }
}

