/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.container;

import com.ibm.ejs.container.BeanId;
import com.ibm.ejs.container.EJBNotFoundException;
import com.ibm.ejs.container.EJSContainer;
import com.ibm.ejs.container.EJSHome;
import com.ibm.ejs.container.TimedObjectWrapper;
import com.ibm.ejs.container.TimerHandleImpl;
import com.ibm.ejs.container.TimerImpl;
import com.ibm.ejs.container.TimerServiceException;
import com.ibm.ejs.container.util.ByteArray;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.util.dopriv.DeserializeObjectPrivileged;
import com.ibm.ejs.util.dopriv.SerializeObjectPrivileged;
import com.ibm.websphere.csi.J2EEName;
import com.ibm.websphere.scheduler.TaskStatus;
import com.ibm.ws.ejb.portable.Constants;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.scheduler.Runnable;
import com.ibm.ws.security.util.AccessController;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;

final class TimerTaskHandler
extends Runnable {
    private static final TraceComponent tc = Tr.register(TimerTaskHandler.class, "EJBContainer", "com.ibm.ejs.container.container");
    private static final String CLASS_NAME = "com.ibm.ejs.container.TimerTaskHandler";
    private static final long serialVersionUID = -8200752857441853748L;
    private static final byte[] EYECATCHER = Constants.TIMER_TASK_EYE_CATCHER;
    private static final short PLATFORM = 1;
    private static final short VERSION_ID = 1;
    private transient BeanId ivBeanId;
    private transient byte[] ivBeanIdBytes;
    private transient Serializable ivInfo;
    private transient byte[] ivInfoBytes;
    private transient TimerServiceException ivBeanIdException;
    private transient TimerServiceException ivInfoException;

    TimerTaskHandler(BeanId beanId, Serializable info) throws IOException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            String infoClassName = info == null ? null : info.getClass().getName();
            Tr.entry(tc, "<init>: " + beanId + ", " + infoClassName);
        }
        this.ivBeanId = beanId;
        this.ivBeanIdBytes = beanId.getByteArrayBytes();
        this.ivBeanIdException = null;
        this.ivInfo = info;
        this.ivInfoBytes = TimerTaskHandler.serializeObject(info);
        this.ivInfoException = null;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "<init>: " + this.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doWork() throws Throwable {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "doWork: " + this.ivBeanId);
        }
        if (this.ivBeanIdException != null || this.ivInfoException != null) {
            TimerServiceException exception = this.ivBeanIdException != null ? this.ivBeanIdException : this.ivInfoException;
            exception.fillInStackTrace();
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "doWork: " + exception);
            }
            throw exception;
        }
        EJSHome home = (EJSHome)this.ivBeanId.home;
        if (!home.enabled) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "doWork: home disabled - rebuilding beanId");
            }
            EJSContainer container2 = EJSContainer.getDefaultContainer();
            this.ivBeanId = BeanId.getBeanId(this.ivBeanId.getByteArray(), container2);
            home = (EJSHome)this.ivBeanId.home;
            if (!home.beanMetaData.isTimedObject) {
                Tr.warning(tc, "HOME_NOT_FOUND_CNTR0092W", this.ivBeanId.getJ2EEName());
                throw new EJBNotFoundException("Incompatible Application Change: " + this.ivBeanId.getJ2EEName() + " no longer implements TimedObject.");
            }
        }
        TaskStatus taskStatus = this.getTaskStatus();
        String taskId = taskStatus.getTaskId();
        int hashCode = taskStatus.hashCode();
        TimerImpl timer = new TimerImpl(this.ivBeanId, taskId, hashCode);
        TimedObjectWrapper timedObject = home.getTimedObjectWrapper(this.ivBeanId);
        try {
            timer.ivStatus = taskStatus;
            timedObject.ejbTimeout(timer);
            timer.ivStatus = null;
            Object var8_8 = null;
            home.putTimedObjectWrapper(timedObject);
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            home.putTimedObjectWrapper(timedObject);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "doWork: " + this.ivBeanId);
            }
            throw throwable;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "doWork: " + this.ivBeanId);
        }
    }

    public BeanId getTimedObjectId() throws TimerServiceException {
        if (this.ivBeanIdException != null) {
            this.ivBeanIdException.fillInStackTrace();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "getTimedObjectId: " + this.ivBeanIdException);
            }
            throw this.ivBeanIdException;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "getTimedObjectId: " + this.ivBeanId);
        }
        return this.ivBeanId;
    }

    public Serializable getInfo() throws TimerServiceException {
        if (this.ivInfoException != null) {
            this.ivInfoException.fillInStackTrace();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "getInfo: " + this.ivInfoException);
            }
            throw this.ivInfoException;
        }
        return this.ivInfo;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public J2EEName getJ2EEName() throws TimerServiceException, IllegalStateException {
        J2EEName j2eeName = null;
        if (this.ivBeanId != null) {
            j2eeName = this.ivBeanId.getJ2EEName();
            if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) return j2eeName;
            Tr.debug(tc, "getJ2EEName: BeanId: " + j2eeName);
            return j2eeName;
        } else if (this.ivBeanIdBytes != null) {
            try {
                byte[] j2eeNameBytes = BeanId.getJ2EENameBytes(this.ivBeanIdBytes);
                j2eeName = EJSContainer.getJ2EENameFactory().create(j2eeNameBytes);
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) return j2eeName;
                Tr.debug(tc, "getJ2EEName: BeanIdBytes: " + j2eeName);
                return j2eeName;
            }
            catch (Throwable th) {
                FFDCFilter.processException((Throwable)th, (String)"com.ibm.ejs.container.TimerTaskHandler.getJ2EEName", (String)"361", (Object)((Object)this));
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) throw new TimerServiceException("Failure deserializing TimedObject identity", th);
                Tr.debug(tc, "getJ2EEName: BeanIdBytes: " + th);
                throw new TimerServiceException("Failure deserializing TimedObject identity", th);
            }
        } else {
            if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) throw new IllegalStateException("TimedObject Identity not set.");
            Tr.debug(tc, "getJ2EEName: BeanId not set: IllegalStateException");
            throw new IllegalStateException("TimedObject Identity not set.");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Serializable getPrimaryKey() throws TimerServiceException, IllegalStateException {
        Serializable pkey = null;
        if (this.ivBeanId != null) {
            pkey = this.ivBeanId.getPrimaryKey();
            if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) return pkey;
            Tr.debug(tc, "getPrimaryKey: BeanId: " + pkey.toString());
            return pkey;
        } else if (this.ivBeanIdBytes != null) {
            try {
                pkey = BeanId.getPrimaryKey(this.ivBeanIdBytes);
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) return pkey;
                Tr.debug(tc, "getPrimaryKey: BeanIdBytes: " + pkey.toString());
                return pkey;
            }
            catch (Throwable th) {
                FFDCFilter.processException((Throwable)th, (String)"com.ibm.ejs.container.TimerTaskHandler.getPrimaryKey", (String)"437", (Object)((Object)this));
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) throw new TimerServiceException("Failure deserializing TimedObject identity", th);
                Tr.debug(tc, "getPrimaryKey: BeanIdBytes: " + th);
                throw new TimerServiceException("Failure deserializing TimedObject identity", th);
            }
        } else {
            if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) throw new IllegalStateException("TimedObject Identity not set.");
            Tr.debug(tc, "getPrimaryKey: BeanId not set: IllegalStateException");
            throw new IllegalStateException("TimedObject Identity not set.");
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "writeObject: " + (Object)((Object)this));
        }
        out.defaultWriteObject();
        out.write(EYECATCHER);
        out.writeShort(1);
        out.writeShort(1);
        out.writeObject(this.ivBeanIdBytes);
        out.writeObject(this.ivInfoBytes);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "writeObject");
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        block10: {
            block9: {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.entry(tc, "readObject");
                }
                in.defaultReadObject();
                byte[] eyeCatcher = new byte[EYECATCHER.length];
                int bytesRead = 0;
                for (int offset = 0; offset < EYECATCHER.length; offset += bytesRead) {
                    bytesRead = in.read(eyeCatcher, offset, EYECATCHER.length - offset);
                    if (bytesRead != -1) continue;
                    throw new IOException("end of input stream while reading eye catcher");
                }
                for (int i = 0; i < EYECATCHER.length; ++i) {
                    if (EYECATCHER[i] == eyeCatcher[i]) continue;
                    String eyeCatcherString = new String(eyeCatcher);
                    throw new IOException("Invalid eye catcher '" + eyeCatcherString + "' in TimerHandle input stream");
                }
                short incoming_platform = in.readShort();
                short incoming_vid = in.readShort();
                if (incoming_vid != 1) {
                    throw new InvalidObjectException("EJB TimerTaskHandler data stream is not of the correct version, this client should be updated.");
                }
                this.ivBeanIdBytes = (byte[])in.readObject();
                this.ivInfoBytes = (byte[])in.readObject();
                try {
                    ByteArray byteArray = new ByteArray(this.ivBeanIdBytes);
                    EJSContainer container2 = EJSContainer.getDefaultContainer();
                    this.ivBeanId = BeanId.getBeanId(byteArray, container2);
                }
                catch (Throwable th) {
                    FFDCFilter.processException((Throwable)th, (String)"com.ibm.ejs.container.TimerTaskHandler.readObject", (String)"567", (Object)((Object)this));
                    this.ivBeanIdException = new TimerServiceException("Failure deserializing TimedObject identity", th);
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block9;
                    Tr.debug(tc, "readObject: " + this.ivBeanIdException);
                }
            }
            try {
                this.ivInfo = (Serializable)TimerTaskHandler.deserializeObject(this.ivInfoBytes);
            }
            catch (Throwable th) {
                FFDCFilter.processException((Throwable)th, (String)"com.ibm.ejs.container.TimerTaskHandler.readObject", (String)"585", (Object)((Object)this));
                this.ivInfoException = new TimerServiceException("Failure deserializing TimedObject identity", th);
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block10;
                Tr.debug(tc, "readObject: " + this.ivInfoException);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "readObject: " + (Object)((Object)this));
        }
    }

    private static byte[] serializeObject(Object obj) throws IOException {
        if (obj == null) {
            return null;
        }
        SerializeObjectPrivileged sop = SerializeObjectPrivileged.getSerializeObjectPrivileged();
        sop.ivObjToSerialize = obj;
        try {
            AccessController.doPrivileged((PrivilegedExceptionAction)sop);
        }
        catch (PrivilegedActionException pae) {
            FFDCFilter.processException((Throwable)pae, (String)"com.ibm.ejs.container.TimerTaskHandler.serializeObject", (String)"642");
            IOException rootex = (IOException)pae.getException();
            throw rootex;
        }
        byte[] rtnObj = sop.ivSerializedObj;
        SerializeObjectPrivileged.releaseSerializeObjectPrivileged((SerializeObjectPrivileged)sop);
        return rtnObj;
    }

    private static Object deserializeObject(byte[] bytes) throws IOException, ClassNotFoundException {
        if (bytes == null) {
            return null;
        }
        Object rtnObj = null;
        DeserializeObjectPrivileged dop = DeserializeObjectPrivileged.getDeserializeObjectPrivileged();
        dop.ivBytesToDeserialize = bytes;
        try {
            rtnObj = AccessController.doPrivileged((PrivilegedExceptionAction)dop);
        }
        catch (PrivilegedActionException pae) {
            FFDCFilter.processException((Throwable)pae, (String)"com.ibm.ejs.container.TimerTaskHandler.deserializeObject", (String)"698");
            Exception rootex = pae.getException();
            if (rootex instanceof IOException) {
                throw (IOException)rootex;
            }
            throw (ClassNotFoundException)rootex;
        }
        DeserializeObjectPrivileged.releaseDeserializeObjectPrivileged((DeserializeObjectPrivileged)dop);
        return rtnObj;
    }

    public boolean equals(Object obj) {
        if (this.ivBeanIdException != null || this.ivInfoException != null) {
            TimerServiceException exception = this.ivBeanIdException != null ? this.ivBeanIdException : this.ivInfoException;
            exception.fillInStackTrace();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "equals: " + exception);
            }
            throw exception;
        }
        if (obj instanceof TimerHandleImpl && super.equals(obj)) {
            TimerTaskHandler taskHandler = (TimerTaskHandler)((Object)obj);
            if (this.ivBeanId.equals(taskHandler.ivBeanId) && this.ivInfo.equals(taskHandler.ivInfo)) {
                return true;
            }
        }
        return false;
    }

    public boolean equals(TimerTaskHandler taskHandler) {
        if (this.ivBeanIdException != null || this.ivInfoException != null) {
            TimerServiceException exception = this.ivBeanIdException != null ? this.ivBeanIdException : this.ivInfoException;
            exception.fillInStackTrace();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "equals: " + exception);
            }
            throw exception;
        }
        return super.equals((Object)taskHandler) && this.ivBeanId.equals(taskHandler.ivBeanId) && this.ivInfo.equals(taskHandler.ivInfo);
    }

    public int hashCode() {
        return super.hashCode();
    }

    public String toString() {
        String taskId = null;
        TaskStatus taskStatus = this.getTaskStatus();
        if (taskStatus != null) {
            taskId = taskStatus.getTaskId();
        }
        return "TimerTaskHandler(" + taskId + ", " + this.ivBeanId + ")";
    }
}

