/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.container;

import com.ibm.ejs.container.BeanId;
import com.ibm.ejs.container.TimeoutElement;
import com.ibm.ejs.container.activator.Activator;
import com.ibm.ejs.container.drs.SfDRSCache;
import com.ibm.ejs.container.passivator.StatefulPassivator;
import com.ibm.ejs.container.util.EJSPlatformHelper;
import com.ibm.ejs.ras.Dumpable;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.util.FastHashtable;
import com.ibm.ejs.util.am.AlarmListener;
import com.ibm.ejs.util.am.AlarmManager;
import com.ibm.websphere.csi.J2EEName;
import com.ibm.ws.ffdc.FFDCFilter;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.Iterator;

public final class StatefulBeanReaper
extends Thread
implements AlarmListener,
Dumpable {
    private static final TraceComponent tc = Tr.register(StatefulBeanReaper.class, "EJBCache", "com.ibm.ejs.container.container");
    private static final String CLASS_NAME = "com.ibm.ejs.container.StatefulBeanReaper";
    private long ivSweepInterval;
    private FastHashtable ivStatefulBeanList;
    private static final long DEFAULT_MIN_CLEANUP_INTERVAL = 60000L;
    private static final long DEFAULT_CLEANUP_INTERVAL = 4200000L;
    private static final long DEFAULT_SESSION_TIMEOUT = 300000L;
    private Activator ivActivator;
    private SfDRSCache ivSfDRSCache;
    protected boolean dumped = false;
    protected int numObjects = 0;
    protected int numAdds = 0;
    protected int numRemoves = 0;
    protected int numNullRemoves = 0;
    protected int numDeletes = 0;

    public StatefulBeanReaper(Activator a, int numBuckets, SfDRSCache drsCache) {
        this(a, numBuckets, 60000L, drsCache);
    }

    public StatefulBeanReaper(Activator a, int numBuckets, long cleanupInterval, SfDRSCache drsCache) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "<init>");
        }
        this.ivSweepInterval = EJSPlatformHelper.isZOS() && cleanupInterval == 0L ? 4200000L : (cleanupInterval < 60000L ? 60000L : cleanupInterval);
        this.setDaemon(true);
        this.setName("StatefulBeanReaper");
        this.ivStatefulBeanList = new FastHashtable(numBuckets);
        this.ivActivator = a;
        this.ivSfDRSCache = drsCache;
        Tr.registerDumpable(tc, this);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "<init> : sweep = " + this.ivSweepInterval + " ms");
        }
    }

    public void run() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "run");
        }
        if (this.ivSweepInterval >= 60000L) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "StatefulBeanReaper using Alarms");
            }
            AlarmManager.create((long)this.ivSweepInterval, (AlarmListener)this, null);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "run");
            }
            return;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "StatefulBeanReaper running as background thread");
        }
        while (true) {
            try {
                while (true) {
                    StatefulBeanReaper.sleep(this.ivSweepInterval);
                    this.sweep();
                }
            }
            catch (InterruptedException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ejs.container.StatefulBeanReaper.run", (String)"185", (Object)this);
                Tr.warning(tc, "STATEFUL_BEAN_REAPER_THREAD_INTERRUPTED_CNTR0014W", new Object[]{e});
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ejs.container.StatefulBeanReaper.run", (String)"192", (Object)this);
                Tr.warning(tc, "UNEXPECTED_EXCEPTION_DURING_STATEFUL_BEAN_CLEANUP_CNTR0015W", new Object[]{this, e});
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void alarm(Object alarmContext) {
        try {
            try {
                this.sweep();
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ejs.container.StatefulBeanReaper.alarm", (String)"226", (Object)this);
                Tr.warning(tc, "UNEXPECTED_EXCEPTION_DURING_STATEFUL_BEAN_CLEANUP_CNTR0015W", new Object[]{this, e});
                Object var4_3 = null;
                AlarmManager.create((long)this.ivSweepInterval, (AlarmListener)this, null);
                return;
            }
            Object var4_2 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            AlarmManager.create((long)this.ivSweepInterval, (AlarmListener)this, null);
            throw throwable;
        }
        AlarmManager.create((long)this.ivSweepInterval, (AlarmListener)this, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sweep() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "Sweep : Stateful Beans = " + this.ivStatefulBeanList.size());
        }
        Enumeration e = this.ivStatefulBeanList.elements();
        while (e.hasMoreElements()) {
            TimeoutElement elt;
            boolean tryToDelete = false;
            TimeoutElement timeoutElement = elt = (TimeoutElement)e.nextElement();
            synchronized (timeoutElement) {
                if (this.beanTimedOut(elt)) {
                    tryToDelete = true;
                }
            }
            if (!tryToDelete) continue;
            this.deleteBean(elt.beanId);
        }
        if (this.ivSfDRSCache != null) {
            this.ivSfDRSCache.sweep();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "Sweep : Stateful Beans = " + this.ivStatefulBeanList.size());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finalSweep(StatefulPassivator passivator) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "finalSweep : Stateful Beans = " + this.ivStatefulBeanList.size());
        }
        Enumeration e = this.ivStatefulBeanList.elements();
        while (e.hasMoreElements()) {
            TimeoutElement elt;
            TimeoutElement timeoutElement = elt = (TimeoutElement)e.nextElement();
            synchronized (timeoutElement) {
                if (elt.passivated) {
                    try {
                        if (this.remove(elt.beanId)) {
                            passivator.remove(elt.beanId, false);
                        }
                    }
                    catch (RemoteException ex) {
                        FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ejs.container.StatefulBeanReaper.finalSweep", (String)"298", (Object)this);
                        Tr.warning(tc, "REMOVE_FROM_PASSIVATION_STORE_FAILED_CNTR0016W", new Object[]{elt.beanId, ex});
                    }
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "finalSweep : Stateful Beans = " + this.ivStatefulBeanList.size());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean beanExistsAndTimedOut(BeanId beanId) {
        TimeoutElement elt = (TimeoutElement)this.ivStatefulBeanList.get((Object)beanId);
        if (elt == null) {
            if (this.ivSfDRSCache != null) {
                return this.ivSfDRSCache.beanExistsAndTimedOut(beanId);
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Session bean not in Reaper: Timeout = false");
            }
            return false;
        }
        TimeoutElement timeoutElement = elt;
        synchronized (timeoutElement) {
            return this.beanTimedOut(elt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean beanDoesNotExistOrHasTimedOut(BeanId beanId) {
        TimeoutElement elt = (TimeoutElement)this.ivStatefulBeanList.get((Object)beanId);
        if (elt == null) {
            if (this.ivSfDRSCache != null) {
                return this.ivSfDRSCache.beanDoesNotExistOrHasTimedOut(beanId);
            }
            return true;
        }
        TimeoutElement timeoutElement = elt;
        synchronized (timeoutElement) {
            return this.beanTimedOut(elt);
        }
    }

    private boolean beanTimedOut(TimeoutElement elt) {
        if (elt.timeout > 0L && System.currentTimeMillis() - elt.lastAccessTime >= elt.timeout) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Date currentTime = new Date(System.currentTimeMillis());
                Date lastAccessTime = new Date(elt.lastAccessTime);
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    Tr.event(tc, "Session bean timed out", "Current Time: " + currentTime.toString() + " Last Access Time: " + lastAccessTime.toString() + " Timeout: " + elt.timeout + " ms");
                }
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteBean(BeanId beanId) {
        block7: {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.entry(tc, "deleteBean " + beanId);
            }
            StatefulBeanReaper statefulBeanReaper = this;
            synchronized (statefulBeanReaper) {
                ++this.numDeletes;
            }
            try {
                this.ivActivator.timeoutBean(beanId);
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ejs.container.StatefulBeanReaper.deleteBean", (String)"367", (Object)this);
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block7;
                Tr.debug(tc, "Unable to timeout session bean");
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "deleteBean");
        }
    }

    public void add(BeanId id) {
        this.add(id, 300000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(BeanId id, long timeout) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "add " + id + ", " + timeout);
        }
        TimeoutElement elt = new TimeoutElement(id, timeout);
        Object obj = this.ivStatefulBeanList.put((Object)id, (Object)elt);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, obj != null ? "Stateful bean information replaced" : "Stateful bean information added");
        }
        this.setLastAccessTime(id);
        StatefulBeanReaper statefulBeanReaper = this;
        synchronized (statefulBeanReaper) {
            ++this.numObjects;
            ++this.numAdds;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "add");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(BeanId id) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "remove (" + id + ")");
        }
        TimeoutElement elt = null;
        elt = (TimeoutElement)this.ivStatefulBeanList.remove((Object)id);
        StatefulBeanReaper statefulBeanReaper = this;
        synchronized (statefulBeanReaper) {
            if (elt != null) {
                --this.numObjects;
                ++this.numRemoves;
            } else {
                ++this.numNullRemoves;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "remove (" + (elt != null) + ")");
        }
        return elt != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLastAccessTime(BeanId id) {
        TimeoutElement elt;
        TimeoutElement timeoutElement = elt = (TimeoutElement)this.ivStatefulBeanList.get((Object)id);
        synchronized (timeoutElement) {
            elt.lastAccessTime = System.currentTimeMillis();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLastAccessTime(BeanId id, long lastAccessTime) {
        TimeoutElement elt;
        TimeoutElement timeoutElement = elt = (TimeoutElement)this.ivStatefulBeanList.get((Object)id);
        synchronized (timeoutElement) {
            elt.lastAccessTime = lastAccessTime;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPassivated(BeanId id) {
        TimeoutElement elt;
        TimeoutElement timeoutElement = elt = (TimeoutElement)this.ivStatefulBeanList.get((Object)id);
        synchronized (timeoutElement) {
            elt.passivated = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setActive(BeanId id) {
        TimeoutElement elt;
        TimeoutElement timeoutElement = elt = (TimeoutElement)this.ivStatefulBeanList.get((Object)id);
        synchronized (timeoutElement) {
            elt.passivated = false;
        }
    }

    public synchronized Iterator getStatefulBeanIds(J2EEName homeName) {
        ArrayList<BeanId> beanList = new ArrayList<BeanId>();
        Enumeration e = this.ivStatefulBeanList.elements();
        while (e.hasMoreElements()) {
            TimeoutElement elt = (TimeoutElement)e.nextElement();
            if (!homeName.equals(elt.beanId.getJ2EEName()) || elt.passivated) continue;
            beanList.add(elt.beanId);
        }
        return beanList.iterator();
    }

    public synchronized Iterator getStatefulBeanIds() {
        ArrayList<BeanId> beanList = new ArrayList<BeanId>();
        Enumeration e = this.ivStatefulBeanList.elements();
        while (e.hasMoreElements()) {
            TimeoutElement elt = (TimeoutElement)e.nextElement();
            if (elt.passivated) continue;
            beanList.add(elt.beanId);
        }
        return beanList.iterator();
    }

    public synchronized Iterator getPassivatedStatefulBeanIds(J2EEName homeName) {
        ArrayList<BeanId> beanList = new ArrayList<BeanId>();
        Enumeration e = this.ivStatefulBeanList.elements();
        while (e.hasMoreElements()) {
            TimeoutElement elt = (TimeoutElement)e.nextElement();
            if (!homeName.equals(elt.beanId.getJ2EEName()) || !elt.passivated) continue;
            beanList.add(elt.beanId);
        }
        return beanList.iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getLastAccessTime(BeanId id) {
        TimeoutElement elt = (TimeoutElement)this.ivStatefulBeanList.get((Object)id);
        long lastAccessTime = 0L;
        TimeoutElement timeoutElement = elt;
        synchronized (timeoutElement) {
            lastAccessTime = elt.lastAccessTime;
        }
        return lastAccessTime;
    }

    public boolean beanExists(BeanId beanId) {
        TimeoutElement elt = (TimeoutElement)this.ivStatefulBeanList.get((Object)beanId);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, elt != null ? "Session bean is in Reaper" : "Session bean is not in Reaper");
        }
        return elt != null;
    }

    public long getBeanTimeoutTime(BeanId beanId) {
        TimeoutElement elt = (TimeoutElement)this.ivStatefulBeanList.get((Object)beanId);
        long timeoutTime = 0L;
        if (elt != null && elt.timeout != 0L) {
            timeoutTime = elt.lastAccessTime + elt.timeout;
        }
        return timeoutTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dump() {
        if (this.dumped) {
            return;
        }
        try {
            Tr.dump(tc, "-- StatefulBeanReaper Dump -- ", this);
            StatefulBeanReaper statefulBeanReaper = this;
            synchronized (statefulBeanReaper) {
                Tr.dump(tc, "Number of objects:      " + this.numObjects);
                Tr.dump(tc, "Number of adds:         " + this.numAdds);
                Tr.dump(tc, "Number of removes:      " + this.numRemoves);
                Tr.dump(tc, "Number of null removes: " + this.numNullRemoves);
                Tr.dump(tc, "Number of deletes:      " + this.numDeletes);
            }
            Object var4_3 = null;
            this.dumped = true;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.dumped = true;
            throw throwable;
        }
    }

    public void resetDump() {
        this.dumped = false;
    }
}

