/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.container;

import com.ibm.ejs.container.BeanId;
import com.ibm.ejs.container.BusinessRemoteWrapper;
import com.ibm.ejs.container.EJSContainer;
import com.ibm.ejs.container.EJSRemoteWrapper;
import com.ibm.ejs.container.WrapperId;
import com.ibm.ejs.container.WrapperInterface;
import com.ibm.ejs.container.util.ByteArray;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.wsspi.cluster.Identity;
import java.io.IOException;

public class EJSWrapperAccess {
    private static final String CLASS_NAME = EJSWrapperAccess.class.getName();
    private static final TraceComponent tc = Tr.register(CLASS_NAME, "ORB", "com.ibm.ejs.container.container");
    private static final ClassLoader svClassLoader = EJSWrapperAccess.class.getClassLoader();

    public static ClassLoader getClassLoader(EJSRemoteWrapper wrapper) {
        ClassLoader classLoader = null;
        classLoader = wrapper.bmd != null ? wrapper.bmd.classLoader : svClassLoader;
        return classLoader;
    }

    public static Identity getClusterIdentity(EJSRemoteWrapper wrapper) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getClusterIdentity", wrapper);
        }
        Identity retVal = null;
        if (wrapper != null) {
            retVal = wrapper.ivCluster;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getClusterIdentity", retVal);
        }
        return retVal;
    }

    public static com.ibm.ejs.util.ByteArray getServantKey(EJSRemoteWrapper wrapper) {
        com.ibm.ejs.util.ByteArray key = null;
        if (wrapper instanceof BusinessRemoteWrapper) {
            Class[] remoteClasses;
            int remoteIndex = 0;
            Class<?> thisClass = wrapper.getClass();
            for (Class remoteClass : remoteClasses = wrapper.bmd.ivBusinessRemoteImplClasses) {
                if (thisClass == remoteClass) break;
                ++remoteIndex;
            }
            key = new WrapperId(wrapper.beanId.getByteArrayBytes(), wrapper.bmd.ivBusinessRemoteInterfaceClasses[remoteIndex].getName(), remoteIndex);
        } else {
            key = wrapper.beanId.getByteArray();
        }
        return key;
    }

    public static boolean isServantKeyForHome(byte[] servantKey) throws IOException, ClassNotFoundException {
        ByteArray beanIdArray = null;
        if (servantKey[0] == -83) {
            WrapperId wrapperId = new WrapperId(servantKey);
            beanIdArray = wrapperId.getBeanIdArray();
        } else {
            beanIdArray = new ByteArray(servantKey);
        }
        BeanId beanId = BeanId.getBeanId(beanIdArray, EJSContainer.defaultContainer);
        return beanId.isHome();
    }

    public static boolean isSessionActivateTran(EJSRemoteWrapper wrapper) {
        if (wrapper.ivInterface == WrapperInterface.HOME) {
            return false;
        }
        return wrapper.bmd.sessionActivateTran;
    }

    public static boolean isStatefulSessionBean(EJSRemoteWrapper wrapper) {
        if (wrapper.ivInterface == WrapperInterface.HOME) {
            return false;
        }
        return wrapper.bmd.isStatefulSessionBean();
    }
}

