/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.container;

import com.ibm.ejs.container.BeanNotReentrantException;
import com.ibm.ejs.container.EJSDeployedSupport;
import com.ibm.ejs.container.ExceptionMappingStrategy;
import com.ibm.ejs.container.InvalidTransactionLocalException;
import com.ibm.ejs.container.util.ExceptionUtil;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.csi.CSIAccessException;
import com.ibm.websphere.csi.CSIActivityCompletedException;
import com.ibm.websphere.csi.CSIActivityRequiredException;
import com.ibm.websphere.csi.CSIException;
import com.ibm.websphere.csi.CSIInvalidActivityException;
import com.ibm.websphere.csi.CSIInvalidTransactionException;
import com.ibm.websphere.csi.CSINoSuchObjectException;
import com.ibm.websphere.csi.CSITransactionRequiredException;
import com.ibm.websphere.csi.CSITransactionRolledbackException;
import com.ibm.websphere.csi.ExceptionType;
import com.ibm.websphere.ejbcontainer.EJBStoppedException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.javax.activity.ActivityCompletedException;
import com.ibm.ws.javax.activity.ActivityRequiredException;
import com.ibm.ws.javax.activity.InvalidActivityException;
import com.ibm.ws.javax.ejb.ActivityCompletedLocalException;
import com.ibm.ws.javax.ejb.ActivityRequiredLocalException;
import com.ibm.ws.javax.ejb.InvalidActivityLocalException;
import java.rmi.AccessException;
import java.rmi.NoSuchObjectException;
import java.rmi.RemoteException;
import javax.ejb.ConcurrentAccessException;
import javax.ejb.EJBAccessException;
import javax.ejb.EJBException;
import javax.ejb.EJBTransactionRequiredException;
import javax.ejb.EJBTransactionRolledbackException;
import javax.ejb.NoSuchEJBException;
import javax.transaction.InvalidTransactionException;
import javax.transaction.TransactionRequiredException;
import javax.transaction.TransactionRolledbackException;

public class BusinessExceptionMappingStrategy
extends ExceptionMappingStrategy {
    private static final String CLASS_NAME = "com.ibm.ejs.container.BusinessExceptionMappingStrategy";
    protected static TraceComponent tc = Tr.register("com.ibm.ejs.container.BusinessExceptionMappingStrategy", "EJBContainer", "com.ibm.ejs.container.container");

    public BusinessExceptionMappingStrategy(EJSDeployedSupport wrapper) {
        super(wrapper);
    }

    private EJBException mapCSIException(CSIException ex, Exception causeEx, Throwable cause) {
        EJBException ejbex;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "mapCSIException: " + ex + ", cause = " + cause);
        }
        boolean createdEx = true;
        String message = ExceptionUtil.getBaseMessage(ex);
        if (ex instanceof CSITransactionRolledbackException) {
            ejbex = new EJBTransactionRolledbackException(message, causeEx);
        } else if (ex instanceof CSIAccessException) {
            ejbex = new EJBAccessException(message);
        } else if (ex instanceof CSIInvalidTransactionException) {
            ejbex = new InvalidTransactionLocalException(message, causeEx);
        } else if (ex instanceof CSINoSuchObjectException) {
            ejbex = new NoSuchEJBException(message, causeEx);
        } else if (ex instanceof CSITransactionRequiredException) {
            ejbex = new EJBTransactionRequiredException(message);
        } else if (ex instanceof CSIInvalidActivityException) {
            ejbex = new InvalidActivityLocalException(message, causeEx);
        } else if (ex instanceof CSIActivityRequiredException) {
            ejbex = new ActivityRequiredLocalException(message, causeEx);
        } else if (ex instanceof CSIActivityCompletedException) {
            ejbex = new ActivityCompletedLocalException(message, causeEx);
        } else {
            ejbex = ExceptionUtil.EJBException(message, causeEx);
            if (causeEx != null) {
                createdEx = false;
            }
        }
        if (createdEx) {
            if (causeEx == null) {
                ejbex.setStackTrace(ex.getStackTrace());
            } else {
                ejbex.initCause(cause);
                ejbex.setStackTrace(new StackTraceElement[0]);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "mapCSIException returning: " + ejbex);
        }
        return ejbex;
    }

    private EJBException mapException(Throwable ex) {
        EJBException ejbex;
        boolean createdEx = true;
        Exception causeEx = null;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "mapException: " + ex);
        }
        String message = ExceptionUtil.getBaseMessage(ex);
        Throwable cause = ExceptionUtil.findCause(ex);
        if (cause != null) {
            if (cause instanceof Exception) {
                causeEx = (Exception)cause;
            } else {
                causeEx = new Exception("See nested Throwable", cause);
                causeEx.setStackTrace(new StackTraceElement[0]);
            }
        }
        if (ex instanceof CSIException) {
            ejbex = this.mapCSIException((CSIException)ex, causeEx, cause);
            createdEx = false;
        } else if (ex instanceof NoSuchObjectException) {
            ejbex = new NoSuchEJBException(message, causeEx);
        } else if (ex instanceof EJBStoppedException) {
            cause = ex;
            causeEx = (Exception)ex;
            ejbex = new NoSuchEJBException((String)null, causeEx);
        } else if (ex instanceof TransactionRequiredException) {
            ejbex = new EJBTransactionRequiredException(message);
        } else if (ex instanceof TransactionRolledbackException) {
            ejbex = new EJBTransactionRolledbackException(message, causeEx);
        } else if (ex instanceof InvalidTransactionException) {
            ejbex = new InvalidTransactionLocalException(message, causeEx);
        } else if (ex instanceof AccessException) {
            ejbex = new EJBAccessException(message);
        } else if (ex instanceof ActivityRequiredException) {
            ejbex = new ActivityRequiredLocalException(message, causeEx);
        } else if (ex instanceof InvalidActivityException) {
            ejbex = new InvalidActivityLocalException(message, causeEx);
        } else if (ex instanceof ActivityCompletedException) {
            ejbex = new ActivityCompletedLocalException(message, causeEx);
        } else if (ex instanceof BeanNotReentrantException) {
            ejbex = new ConcurrentAccessException(message, causeEx);
        } else {
            ejbex = ExceptionUtil.EJBException(ex);
            createdEx = false;
        }
        if (createdEx) {
            if (causeEx != null) {
                ejbex.initCause(cause);
                ejbex.setStackTrace(new StackTraceElement[0]);
            } else {
                ejbex.setStackTrace(ex.getStackTrace());
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "mapException returning: " + ejbex);
        }
        return ejbex;
    }

    public final Throwable setUncheckedException(Throwable ex) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "setUncheckedException:" + ex);
        }
        if (this.ivException != null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event(tc, "setting unchecked exception again", ex);
                Tr.event(tc, "original exception", this.ivException);
            }
            return this.ivException;
        }
        Boolean applicationExceptionRollback = null;
        if (ex instanceof Exception && !(ex instanceof RemoteException)) {
            applicationExceptionRollback = this.getApplicationExceptionRollback(ex);
        }
        if (applicationExceptionRollback != null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event(tc, "ApplicationException with rollback set to true, changing to a checked exception", ex);
            }
            this.exType = ExceptionType.CHECKED_EXCEPTION;
            this.ivException = ex;
            this.root = ex;
            if (applicationExceptionRollback == Boolean.TRUE) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    Tr.event(tc, "ApplicationException with rollback set to true, setting rollback only", ex);
                }
                this.thisStrategiesOwner.currentTx.setRollbackOnly();
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "setUncheckedException returning: " + this.ivException);
            }
            return this.ivException;
        }
        if (this.thisStrategiesOwner.preInvokeException && (ex instanceof NoSuchObjectException || ex instanceof EJBStoppedException || ex instanceof CSIAccessException || ex instanceof BeanNotReentrantException)) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception should not cause rollback, changing to checked exception");
            }
            if (ex instanceof BeanNotReentrantException) {
                this.thisStrategiesOwner.beanO = null;
            }
            this.exType = ExceptionType.CHECKED_EXCEPTION;
        } else {
            this.exType = ExceptionType.UNCHECKED_EXCEPTION;
            ExceptionUtil.logException(tc, ex, this.thisStrategiesOwner.getEJBMethodInfo(), this.thisStrategiesOwner.getBeanO());
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ejs.container.BusinessExceptionMappingStrategy.setUncheckedException", (String)"506", (Object)this);
        }
        this.root = this.findRootCause(ex);
        this.ivException = this.mapException(ex);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "setUncheckedException returning: " + this.ivException);
        }
        return this.ivException;
    }

    public Exception mapCSITransactionRolledBackException(CSITransactionRolledbackException ex) throws CSIException {
        Throwable cause = null;
        Exception causeEx = null;
        if (this.exType == ExceptionType.UNCHECKED_EXCEPTION) {
            cause = this.ivException;
        } else {
            cause = ExceptionUtil.findCause(ex);
            if (cause == null) {
                cause = this.ivException;
            }
        }
        if (cause != null) {
            if (cause instanceof Exception) {
                causeEx = (Exception)cause;
            } else {
                causeEx = new Exception("See nested Throwable", cause);
                causeEx.setStackTrace(new StackTraceElement[0]);
            }
        }
        EJBException mappedEx = this.mapCSIException(ex, causeEx, cause);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "mapped exception = " + mappedEx);
        }
        return mappedEx;
    }
}

