/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.dtfjview.commands.infocommands;

import com.ibm.dtfj.image.CorruptData;
import com.ibm.dtfj.image.CorruptDataException;
import com.ibm.dtfj.image.DTFJException;
import com.ibm.dtfj.image.DataUnavailable;
import com.ibm.dtfj.image.Image;
import com.ibm.dtfj.image.ImageAddressSpace;
import com.ibm.dtfj.image.ImageProcess;
import com.ibm.dtfj.image.ImageRegister;
import com.ibm.dtfj.image.ImageSection;
import com.ibm.dtfj.image.ImageStackFrame;
import com.ibm.dtfj.image.ImageThread;
import com.ibm.dtfj.java.JavaLocation;
import com.ibm.dtfj.java.JavaMonitor;
import com.ibm.dtfj.java.JavaObject;
import com.ibm.dtfj.java.JavaRuntime;
import com.ibm.dtfj.java.JavaStackFrame;
import com.ibm.dtfj.java.JavaThread;
import com.ibm.dtfj.runtime.ManagedRuntime;
import com.ibm.jvm.dtfjview.Output;
import com.ibm.jvm.dtfjview.commands.Command;
import com.ibm.jvm.dtfjview.commands.helpers.Exceptions;
import com.ibm.jvm.dtfjview.commands.helpers.MonitorState;
import com.ibm.jvm.dtfjview.commands.helpers.StateToString;
import com.ibm.jvm.dtfjview.commands.helpers.ThreadData;
import com.ibm.jvm.dtfjview.commands.helpers.Utils;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Stack;

public class InfoThreadCommand
extends Command {
    private int pointerSize;

    public InfoThreadCommand(Output o) {
        super(o, "thread", "displays information about Java and native threads", "parameters: none, \"*\", or thread name\n\nprints the following information about the current thread, all threads, or the specified thread, respectively:\n - thread id\n - registers\n - stack sections\n - thread frames: procedure name and base pointer\n - the thread properties\n - associated Java thread (if applicable):\n  - name of Java thread\n  - address of associated java.lang.Thread object\n  - current state according to JVMTI specification\n  - current state relative to java.lang.Thread.State\n  - the Java thread priority\n  - the monitor the thread is waiting to enter or waiting on notify\n  - thread frames: base pointer, method, and filename:line\n");
        this.child_commands = null;
    }

    public void doCommand(Stack args, Image loadedImage, HashMap properties) {
        if (args.isEmpty()) {
            String id;
            ImageAddressSpace ias = (ImageAddressSpace)properties.get("current_address_space");
            try {
                ImageThread it = ias.getCurrentProcess().getCurrentThread();
                if (null == it) {
                    this.out.print("\n\tNo current (failing) thread, try specifying a native thread ID or '*'\n");
                    ImageProcess ip = ias.getCurrentProcess();
                    if (ip != null) {
                        this.printThreadSummary(ip, this.out);
                    }
                    return;
                }
                id = it.getID();
            }
            catch (CorruptDataException e) {
                this.out.error("exception encountered while getting information about current thread");
                return;
            }
            args.push(id);
        }
        String param = (String)args.pop();
        if (!args.isEmpty()) {
            this.out.error("\"info thread\" takes at most one parameter, which, if specified, must be a thread ID or \"*\"");
            return;
        }
        if (param.equals("*")) {
            this.out.print("\n");
            this.printAddressSpaceInfo(loadedImage, this.out, null, this.getJavaThreads(loadedImage, null));
            this.out.print("\n");
        } else {
            this.out.print("\n");
            this.printAddressSpaceInfo(loadedImage, this.out, param, this.getJavaThreads(loadedImage, param));
            this.out.print("\n");
        }
    }

    private void printAddressSpaceInfo(Image loadedImage, Output out, String id, Map threads) {
        int asnum = 0;
        Iterator itAddressSpace = loadedImage.getAddressSpaces();
        while (itAddressSpace.hasNext()) {
            ImageAddressSpace ias = (ImageAddressSpace)itAddressSpace.next();
            out.print("\n\tnative threads for address space # " + asnum + "\n");
            this.printProcessInfo(ias, out, id, threads);
            ++asnum;
        }
        if (!threads.isEmpty()) {
            out.print("\n\tJava threads not associated with known native threads:\n\n");
            ArrayList ta = (ArrayList)threads.remove(null);
            if (ta != null) {
                for (int i = 0; i < ta.size(); ++i) {
                    ThreadData td = (ThreadData)ta.get(i);
                    this.printJavaThreadInfo(out, td.getThread(), this.getMonitors(td.getRuntime()));
                }
            }
        }
    }

    private void printProcessInfo(ImageAddressSpace ias, Output out, String id, Map threads) {
        boolean found = false;
        Iterator itProcess = ias.getProcesses();
        while (itProcess.hasNext()) {
            ImageProcess ip = (ImageProcess)itProcess.next();
            this.pointerSize = ip.getPointerSize();
            out.print("\t process id: ");
            try {
                out.print(ip.getID());
            }
            catch (DataUnavailable d) {
                out.print(Exceptions.getDataUnavailableString());
            }
            catch (CorruptDataException e) {
                out.print(Exceptions.getCorruptDataExceptionString());
            }
            out.print("\n\n");
            found = this.printThreadInfo(ip, out, id, threads);
        }
        if (!found) {
            out.print("\t no native threads found with specified id\n");
        }
    }

    private boolean printThreadInfo(ImageProcess ip, Output out, String id, Map threads) {
        boolean found = false;
        Iterator itThread = ip.getThreads();
        while (itThread.hasNext()) {
            String currID;
            Object next = itThread.next();
            if (next instanceof CorruptData) continue;
            ImageThread it = (ImageThread)next;
            try {
                currID = it.getID();
            }
            catch (CorruptDataException e) {
                currID = null;
            }
            if (null != id && !id.equals(currID)) continue;
            out.print("\t  thread id: ");
            out.print(currID);
            out.print("\n");
            this.printRegisters(it);
            out.print("\t   stack sections:");
            out.print("\n");
            Iterator itStackSection = it.getStackSections();
            while (itStackSection.hasNext()) {
                Object nextStackSection = itStackSection.next();
                if (nextStackSection instanceof CorruptData) {
                    out.print("\t    " + Exceptions.getCorruptDataExceptionString() + "\n");
                    continue;
                }
                ImageSection is = (ImageSection)nextStackSection;
                this.printStackSection(is);
            }
            this.printStackFrameInfo(it, out);
            out.print("\t   properties:");
            out.print("\n");
            this.printProperties(it, out);
            out.print("\n");
            out.print("\t   associated Java thread: ");
            ThreadData td = (ThreadData)threads.remove(currID);
            if (null != td) {
                out.print("\n");
                this.printJavaThreadInfo(out, td.getThread(), this.getMonitors(td.getRuntime()));
            } else {
                out.print("<no associated Java thread>\n");
            }
            out.print("\n");
            found = true;
        }
        return found;
    }

    public void printRegisters(ImageThread it) {
        this.out.print("\t   registers:");
        this.out.print("\n");
        int count = 0;
        Iterator itImageRegister = it.getRegisters();
        while (itImageRegister.hasNext()) {
            if (count % 4 == 0) {
                if (0 != count) {
                    this.out.print("\n");
                }
                this.out.print("\t    ");
            }
            ImageRegister ir = (ImageRegister)itImageRegister.next();
            this.printRegisterInfo(ir);
            ++count;
        }
        this.out.print("\n");
    }

    public void printRegisterInfo(ImageRegister ir) {
        this.out.print(Utils.padWithSpaces(ir.getName(), 8) + " = ");
        try {
            this.out.print(this.toAdjustedHex(ir.getValue().longValue()));
        }
        catch (CorruptDataException e) {
            this.out.print(Exceptions.getCorruptDataExceptionString());
        }
        this.out.print("   ");
    }

    public void printStackSection(ImageSection is) {
        long startAddr = is.getBaseAddress().getAddress();
        long size = is.getSize();
        long endAddr = startAddr + size;
        this.out.print("\t    ");
        this.out.print(Utils.toHex(startAddr));
        this.out.print(" to ");
        this.out.print(Utils.toHex(endAddr));
        this.out.print(" (length ");
        this.out.print(Utils.toHex(size));
        this.out.print(")\n");
    }

    private void printStackFrameInfo(ImageThread it, Output out) {
        Iterator itStackFrame;
        try {
            itStackFrame = it.getStackFrames();
        }
        catch (DataUnavailable d) {
            out.print("\t   error with stack frames: " + Exceptions.getDataUnavailableString() + "\n");
            return;
        }
        out.print("\t   stack frames:");
        out.print("\n");
        while (itStackFrame.hasNext()) {
            ImageStackFrame isf = (ImageStackFrame)itStackFrame.next();
            out.print("\t    bp: ");
            try {
                out.print(this.toAdjustedHex(isf.getBasePointer().getAddress()));
            }
            catch (CorruptDataException e) {
                out.print(Exceptions.getCorruptDataExceptionString());
            }
            out.print(" pc: ");
            try {
                out.print(this.toAdjustedHex(isf.getProcedureAddress().getAddress()));
            }
            catch (CorruptDataException e) {
                out.print(Exceptions.getCorruptDataExceptionString());
            }
            out.print(" ");
            try {
                out.print(isf.getProcedureName());
            }
            catch (CorruptDataException e) {
                out.print(Exceptions.getCorruptDataExceptionString());
            }
            out.print("\n");
        }
    }

    private Map getJavaThreads(Image loadedImage, String id) {
        Iterator itRuntime = Utils.getRuntimes(loadedImage);
        HashMap<String, Object> threads = new HashMap<String, Object>();
        while (itRuntime.hasNext()) {
            ManagedRuntime mr = (ManagedRuntime)itRuntime.next();
            if (!(mr instanceof JavaRuntime)) continue;
            JavaRuntime jr = (JavaRuntime)mr;
            Iterator itThread = jr.getThreads();
            while (itThread.hasNext()) {
                String currID;
                JavaThread jt = (JavaThread)itThread.next();
                try {
                    ImageThread it = jt.getImageThread();
                    currID = it.getID();
                }
                catch (DTFJException e) {
                    currID = null;
                }
                if (null == id) {
                    if (null == currID) {
                        ArrayList<ThreadData> ta;
                        if (threads.containsKey(null)) {
                            ta = (ArrayList<ThreadData>)threads.get(null);
                            ta.add(new ThreadData(jt, jr));
                            continue;
                        }
                        ta = new ArrayList<ThreadData>(1);
                        ta.add(new ThreadData(jt, jr));
                        threads.put(null, ta);
                        continue;
                    }
                    threads.put(currID, new ThreadData(jt, jr));
                    continue;
                }
                if (!id.equals(currID)) continue;
                threads.put(currID, new ThreadData(jt, jr));
            }
        }
        return threads;
    }

    private Map getMonitors(JavaRuntime jr) {
        HashMap<JavaThread, MonitorState> monitors = new HashMap<JavaThread, MonitorState>();
        Iterator itMonitor = jr.getMonitors();
        while (itMonitor.hasNext()) {
            JavaMonitor jm = (JavaMonitor)itMonitor.next();
            Iterator itEnterWaiter = jm.getEnterWaiters();
            while (itEnterWaiter.hasNext()) {
                JavaThread jt = (JavaThread)itEnterWaiter.next();
                monitors.put(jt, new MonitorState(jm, MonitorState.WAITING_TO_ENTER));
            }
            Iterator itNotifyWaiter = jm.getNotifyWaiters();
            while (itNotifyWaiter.hasNext()) {
                JavaThread jt = (JavaThread)itNotifyWaiter.next();
                monitors.put(jt, new MonitorState(jm, MonitorState.WAITING_TO_BE_NOTIFIED_ON));
            }
        }
        return monitors;
    }

    private void printJavaThreadInfo(Output out, JavaThread jt, Map monitors) {
        out.print("\t    name:          ");
        try {
            out.print(jt.getName());
        }
        catch (CorruptDataException e) {
            out.print(Exceptions.getCorruptDataExceptionString());
        }
        out.print("\n");
        out.print("\t    Thread object: ");
        try {
            JavaObject threadObj = jt.getObject();
            if (null == threadObj) {
                out.print("<no associated Thread object>");
            } else {
                out.print(Utils.toHex(threadObj.getID().getAddress()));
            }
        }
        catch (CorruptDataException cde) {
            out.print(Exceptions.getCorruptDataExceptionString());
        }
        out.print("\n");
        out.print("\t    JVMTI state:   ");
        try {
            out.print(StateToString.getJVMTIStateString(jt.getState()));
        }
        catch (CorruptDataException cde) {
            out.print(Exceptions.getCorruptDataExceptionString());
        }
        out.print("\n");
        out.print("\t    Thread.State:  ");
        try {
            out.print(StateToString.getThreadStateString(jt.getState()));
        }
        catch (CorruptDataException cde) {
            out.print(Exceptions.getCorruptDataExceptionString());
        }
        out.print("\n");
        out.print("\t    Priority:      ");
        try {
            Integer pri = new Integer(jt.getPriority());
            out.print(pri.toString());
        }
        catch (CorruptDataException e) {
            out.print(Exceptions.getCorruptDataExceptionString());
        }
        out.print("\n");
        out.print("\t    monitor:       ");
        MonitorState ms = (MonitorState)monitors.get(jt);
        if (null == ms) {
            out.print("<no associated monitor>");
        } else {
            try {
                String name = ms.getMonitor().getName();
                if (name.equals("")) {
                    name = "<unnamed>";
                }
                out.print(ms.getStatusString() + " \"" + name + "\"");
            }
            catch (CorruptDataException cde) {
                out.print(Exceptions.getCorruptDataExceptionString());
            }
            JavaObject jo = ms.getMonitor().getObject();
            if (null == jo) {
                out.print(" with ID ");
                out.print("<unavailable>");
            } else {
                out.print(" with object ");
                out.print(Utils.toHex(jo.getID().getAddress()));
            }
        }
        out.print("\n");
        out.print("\t    thread frames: ");
        this.printJavaStackFrameInfo(jt, out);
        out.print("\n");
    }

    private void printJavaStackFrameInfo(JavaThread jt, Output out) {
        Iterator itStackFrame = jt.getStackFrames();
        if (!itStackFrame.hasNext()) {
            out.print("<no frames to print>\n");
            return;
        }
        out.print("\n");
        while (itStackFrame.hasNext()) {
            JavaLocation jl;
            Object next = itStackFrame.next();
            if (next instanceof CorruptData) {
                out.print("\t     " + Exceptions.getCorruptDataExceptionString() + "\n");
                return;
            }
            JavaStackFrame jsf = (JavaStackFrame)next;
            try {
                jl = jsf.getLocation();
            }
            catch (CorruptDataException e) {
                out.print("\t     " + Exceptions.getCorruptDataExceptionString() + "\n");
                return;
            }
            out.print("\t     bp: ");
            try {
                out.print(this.toAdjustedHex(jsf.getBasePointer().getAddress()));
            }
            catch (CorruptDataException e) {
                out.print(Exceptions.getCorruptDataExceptionString());
            }
            out.print("    method: ");
            try {
                String signature = jl.getMethod().getSignature();
                out.print(Utils.getReturnValueName(signature) + " " + jl.getMethod().getDeclaringClass().getName() + "." + jl.getMethod().getName() + Utils.getMethodSignatureName(signature));
            }
            catch (CorruptDataException e) {
                out.print(Exceptions.getCorruptDataExceptionString());
            }
            catch (DataUnavailable e) {
                out.print(Exceptions.getDataUnavailableString());
            }
            out.print("    filename:line: ");
            try {
                out.print(jl.getFilename());
            }
            catch (DataUnavailable d) {
                out.print(Exceptions.getDataUnavailableString());
            }
            catch (CorruptDataException e) {
                out.print(Exceptions.getCorruptDataExceptionString());
            }
            out.print(":");
            try {
                out.print(Integer.toString(jl.getLineNumber()));
            }
            catch (DataUnavailable d) {
                out.print(Exceptions.getDataUnavailableString());
            }
            catch (CorruptDataException e) {
                out.print(Exceptions.getCorruptDataExceptionString());
            }
            out.print("\n");
        }
    }

    private String toAdjustedHex(long l) {
        if (this.pointerSize > 32) {
            return "0x" + Utils.toFixedWidthHex(l);
        }
        if (31 == this.pointerSize) {
            return "0x" + Utils.toFixedWidthHex((int)(l & (1L << this.pointerSize) - 1L));
        }
        return "0x" + Utils.toFixedWidthHex((int)l);
    }

    private void printThreadSummary(ImageProcess ip, Output out) {
        int count = 0;
        Iterator itThread = ip.getThreads();
        while (itThread.hasNext()) {
            Object next = itThread.next();
            if (next instanceof CorruptData) continue;
            ImageThread it = (ImageThread)next;
            if (count % 8 == 0) {
                if (0 == count) {
                    out.print("\n\n\tNative thread IDs for current process:");
                }
                out.print("\n\t ");
            }
            try {
                out.print(Utils.padWithSpaces(it.getID(), 8));
            }
            catch (CorruptDataException e) {
                out.print(Exceptions.getCorruptDataExceptionString());
            }
            ++count;
        }
        out.print("\n");
    }

    private void printProperties(ImageThread it, Output out) {
        Properties jtp = it.getProperties();
        Enumeration<?> keys = jtp.propertyNames();
        while (keys.hasMoreElements()) {
            String propertyKey = keys.nextElement().toString();
            out.print("\t    " + propertyKey + ": " + jtp.getProperty(propertyKey));
            out.print("\n");
        }
    }
}

