/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.dtfjview.commands.infocommands;

import com.ibm.dtfj.image.CorruptDataException;
import com.ibm.dtfj.image.DataUnavailable;
import com.ibm.dtfj.image.Image;
import com.ibm.dtfj.runtime.ManagedRuntime;
import com.ibm.jvm.dtfjview.Output;
import com.ibm.jvm.dtfjview.commands.Command;
import com.ibm.jvm.dtfjview.commands.helpers.Utils;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Stack;

public class InfoSystemCommand
extends Command {
    public InfoSystemCommand(Output o) {
        super(o, "system", "displays information about the system the core dump is from", "parameters: none\n\nprints the following information about the system the core dump is from:\n  - operating system\n  - amount of memory\n  - virtual machine(s) present\n");
        this.child_commands = null;
    }

    public void doCommand(Stack args, Image loadedImage, HashMap properties) {
        if (!args.isEmpty()) {
            this.out.error("\"info system\" command does not take any parameters");
        } else {
            Iterator itRuntime = Utils.getRuntimes(loadedImage);
            String output = "";
            try {
                output = output + "\nSystem:\t\t";
                output = output + loadedImage.getSystemType() + "\n";
                output = output + "System Memory:\t";
                output = output + loadedImage.getInstalledMemory() + " bytes\n";
                output = output + "Virtual Machine(s):\n";
                int count = 1;
                while (itRuntime.hasNext()) {
                    ManagedRuntime mr = (ManagedRuntime)itRuntime.next();
                    output = output + "\tRuntime #" + count + ":\n\t\t";
                    StringBuffer version = new StringBuffer(mr.getVersion());
                    version.insert(version.indexOf("IBM J9 VM"), "\t\t");
                    version.insert(version.indexOf("J9VM "), "\t\t");
                    version.insert(version.indexOf("JIT  "), "\t\t");
                    version.insert(version.indexOf("GC   "), "\t\t");
                    if (version.indexOf("RT   ") > 0) {
                        version.insert(version.indexOf("RT   "), "\t\t");
                    }
                    output = output + version + "\n";
                    ++count;
                }
            }
            catch (DataUnavailable d) {
            }
            catch (CorruptDataException e) {
                // empty catch block
            }
            if (!output.equals("")) {
                this.out.println(output);
            } else {
                this.out.error("error occurred while processing \"info system\"");
            }
        }
    }
}

