/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.dtfjview.commands;

import com.ibm.dtfj.image.CorruptDataException;
import com.ibm.dtfj.image.DataUnavailable;
import com.ibm.dtfj.image.Image;
import com.ibm.dtfj.image.ImageSection;
import com.ibm.dtfj.java.JavaClass;
import com.ibm.dtfj.java.JavaHeap;
import com.ibm.dtfj.java.JavaMethod;
import com.ibm.dtfj.java.JavaObject;
import com.ibm.dtfj.java.JavaRuntime;
import com.ibm.dtfj.runtime.ManagedRuntime;
import com.ibm.jvm.dtfjview.Output;
import com.ibm.jvm.dtfjview.commands.Command;
import com.ibm.jvm.dtfjview.commands.helpers.Utils;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Stack;

public class WhatisCommand
extends Command {
    public WhatisCommand(Output o) {
        super(o, "whatis", "gives information about what is stored at the given memory address", "parameters: <hex_address>\n\nthe whatis command examines the memory location at <hex_address> and tries to find out more information about this address - for example whether it is within an object in a heap or within the byte codes associated with a class method.");
        this.child_commands = null;
    }

    public void doCommand(Stack args, Image loadedImage, HashMap systemProperties) {
        if (0 == args.size()) {
            this.out.error("missing address argument");
            return;
        }
        String address = (String)args.pop();
        Long lAddressInDecimal = Utils.longFromString(address);
        if (null == lAddressInDecimal) {
            this.out.error("cannot convert \"" + address + "\" to numeric value");
            return;
        }
        long addressInDecimal = lAddressInDecimal;
        this.findInImage(loadedImage, addressInDecimal);
        this.out.print("\n");
    }

    private void findInImage(Image loadedImage, long address) {
        Iterator itRuntime = Utils.getRuntimes(loadedImage);
        int count = 1;
        this.out.print("\n");
        while (itRuntime.hasNext()) {
            ManagedRuntime mr = (ManagedRuntime)itRuntime.next();
            if (mr instanceof JavaRuntime) {
                this.out.print("\truntime #" + count + "\n");
                this.findInRuntime((JavaRuntime)mr, address);
            }
            ++count;
        }
    }

    private void findInRuntime(JavaRuntime jr, long address) {
        Iterator itHeap = jr.getHeaps();
        int count = 1;
        while (itHeap.hasNext()) {
            JavaHeap jh = (JavaHeap)itHeap.next();
            this.out.print("\t  heap #" + count + " - name: ");
            this.out.print(jh.getName() + "\n");
            this.findInHeap(jh, address);
            ++count;
        }
    }

    private void findInHeap(JavaHeap jh, long address) {
        if (this.isWithinImageSections(jh.getSections(), null, false, address)) {
            if (!this.isStartOfObj(jh.getObjects(), address) && !this.isWithinObjectRange(jh.getObjects(), address)) {
                this.out.print("\t\t0x" + Long.toHexString(address) + " is orphaned on the heap.\n");
            }
        } else {
            this.out.print("\t\t0x" + Long.toHexString(address) + " is not within this heap.\n");
            long bound = 12L;
            this.checkClassInRange(jh.getObjects(), bound, address);
        }
        this.checkMethodInRange(jh.getObjects(), address);
    }

    private void checkMethodInRange(Iterator objects, long address) {
        while (objects.hasNext()) {
            JavaClass jClass;
            JavaObject jObject = (JavaObject)objects.next();
            try {
                jClass = jObject.getJavaClass();
            }
            catch (CorruptDataException cde) {
                continue;
            }
            Iterator methods = jClass.getDeclaredMethods();
            while (methods.hasNext()) {
                JavaMethod jMethod = (JavaMethod)methods.next();
                Iterator bytecodeSections = jMethod.getBytecodeSections();
                Iterator compiledSections = jMethod.getCompiledSections();
                this.isWithinImageSections(bytecodeSections, jMethod, false, address);
                this.isWithinImageSections(compiledSections, jMethod, true, address);
            }
        }
    }

    private void checkClassInRange(Iterator objects, long bound, long address) {
        while (objects.hasNext()) {
            String className;
            JavaClass jClass;
            JavaObject jObject = (JavaObject)objects.next();
            try {
                jClass = jObject.getJavaClass();
                className = jClass.getName();
            }
            catch (CorruptDataException cde) {
                continue;
            }
            long startAddress = jClass.getID().getAddress();
            long endAddress = startAddress + bound;
            if (address == startAddress) {
                this.out.print("0x" + Long.toHexString(address) + " is the address of the java/lang/Class object for " + className);
                return;
            }
            if (!this.isWithinRange(startAddress, endAddress, address)) continue;
            this.out.print("0x" + Long.toHexString(address) + " is within the java/lang/Class object for " + className);
            return;
        }
    }

    private boolean isWithinObjectRange(Iterator objects, long address) {
        while (objects.hasNext()) {
            long endAddress;
            long startAddress;
            String className;
            JavaObject jObject = (JavaObject)objects.next();
            try {
                className = jObject.getJavaClass().getName();
                startAddress = jObject.getID().getAddress();
                endAddress = startAddress + jObject.getSize();
            }
            catch (CorruptDataException cde) {
                continue;
            }
            if (!this.isWithinRange(startAddress, endAddress, address)) continue;
            this.out.print("\t\t0x" + Long.toHexString(address) + " is within an object on the heap:\n" + "\t\t\toffset " + (address - startAddress) + " within " + className + " instance @ 0x" + Long.toHexString(startAddress) + "\n");
            return true;
        }
        return false;
    }

    private boolean isWithinRange(long startAddress, long endAddress, long address) {
        return address <= endAddress && address > startAddress;
    }

    private boolean isStartOfObj(Iterator objects, long address) {
        while (objects.hasNext()) {
            String className;
            JavaObject jObject = (JavaObject)objects.next();
            if (address != jObject.getID().getAddress()) continue;
            try {
                className = jObject.getJavaClass().getName();
            }
            catch (CorruptDataException cde) {
                className = "N/A (CorruptDataException occurred)";
            }
            this.out.print("0x" + Long.toHexString(address) + " is start of an object of type " + className);
            return true;
        }
        return false;
    }

    private boolean isWithinImageSections(Iterator heapImageSections, Object memType, boolean isMethodCompiled, long address) {
        while (heapImageSections.hasNext()) {
            long size;
            ImageSection imageSection = (ImageSection)heapImageSections.next();
            long baseAddress = imageSection.getBaseAddress().getAddress();
            long endAddress = baseAddress + (size = imageSection.getSize());
            if (address > endAddress || address < baseAddress) continue;
            if (null == memType) {
                this.out.print("\t\t0x" + Long.toHexString(address) + " is within heap segment: " + Long.toHexString(baseAddress) + " -- " + Long.toHexString(endAddress) + "\n");
                return true;
            }
            if (!(memType instanceof JavaMethod)) continue;
            String methodName = "N/A";
            String methodSig = "N/A";
            String className = "N/A";
            try {
                methodName = ((JavaMethod)memType).getName();
                methodSig = ((JavaMethod)memType).getSignature();
                className = ((JavaMethod)memType).getDeclaringClass().getName();
            }
            catch (CorruptDataException cde) {
            }
            catch (DataUnavailable du) {
                // empty catch block
            }
            String codeType = isMethodCompiled ? "compiled code" : "byte code";
            this.out.print("0x" + Long.toHexString(address) + " is within the " + codeType + " range: " + Long.toHexString(baseAddress) + " -- " + Long.toHexString(endAddress) + "\n\t" + "...of method " + methodName + " with signature " + methodSig + "\n\t" + "...in class " + className + "\n");
            return true;
        }
        return false;
    }
}

