/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import tcl.lang.ClassRep;
import tcl.lang.Command;
import tcl.lang.FieldSig;
import tcl.lang.FuncSig;
import tcl.lang.Interp;
import tcl.lang.ReflectObject;
import tcl.lang.TclException;
import tcl.lang.TclIndex;
import tcl.lang.TclList;
import tcl.lang.TclNumArgsException;
import tcl.lang.TclObject;
import tcl.lang.TclString;
import tcl.lang.reflect.PkgInvoker;

class JavaInfoCmd
implements Command {
    private static final String[] validCmds = new String[]{"class", "baseclass", "dimensions", "events", "fields", "methods", "constructors", "properties", "superclass"};
    private static final int CLASS = 0;
    private static final int BASECLASS = 1;
    private static final int DIMENSIONS = 2;
    private static final int EVENTS = 3;
    private static final int FIELDS = 4;
    private static final int METHODS = 5;
    private static final int CONSTRUCTORS = 6;
    private static final int PROPERTIES = 7;
    private static final int SUPERCLASS = 8;
    private static final String[] propOpts = new String[]{"-type"};
    private static final String[] methOpts = new String[]{"-type", "-static"};
    static final int TYPE_OPT = 0;
    static final int STATIC_OPT = 1;

    JavaInfoCmd() {
    }

    /*
     * Unable to fully structure code
     */
    public void cmdProc(Interp interp, TclObject[] argv) throws TclException {
        lastArg = argv.length - 1;
        statOpt = false;
        typeOpt = false;
        if (argv.length < 2) {
            throw new TclNumArgsException(interp, 1, argv, "option ?arg arg ...?");
        }
        opt = TclIndex.get(interp, argv[1], JavaInfoCmd.validCmds, "option", 0);
        switch (opt) {
            case 1: {
                if (argv.length != 3) {
                    throw new TclNumArgsException(interp, 2, argv, "objOrClass");
                }
                c = JavaInfoCmd.getClassFromObj(interp, argv[2]);
                if (c != null) {
                    interp.setResult(JavaInfoCmd.getBaseNameFromClass(c));
                }
                return;
            }
            case 0: {
                if (argv.length != 3) {
                    throw new TclNumArgsException(interp, 2, argv, "javaObj");
                }
                c = ReflectObject.getClass(interp, argv[2]);
                if (c != null) {
                    interp.setResult(JavaInfoCmd.getNameFromClass(c));
                }
                return;
            }
            case 2: {
                if (argv.length != 3) {
                    throw new TclNumArgsException(interp, 2, argv, "objOrClass");
                }
                c = JavaInfoCmd.getClassFromObj(interp, argv[2]);
                if (c == null) {
                    interp.setResult(0);
                } else {
                    interp.setResult(JavaInfoCmd.getNumDimsFromClass(c));
                }
                return;
            }
            case 3: {
                if (argv.length != 3) {
                    throw new TclNumArgsException(interp, 2, argv, "javaObj");
                }
                c = JavaInfoCmd.getClassFromObj(interp, argv[2]);
                if (c == null) {
                    interp.resetResult();
                    return;
                }
                if (!PkgInvoker.isAccessible(c)) {
                    throw new TclException(interp, "Class \"" + c.getName() + "\" is not accessible");
                }
                try {
                    beanInfo = Introspector.getBeanInfo(c);
                }
                catch (IntrospectionException e) {
                    ** GOTO lbl53
                }
                events = beanInfo.getEventSetDescriptors();
                if (events != null) {
                    list = TclList.newInstance();
                    for (i = 0; i < events.length; ++i) {
                        TclList.append(interp, list, TclString.newInstance(events[i].getListenerType().getName()));
                    }
                    interp.setResult(list);
                    return;
                }
lbl53:
                // 3 sources

                interp.resetResult();
                return;
            }
            case 4: {
                if (lastArg < 2 || lastArg > 4) {
                    throw new TclNumArgsException(interp, 2, argv, "?-type? ?-static? objOrClass");
                }
                block22: for (i = 2; i < lastArg; ++i) {
                    opt = TclIndex.get(interp, argv[i], JavaInfoCmd.methOpts, "option", 0);
                    switch (opt) {
                        case 1: {
                            statOpt = true;
                            continue block22;
                        }
                        case 0: {
                            typeOpt = true;
                        }
                    }
                }
                c = JavaInfoCmd.getClassFromObj(interp, argv[lastArg]);
                if (c != null) {
                    if (!PkgInvoker.isAccessible(c)) {
                        throw new TclException(interp, "Class \"" + c.getName() + "\" is not accessible");
                    }
                    resultListObj = JavaInfoCmd.getFieldInfoList(interp, c, statOpt, typeOpt);
                    interp.setResult(resultListObj);
                }
                return;
            }
            case 5: {
                if (lastArg < 2 || lastArg > 4) {
                    throw new TclNumArgsException(interp, 2, argv, "?-type? ?-static? objOrClass");
                }
                block23: for (i = 2; i < lastArg; ++i) {
                    opt = TclIndex.get(interp, argv[i], JavaInfoCmd.methOpts, "option", 0);
                    switch (opt) {
                        case 1: {
                            statOpt = true;
                            continue block23;
                        }
                        case 0: {
                            typeOpt = true;
                        }
                    }
                }
                c = JavaInfoCmd.getClassFromObj(interp, argv[lastArg]);
                if (c != null) {
                    if (!PkgInvoker.isAccessible(c)) {
                        throw new TclException(interp, "Class \"" + c.getName() + "\" is not accessible");
                    }
                    resultListObj = JavaInfoCmd.getMethodInfoList(interp, c, statOpt, typeOpt);
                    interp.setResult(resultListObj);
                }
                return;
            }
            case 6: {
                if (argv.length != 3) {
                    throw new TclNumArgsException(interp, 2, argv, "objOrClass");
                }
                c = JavaInfoCmd.getClassFromObj(interp, argv[lastArg]);
                if (c != null) {
                    if (!PkgInvoker.isAccessible(c)) {
                        throw new TclException(interp, "Class \"" + c.getName() + "\" is not accessible");
                    }
                    resultListObj = JavaInfoCmd.getConstructorInfoList(interp, c);
                    interp.setResult(resultListObj);
                }
                return;
            }
            case 7: {
                if (lastArg < 2 || lastArg > 3) {
                    throw new TclNumArgsException(interp, 2, argv, "?-type? objOrClass");
                }
                if (lastArg == 3) {
                    opt = TclIndex.get(interp, argv[2], JavaInfoCmd.propOpts, "option", 0);
                    typeOpt = true;
                }
                if ((c = JavaInfoCmd.getClassFromObj(interp, argv[lastArg])) != null) {
                    if (!PkgInvoker.isAccessible(c)) {
                        throw new TclException(interp, "Class \"" + c.getName() + "\" is not accessible");
                    }
                    resultListObj = JavaInfoCmd.getPropInfoList(interp, c, typeOpt);
                    interp.setResult(resultListObj);
                }
                return;
            }
            case 8: {
                if (argv.length != 3) {
                    throw new TclNumArgsException(interp, 2, argv, "objOrClass");
                }
                c = JavaInfoCmd.getClassFromObj(interp, argv[2]);
                interp.resetResult();
                if (c != null && (c = c.getSuperclass()) != null) {
                    interp.setResult(JavaInfoCmd.getNameFromClass(c));
                }
                return;
            }
        }
    }

    private static Class getClassFromObj(Interp interp, TclObject objOrClass) throws TclException {
        Class c;
        try {
            c = ReflectObject.getClass(interp, objOrClass);
        }
        catch (TclException e) {
            try {
                c = ClassRep.get(interp, objOrClass);
            }
            catch (TclException e2) {
                throw new TclException(interp, "unknown java class or object \"" + objOrClass + "\"");
            }
        }
        return c;
    }

    private static TclObject getPropInfoList(Interp interp, Class c, boolean typeOpt) throws TclException {
        BeanInfo beaninfo;
        try {
            beaninfo = Introspector.getBeanInfo(c);
        }
        catch (IntrospectionException e) {
            throw new TclException(interp, e.toString());
        }
        PropertyDescriptor[] propDesc = null;
        propDesc = beaninfo.getPropertyDescriptors();
        TclObject resultListObj = TclList.newInstance();
        for (int i = 0; i < propDesc.length; ++i) {
            TclObject elementObj;
            TclObject pairObj = TclList.newInstance();
            if (typeOpt && (elementObj = TclString.newInstance(propDesc[i].getPropertyType().getName())) != null) {
                TclList.append(interp, pairObj, elementObj);
            }
            elementObj = TclString.newInstance(propDesc[i].getName());
            TclList.append(interp, pairObj, elementObj);
            TclList.append(interp, resultListObj, pairObj);
        }
        return resultListObj;
    }

    private static TclObject getFieldInfoList(Interp interp, Class c, boolean statOpt, boolean typeOpt) throws TclException {
        Field[] fieldArray = FieldSig.getAccessibleFields(c);
        TclObject resultListObj = TclList.newInstance();
        for (int f = 0; f < fieldArray.length; ++f) {
            boolean isStatic;
            boolean bl = isStatic = (fieldArray[f].getModifiers() & 8) > 0;
            if (isStatic != statOpt) continue;
            TclObject sigObj = TclList.newInstance();
            String fieldName = fieldArray[f].getName();
            TclObject elementObj = TclString.newInstance(fieldName);
            TclList.append(interp, sigObj, elementObj);
            Class<?> declClass = fieldArray[f].getDeclaringClass();
            if (!declClass.equals(c)) {
                for (int i = 0; i < fieldArray.length; ++i) {
                    Class<?> tmpClass;
                    if (i == f || !fieldName.equals(fieldArray[i].getName()) || !declClass.isAssignableFrom(tmpClass = fieldArray[i].getDeclaringClass())) continue;
                    elementObj = TclString.newInstance(declClass.getName());
                    TclList.append(interp, sigObj, elementObj);
                    break;
                }
            }
            if (typeOpt) {
                TclObject pairObj = TclList.newInstance();
                elementObj = TclString.newInstance(JavaInfoCmd.getNameFromClass(fieldArray[f].getType()));
                TclList.append(interp, pairObj, elementObj);
                TclList.append(interp, pairObj, sigObj);
                TclList.append(interp, resultListObj, pairObj);
                continue;
            }
            TclList.append(interp, resultListObj, sigObj);
        }
        return resultListObj;
    }

    private static TclObject getMethodInfoList(Interp interp, Class c, boolean statOpt, boolean typeOpt) throws TclException {
        Method[] methodArray = statOpt ? FuncSig.getAccessibleStaticMethods(c) : FuncSig.getAccessibleInstanceMethods(c);
        TclObject resultListObj = TclList.newInstance();
        for (int m = 0; m < methodArray.length; ++m) {
            TclObject sigObj = TclList.newInstance();
            TclObject elementObj = TclString.newInstance(methodArray[m].getName());
            TclList.append(interp, sigObj, elementObj);
            Class<?>[] paramArray = methodArray[m].getParameterTypes();
            for (int p = 0; p < paramArray.length; ++p) {
                elementObj = TclString.newInstance(JavaInfoCmd.getNameFromClass(paramArray[p]));
                TclList.append(interp, sigObj, elementObj);
            }
            if (typeOpt) {
                TclObject sublist = TclList.newInstance();
                TclObject exceptions2 = TclList.newInstance();
                Class<?>[] ex = methodArray[m].getExceptionTypes();
                for (int i = 0; i < ex.length; ++i) {
                    TclList.append(interp, exceptions2, TclString.newInstance(ex[i].getName()));
                }
                TclList.append(interp, sublist, TclString.newInstance(JavaInfoCmd.getNameFromClass(methodArray[m].getReturnType())));
                TclList.append(interp, sublist, sigObj);
                TclList.append(interp, sublist, exceptions2);
                TclList.append(interp, resultListObj, sublist);
                continue;
            }
            TclList.append(interp, resultListObj, sigObj);
        }
        return resultListObj;
    }

    private static TclObject getConstructorInfoList(Interp interp, Class c) throws TclException {
        Constructor[] constructorArray = FuncSig.getAccessibleConstructors(c);
        TclObject resultListObj = TclList.newInstance();
        for (int m = 0; m < constructorArray.length; ++m) {
            TclObject sigObj = TclList.newInstance();
            TclObject elementObj = TclString.newInstance(constructorArray[m].getName());
            TclList.append(interp, sigObj, elementObj);
            Class<?>[] paramArray = constructorArray[m].getParameterTypes();
            for (int p = 0; p < paramArray.length; ++p) {
                elementObj = TclString.newInstance(JavaInfoCmd.getNameFromClass(paramArray[p]));
                TclList.append(interp, sigObj, elementObj);
            }
            TclList.append(interp, resultListObj, sigObj);
        }
        return resultListObj;
    }

    static int getNumDimsFromClass(Class type) {
        int dim = 0;
        while (type.isArray()) {
            type = type.getComponentType();
            ++dim;
        }
        return dim;
    }

    static String getNameFromClass(Class type) {
        StringBuffer name = new StringBuffer();
        while (type.isArray()) {
            name.append("[]");
            type = type.getComponentType();
        }
        name.insert(0, type.getName());
        return name.toString();
    }

    private static String getBaseNameFromClass(Class type) {
        while (type.isArray()) {
            type = type.getComponentType();
        }
        return type.getName();
    }
}

