/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.internal.emf.resource;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import org.apache.xml.serializer.OutputPropertiesFactory;
import org.apache.xml.serializer.Serializer;
import org.apache.xml.serializer.SerializerFactory;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.wst.common.internal.emf.resource.AbstractRendererImpl;
import org.eclipse.wst.common.internal.emf.resource.EMF2SAXDocumentHandler;
import org.eclipse.wst.common.internal.emf.resource.EMF2SAXWriter;
import org.eclipse.wst.common.internal.emf.resource.EntityWidget;
import org.eclipse.wst.common.internal.emf.resource.TranslatorResourceImpl;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;

public class EMF2SAXRenderer
extends AbstractRendererImpl {
    public static final String CONFIG_WTP_LOGGER = "com.ibm.config.eclipse.wtp";
    public static Logger logger = Logger.getLogger("com.ibm.config.eclipse.wtp");
    public static final String CLASS_NAME = EMF2SAXRenderer.class.getName();
    public static final String SYSTEM_ID_OPTION = "org.eclipse.wst.common.internal.emf.resource.systemIdOption";
    public static final String SERIALIZER_CLASS_NAME = "org.apache.xml.serializer.SerializerFactory";

    public int getVersionID() {
        return this.getResource().getVersionID();
    }

    public void doLoad(InputStream in, Map options) {
        String methodName = "doLoad";
        logger.entering(CLASS_NAME, methodName);
        try {
            XMLReader reader = this.createReader(in, options);
            InputSource inputSource = new InputSource(in);
            URI useSystemURI = EMF2SAXRenderer.getSystemId(options);
            logger.logp(Level.FINER, CLASS_NAME, methodName, "Parsing with system ID [ {0} ]", new Object[]{useSystemURI});
            if (useSystemURI != null) {
                inputSource.setSystemId(useSystemURI.toString());
            }
            reader.parse(inputSource);
        }
        catch (RuntimeException t_rex) {
            String message = "Parse exception for [ " + TranslatorResourceImpl.getResourceMessage(this.getResource()) + " ]" + " [ " + t_rex + " ]";
            logger.warning(message);
            logger.exiting(CLASS_NAME, methodName);
            throw t_rex;
        }
        catch (Exception ex) {
            String message = "Parse exception for [ " + TranslatorResourceImpl.getResourceMessage(this.getResource()) + " ]" + " [ " + ex + " ]";
            logger.warning(message);
            logger.exiting(CLASS_NAME, methodName);
            throw new WrappedException(ex);
        }
        logger.exiting(CLASS_NAME, methodName);
    }

    public static Map addURI(Map options, URI uri) {
        HashMap newOptions = new HashMap();
        if (options != null) {
            for (Object nextKey : options.keySet()) {
                Object nextValue = options.get(nextKey);
                newOptions.put(nextKey, nextValue);
            }
        }
        newOptions.put(SYSTEM_ID_OPTION, EntityWidget.createLocalArchiveURI(uri));
        return newOptions;
    }

    public static URI getSystemId(Map options) {
        if (options == null) {
            return null;
        }
        return (URI)options.get(SYSTEM_ID_OPTION);
    }

    protected XMLReader createReader(InputStream in, Map options) throws ParserConfigurationException, SAXException {
        String methodName = "createReader";
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setValidating(this.isValidating());
        logger.logp(Level.FINER, CLASS_NAME, methodName, "Factory Property [ {0} ] - Value [ {1} ]", new Object[]{"Validating", this.isValidating() ? "true" : "false"});
        factory.setNamespaceAware(true);
        logger.logp(Level.FINER, CLASS_NAME, methodName, "Factory Property [ {0} ] - Value [ {1} ]", new Object[]{"NamespaceAware", "true"});
        SAXParser parser2 = factory.newSAXParser();
        XMLReader reader = parser2.getXMLReader();
        EMF2SAXDocumentHandler handler = new EMF2SAXDocumentHandler(this.getResource());
        logger.logp(Level.FINER, CLASS_NAME, methodName, "Handler [ {0} ]", handler);
        this.setFeature(reader, "http://xml.org/sax/features/validation", this.isValidating());
        this.setFeature(reader, "http://xml.org/sax/features/namespace-prefixes", true);
        if (!this.setFeature(reader, "http://apache.org/xml/features/validation/schema", this.isValidating())) {
            logger.warning("Disabling validation");
            this.setFeature(reader, "http://xml.org/sax/features/validation", false);
        }
        this.setFeature(reader, "http://apache.org/xml/features/allow-java-encodings", true);
        reader.setContentHandler(handler);
        reader.setErrorHandler(handler);
        reader.setEntityResolver(handler);
        return reader;
    }

    protected boolean setFeature(XMLReader reader, String featureName, boolean featureValue) throws SAXNotSupportedException {
        String methodName = "setFeature";
        logger.logp(Level.FINER, CLASS_NAME, methodName, "Name [ {0} ] - Value [ {1} ]", new Object[]{featureName, new Boolean(featureValue)});
        try {
            reader.setFeature(featureName, featureValue);
            return true;
        }
        catch (SAXNotRecognizedException snre) {
            String message = "Ignoring feature exeception [ " + snre + " ]" + " on feature [ " + featureName + " ]" + " for [ " + TranslatorResourceImpl.getResourceMessage(this.getResource()) + " ]";
            logger.warning(message);
            return false;
        }
    }

    public void doSave(OutputStream outputStream, Map options) throws IOException {
        String methodName = "doSave";
        logger.logp(Level.FINER, CLASS_NAME, methodName, "ENTRY");
        try {
            ContentHandler handler = null;
            try {
                handler = this.createHandler(outputStream);
            }
            catch (TransformerConfigurationException e) {
                logger.logp(Level.WARNING, CLASS_NAME, methodName, "Ignoring exception [ {0} ]", e);
                logger.throwing(CLASS_NAME, methodName, e);
            }
            catch (TransformerFactoryConfigurationError e) {
                logger.logp(Level.WARNING, CLASS_NAME, methodName, "Ignoring exception [ {0} ]", e);
                logger.throwing(CLASS_NAME, methodName, e);
            }
            if (handler == null) {
                logger.logp(Level.SEVERE, CLASS_NAME, methodName, "Null transformer handler; serialization has been skipped.");
                return;
            }
            EMF2SAXWriter writer = new EMF2SAXWriter();
            writer.serialize(this.resource, handler);
        }
        catch (SAXException saxe) {
            throw new WrappedException(saxe);
        }
        logger.logp(Level.FINER, CLASS_NAME, methodName, "RETURN");
    }

    protected ContentHandler createHandler(OutputStream outputStream) throws TransformerConfigurationException, IOException {
        String methodName = "createHandler";
        logger.logp(Level.FINER, CLASS_NAME, methodName, "ENTRY");
        if (this.shouldUseSerializer()) {
            logger.logp(Level.FINER, CLASS_NAME, methodName, "Serializer Case");
            Properties properties = OutputPropertiesFactory.getDefaultMethodProperties((String)"xml");
            this.setOutputProperty(properties, "indent", "yes");
            this.setOutputProperty(properties, "encoding", this.getResource().getEncoding());
            this.setOutputProperty(properties, "version", this.getResource().getXMLVersion());
            this.setOutputProperty(properties, "method", "xml");
            this.setOutputProperty(properties, "omit-xml-declaration", "no");
            this.setOutputProperty(properties, "{http://xml.apache.org/xalan}indent-amount", "4");
            if (this.getResource().getPublicId() != null) {
                this.setOutputProperty(properties, "doctype-public", this.getResource().getPublicId());
            }
            if (this.getResource().getSystemId() != null) {
                this.setOutputProperty(properties, "doctype-system", this.getResource().getSystemId());
            }
            Serializer serializer = SerializerFactory.getSerializer((Properties)properties);
            serializer.setOutputStream(outputStream);
            ContentHandler handler = serializer.asContentHandler();
            logger.logp(Level.FINER, CLASS_NAME, methodName, "RETURN");
            return handler;
        }
        logger.logp(Level.FINER, CLASS_NAME, methodName, "Transformer Case");
        SAXTransformerFactory factory = (SAXTransformerFactory)TransformerFactory.newInstance();
        TransformerHandler handler = factory.newTransformerHandler();
        handler.setResult(new StreamResult(outputStream));
        Transformer transformer = handler.getTransformer();
        this.setOutputProperty(transformer, "indent", "yes");
        this.setOutputProperty(transformer, "encoding", this.getResource().getEncoding());
        this.setOutputProperty(transformer, "version", this.getResource().getXMLVersion());
        this.setOutputProperty(transformer, "method", "xml");
        this.setOutputProperty(transformer, "omit-xml-declaration", "no");
        this.setOutputProperty(transformer, "{http://xml.apache.org/xslt}indent-amount", "4");
        if (this.getResource().getPublicId() != null) {
            this.setOutputProperty(transformer, "doctype-public", this.getResource().getPublicId());
        }
        if (this.getResource().getSystemId() != null) {
            this.setOutputProperty(transformer, "doctype-system", this.getResource().getSystemId());
        }
        logger.logp(Level.FINER, CLASS_NAME, methodName, "RETURN");
        return handler;
    }

    protected void setOutputProperty(Transformer transformer, String key, String value) {
        logger.logp(Level.FINER, CLASS_NAME, "setOutputProperty", "Key [ {0} ] Value [ {1} ]", new Object[]{key, value});
        transformer.setOutputProperty(key, value);
    }

    protected boolean shouldUseSerializer() {
        String methodName = "shouldUseSerializer";
        logger.logp(Level.FINER, CLASS_NAME, methodName, "ENTRY");
        if (this.getResource().getPublicId() == null && this.getResource().getSystemId() == null) {
            logger.logp(Level.FINER, CLASS_NAME, methodName, "RETURN [ false ] - No Public ID and no System ID");
            return false;
        }
        boolean result = this.canLoad(SERIALIZER_CLASS_NAME);
        logger.logp(Level.FINER, CLASS_NAME, methodName, "RETURN [ {0} ]", new Boolean(result));
        return result;
    }

    protected boolean canLoad(String className) {
        String methodName = "canLoad";
        try {
            EMF2SAXRenderer.class.getClassLoader().loadClass(SERIALIZER_CLASS_NAME);
        }
        catch (ClassNotFoundException e) {
            logger.logp(Level.FINER, className, methodName, "ENTRY / RETURN [ false ] - Class [ {0} ] was not found", SERIALIZER_CLASS_NAME);
            return false;
        }
        logger.logp(Level.FINER, className, methodName, "ENTRY / RETURN [ true ] - Class [ {0} ] was found", SERIALIZER_CLASS_NAME);
        return true;
    }

    protected void setOutputProperty(Properties properties, String key, String value) {
        logger.logp(Level.FINER, CLASS_NAME, "setOutputProperty", "Key [ {0} ] Value [ {1} ]", new Object[]{key, value});
        properties.setProperty(key, value);
    }

    protected void handleTransformException(Throwable th) {
        String message = "Ignoring transform exeception [ " + th + " ]" + " for [ " + TranslatorResourceImpl.getResourceMessage(this.getResource()) + " ]";
        logger.warning(message);
    }

    public void prepareToAddContents() {
    }
}

