/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.webapplication.internal.impl;

import org.eclipse.emf.common.util.URI;
import org.eclipse.jst.j2ee.common.internal.impl.XMLResourceImpl;
import org.eclipse.jst.j2ee.internal.model.translator.webapplication.WebAppTranslator;
import org.eclipse.jst.j2ee.webapplication.WebApp;
import org.eclipse.jst.j2ee.webapplication.WebAppResource;
import org.eclipse.wst.common.internal.emf.resource.J2EESchemaUtility;
import org.eclipse.wst.common.internal.emf.resource.Renderer;
import org.eclipse.wst.common.internal.emf.resource.Translator;

public class WebAppResourceImpl
extends XMLResourceImpl
implements WebAppResource {
    public static final String CLASS_NAME = WebAppResourceImpl.class.getName();

    public WebAppResourceImpl(URI uri, Renderer aRenderer) {
        super(uri, aRenderer);
    }

    public WebAppResourceImpl(Renderer aRenderer) {
        super(aRenderer);
    }

    public WebApp getWebApp() {
        return (WebApp)this.getRootObject();
    }

    public Translator getRootTranslator() {
        return WebAppTranslator.INSTANCE;
    }

    public int getType() {
        return 4;
    }

    public String getJ2EE_1_2_PublicID() {
        return "-//Sun Microsystems, Inc.//DTD Web Application 2.2//EN";
    }

    public String getJ2EE_1_2_SystemID() {
        return "http://java.sun.com/j2ee/dtds/web-app_2_2.dtd";
    }

    public String getJ2EE_Alt_1_2_SystemID() {
        return "http://java.sun.com/j2ee/dtds/web-app_2.2.dtd";
    }

    public String getJ2EE_1_3_PublicID() {
        return "-//Sun Microsystems, Inc.//DTD Web Application 2.3//EN";
    }

    public String getJ2EE_1_3_SystemID() {
        return "http://java.sun.com/dtd/web-app_2_3.dtd";
    }

    public String getJ2EE_Alt_1_3_SystemID() {
        return "http://java.sun.com/dtd/web-app_2.3.dtd";
    }

    public boolean isWeb2_2() {
        return this.getModuleVersionID() == 22;
    }

    public boolean isWeb2_3() {
        return this.getModuleVersionID() == 23;
    }

    public boolean isWeb2_4() {
        return this.getModuleVersionID() == 24;
    }

    public String getDoctype() {
        int j2eeVersionId = this.getJ2EEVersionID();
        if (j2eeVersionId == 12) {
            return "web-app";
        }
        if (j2eeVersionId == 13) {
            return "web-app";
        }
        return null;
    }

    public int getJ2EEVersionID() {
        int moduleVersionId = this.getModuleVersionID();
        if (moduleVersionId == 22) {
            return 12;
        }
        if (moduleVersionId == 23) {
            return 13;
        }
        if (moduleVersionId == 24) {
            return 14;
        }
        if (moduleVersionId == 25) {
            return 50;
        }
        this.unrecognizedModuleVersionID(CLASS_NAME, "getJ2EEVersionID", moduleVersionId);
        return 50;
    }

    public void setModuleVersionID(int moduleVersionId) {
        this.primSetVersionID(moduleVersionId);
        if (moduleVersionId == 25) {
            this.primSetDoctypeValues(null, null);
        } else if (moduleVersionId == 24) {
            this.primSetDoctypeValues(null, null);
        } else if (moduleVersionId == 23) {
            this.primSetDoctypeValues(this.getJ2EE_1_3_PublicID(), this.getJ2EE_1_3_SystemID());
        } else if (moduleVersionId == 22) {
            this.primSetDoctypeValues(this.getJ2EE_1_2_PublicID(), this.getJ2EE_1_2_SystemID());
        } else {
            this.primSetDoctypeValues(null, null);
            this.unrecognizedModuleVersionID(CLASS_NAME, "setModuleVersionID", moduleVersionId);
        }
        this.syncVersionOfRootObject();
    }

    public void setJ2EEVersionID(int j2eeVersionId) {
        if (j2eeVersionId == 50) {
            this.primSetDoctypeValues(null, null);
            this.primSetVersionID(25);
        } else if (j2eeVersionId == 14) {
            this.primSetDoctypeValues(null, null);
            this.primSetVersionID(24);
        } else if (j2eeVersionId == 13) {
            this.primSetDoctypeValues(this.getJ2EE_1_3_PublicID(), this.getJ2EE_1_3_SystemID());
            this.primSetVersionID(23);
        } else if (j2eeVersionId == 12) {
            this.primSetDoctypeValues(this.getJ2EE_1_2_PublicID(), this.getJ2EE_1_2_SystemID());
            this.primSetVersionID(22);
        } else {
            this.setModuleVersionID(this.getDefaultModuleVersionID());
            this.unrecognizedJ2EEVersionID(CLASS_NAME, "setJ2EEVersionID", j2eeVersionId);
        }
        this.syncVersionOfRootObject();
    }

    protected int getDefaultVersionID() {
        return this.getDefaultModuleVersionID();
    }

    protected int getDefaultModuleVersionID() {
        return 25;
    }

    protected void syncVersionOfRootObject() {
        WebApp app = this.getWebApp();
        if (app == null) {
            return;
        }
        String version = app.getVersion();
        String newVersion = this.getModuleVersionString();
        if (!newVersion.equals(version)) {
            app.setVersion(newVersion);
        }
    }

    protected byte[] getElementBytes() {
        return J2EESchemaUtility.WEB_BYTES;
    }

    protected byte[] getVersionBytes() {
        return J2EESchemaUtility.VERSION_2_4_BYTES;
    }

    protected byte[] getSchemaLocationBytes() {
        return J2EESchemaUtility.WEB_2_4_BYTES;
    }

    public int lookupModuleVersionId(String schemaName) {
        if (schemaName == null) {
            return -1;
        }
        if (schemaName.equals("http://java.sun.com/xml/ns/j2ee http://java.sun.com/xml/ns/j2ee/web-app_2_4.xsd")) {
            return 24;
        }
        if (schemaName.equals("http://java.sun.com/xml/ns/javaee http://java.sun.com/xml/ns/javaee/web-app_2_5.xsd")) {
            return 25;
        }
        return -1;
    }

    public int lookupModuleVersionId(String publicId, String systemId) {
        if (publicId == null || systemId == null) {
            return -1;
        }
        if (publicId.equals("-//Sun Microsystems, Inc.//DTD Web Application 2.2//EN") && (systemId.equals("http://java.sun.com/j2ee/dtds/web-app_2_2.dtd") || systemId.equals("http://java.sun.com/j2ee/dtds/web-app_2.2.dtd"))) {
            return 22;
        }
        if (publicId.equals("-//Sun Microsystems, Inc.//DTD Web Application 2.3//EN") && (systemId.equals("http://java.sun.com/dtd/web-app_2_3.dtd") || systemId.equals("http://java.sun.com/dtd/web-app_2.3.dtd"))) {
            return 23;
        }
        return -1;
    }

    public int parseModuleVersionId(String versionString) {
        if (versionString == null) {
            return -1;
        }
        if (versionString.equals("2.2")) {
            return 22;
        }
        if (versionString.equals("2.3")) {
            return 23;
        }
        if (versionString.equals("2.4")) {
            return 24;
        }
        if (versionString.equals("2.5")) {
            return 25;
        }
        return -1;
    }
}

