/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.model.internal.validation;

import java.util.Arrays;
import java.util.List;
import org.eclipse.jem.java.Field;
import org.eclipse.jem.java.JavaClass;
import org.eclipse.jem.java.JavaHelpers;
import org.eclipse.jem.java.JavaParameter;
import org.eclipse.jem.java.Method;
import org.eclipse.jst.j2ee.ejb.EnterpriseBean;
import org.eclipse.jst.j2ee.ejb.Entity;
import org.eclipse.jst.j2ee.model.internal.validation.ABeanClassVRule;
import org.eclipse.jst.j2ee.model.internal.validation.IEJBType;
import org.eclipse.jst.j2ee.model.internal.validation.IFieldType;
import org.eclipse.jst.j2ee.model.internal.validation.IMethodAndFieldConstants;
import org.eclipse.jst.j2ee.model.internal.validation.IMethodType;
import org.eclipse.jst.j2ee.model.internal.validation.InvalidInputException;
import org.eclipse.jst.j2ee.model.internal.validation.ValidationRuleUtility;

public final class MethodUtility {
    private static MethodUtility _inst = null;
    private long[] _methodTypeIndex;
    private IMethodType[] _methodTypes;
    private long[] _fieldTypeIndex;
    private IFieldType[] _fieldTypes;

    private MethodUtility() {
        this.buildTypeList();
    }

    public static MethodUtility getUtility() {
        if (_inst == null) {
            _inst = new MethodUtility();
        }
        return _inst;
    }

    protected IMethodType[] getMethodTypes() {
        return this._methodTypes;
    }

    public IFieldType getFieldType(long type) {
        int index = Arrays.binarySearch(this._fieldTypeIndex, type);
        if (index > this._fieldTypes.length) {
            return null;
        }
        if (index < 0) {
            return null;
        }
        if (this._fieldTypes[index].getId() != type) {
            return null;
        }
        return this._fieldTypes[index];
    }

    public IMethodType getMethodType(long type) {
        int index = Arrays.binarySearch(this._methodTypeIndex, type);
        if (index > this._methodTypes.length) {
            return null;
        }
        if (index < 0) {
            return null;
        }
        if (this._methodTypes[index].getId() != type) {
            return null;
        }
        return this._methodTypes[index];
    }

    public long getMethodTypeId(EnterpriseBean bean, JavaClass clazz, Method method2, List[] methodsExtendedLists, IEJBType rule) {
        IMethodType mType = this.getMethodType(bean, clazz, method2, methodsExtendedLists, rule);
        if (mType == null) {
            return rule.getDefaultMethodType();
        }
        return mType.getId();
    }

    public long getFieldTypeId(EnterpriseBean bean, JavaClass clazz, Field field, IEJBType rule) {
        IFieldType mType = this.getFieldType(bean, clazz, field, rule);
        if (mType == null) {
            return IMethodAndFieldConstants.EXCLUDED_FIELD;
        }
        return mType.getId();
    }

    public IFieldType getFieldType(EnterpriseBean bean, JavaClass clazz, Field field, IEJBType rule) {
        IFieldType[] knownFieldTypes = this._fieldTypes;
        if (knownFieldTypes == null) {
            return null;
        }
        for (int i = 0; i < knownFieldTypes.length; ++i) {
            IFieldType mt = knownFieldTypes[i];
            if (mt == null || !mt.isFieldType(bean, clazz, field)) continue;
            return mt;
        }
        return null;
    }

    public IMethodType getMethodType(EnterpriseBean bean, JavaClass clazz, Method method2, List[] methodsExtendedLists, IEJBType rule) {
        long[] knownMethodTypes = rule.getKnownMethodTypes();
        if (knownMethodTypes == null) {
            return null;
        }
        for (int i = 0; i < knownMethodTypes.length; ++i) {
            IMethodType mt = this.getMethodType(knownMethodTypes[i]);
            if (mt == null || mt.isDefaultType() || !mt.isMethodType(bean, clazz, method2, methodsExtendedLists)) continue;
            return mt;
        }
        return this.getMethodType(rule.getDefaultMethodType());
    }

    private void buildTypeList() {
        int typeCount = 29;
        this._methodTypeIndex = new long[typeCount];
        this._methodTypes = new IMethodType[typeCount];
        int count = 0;
        int fieldTypeCount = 1;
        this._fieldTypeIndex = new long[fieldTypeCount];
        this._fieldTypes = new IFieldType[fieldTypeCount];
        int fieldCount = 0;
        this._methodTypeIndex[count] = IMethodAndFieldConstants.ACCESSOR;
        this._methodTypes[count++] = new IMethodType(){

            public long getId() {
                return IMethodAndFieldConstants.ACCESSOR;
            }

            public String getMethodName(EnterpriseBean bean, JavaClass clazz, Method method2) {
                return "";
            }

            public String getMessageId_messageMissing() {
                return "CHKJ2050.acc";
            }

            public String getMessageId_messageExists() {
                return "ACCESSOR::getMessageId_messageExists";
            }

            public String getMessageId_messageRemoteException() {
                return "ACCESSOR::getMessageId_messageRemoteException";
            }

            public String getMessageId_messageMissingMatching() {
                return "ACCESSOR::getMessageId_messageMissingMatching";
            }

            public String getMessageId_messageRMI_IIOPParm() {
                return "ACCESSOR::getMessageId_messageRMI_IIOPParm";
            }

            public boolean isDefaultType() {
                return false;
            }

            public boolean isMethodType(EnterpriseBean bean, JavaClass clazz, Method method2, List[] methodsExtendedLists) {
                return false;
            }

            public String toString() {
                return String.valueOf(this.getId());
            }
        };
        this._methodTypeIndex[count] = IMethodAndFieldConstants.BUSINESS;
        this._methodTypes[count++] = new IMethodType(){

            public long getId() {
                return IMethodAndFieldConstants.BUSINESS;
            }

            public String getMethodName(EnterpriseBean bean, JavaClass clazz, Method method2) {
                if (method2 == null) {
                    return "";
                }
                return method2.getName();
            }

            public String getMessageId_messageMissing() {
                return "BUSINESS::getMessageId_messageMissing";
            }

            public String getMessageId_messageExists() {
                return "BUSINESS::getMessageId_messageExists";
            }

            public String getMessageId_messageRemoteException() {
                return "CHKJ2503.bus";
            }

            public String getMessageId_messageMissingMatching() {
                return "CHKJ2504.business";
            }

            public String getMessageId_messageRMI_IIOPParm() {
                return "CHKJ2500.bus";
            }

            public boolean isDefaultType() {
                return false;
            }

            public boolean isMethodType(EnterpriseBean bean, JavaClass clazz, Method method2, List[] methodsExtendedLists) {
                if (ValidationRuleUtility.getMethod(method2, method2.getName(), ABeanClassVRule.getRemoteComponentMethodsExtended(methodsExtendedLists)) != null) {
                    return true;
                }
                return ValidationRuleUtility.getMethod(method2, method2.getName(), ABeanClassVRule.getRemoteComponentMethodsExtended(methodsExtendedLists)) != null;
            }

            public String toString() {
                return String.valueOf(this.getId());
            }
        };
        this._methodTypeIndex[count] = IMethodAndFieldConstants.CLINIT;
        this._methodTypes[count++] = new IMethodType(){

            public long getId() {
                return IMethodAndFieldConstants.CLINIT;
            }

            public String getMethodName(EnterpriseBean bean, JavaClass clazz, Method method2) {
                return "clinit";
            }

            public String getMessageId_messageMissing() {
                return "CLINIT::getMessageId_messageMissing";
            }

            public String getMessageId_messageExists() {
                return "CLINIT::getMessageId_messageExists";
            }

            public String getMessageId_messageRemoteException() {
                return "CLINIT::getMessageId_messageRemoteException";
            }

            public String getMessageId_messageMissingMatching() {
                return "CLINIT::getMessageId_messageMissingMatching";
            }

            public String getMessageId_messageRMI_IIOPParm() {
                return "CLINIT::getMessageId_messageRMI_IIOPParm";
            }

            public boolean isDefaultType() {
                return false;
            }

            public boolean isMethodType(EnterpriseBean bean, JavaClass clazz, Method method2, List[] methodsExtendedLists) {
                if (method2 == null) {
                    return false;
                }
                return method2.getName().equals("<clinit>");
            }

            public String toString() {
                return String.valueOf(this.getId());
            }
        };
        this._methodTypeIndex[count] = IMethodAndFieldConstants.CONSTRUCTOR;
        this._methodTypes[count++] = new IMethodType(){

            public long getId() {
                return IMethodAndFieldConstants.CONSTRUCTOR;
            }

            public String getMethodName(EnterpriseBean bean, JavaClass clazz, Method method2) {
                return clazz.getName();
            }

            public String getMessageId_messageMissing() {
                return "CHKJ2050.constr";
            }

            public String getMessageId_messageExists() {
                return "CONSTRUCTOR::getMessageId_messageExists";
            }

            public String getMessageId_messageRemoteException() {
                return "CONSTRUCTOR::getMessageId_messageRemoteException";
            }

            public String getMessageId_messageMissingMatching() {
                return "CONSTRUCTOR::getMessageId_messageMissingMatching";
            }

            public String getMessageId_messageRMI_IIOPParm() {
                return "CONSTRUCTOR::getMessageId_messageRMI_IIOPParm";
            }

            public boolean isDefaultType() {
                return false;
            }

            public boolean isMethodType(EnterpriseBean bean, JavaClass clazz, Method method2, List[] methodsExtendedLists) {
                if (method2 == null) {
                    return false;
                }
                return method2.isConstructor();
            }

            public String toString() {
                return String.valueOf(this.getId());
            }
        };
        this._methodTypeIndex[count] = IMethodAndFieldConstants.CONSTRUCTOR_NOPARM;
        this._methodTypes[count++] = new IMethodType(){

            public long getId() {
                return IMethodAndFieldConstants.CONSTRUCTOR_NOPARM;
            }

            public String getMethodName(EnterpriseBean bean, JavaClass clazz, Method method2) {
                return clazz.getName() + "()";
            }

            public String getMessageId_messageMissing() {
                return "CHKJ2050.constr";
            }

            public String getMessageId_messageExists() {
                return "CONSTRUCTOR_NOPARM::getMessageId_messageExists";
            }

            public String getMessageId_messageRemoteException() {
                return "CONSTRUCTOR_NOPARM::getMessageId_messageRemoteException";
            }

            public String getMessageId_messageMissingMatching() {
                return "CONSTRUCTOR_NOPARM::getMessageId_messageMissingMatching";
            }

            public String getMessageId_messageRMI_IIOPParm() {
                return "CONSTRUCTOR_NOPARM::getMessageId_messageRMI_IIOPParm";
            }

            public boolean isDefaultType() {
                return false;
            }

            public boolean isMethodType(EnterpriseBean bean, JavaClass clazz, Method method2, List[] methodsExtendedLists) {
                if (method2 == null) {
                    return false;
                }
                return method2.isConstructor() && ValidationRuleUtility.isPublic(method2) && method2.getParameters().size() == 0;
            }

            public String toString() {
                return String.valueOf(this.getId());
            }
        };
        this._methodTypeIndex[count] = IMethodAndFieldConstants.CREATE;
        this._methodTypes[count++] = new IMethodType(){

            public long getId() {
                return IMethodAndFieldConstants.CREATE;
            }

            public String getMethodName(EnterpriseBean bean, JavaClass clazz, Method method2) {
                return "create";
            }

            public String getMessageId_messageMissing() {
                return "CHKJ2050.create";
            }

            public String getMessageId_messageExists() {
                return "CREATE::getMessageId_messageExists";
            }

            public String getMessageId_messageRemoteException() {
                return "CHKJ2503.create";
            }

            public String getMessageId_messageMissingMatching() {
                return "CHKJ2504.create";
            }

            public String getMessageId_messageRMI_IIOPParm() {
                return "CHKJ2500.create";
            }

            public boolean isDefaultType() {
                return false;
            }

            public boolean isMethodType(EnterpriseBean bean, JavaClass clazz, Method method2, List[] methodsExtendedLists) {
                if (method2 == null) {
                    return false;
                }
                return method2.getName().startsWith("create");
            }

            public String toString() {
                return String.valueOf(this.getId());
            }
        };
        this._methodTypeIndex[count] = IMethodAndFieldConstants.CREATE_NOPARM;
        this._methodTypes[count++] = new IMethodType(){

            public long getId() {
                return IMethodAndFieldConstants.CREATE_NOPARM;
            }

            public String getMethodName(EnterpriseBean bean, JavaClass clazz, Method method2) {
                return "create()";
            }

            public String getMessageId_messageMissing() {
                return "CHKJ2050.create";
            }

            public String getMessageId_messageExists() {
                return "CREATE_NOPARM::getMessageId_messageExists";
            }

            public String getMessageId_messageRemoteException() {
                return "CHKJ2503.create";
            }

            public String getMessageId_messageMissingMatching() {
                return "CHKJ2504.create";
            }

            public String getMessageId_messageRMI_IIOPParm() {
                return "CHKJ2500.create";
            }

            public boolean isDefaultType() {
                return false;
            }

            public boolean isMethodType(EnterpriseBean bean, JavaClass clazz, Method method2, List[] methodsExtendedLists) {
                if (method2 == null) {
                    return false;
                }
                return method2.getName().startsWith("create") && method2.listParametersWithoutReturn().length == 0;
            }

            public String toString() {
                return String.valueOf(this.getId());
            }
        };
        this._methodTypeIndex[count] = IMethodAndFieldConstants.EJBACTIVATE_NOPARM;
        this._methodTypes[count++] = new IMethodType(){

            public long getId() {
                return IMethodAndFieldConstants.EJBACTIVATE_NOPARM;
            }

            public String getMethodName(EnterpriseBean bean, JavaClass clazz, Method method2) {
                return "ejbActivate()";
            }

            public String getMessageId_messageMissing() {
                return "CHKJ2050.ejbActivate";
            }

            public String getMessageId_messageExists() {
                return "EJBACTIVATE_NOPARM::getMessageId_messageExists";
            }

            public String getMessageId_messageRemoteException() {
                return "EJBACTIVATE_NOPARM::getMessageId_messageRemoteException";
            }

            public String getMessageId_messageMissingMatching() {
                return "EJBACTIVATE_NOPARM::getMessageId_messageMissingMatching";
            }

            public String getMessageId_messageRMI_IIOPParm() {
                return "EJBACTIVATE_NOPARM::getMessageId_messageRMI_IIOPParm";
            }

            public boolean isDefaultType() {
                return false;
            }

            public boolean isMethodType(EnterpriseBean bean, JavaClass clazz, Method method2, List[] methodsExtendedLists) {
                if (method2 == null) {
                    return false;
                }
                return method2.getName().equals("ejbActivate") && method2.listParametersWithoutReturn().length == 0;
            }

            public String toString() {
                return String.valueOf(this.getId());
            }
        };
        this._methodTypeIndex[count] = IMethodAndFieldConstants.EJBCREATE;
        this._methodTypes[count++] = new IMethodType(){

            public long getId() {
                return IMethodAndFieldConstants.EJBCREATE;
            }

            public String getMethodName(EnterpriseBean bean, JavaClass clazz, Method method2) {
                return "ejbCreate";
            }

            public String getMessageId_messageMissing() {
                return "CHKJ2050.ejbCreate";
            }

            public String getMessageId_messageExists() {
                return "EJBCREATE::getMessageId_messageExists";
            }

            public String getMessageId_messageRemoteException() {
                return "CHKJ2503.ejbCreate";
            }

            public String getMessageId_messageMissingMatching() {
                return "EJBCREATE::getMessageId_messageMissingMatching";
            }

            public String getMessageId_messageRMI_IIOPParm() {
                return "CHKJ2500.ejbCreate";
            }

            public boolean isDefaultType() {
                return false;
            }

            public boolean isMethodType(EnterpriseBean bean, JavaClass clazz, Method method2, List[] methodsExtendedLists) {
                if (method2 == null) {
                    return false;
                }
                return method2.getName().startsWith("ejbCreate");
            }

            public String toString() {
                return String.valueOf(this.getId());
            }
        };
        this._methodTypeIndex[count] = IMethodAndFieldConstants.EJBCREATE_NOPARM;
        this._methodTypes[count++] = new IMethodType(){

            public long getId() {
                return IMethodAndFieldConstants.EJBCREATE_NOPARM;
            }

            public String getMethodName(EnterpriseBean bean, JavaClass clazz, Method method2) {
                return "ejbCreate()";
            }

            public String getMessageId_messageMissing() {
                return "CHKJ2050.ejbCreate";
            }

            public String getMessageId_messageExists() {
                return "EJBCREATE_NOPARM::getMessageId_messageExists";
            }

            public String getMessageId_messageRemoteException() {
                return "CHKJ2503.ejbCreate";
            }

            public String getMessageId_messageMissingMatching() {
                return "EJBCREATE_NOPARM::getMessageId_messageMissingMatching";
            }

            public String getMessageId_messageRMI_IIOPParm() {
                return "EJBCREATE_NOPARM::getMessageId_messageRMI_IIOPParm";
            }

            public boolean isDefaultType() {
                return false;
            }

            public boolean isMethodType(EnterpriseBean bean, JavaClass clazz, Method method2, List[] methodsExtendedLists) {
                if (method2 == null) {
                    return false;
                }
                return method2.getName().startsWith("ejbCreate") && method2.listParametersWithoutReturn().length == 0;
            }

            public String toString() {
                return String.valueOf(this.getId());
            }
        };
        this._methodTypeIndex[count] = IMethodAndFieldConstants.EJBFIND;
        this._methodTypes[count++] = new IMethodType(){

            public long getId() {
                return IMethodAndFieldConstants.EJBFIND;
            }

            public String getMethodName(EnterpriseBean bean, JavaClass clazz, Method method2) {
                if (method2 == null) {
                    return "ejbFind";
                }
                return method2.getName();
            }

            public String getMessageId_messageMissing() {
                return "CHKJ2050.ejbFind";
            }

            public String getMessageId_messageExists() {
                return "CHKJ2502.ejbFind";
            }

            public String getMessageId_messageRemoteException() {
                return "CHKJ2503.ejbFind";
            }

            public String getMessageId_messageMissingMatching() {
                return "EJBFIND::getMessageId_messageMissingMatching";
            }

            public String getMessageId_messageRMI_IIOPParm() {
                return "CHKJ2500.ejbFind";
            }

            public boolean isDefaultType() {
                return false;
            }

            public boolean isMethodType(EnterpriseBean bean, JavaClass clazz, Method method2, List[] methodsExtendedLists) {
                if (method2 == null) {
                    return false;
                }
                return method2.getName().startsWith("ejbFind");
            }

            public String toString() {
                return String.valueOf(this.getId());
            }
        };
        this._methodTypeIndex[count] = IMethodAndFieldConstants.EJBFINDBYPRIMARYKEY;
        this._methodTypes[count++] = new IMethodType(){

            public long getId() {
                return IMethodAndFieldConstants.EJBFINDBYPRIMARYKEY;
            }

            public String getMethodName(EnterpriseBean bean, JavaClass clazz, Method method2) {
                StringBuffer buffer = new StringBuffer("ejbFindByPrimaryKey(");
                String pkName = "";
                if (bean instanceof Entity) {
                    JavaClass pk = ((Entity)bean).getPrimaryKey();
                    pkName = pk == null ? "<primary-key>" : pk.getQualifiedName();
                }
                buffer.append(pkName);
                buffer.append(")");
                return buffer.toString();
            }

            public boolean isDefaultType() {
                return false;
            }

            public String getMessageId_messageMissing() {
                return "CHKJ2050.ejbFindByPrimaryKey";
            }

            public String getMessageId_messageExists() {
                return "EJBFINDBYPRIMARYKEY::getMessageId_messageExists";
            }

            public String getMessageId_messageRemoteException() {
                return "CHKJ2503.ejbFind";
            }

            public String getMessageId_messageMissingMatching() {
                return "EJBFINDBYPRIMARYKEY::getMessageId_messageMissingMatching";
            }

            public String getMessageId_messageRMI_IIOPParm() {
                return "EJBFINDBYPRIMARYKEY::getMessageId_messageRMI_IIOPParm";
            }

            public boolean isMethodType(EnterpriseBean bean, JavaClass clazz, Method method2, List[] methodsExtendedLists) {
                if (method2 == null) {
                    return false;
                }
                return method2.getName().startsWith("ejbFind") && method2.getName().equals("ejbFindByPrimaryKey");
            }

            public String toString() {
                return String.valueOf(this.getId());
            }
        };
        this._methodTypeIndex[count] = IMethodAndFieldConstants.EJBHOME;
        this._methodTypes[count++] = new IMethodType(){

            public long getId() {
                return IMethodAndFieldConstants.EJBHOME;
            }

            public String getMethodName(EnterpriseBean bean, JavaClass clazz, Method method2) {
                if (method2 == null) {
                    return "ejbHome";
                }
                return method2.getName();
            }

            public String getMessageId_messageMissing() {
                return "CHKJ2050.ejbHome";
            }

            public String getMessageId_messageExists() {
                return "EJBHOME::getMessageId_messageExists";
            }

            public String getMessageId_messageRemoteException() {
                return "CHKJ2503.ejbHome";
            }

            public String getMessageId_messageMissingMatching() {
                return "EJBHOME::getMessageId_messageMissingMatching";
            }

            public String getMessageId_messageRMI_IIOPParm() {
                return "CHKJ2500.ejbHome";
            }

            public boolean isDefaultType() {
                return false;
            }

            public boolean isMethodType(EnterpriseBean bean, JavaClass clazz, Method method2, List[] methodsExtendedLists) {
                if (method2 == null) {
                    return false;
                }
                return method2.getName().startsWith("ejbHome");
            }

            public String toString() {
                return String.valueOf(this.getId());
            }
        };
        this._methodTypeIndex[count] = IMethodAndFieldConstants.EJBLOAD_NOPARM;
        this._methodTypes[count++] = new IMethodType(){

            public long getId() {
                return IMethodAndFieldConstants.EJBLOAD_NOPARM;
            }

            public String getMethodName(EnterpriseBean bean, JavaClass clazz, Method method2) {
                return "ejbLoad()";
            }

            public String getMessageId_messageMissing() {
                return "CHKJ2050.ejbLoad";
            }

            public String getMessageId_messageExists() {
                return "EJBLOAD::getMessageId_messageExists";
            }

            public String getMessageId_messageRemoteException() {
                return "EJBLOAD::getMessageId_messageRemoteException";
            }

            public String getMessageId_messageMissingMatching() {
                return "EJBLOAD::getMessageId_messageMissingMatching";
            }

            public String getMessageId_messageRMI_IIOPParm() {
                return "EJBLOAD::getMessageId_messageRMI_IIOPParm";
            }

            public boolean isDefaultType() {
                return false;
            }

            public boolean isMethodType(EnterpriseBean bean, JavaClass clazz, Method method2, List[] methodsExtendedLists) {
                if (method2 == null) {
                    return false;
                }
                return method2.getName().equals("ejbLoad") && method2.listParametersWithoutReturn().length == 0;
            }

            public String toString() {
                return String.valueOf(this.getId());
            }
        };
        this._methodTypeIndex[count] = IMethodAndFieldConstants.EJBPASSIVATE_NOPARM;
        this._methodTypes[count++] = new IMethodType(){

            public long getId() {
                return IMethodAndFieldConstants.EJBPASSIVATE_NOPARM;
            }

            public String getMethodName(EnterpriseBean bean, JavaClass clazz, Method method2) {
                return "ejbPassivate()";
            }

            public String getMessageId_messageMissing() {
                return "CHKJ2050.ejbPassivate";
            }

            public String getMessageId_messageExists() {
                return "EJBPASSIVATE::getMessageId_messageExists";
            }

            public String getMessageId_messageRemoteException() {
                return "EJBPASSIVATE::getMessageId_messageRemoteException";
            }

            public String getMessageId_messageMissingMatching() {
                return "EJBPASSIVATE::getMessageId_messageMissingMatching";
            }

            public String getMessageId_messageRMI_IIOPParm() {
                return "EJBPASSIVATE::getMessageId_messageRMI_IIOPParm";
            }

            public boolean isDefaultType() {
                return false;
            }

            public boolean isMethodType(EnterpriseBean bean, JavaClass clazz, Method method2, List[] methodsExtendedLists) {
                if (method2 == null) {
                    return false;
                }
                return method2.getName().equals("ejbPassivate") && method2.listParametersWithoutReturn().length == 0;
            }

            public String toString() {
                return String.valueOf(this.getId());
            }
        };
        this._methodTypeIndex[count] = IMethodAndFieldConstants.EJBPOSTCREATE;
        this._methodTypes[count++] = new IMethodType(){

            public long getId() {
                return IMethodAndFieldConstants.EJBPOSTCREATE;
            }

            public String getMethodName(EnterpriseBean bean, JavaClass clazz, Method method2) {
                return "ejbPostCreate";
            }

            public String getMessageId_messageMissing() {
                return "EJBPOSTCREATE::getMessageId_messageMissing";
            }

            public String getMessageId_messageExists() {
                return "EJBPOSTCREATE::getMessageId_messageExists";
            }

            public String getMessageId_messageRemoteException() {
                return "CHKJ2503.ejbPostCreate";
            }

            public String getMessageId_messageMissingMatching() {
                return "EJBPOSTCREATE::getMessageId_messageMissingMatching";
            }

            public String getMessageId_messageRMI_IIOPParm() {
                return "EJBPOSTCREATE::getMessageId_messageRMI_IIOPParm";
            }

            public boolean isDefaultType() {
                return false;
            }

            public boolean isMethodType(EnterpriseBean bean, JavaClass clazz, Method method2, List[] methodsExtendedLists) {
                if (method2 == null) {
                    return false;
                }
                return method2.getName().startsWith("ejbPostCreate");
            }

            public String toString() {
                return String.valueOf(this.getId());
            }
        };
        this._methodTypeIndex[count] = IMethodAndFieldConstants.EJBREMOVE_NOPARM;
        this._methodTypes[count++] = new IMethodType(){

            public long getId() {
                return IMethodAndFieldConstants.EJBREMOVE_NOPARM;
            }

            public String getMethodName(EnterpriseBean bean, JavaClass clazz, Method method2) {
                return "ejbRemove()";
            }

            public String getMessageId_messageMissing() {
                return "CHKJ2050.ejbRemove";
            }

            public String getMessageId_messageExists() {
                return "EJBREMOVE::getMessageId_messageExists";
            }

            public String getMessageId_messageRemoteException() {
                return "EJBREMOVE::getMessageId_messageRemoteException";
            }

            public String getMessageId_messageMissingMatching() {
                return "EJBREMOVE::getMessageId_messageMissingMatching";
            }

            public String getMessageId_messageRMI_IIOPParm() {
                return "EJBREMOVE::getMessageId_messageRMI_IIOPParm";
            }

            public boolean isDefaultType() {
                return false;
            }

            public boolean isMethodType(EnterpriseBean bean, JavaClass clazz, Method method2, List[] methodsExtendedLists) {
                if (method2 == null) {
                    return false;
                }
                return method2.getName().equals("ejbRemove") && method2.listParametersWithoutReturn().length == 0;
            }

            public String toString() {
                return String.valueOf(this.getId());
            }
        };
        this._methodTypeIndex[count] = IMethodAndFieldConstants.EJBSELECT;
        this._methodTypes[count++] = new IMethodType(){

            public long getId() {
                return IMethodAndFieldConstants.EJBSELECT;
            }

            public String getMethodName(EnterpriseBean bean, JavaClass clazz, Method method2) {
                if (method2 == null) {
                    return "ejbSelect";
                }
                return method2.getName();
            }

            public String getMessageId_messageMissing() {
                return "CHKJ2050.ejbSelect";
            }

            public String getMessageId_messageExists() {
                return "CHKJ2502.ejbSelect";
            }

            public String getMessageId_messageRemoteException() {
                return "EJBSELECT::getMessageId_messageRemoteException";
            }

            public String getMessageId_messageMissingMatching() {
                return "EJBSELECT::getMessageId_messageMissingMatching";
            }

            public String getMessageId_messageRMI_IIOPParm() {
                return "EJBSELECT::getMessageId_messageRMI_IIOPParm";
            }

            public boolean isDefaultType() {
                return false;
            }

            public boolean isMethodType(EnterpriseBean bean, JavaClass clazz, Method method2, List[] methodsExtendedLists) {
                if (method2 == null) {
                    return false;
                }
                return method2.getName().startsWith("ejbSelect");
            }

            public String toString() {
                return String.valueOf(this.getId());
            }
        };
        this._methodTypeIndex[count] = IMethodAndFieldConstants.EJBSTORE_NOPARM;
        this._methodTypes[count++] = new IMethodType(){

            public long getId() {
                return IMethodAndFieldConstants.EJBSTORE_NOPARM;
            }

            public String getMethodName(EnterpriseBean bean, JavaClass clazz, Method method2) {
                return "ejbStore()";
            }

            public String getMessageId_messageMissing() {
                return "CHKJ2050.ejbStore";
            }

            public String getMessageId_messageExists() {
                return "EJBSTORE::getMessageId_messageExists";
            }

            public String getMessageId_messageRemoteException() {
                return "EJBSTORE::getMessageId_messageRemoteException";
            }

            public String getMessageId_messageMissingMatching() {
                return "EJBSTORE::getMessageId_messageMissingMatching";
            }

            public String getMessageId_messageRMI_IIOPParm() {
                return "EJBSTORE::getMessageId_messageRMI_IIOPParm";
            }

            public boolean isDefaultType() {
                return false;
            }

            public boolean isMethodType(EnterpriseBean bean, JavaClass clazz, Method method2, List[] methodsExtendedLists) {
                if (method2 == null) {
                    return false;
                }
                return method2.getName().equals("ejbStore") && method2.listParametersWithoutReturn().length == 0;
            }

            public String toString() {
                return String.valueOf(this.getId());
            }
        };
        this._methodTypeIndex[count] = IMethodAndFieldConstants.EQUALS;
        this._methodTypes[count++] = new IMethodType(){

            public long getId() {
                return IMethodAndFieldConstants.EQUALS;
            }

            public String getMethodName(EnterpriseBean bean, JavaClass clazz, Method method2) {
                return "equals(Object)";
            }

            public String getMessageId_messageMissing() {
                return "CHKJ2050.equals";
            }

            public String getMessageId_messageExists() {
                return "EQUALS::getMessageId_messageExists";
            }

            public String getMessageId_messageRemoteException() {
                return "EQUALS::getMessageId_messageRemoteException";
            }

            public String getMessageId_messageMissingMatching() {
                return "EQUALS::getMessageId_messageMissingMatching";
            }

            public String getMessageId_messageRMI_IIOPParm() {
                return "EQUALS::getMessageId_messageRMI_IIOPParm";
            }

            public boolean isDefaultType() {
                return false;
            }

            public boolean isMethodType(EnterpriseBean bean, JavaClass clazz, Method method2, List[] methodsExtendedLists) {
                JavaParameter[] parm;
                if (method2 == null) {
                    return false;
                }
                if (method2.getName().startsWith("equals") && (parm = method2.listParametersWithoutReturn()).length == 1) {
                    try {
                        JavaHelpers object = ValidationRuleUtility.getType("java.lang.Object", bean);
                        JavaHelpers parmType = parm[0].getJavaType();
                        if (object.equals(parmType)) {
                            return true;
                        }
                    }
                    catch (InvalidInputException e) {
                        return false;
                    }
                }
                return false;
            }

            public String toString() {
                return String.valueOf(this.getId());
            }
        };
        this._methodTypeIndex[count] = IMethodAndFieldConstants.FIND;
        this._methodTypes[count++] = new IMethodType(){

            public long getId() {
                return IMethodAndFieldConstants.FIND;
            }

            public String getMethodName(EnterpriseBean bean, JavaClass clazz, Method method2) {
                if (method2 == null) {
                    return "find";
                }
                return method2.getName();
            }

            public String getMessageId_messageMissing() {
                return "CHKJ2050.find";
            }

            public String getMessageId_messageExists() {
                return "FIND::getMessageId_messageExists";
            }

            public String getMessageId_messageRemoteException() {
                return "CHKJ2503.find";
            }

            public String getMessageId_messageMissingMatching() {
                return "CHKJ2504.find";
            }

            public String getMessageId_messageRMI_IIOPParm() {
                return "CHKJ2500.find";
            }

            public boolean isDefaultType() {
                return false;
            }

            public boolean isMethodType(EnterpriseBean bean, JavaClass clazz, Method method2, List[] methodsExtendedLists) {
                if (method2 == null) {
                    return false;
                }
                return method2.getName().startsWith("find");
            }

            public String toString() {
                return String.valueOf(this.getId());
            }
        };
        this._methodTypeIndex[count] = IMethodAndFieldConstants.FINDBYPRIMARYKEY;
        this._methodTypes[count++] = new IMethodType(){

            public long getId() {
                return IMethodAndFieldConstants.FINDBYPRIMARYKEY;
            }

            public String getMethodName(EnterpriseBean bean, JavaClass clazz, Method method2) {
                return "findByPrimaryKey";
            }

            public String getMessageId_messageMissing() {
                return "CHKJ2050.findByPrimaryKey";
            }

            public String getMessageId_messageExists() {
                return "CHKJ2500.find";
            }

            public String getMessageId_messageRemoteException() {
                return "CHKJ2503.find";
            }

            public String getMessageId_messageMissingMatching() {
                return "CHKJ2504.find";
            }

            public String getMessageId_messageRMI_IIOPParm() {
                return "CHKJ2500.find";
            }

            public boolean isDefaultType() {
                return false;
            }

            public boolean isMethodType(EnterpriseBean bean, JavaClass clazz, Method method2, List[] methodsExtendedLists) {
                if (method2 == null) {
                    return false;
                }
                return method2.getName().startsWith("find") && method2.getName().startsWith("findByPrimaryKey");
            }

            public String toString() {
                return String.valueOf(this.getId());
            }
        };
        this._methodTypeIndex[count] = IMethodAndFieldConstants.FINALIZE_NOPARM;
        this._methodTypes[count++] = new IMethodType(){

            public long getId() {
                return IMethodAndFieldConstants.FINALIZE_NOPARM;
            }

            public String getMethodName(EnterpriseBean bean, JavaClass clazz, Method method2) {
                return "finalize()";
            }

            public String getMessageId_messageMissing() {
                return "FINALIZE::getMessageId_messageExists";
            }

            public String getMessageId_messageExists() {
                return "CHKJ2502.finalize";
            }

            public String getMessageId_messageRemoteException() {
                return "FINALIZE::getMessageId_messageRemoteException";
            }

            public String getMessageId_messageMissingMatching() {
                return "FINALIZE::getMessageId_messageMissingMatching";
            }

            public String getMessageId_messageRMI_IIOPParm() {
                return "FINALIZE::getMessageId_messageRMI_IIOPParm";
            }

            public boolean isDefaultType() {
                return false;
            }

            public boolean isMethodType(EnterpriseBean bean, JavaClass clazz, Method method2, List[] methodsExtendedLists) {
                if (method2 == null) {
                    return false;
                }
                return method2.getName().equals("finalize") && method2.listParametersWithoutReturn().length == 0;
            }

            public String toString() {
                return String.valueOf(this.getId());
            }
        };
        this._methodTypeIndex[count] = IMethodAndFieldConstants.HASHCODE_NOPARM;
        this._methodTypes[count++] = new IMethodType(){

            public long getId() {
                return IMethodAndFieldConstants.HASHCODE_NOPARM;
            }

            public String getMethodName(EnterpriseBean bean, JavaClass clazz, Method method2) {
                return "hashCode()";
            }

            public String getMessageId_messageMissing() {
                return "CHKJ2050.hashCode";
            }

            public String getMessageId_messageExists() {
                return "HASHCODE::getMessageId_messageExists";
            }

            public String getMessageId_messageRemoteException() {
                return "HASHCODE::getMessageId_messageRemoteException";
            }

            public String getMessageId_messageMissingMatching() {
                return "HASHCODE::getMessageId_messageMissingMatching";
            }

            public String getMessageId_messageRMI_IIOPParm() {
                return "HASHCODE::getMessageId_messageRMI_IIOPParm";
            }

            public boolean isDefaultType() {
                return false;
            }

            public boolean isMethodType(EnterpriseBean bean, JavaClass clazz, Method method2, List[] methodsExtendedLists) {
                if (method2 == null) {
                    return false;
                }
                return method2.getName().equals("hashCode") && method2.listParametersWithoutReturn().length == 0;
            }

            public String toString() {
                return String.valueOf(this.getId());
            }
        };
        this._methodTypeIndex[count] = IMethodAndFieldConstants.HOME;
        this._methodTypes[count++] = new IMethodType(){

            public long getId() {
                return IMethodAndFieldConstants.HOME;
            }

            public String getMethodName(EnterpriseBean bean, JavaClass clazz, Method method2) {
                return "home";
            }

            public String getMessageId_messageMissing() {
                return "CHKJ2050.home";
            }

            public String getMessageId_messageExists() {
                return "HOME::getMessageId_messageExists";
            }

            public String getMessageId_messageRemoteException() {
                return "CHKJ2503.home";
            }

            public String getMessageId_messageMissingMatching() {
                return "CHKJ2504.home";
            }

            public String getMessageId_messageRMI_IIOPParm() {
                return "CHKJ2500.home";
            }

            public boolean isDefaultType() {
                return true;
            }

            public boolean isMethodType(EnterpriseBean bean, JavaClass clazz, Method method2, List[] methodsExtendedLists) {
                return method2 != null;
            }

            public String toString() {
                return String.valueOf(this.getId());
            }
        };
        this._methodTypeIndex[count] = IMethodAndFieldConstants.ONMESSAGE;
        this._methodTypes[count++] = new IMethodType(){

            public long getId() {
                return IMethodAndFieldConstants.ONMESSAGE;
            }

            public String getMethodName(EnterpriseBean bean, JavaClass clazz, Method method2) {
                return "onMessage";
            }

            public String getMessageId_messageMissing() {
                return "CHKJ2050.onMessage";
            }

            public String getMessageId_messageExists() {
                return "ONMESSAGE::getMessageId_messageExists";
            }

            public String getMessageId_messageRemoteException() {
                return "ONMESSAGE::getMessageId_messageRemoteException";
            }

            public String getMessageId_messageMissingMatching() {
                return "ONMESSAGE::getMessageId_messageMissingMatching";
            }

            public String getMessageId_messageRMI_IIOPParm() {
                return "ONMESSAGE::getMessageId_messageRMI_IIOPParm";
            }

            public boolean isDefaultType() {
                return false;
            }

            public boolean isMethodType(EnterpriseBean bean, JavaClass clazz, Method method2, List[] methodsExtendedLists) {
                JavaParameter[] parms;
                if (method2 == null) {
                    return false;
                }
                if (method2.getName().equals("onMessage") && (parms = method2.listParametersWithoutReturn()).length == 1) {
                    try {
                        JavaHelpers jmsMessage = ValidationRuleUtility.getType("javax.jms.Message", bean);
                        JavaHelpers parmType = parms[0].getJavaType();
                        if (jmsMessage.equals(parmType)) {
                            return true;
                        }
                    }
                    catch (InvalidInputException e) {
                        return false;
                    }
                }
                return false;
            }

            public String toString() {
                return String.valueOf(this.getId());
            }
        };
        this._methodTypeIndex[count] = IMethodAndFieldConstants.SETENTITYCONTEXT;
        this._methodTypes[count++] = new IMethodType(){

            public long getId() {
                return IMethodAndFieldConstants.SETENTITYCONTEXT;
            }

            public String getMethodName(EnterpriseBean bean, JavaClass clazz, Method method2) {
                return "setEntityContext";
            }

            public String getMessageId_messageMissing() {
                return "CHKJ2050.setEntityContext";
            }

            public String getMessageId_messageExists() {
                return "SETENTITYCONTEXT::getMessageId_messageExists";
            }

            public String getMessageId_messageRemoteException() {
                return "SETENTITYCONTEXT::getMessageId_messageRemoteException";
            }

            public String getMessageId_messageMissingMatching() {
                return "SETENTITYCONTEXT::getMessageId_messageMissingMatching";
            }

            public String getMessageId_messageRMI_IIOPParm() {
                return "SETENTITYCONTEXT::getMessageId_messageRMI_IIOPParm";
            }

            public boolean isDefaultType() {
                return false;
            }

            public boolean isMethodType(EnterpriseBean bean, JavaClass clazz, Method method2, List[] methodsExtendedLists) {
                JavaParameter[] parm;
                if (method2 == null) {
                    return false;
                }
                if (method2.getName().equals("setEntityContext") && (parm = method2.listParametersWithoutReturn()).length == 1) {
                    try {
                        JavaHelpers entityContext = ValidationRuleUtility.getType("javax.ejb.EntityContext", bean);
                        JavaHelpers parmType = parm[0].getJavaType();
                        if (entityContext.equals(parmType)) {
                            return true;
                        }
                    }
                    catch (InvalidInputException e) {
                        return false;
                    }
                }
                return false;
            }

            public String toString() {
                return String.valueOf(this.getId());
            }
        };
        this._methodTypeIndex[count] = IMethodAndFieldConstants.UNSETENTITYCONTEXT_NOPARM;
        this._methodTypes[count++] = new IMethodType(){

            public long getId() {
                return IMethodAndFieldConstants.UNSETENTITYCONTEXT_NOPARM;
            }

            public String getMethodName(EnterpriseBean bean, JavaClass clazz, Method method2) {
                return "unsetEntityContext()";
            }

            public String getMessageId_messageMissing() {
                return "CHKJ2050.unsetEntityContext";
            }

            public String getMessageId_messageExists() {
                return "UNSETENTITYCONTEXT::getMessageId_messageExists";
            }

            public String getMessageId_messageRemoteException() {
                return "UNSETENTITYCONTEXT::getMessageId_messageRemoteException";
            }

            public String getMessageId_messageMissingMatching() {
                return "UNSETENTITYCONTEXT::getMessageId_messageMissingMatching";
            }

            public String getMessageId_messageRMI_IIOPParm() {
                return "UNSETENTITYCONTEXT::getMessageId_messageRMI_IIOPParm";
            }

            public boolean isDefaultType() {
                return false;
            }

            public boolean isMethodType(EnterpriseBean bean, JavaClass clazz, Method method2, List[] methodsExtendedLists) {
                if (method2 == null) {
                    return false;
                }
                return method2.getName().equals("unsetEntityContext") && method2.listParametersWithoutReturn().length == 0;
            }

            public String toString() {
                return String.valueOf(this.getId());
            }
        };
        this._fieldTypeIndex[fieldCount] = IMethodAndFieldConstants.SERIALVERSIONUID;
        this._fieldTypes[fieldCount++] = new IFieldType(){

            public long getId() {
                return IMethodAndFieldConstants.SERIALVERSIONUID;
            }

            public boolean isFieldType(EnterpriseBean bean, JavaClass clazz, Field field) {
                if (field == null) {
                    return false;
                }
                return field.getName().equals("serialVersionUID");
            }

            public String toString() {
                return String.valueOf(this.getId());
            }
        };
    }
}

